/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.LanguageProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderAccessor;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemCreator;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.persistence.base.IAdditionalFileInfoProvider;
import com.hello2morrow.sonargraph.core.persistence.system.XmlDynamicSystemInfoPersistenceProvider;
import com.hello2morrow.sonargraph.core.persistence.system.XmlSystemPersistenceProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class PersistenceAccessor {
    private final ISoftwareSystemCreator m_creator;
    private final Installation m_installation;
    private final LanguageProviderAccessor m_accessor;

    public PersistenceAccessor(ISoftwareSystemCreator creator, Installation installation, LanguageProviderAccessor accessor) {
        assert (creator != null) : "Parameter 'creator' of method 'SoftwareSystemPersistenceAccessor' must not be null";
        assert (installation != null) : "Parameter 'installation' of method 'SoftwareSystemPersistenceAccessor' must not be null";
        assert (accessor != null) : "Parameter 'accessor' of method 'SoftwareSystemPersistenceAccessor' must not be null";
        this.m_creator = creator;
        this.m_installation = installation;
        this.m_accessor = accessor;
    }

    private List<IAdditionalFileInfoProvider> getLanguageProviders(Set<Language> languages) {
        ArrayList<IAdditionalFileInfoProvider> infoProviders = new ArrayList<IAdditionalFileInfoProvider>();
        if (languages != null && !languages.isEmpty()) {
            for (LanguageProvider nextLanguageProvider : this.m_accessor.getLanguageProviders(languages)) {
                infoProviders.add(nextLanguageProvider.getPersistenceProvider(this.m_installation));
            }
        }
        return infoProviders;
    }

    public XmlSystemPersistenceProvider getPersistence(Set<Language> languages) {
        List<IAdditionalFileInfoProvider> infoProviders = this.getLanguageProviders(languages);
        return new XmlSystemPersistenceProvider(this.m_installation.getVersion(), infoProviders, this.m_creator);
    }

    public XmlDynamicSystemInfoPersistenceProvider getDynamicInfoPersistence(Set<Language> languages) {
        List<IAdditionalFileInfoProvider> infoProviders = this.getLanguageProviders(languages);
        return new XmlDynamicSystemInfoPersistenceProvider(this.m_installation.getVersion(), infoProviders);
    }
}

