/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.api.script.model.ResultAccess;
import com.hello2morrow.sonargraph.core.api.script.model.ScriptAccess;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderAccessor;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.parser.JavaFamilySourceLineVisitor;
import com.hello2morrow.sonargraph.core.controller.system.script.CoreAccess;
import com.hello2morrow.sonargraph.core.controller.system.script.ScriptAutoCompletionProposalsCollector;
import com.hello2morrow.sonargraph.core.controller.system.script.ScriptFormatter;
import com.hello2morrow.sonargraph.core.controller.system.script.internal.ScriptApi;
import com.hello2morrow.sonargraph.core.controller.system.script.internal.SonargraphGroovyShell;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfigurationFile;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.ScriptRunnerConfiguration;
import com.hello2morrow.sonargraph.core.model.common.AutoCompletionProposal;
import com.hello2morrow.sonargraph.core.model.common.FormatterOptions;
import com.hello2morrow.sonargraph.core.model.common.IFormatter;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementContainer;
import com.hello2morrow.sonargraph.core.model.element.NamedElementUtility;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.ISourceFileRegionVisitor;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFilesDirectory;
import com.hello2morrow.sonargraph.core.model.programming.CoreKeywords;
import com.hello2morrow.sonargraph.core.model.script.AutomatedScriptRunConfiguration;
import com.hello2morrow.sonargraph.core.model.script.DefaultRunConfiguration;
import com.hello2morrow.sonargraph.core.model.script.FileBasedRunConfiguration;
import com.hello2morrow.sonargraph.core.model.script.FullGroovyScript;
import com.hello2morrow.sonargraph.core.model.script.GroovyScript;
import com.hello2morrow.sonargraph.core.model.script.GroovyScripts;
import com.hello2morrow.sonargraph.core.model.script.IGroovyProvider;
import com.hello2morrow.sonargraph.core.model.script.IGroovyScript;
import com.hello2morrow.sonargraph.core.model.script.IMetricIdProvider;
import com.hello2morrow.sonargraph.core.model.script.IRunConfiguration;
import com.hello2morrow.sonargraph.core.model.script.IScriptApi;
import com.hello2morrow.sonargraph.core.model.script.ParameterDefinition;
import com.hello2morrow.sonargraph.core.model.script.ParameterNameValidator;
import com.hello2morrow.sonargraph.core.model.script.RunConfigurationNameValidator;
import com.hello2morrow.sonargraph.core.model.script.RunConfigurationParameters;
import com.hello2morrow.sonargraph.core.model.script.ScriptContent;
import com.hello2morrow.sonargraph.core.model.script.ScriptDirectory;
import com.hello2morrow.sonargraph.core.model.script.ScriptOutputStreamProvider;
import com.hello2morrow.sonargraph.core.model.script.ScriptResultSet;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystemMode;
import com.hello2morrow.sonargraph.core.persistence.script.ScriptPersistence;
import com.hello2morrow.sonargraph.core.persistence.script.runconfiguration.RunConfigurationPersistence;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Result;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public abstract class GroovyProvider
extends Extension
implements IGroovyProvider {
    private final Map<String, ScriptContent> m_identifyingPathToAutomatedScriptContent = new THashMap();
    private final LanguageProviderAccessor m_accessor;
    private final Installation m_installation;
    private final SoftwareSystem m_softwareSystem;
    private final SonargraphGroovyShell m_groovyShell;

    GroovyProvider(LanguageProviderAccessor accessor, Installation installation, SoftwareSystem softwareSystem, ScriptOutputStreamProvider outputStreamProvider) {
        assert (accessor != null) : "Parameter 'accessor' of method 'GroovyExtension' must not be null";
        assert (installation != null) : "Parameter 'installation' of method 'GroovyProvider' must not be null";
        assert (softwareSystem != null) : "'softwareSystem' must not be null";
        assert (outputStreamProvider != null) : "Parameter 'outputStreamProvider' of method 'GroovyExtension' must not be null";
        this.m_accessor = accessor;
        this.m_installation = installation;
        this.m_softwareSystem = softwareSystem;
        this.m_groovyShell = new SonargraphGroovyShell(this.getFileOutputBaseDirectory(), this.m_softwareSystem.getClassLoader(), outputStreamProvider);
    }

    protected final ScriptOutputStreamProvider getOutputStreamProvider() {
        return this.m_groovyShell.getOutputStreamProvider();
    }

    protected final SoftwareSystem getSoftwareSystem() {
        return this.m_softwareSystem;
    }

    protected final SonargraphGroovyShell getShell() {
        return this.m_groovyShell;
    }

    protected final GroovyScripts getScriptsDirectory() {
        return this.m_softwareSystem.getUniqueExistingChild(Files.class).getGroovyScripts();
    }

    protected final ScriptPersistence getScriptPersistence() {
        return new ScriptPersistence(this.getScriptsDirectory(), this.m_installation.getVersion(), this.getAvailableLanguages(), this.m_softwareSystem.getMode() == SoftwareSystemMode.SYSTEM_LOADED_FROM_SNAPSHOT);
    }

    protected final RunConfigurationPersistence getRunConfigurationPersistence() {
        return new RunConfigurationPersistence(this.getScriptsDirectory(), this.m_installation.getVersion());
    }

    @Override
    public final IFormatter getFormatter(FormatterOptions options) {
        assert (options != null) : "Parameter 'options' of method 'getFormatter' must not be null";
        return new ScriptFormatter(options);
    }

    protected final ScriptContent getAutomatedScriptContent(String identifyingPath) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'getAutomatedScriptContent' must not be empty";
        return this.m_identifyingPathToAutomatedScriptContent.get(identifyingPath);
    }

    protected final void removeAllScripts(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'removeAllScripts' must not be null";
        this.getScriptsDirectory().removeAll(result);
        this.m_identifyingPathToAutomatedScriptContent.clear();
    }

    protected final ScriptContent addAutomatedScriptContent(String identifyingPath, ScriptContent scriptContent) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'addAutomatedScriptContent' must not be empty";
        assert (scriptContent != null) : "Parameter 'scriptContent' of method 'addAutomatedScriptContent' must not be null";
        ScriptContent automatedScriptContent = new ScriptContent.Builder(scriptContent).build();
        assert (!scriptContent.hasChildren(false, AutomatedScriptRunConfiguration.class)) : "Must not have automated script run configuration children: " + String.valueOf(scriptContent);
        for (FileBasedRunConfiguration next : scriptContent.getChildren(FileBasedRunConfiguration.class)) {
            automatedScriptContent.addChild(new AutomatedScriptRunConfiguration(automatedScriptContent, next.getRunConfigurationName(), new RunConfigurationParameters(next.getRunConfigurationParameters()), automatedScriptContent));
        }
        return this.m_identifyingPathToAutomatedScriptContent.put(identifyingPath, automatedScriptContent);
    }

    protected final void changeIdentifyingPathOfAutomatedScriptContent(String oldIdentifyingPath, String newIdentifyingPath) {
        assert (oldIdentifyingPath != null && oldIdentifyingPath.length() > 0) : "Parameter 'oldIdentifyingPath' of method 'changeIdentifyingPathOfAutomatedScriptContent' must not be empty";
        assert (newIdentifyingPath != null && newIdentifyingPath.length() > 0) : "Parameter 'newIdentifyingPath' of method 'changeIdentifyingPathOfAutomatedScriptContent' must not be empty";
        ScriptContent found = this.m_identifyingPathToAutomatedScriptContent.remove(oldIdentifyingPath);
        assert (found != null) : "'found' of method 'changeIdentifyingPathOfAutomatedScriptContent' must not be null";
        ScriptContent replaced = this.m_identifyingPathToAutomatedScriptContent.put(newIdentifyingPath, found);
        assert (replaced == null) : "'replaced' of method 'changeIdentifyingPathOfAutomatedScriptContent' must be null";
    }

    protected final void changeRunConfigurationName(String identifyingPath, String oldRunConfigurationName, String newRunConfigurationName) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'changeRunConfigurationName' must not be empty";
        assert (oldRunConfigurationName != null && oldRunConfigurationName.length() > 0) : "Parameter 'oldRunConfigurationName' of method 'changeRunConfigurationName' must not be empty";
        assert (newRunConfigurationName != null && newRunConfigurationName.length() > 0) : "Parameter 'newRunConfigurationName' of method 'changeRunConfigurationName' must not be empty";
        ScriptContent scriptContent = this.m_identifyingPathToAutomatedScriptContent.get(identifyingPath);
        assert (scriptContent != null) : "Parameter 'scriptContent' of method 'changeRunConfigurationName' must not be null";
        for (AutomatedScriptRunConfiguration next : scriptContent.getChildren(AutomatedScriptRunConfiguration.class)) {
            if (!next.getRunConfigurationName().equals(oldRunConfigurationName)) continue;
            next.setRunConfigurationName(newRunConfigurationName);
        }
    }

    protected final ScriptContent removeAutomatedScriptContent(String identifyingPath) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'removeAutomatedScriptContent' must not be empty";
        return this.m_identifyingPathToAutomatedScriptContent.remove(identifyingPath);
    }

    @Override
    public final TFile getFileOutputBaseDirectory() {
        TFile systemParentDirectory = this.m_softwareSystem.getUniqueChild(Files.class).getSystemDirectory().getDirectoryFile().getParentFile();
        if (this.m_softwareSystem.getMode() != SoftwareSystemMode.SYSTEM_LOADED_FROM_SNAPSHOT) {
            return systemParentDirectory;
        }
        return systemParentDirectory.getParentFile();
    }

    @Override
    public final boolean isScriptDirectory(DirectoryPath directoryPath) {
        assert (directoryPath != null) : "Parameter 'directoryPath' of method 'isScriptDirectory' must not be null";
        return directoryPath instanceof GroovyScripts || directoryPath instanceof ScriptDirectory;
    }

    @Override
    public final boolean isModifiableScriptDirectory(DirectoryPath directoryPath) {
        assert (directoryPath != null) : "Parameter 'directoryPath' of method 'isModifiableScriptDirectory' must not be null";
        return directoryPath instanceof ScriptDirectory;
    }

    @Override
    public final String getScriptRunnerConfigurationFileName() {
        return AnalyzerConfigurationFile.getFileName(CoreAnalyzerId.SCRIPT_RUNNER);
    }

    @Override
    public final AnalyzerConfigurationFile getScriptRunnerConfigurationFile() {
        return this.m_softwareSystem.getExtension(IAnalyzerController.class).getAnalyzerConfigurationFile(CoreAnalyzerId.SCRIPT_RUNNER);
    }

    protected final boolean isFileNameAJavaIdentifier(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'isFileNameAJavaIdentifier' must not be empty";
        String nameToCheck = Arrays.stream(CoreFileType.GROOVY_SCRIPT.getExtensions()).anyMatch(ext -> name.endsWith((String)ext)) ? name.substring(0, name.lastIndexOf(".")) : name;
        if (!Character.isJavaIdentifierStart(nameToCheck.charAt(0))) {
            return false;
        }
        int index = 1;
        while (index < nameToCheck.length()) {
            if (!Character.isJavaIdentifierPart(nameToCheck.charAt(index))) {
                return false;
            }
            ++index;
        }
        return true;
    }

    @Override
    public final ITextValidator getScriptNameValidator(final DirectoryPath parentDirectoryPath) {
        assert (parentDirectoryPath != null) : "Parameter 'parentDirectoryPath' of method 'getScriptNameValidator' must not be null";
        assert (this.isScriptDirectory(parentDirectoryPath)) : "Not a script directory: " + String.valueOf(parentDirectoryPath);
        return new ITextValidator(){

            @Override
            public ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                if (newInput != null) {
                    newInput = newInput.trim();
                } else {
                    result.addError("Input not valid");
                }
                if (newInput.isEmpty()) {
                    result.addError("Must not be empty");
                } else if (newInput.endsWith(CoreFileType.GROOVY_SCRIPT.getDefaultExtension())) {
                    result.addError("Extension will be added automatically");
                } else if (result.inputModified()) {
                    if (!GroovyProvider.this.isFileNameAJavaIdentifier(newInput)) {
                        result.addError("Must be a valid Java identifier");
                    } else {
                        String newInputWithExtension = newInput + CoreFileType.GROOVY_SCRIPT.getDefaultExtension();
                        for (GroovyScript next : parentDirectoryPath.getChildren(GroovyScript.class)) {
                            if (!next.getShortName().equalsIgnoreCase(newInputWithExtension)) continue;
                            result.addError("Groovy script with name '" + newInput + "' already exists");
                            break;
                        }
                    }
                }
                return result;
            }
        };
    }

    @Override
    public final IPathValidator getDirectoryPathValidator() {
        return new IPathValidator(){

            @Override
            public ValidationResult isValid(TFile currentInput, TFile newInput) {
                ValidationResult result = new ValidationResult(FileUtility.areEqual((TFile)currentInput, (TFile)newInput));
                if (newInput == null) {
                    result.addError("Null input");
                    return result;
                }
                if (!newInput.isDirectory() || !newInput.isDirectory()) {
                    result.addError("Not a directory");
                    return result;
                }
                if (FileUtility.areEqual((TFile)newInput, (TFile)GroovyProvider.this.getScriptsDirectory().getFile())) {
                    return result;
                }
                for (ScriptDirectory nextPath : GroovyProvider.this.m_softwareSystem.getUniqueExistingChild(Files.class).getChildrenRecursively(ScriptDirectory.class, new Class[0])) {
                    if (!FileUtility.areEqual((TFile)currentInput, (TFile)nextPath.getFile())) continue;
                    return result;
                }
                result.addError("Not a Scripts directory");
                return result;
            }

            @Override
            public IPathValidator.PathType getType() {
                return IPathValidator.PathType.DIRECTORY;
            }
        };
    }

    @Override
    public final ITextValidator getDirectoryNameValidator(final DirectoryPath parentDirectoryPath) {
        assert (parentDirectoryPath != null) : "Parameter 'parentDirectoryPath' of method 'getDirectoryNameValidator' must not be null";
        assert (this.isScriptDirectory(parentDirectoryPath)) : "Not a script directory: " + String.valueOf(parentDirectoryPath);
        return new ITextValidator(){

            @Override
            public ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                if (newInput == null) {
                    result.addError("Input not valid");
                    return result;
                }
                if ((newInput = newInput.trim()).isEmpty()) {
                    result.addError("Must not be empty");
                } else if (result.inputModified()) {
                    if (!GroovyProvider.this.isFileNameAJavaIdentifier(newInput)) {
                        result.addError("Invalid directory name");
                    } else {
                        for (ScriptDirectory next : parentDirectoryPath.getChildren(ScriptDirectory.class)) {
                            if (!next.getShortName().equalsIgnoreCase(newInput)) continue;
                            result.addError("Directory with name '" + newInput + "' already exists");
                            break;
                        }
                    }
                }
                return result;
            }
        };
    }

    @Override
    public final ITextValidator getRunConfigurationNameValidator(GroovyScript script, FileBasedRunConfiguration runConfiguration) {
        assert (script != null) : "Parameter 'script' of method 'getRunConfigurationValidator' must not be null";
        THashSet existingRunConfigurationNames = new THashSet();
        for (IRunConfiguration next : script.getRunConfigurations()) {
            if (runConfiguration != null && next.getRunConfigurationName().equals(runConfiguration.getRunConfigurationName())) continue;
            existingRunConfigurationNames.add(next.getRunConfigurationName());
        }
        return new RunConfigurationNameValidator((Set<String>)existingRunConfigurationNames, script.getScriptContent().getParameterDefinitions());
    }

    @Override
    public final ITextValidator getParameterValueValidator(final IGroovyProvider.IParameterDefinitionInfoProvider provider) {
        assert (provider != null) : "Parameter 'provider' of method 'getParameterDefinitionDefaultValueValidator' must not be null";
        return new ITextValidator(){

            @Override
            public ValidationResult isValid(String initialInput, String newInput) {
                if (!$assertionsDisabled && newInput == null) {
                    throw new AssertionError((Object)"Parameter 'newInput' of method 'isValid' must not be null");
                }
                boolean modified = !StringUtility.areEqual((String)initialInput, (String)newInput);
                ValidationResult result = new ValidationResult(modified);
                newInput = newInput.trim();
                if (!provider.getCurrentParameterType().isConversionIntoTargetTypePossible(newInput)) {
                    result.addError("Not of type '" + provider.getCurrentParameterType().getPresentationName() + "'");
                } else if (provider.getCurrentPossibleValuesAsString() != null && !provider.getCurrentPossibleValuesAsString().isEmpty()) {
                    if (!provider.getCurrentParameterType().splitPossibleValues(provider.getCurrentPossibleValuesAsString()).contains(newInput)) {
                        result.addError("Default value not allowed. Must be one of the possible values.");
                    }
                } else if ("output".equals(provider.getCurrentParameterName()) && !newInput.isEmpty()) {
                    if (!FileUtility.normalizedPathMightDenoteFilePath((String)newInput)) {
                        result.addError("Does not represent a possible file path.");
                    } else if (FileUtility.isNormalizedPathAbsolute((String)newInput)) {
                        result.addWarning("Consider not to use an absolute path - it might not be cross-platform compatible.");
                    }
                } else if ("timeout".equals(provider.getCurrentParameterName()) && !newInput.isEmpty()) {
                    Object timeout = provider.getCurrentParameterType().convertIntoTargetType(newInput);
                    if (!($assertionsDisabled || timeout != null && timeout instanceof Integer)) {
                        throw new AssertionError((Object)("Unexpected class in method 'isValid': " + String.valueOf(timeout)));
                    }
                    if ((Integer)timeout < 1) {
                        result.addError("The value must be greater than '0'");
                    }
                }
                return result;
            }
        };
    }

    @Override
    public final ITextValidator getParameterPossibleValuesValidator(final IGroovyProvider.IParameterDefinitionInfoProvider provider) {
        assert (provider != null) : "Parameter 'provider' of method 'getParameterDefinitionPossibleValuesValidator' must not be null";
        return new ITextValidator(){

            @Override
            public ValidationResult isValid(String initialInput, String newInput) {
                if (!$assertionsDisabled && newInput == null) {
                    throw new AssertionError((Object)"Parameter 'newInput' of method 'isValid' must not be null");
                }
                boolean modified = !StringUtility.areEqual((String)initialInput, (String)newInput);
                ValidationResult result = new ValidationResult(modified);
                LinkedHashSet<String> values = new LinkedHashSet<String>();
                for (String next : provider.getCurrentParameterType().splitPossibleValues(newInput)) {
                    if (!provider.getCurrentParameterType().isConversionIntoTargetTypePossible(next)) {
                        result.addError("Not of type '" + provider.getCurrentParameterType().getPresentationName() + "'");
                        continue;
                    }
                    if (values.add(next)) continue;
                    result.addError("Contains duplicate");
                }
                return result;
            }
        };
    }

    @Override
    public final ITextValidator getParameterNameValidator(List<ParameterDefinition.Builder> parameters, ParameterDefinition.Builder parameterToBeEdited) {
        assert (parameters != null) : "Parameter 'parameters' of method 'getParameterNameValidator' must not be null";
        return parameterToBeEdited != null ? new ParameterNameValidator(parameters, parameterToBeEdited) : new ParameterNameValidator(parameters);
    }

    @Override
    public final String getNameForEdit(GroovyScript script) {
        assert (script != null) : "Parameter 'script' of method 'getNameForEdit' must not be null";
        assert (script.isValid()) : "No valid: " + String.valueOf(script);
        return FileUtility.removeExtension((String)script.getShortName());
    }

    public final GroovyScript getScript(final String identifyingPath) {
        assert (identifyingPath != null) : "Parameter 'identifyingPath' of method 'getScript' must not be null";
        return this.getScriptsDirectory().getFirstChildRecursively(new NamedElement.IFilter(){

            @Override
            public boolean accept(NamedElement namedElement) {
                GroovyScript script = (GroovyScript)namedElement;
                return identifyingPath.equalsIgnoreCase(script.getIdentifyingPath());
            }
        }, GroovyScript.class, new Class[0]);
    }

    protected final IScriptApi getScriptApi(IGroovyScript script, ScriptResultSet resultSet, IMetricIdProvider metricIdProvider) {
        assert (script != null) : "Parameter 'script' of method 'getScriptApi' must not be null";
        assert (resultSet != null) : "Parameter 'resultSet' of method 'getScriptApi' must not be null";
        ArrayList<CoreAccess> systemAccesses = new ArrayList<CoreAccess>();
        ScriptApi api = new ScriptApi(script.getIdentifyingPath(), new ScriptAccess(script), new ResultAccess(resultSet));
        systemAccesses.add(new CoreAccess(this.m_installation, this.getSoftwareSystem(), metricIdProvider, api));
        for (LanguageProvider nextLanguageProvider : this.m_accessor.getAvailableLanguageProviders()) {
            if (!script.getScriptContent().getLanguages().contains(nextLanguageProvider.getLanguage())) continue;
            CoreAccess nextSystemAccess = nextLanguageProvider.getSystemAccess(this.m_installation, this.getSoftwareSystem(), metricIdProvider, api);
            assert (nextSystemAccess != null) : "Parameter 'nextSystemAccess' of method 'getScriptApi' must not be null";
            systemAccesses.add(nextSystemAccess);
        }
        return api;
    }

    @Override
    public final void accept(ISourceFileRegionVisitor visitor, String content, IFileType fileType) {
        assert (fileType != null) : "Parameter 'fileType' of method 'accept' must not be null";
        assert (fileType.equals((Object)CoreFileType.GROOVY_SCRIPT)) : "Unexpected 'fileType' " + fileType.getPresentationName();
        JavaFamilySourceLineVisitor.process(visitor, content, CoreKeywords.getGroovyKeywords());
    }

    @Override
    public final boolean editRequiresSave(GroovyScript script, String newName) {
        assert (script != null) : "Parameter 'script' of method 'editRequiresSave' must not be null";
        assert (newName != null && newName.length() > 0) : "Parameter 'newName' of method 'editRequiresSave' must not be empty";
        return !newName.equals(FileUtility.getFileNameWithoutExtension((TFile)script.getFile())) && script.needsSave();
    }

    @Override
    public boolean editRequiresSave(FileBasedRunConfiguration runConfiguration, String newName) {
        assert (runConfiguration != null) : "Parameter 'runConfiguration' of method 'editRequiresSave' must not be null";
        return !runConfiguration.getRunConfigurationName().equals(newName);
    }

    @Override
    public final boolean areDeletableScriptElements(List<? extends Element> elements) {
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'areDeletableScriptElements' must not be empty";
        for (Element element : elements) {
            if (element instanceof GroovyScript || element instanceof ScriptDirectory || element instanceof FileBasedRunConfiguration) continue;
            return false;
        }
        return true;
    }

    protected final Set<NamedElement> getNormalizedScriptElementsToDelete(List<? extends Element> scriptElements, OperationResult result) {
        assert (scriptElements != null && !scriptElements.isEmpty()) : "Parameter 'scriptElements' of method 'getNormalizedScriptElementsToDelete' must not be empty";
        ArrayList<NamedElement> namedElements = new ArrayList<NamedElement>(scriptElements.size());
        for (Element element : scriptElements) {
            if (!(element instanceof NamedElement)) continue;
            namedElements.add((NamedElement)element);
        }
        Set<NamedElement> set = NamedElementUtility.normalize(namedElements, true, new Class[0]);
        if (result != null) {
            for (NamedElement nextNamedElement : set) {
                if (nextNamedElement instanceof GroovyScript) {
                    GroovyScript script = (GroovyScript)nextNamedElement;
                    if (!SoftwareSystemFilesDirectory.isOutOfSync(script)) continue;
                    result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_SYSTEM_OUT_OF_SYNC, script.getIdentifyingPath(), new Object[0]);
                    continue;
                }
                if (nextNamedElement instanceof FileBasedRunConfiguration) {
                    FileBasedRunConfiguration runConfiguration = (FileBasedRunConfiguration)nextNamedElement;
                    if (!SoftwareSystemFilesDirectory.isOutOfSync(runConfiguration)) continue;
                    result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_SYSTEM_OUT_OF_SYNC, runConfiguration.getIdentifyingPath(), new Object[0]);
                    continue;
                }
                if (nextNamedElement instanceof ScriptDirectory) {
                    ScriptDirectory directoryPath = (ScriptDirectory)nextNamedElement;
                    TFile file = directoryPath.getFile();
                    if (!file.exists()) {
                        result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_SYSTEM_OUT_OF_SYNC, directoryPath.getIdentifyingPath(), new Object[0]);
                    }
                    for (GroovyScript next : directoryPath.getChildrenRecursively(GroovyScript.class, GroovyScript.class)) {
                        if (!SoftwareSystemFilesDirectory.isOutOfSync(next)) continue;
                        result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_SYSTEM_OUT_OF_SYNC, next.getIdentifyingPath(), new Object[0]);
                    }
                    continue;
                }
                assert (false) : "Unhandled script element type: " + String.valueOf(nextNamedElement);
            }
        }
        return set;
    }

    @Override
    public final Set<String> scriptElementsDeletionAffectsScriptRunner(List<? extends Element> scriptElements) {
        assert (this.areDeletableScriptElements(scriptElements)) : "Not deletable script elements";
        ScriptRunnerConfiguration configuration = this.getScriptRunnerConfiguration();
        if (configuration != null) {
            TreeSet<String> toBeDeleted = new TreeSet<String>();
            for (Element element : this.getNormalizedScriptElementsToDelete(scriptElements, null)) {
                if (element instanceof GroovyScript) {
                    String identifyingPath = ((GroovyScript)element).getIdentifyingPath();
                    List<String> automated = configuration.getAutomatedRunConfigurations(identifyingPath);
                    for (String nextRunConfiguration : automated) {
                        toBeDeleted.add(identifyingPath + ":" + nextRunConfiguration);
                    }
                    continue;
                }
                if (element instanceof FileBasedRunConfiguration) {
                    FileBasedRunConfiguration runConfiguration = (FileBasedRunConfiguration)element;
                    GroovyScript script = runConfiguration.getParent(GroovyScript.class, new Class[0]);
                    assert (script != null) : "'script' of method 'scriptElementsDeletionAffectsScriptRunner' must not be null";
                    if (!configuration.isAutomated(script.getIdentifyingPath(), runConfiguration.getRunConfigurationName())) continue;
                    toBeDeleted.add(script.getIdentifyingPath() + ":" + runConfiguration.getRunConfigurationName());
                    continue;
                }
                if (!(element instanceof ScriptDirectory)) continue;
                for (GroovyScript nextScript : ((ScriptDirectory)element).getChildrenRecursively(GroovyScript.class, GroovyScript.class)) {
                    String identifyingPath = nextScript.getIdentifyingPath();
                    List<String> automated = configuration.getAutomatedRunConfigurations(identifyingPath);
                    for (String nextRunConfiguration : automated) {
                        toBeDeleted.add(identifyingPath + ":" + nextRunConfiguration);
                    }
                }
            }
            return toBeDeleted;
        }
        return Collections.emptySet();
    }

    protected final ScriptRunnerConfiguration getScriptRunnerConfiguration() {
        AnalyzerConfiguration configuration = this.m_softwareSystem.getExtension(IAnalyzerController.class).getConfiguration(CoreAnalyzerId.SCRIPT_RUNNER);
        if (configuration != null) {
            assert (configuration instanceof ScriptRunnerConfiguration) : "Unexpected class in method 'getScriptRunnerConfiguration': " + String.valueOf(configuration);
            return (ScriptRunnerConfiguration)configuration;
        }
        return null;
    }

    @Override
    public boolean isAutomated(IRunConfiguration configuration) {
        assert (configuration != null) : "Parameter 'configuration' of method 'isAutomated' must not be null";
        if (configuration instanceof DefaultRunConfiguration) {
            GroovyScript script = ((DefaultRunConfiguration)configuration).getParent(GroovyScript.class, new Class[0]);
            return this.isAutomated(script, configuration);
        }
        if (configuration instanceof FileBasedRunConfiguration) {
            GroovyScript script = ((FileBasedRunConfiguration)configuration).getParent(GroovyScript.class, new Class[0]);
            return this.isAutomated(script, configuration);
        }
        return false;
    }

    protected final boolean isAutomated(GroovyScript script, IRunConfiguration runConfiguration) {
        assert (script != null) : "Parameter 'script' of method 'isAutomatedScriptWithRunConfiguration' must not be null";
        ScriptRunnerConfiguration configuration = this.getScriptRunnerConfiguration();
        if (configuration == null) {
            return false;
        }
        String runConfigurationName = runConfiguration != null ? runConfiguration.getRunConfigurationName() : null;
        return configuration.isAutomated(script.getIdentifyingPath(), runConfigurationName);
    }

    private final EnumSet<ScriptDiff> getDifferences(GroovyScript script, ScriptContent currentContent, String newName, ScriptContent newContent, DiffMode mode) {
        assert (script != null) : "Parameter 'script' of method 'getDifferences' must not be null";
        assert (newName != null) : "Parameter 'newName' of method 'getDifferences' must not be null";
        assert (currentContent != null) : "Parameter 'currentContent' of method 'getDifferences' must not be null";
        assert (newContent != null) : "Parameter 'newContent' of method 'getDifferences' must not be null";
        assert (script != null) : "Parameter 'script' of method 'getDifferencesWithAutomatedScript' must not be null";
        assert (mode != null) : "Parameter 'mode' of method 'getDifferences' must not be null";
        EnumSet<ScriptDiff> diff = EnumSet.noneOf(ScriptDiff.class);
        if (!newName.equals(FileUtility.getFileNameWithoutExtension((TFile)script.getFile()))) {
            diff.add(ScriptDiff.NAME);
        }
        if (!newContent.getDescription().equals(currentContent.getDescription())) {
            diff.add(ScriptDiff.DESCRIPTION);
        }
        if (!newContent.getLanguages().equals(currentContent.getLanguages())) {
            diff.add(ScriptDiff.LANGUAGES);
        }
        if (mode != DiffMode.AUTOMATED) {
            if (!newContent.getParameterDefinitions().equals(currentContent.getParameterDefinitions())) {
                diff.add(ScriptDiff.PARAMETER_DEFINITIONS);
            }
        } else {
            THashSet currentParameterDefinitions;
            THashSet newParameterDefinitions = new THashSet(newContent.getParameterDefinitions());
            if (!newParameterDefinitions.equals(currentParameterDefinitions = new THashSet(currentContent.getParameterDefinitions()))) {
                diff.add(ScriptDiff.PARAMETER_DEFINITIONS);
            }
            THashSet newRunConfigurationParameters = new THashSet();
            for (IRunConfiguration next : newContent.getRunConfigurations()) {
                if (!this.isAutomated(script, next)) continue;
                newRunConfigurationParameters.add(next.getDefinedParameters());
            }
            THashSet currentRunConfigurationParameters = new THashSet();
            for (IRunConfiguration next : currentContent.getRunConfigurations()) {
                if (!this.isAutomated(script, next)) continue;
                currentRunConfigurationParameters.add(next.getDefinedParameters());
            }
            if (!newRunConfigurationParameters.equals(currentRunConfigurationParameters)) {
                diff.add(ScriptDiff.RUN_CONFIGURATION_PARAMETERS);
            }
            if (!newContent.getSource().equals(currentContent.getSource())) {
                diff.add(ScriptDiff.SOURCE);
            }
        }
        return diff;
    }

    protected final EnumSet<ScriptDiff> getDifferencesOfScriptConfiguration(GroovyScript script, String newName, ScriptContent newContent) {
        assert (script != null) : "Parameter 'script' of method 'getDifferences' must not be null";
        assert (newName != null) : "Parameter 'newName' of method 'getDifferences' must not be null";
        assert (newContent != null) : "Parameter 'newContent' of method 'getDifferences' must not be null";
        return this.getDifferences(script, script.getScriptContent(), newName, newContent, DiffMode.SCRIPT_CONFIGURATION);
    }

    @Override
    public final boolean hasScriptConfigurationChanged(GroovyScript script, String newName, ScriptContent newContent) {
        return !this.getDifferencesOfScriptConfiguration(script, newName, newContent).isEmpty();
    }

    @Override
    public final Set<Language> getAvailableLanguages() {
        return this.m_accessor.getAvailableLanguages();
    }

    @Override
    public List<GroovyScript> getAvailableScripts() {
        return this.getScriptsDirectory().getChildrenRecursively(GroovyScript.class, ScriptContent.class);
    }

    @Override
    public final FullGroovyScript getFullScript(GroovyScript script, IMetricIdProvider metricIdProvider, String source, int offset) {
        return this.m_groovyShell.getFullScript(script, this.getScriptApi(script, script.getResultSet(), metricIdProvider), source, offset);
    }

    protected final EnumSet<ScriptDiff> getDifferencesOfAutmatedScript(GroovyScript script) {
        assert (script != null) : "Parameter 'script' of method 'getDifferencesOfAutmatedScript' must not be null";
        assert (this.isAutomated(script, null)) : "Not automated: " + String.valueOf(script);
        ScriptContent automatedScriptContent = this.m_identifyingPathToAutomatedScriptContent.get(script.getIdentifyingPath());
        assert (automatedScriptContent != null) : "Script '" + script.getIdentifyingPath() + "' has no automated content";
        return this.getDifferences(script, script.getScriptContent(), FileUtility.getFileNameWithoutExtension((TFile)script.getFile()), automatedScriptContent, DiffMode.AUTOMATED);
    }

    @Override
    public final Result canContentBeTransferedToAutomatedScript(GroovyScript script) {
        assert (script != null) : "Parameter 'script' of method 'canContentBeTransferedToAutomatedScript' must not be null";
        Result result = new Result();
        if (!this.isAutomated(script, null)) {
            result.addErrorMessage("Script is not configured to be run automatically");
            return result;
        }
        if (!script.isExecutable()) {
            result.addErrorMessage("Script must be compiled successfully first");
            return result;
        }
        if (script.needsSave()) {
            result.addErrorMessage("Script must be saved first");
            return result;
        }
        EnumSet<ScriptDiff> diff = this.getDifferencesOfAutmatedScript(script);
        if (diff.isEmpty()) {
            result.addErrorMessage("Script does not differ from automated script");
        }
        return result;
    }

    @Override
    public boolean mayBeAddedToScriptRunnerExecution(List<Element> elements) {
        return this.internCheckForAutomatedStatus(elements, false);
    }

    @Override
    public boolean mayBeRemovedFromScriptRunner(List<Element> elements) {
        return this.internCheckForAutomatedStatus(elements, true);
    }

    private boolean internCheckForAutomatedStatus(List<Element> elements, boolean mustBeAutomated) {
        assert (elements != null && elements.size() > 0) : "Parameter 'elements' of method 'mayBeAddedToAutomatedExecution' must not be empty";
        long numberOfValidElements = elements.stream().filter(e -> e != null).filter(e -> e instanceof DefaultRunConfiguration || e instanceof FileBasedRunConfiguration).count();
        if ((long)elements.size() != numberOfValidElements) {
            return false;
        }
        for (Element next : elements) {
            NamedElementContainer runConfig;
            GroovyScript script;
            if (next instanceof DefaultRunConfiguration) {
                DefaultRunConfiguration defaultRunConfig = (DefaultRunConfiguration)next;
                script = defaultRunConfig.getParent(GroovyScript.class, new Class[0]);
                runConfig = defaultRunConfig;
            } else {
                assert (next != null && next instanceof FileBasedRunConfiguration) : "Unexpected class in method 'addToAutomated': " + String.valueOf(next);
                FileBasedRunConfiguration fileBasedRunConfig = (FileBasedRunConfiguration)next;
                script = fileBasedRunConfig.getParent(GroovyScript.class, new Class[0]);
                runConfig = fileBasedRunConfig;
            }
            if (!(mustBeAutomated ? !this.isAutomated(script, (IRunConfiguration)((Object)runConfig)) : this.isAutomated(script, (IRunConfiguration)((Object)runConfig)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<AutoCompletionProposal> getAutoCompletionProposals(GroovyScript script, String text, int offset, int line) {
        assert (script != null) : "Parameter 'script' of method 'getAutoCompletionProposals' must not be null";
        assert (text != null) : "Parameter 'text' of method 'getAutoCompletionProposals' must not be null";
        assert (offset >= 0) : "'offset' must not be negative";
        assert (line >= 0) : "'line' must not be negative";
        if (script.getScriptApi() != null) {
            assert (script.getClassLoader() != null) : "'classLoader' must not be null";
            return ScriptAutoCompletionProposalsCollector.getAutoCompletionProposals(script.getCompiledScript(), script.getScriptApi(), script.getClassLoader(), text, offset, line);
        }
        return Collections.emptyList();
    }

    private static enum DiffMode {
        SCRIPT_CONFIGURATION,
        AUTOMATED;

    }

    public static enum ScriptDiff {
        NAME,
        DESCRIPTION,
        LANGUAGES,
        PARAMETER_DEFINITIONS,
        RUN_CONFIGURATION_PARAMETERS,
        SOURCE;

    }
}

