/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.GroovyProvider;
import com.hello2morrow.sonargraph.core.controller.system.IQualityModelProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderAccessor;
import com.hello2morrow.sonargraph.core.controller.system.analysis.IGroovyScriptAccess;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.ResetMode;
import com.hello2morrow.sonargraph.core.controller.system.base.AnalyzerConfigurationChangeMode;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.controller.system.base.IModifiableFileProvider;
import com.hello2morrow.sonargraph.core.controller.system.base.ISoftwareSystemLifecycleListener;
import com.hello2morrow.sonargraph.core.controller.system.script.GroovyMessageCause;
import com.hello2morrow.sonargraph.core.controller.system.script.internal.ScriptMetricRepository;
import com.hello2morrow.sonargraph.core.controllerinterface.common.ILicenseProvider;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IGroovyExtension;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ISoftwareSystemController;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfigurationFile;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.ScriptRunnerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.ScriptRunnerData;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.BackgroundTaskException;
import com.hello2morrow.sonargraph.core.model.common.IAnalyzerId;
import com.hello2morrow.sonargraph.core.model.common.IOriginator;
import com.hello2morrow.sonargraph.core.model.common.SonargraphFeature;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.ExceptionEvent;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.ScriptCompiledEvent;
import com.hello2morrow.sonargraph.core.model.event.ScriptExecutedEvent;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemEvent;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.IModifiableDirectory;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFileAccess;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFileDeltaKey;
import com.hello2morrow.sonargraph.core.model.path.IModificationOnSave;
import com.hello2morrow.sonargraph.core.model.path.ImportQualityModel;
import com.hello2morrow.sonargraph.core.model.path.ModifiableDirectoryPathCandidate;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileCandidate;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDelta;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDeltaDetector;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFilesDirectory;
import com.hello2morrow.sonargraph.core.model.script.AutomatedGroovyScript;
import com.hello2morrow.sonargraph.core.model.script.AutomatedScriptRuntimeError;
import com.hello2morrow.sonargraph.core.model.script.DefaultRunConfiguration;
import com.hello2morrow.sonargraph.core.model.script.FileBasedRunConfiguration;
import com.hello2morrow.sonargraph.core.model.script.GroovyScript;
import com.hello2morrow.sonargraph.core.model.script.GroovyScripts;
import com.hello2morrow.sonargraph.core.model.script.IGroovyScript;
import com.hello2morrow.sonargraph.core.model.script.IMetricIdProvider;
import com.hello2morrow.sonargraph.core.model.script.IRunConfiguration;
import com.hello2morrow.sonargraph.core.model.script.RunConfigurationParameters;
import com.hello2morrow.sonargraph.core.model.script.ScriptApiLanguageIssue;
import com.hello2morrow.sonargraph.core.model.script.ScriptContent;
import com.hello2morrow.sonargraph.core.model.script.ScriptDirectory;
import com.hello2morrow.sonargraph.core.model.script.ScriptMessageCause;
import com.hello2morrow.sonargraph.core.model.script.ScriptOutputStreamProvider;
import com.hello2morrow.sonargraph.core.model.script.ScriptResultSet;
import com.hello2morrow.sonargraph.core.model.script.ScriptRunnerConfigurationInconsistent;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.persistence.script.ScriptPersistence;
import com.hello2morrow.sonargraph.core.persistence.script.runconfiguration.RunConfigurationPersistence;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.event.Event;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.file.TrueZipFacade;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GroovyExtension
extends GroovyProvider
implements IGroovyExtension,
IGroovyScriptAccess,
IModifiableFileProvider,
IModifiableFileDeltaKey,
IQualityModelProvider,
ISoftwareSystemLifecycleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyExtension.class);
    private static final int MILLIS_TO_WAIT_FOR_MANUAL_SCRIPT_THREAD = 500;
    private static final long MILLIS_TO_WAIT_FOR_AUTOMATED_SCRIPT_THREAD = 10L;
    private static final long SCRIPT_CANCELLATION_CHECK_INTERVAL = 10L;
    private final IFinishModelProcessor m_finishModelProcessor;
    private final Map<String, Thread> m_manualScriptExecutionsMap = Collections.synchronizedMap(new HashMap());

    GroovyExtension(LanguageProviderAccessor accessor, Installation installation, SoftwareSystem softwareSystem, ScriptOutputStreamProvider outputStreamProvider, IFinishModelProcessor finishModelProcessor) {
        super(accessor, installation, softwareSystem, outputStreamProvider);
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'GroovyExtension' must not be null";
        this.m_finishModelProcessor = finishModelProcessor;
        this.m_finishModelProcessor.addListener(this);
    }

    @Override
    public void checkOutOfSync(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'checkOutOfSync' must not be null";
        GroovyScripts scripts = this.getScriptsDirectory();
        scripts.enforceExistence(result);
        if (result.isSuccess()) {
            IModifiableFileAccess fileAccess = new IModifiableFileAccess(){

                @Override
                public List<IModifiableFile> getModifiableFiles(SoftwareSystemDirectoryPath directoryPath) {
                    if (!$assertionsDisabled && directoryPath == null) {
                        throw new AssertionError((Object)"Parameter 'directoryPath' of method 'getModifiableFiles' must not be null");
                    }
                    ArrayList<IModifiableFile> modifiableFiles = new ArrayList<IModifiableFile>(directoryPath.getChildren(IModifiableFile.class));
                    for (GroovyScript nextScript : directoryPath.getChildren(GroovyScript.class)) {
                        modifiableFiles.addAll(nextScript.getFileBasedRunConfigurations());
                    }
                    return modifiableFiles;
                }
            };
            if (SoftwareSystemFilesDirectory.isOutOfSync(this.getScriptRunnerConfigurationFile()) || this.getScriptsDirectory().isOutOfSync(fileAccess, (String[][])new String[][]{CoreFileType.GROOVY_SCRIPT.getExtensions(), CoreFileType.RUN_CONFIGURATION.getExtensions()})) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_SYSTEM_OUT_OF_SYNC, "Consider to refresh the system", new Object[0]);
            }
        }
    }

    private void resetScriptResults() {
        this.getSoftwareSystem().getUniqueExistingChild(Files.class).getGroovyScripts().getChildren(GroovyScript.class).forEach(s -> s.getResultSet().reset());
    }

    private void compile(IGroovyScript script, IRunConfiguration runConfiguration, ScriptResultSet resultSet, IMetricIdProvider metricIdProvider, boolean isAutomated, NamedElement issueTarget) {
        assert (script != null) : "Parameter 'script' of method 'compile' not be null";
        assert (resultSet != null) : "Parameter 'resultSet' of method 'compile' must not be null";
        assert (issueTarget != null) : "Parameter 'issueTarget' of method 'compile' must not be null";
        this.getShell().compile(script, this.getScriptApi(script, resultSet, metricIdProvider), runConfiguration == null ? script.getScriptContent().getDefaultRunConfiguration() : runConfiguration, isAutomated, issueTarget);
    }

    @Override
    public OperationResultWithOutcome<GroovyScript> createScript(IWorkerContext workerContext, String name, DirectoryPath parentDirectoryPath, ScriptContent scriptContent) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createScript' must not be null";
        assert (parentDirectoryPath != null) : "Parameter 'parentDirectoryPath' of method 'createScript' must not be null";
        assert (this.isScriptDirectory(parentDirectoryPath)) : "Not a script directory: " + String.valueOf(parentDirectoryPath);
        ValidationResult nameValidationResult = this.getScriptNameValidator(parentDirectoryPath).isValid(null, name);
        assert (nameValidationResult.isSuccess()) : "Script name '" + name + "' not valid - " + String.valueOf(nameValidationResult);
        assert (scriptContent != null) : "Parameter 'scriptContent' of method 'createScript' must not be null";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Create Groovy Script");
        this.checkOutOfSync((OperationResult)result);
        if (result.isFailure()) {
            return result;
        }
        TFile file = new TFile((File)parentDirectoryPath.getFile(), name + CoreFileType.GROOVY_SCRIPT.getDefaultExtension());
        Files files = this.getSoftwareSystem().getUniqueExistingChild(Files.class);
        GroovyScript script = new GroovyScript(parentDirectoryPath, file, scriptContent, files);
        this.getScriptPersistence().storeScriptToFile(file, scriptContent, (OperationResult)result);
        TrueZipFacade.clear((TFile)file);
        if (result.isSuccess()) {
            parentDirectoryPath.addChild(script);
            script.resetTimestamp();
            script.setExistsOnDisk(true);
            result.setOutcome((Object)script);
            this.compile(script, null, script.getResultSet(), null, false, script);
            this.addAutomatedScriptContent(script.getIdentifyingPath(), scriptContent);
            this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), (OperationResult)result);
        }
        return result;
    }

    @Override
    public Set<IAnalyzerId> getAffectedAnalyzerIdsOnModifiableFileInterchange() {
        return Collections.singleton(CoreAnalyzerId.SCRIPT_RUNNER);
    }

    @Override
    public void prepareRefresh(ModifiableFileDeltaDetector deltaDetector, boolean onSystemOpen, final PrepareRefreshResult result) {
        assert (deltaDetector != null) : "Parameter 'deltaDetector' of method 'prepareRefresh' must not be null";
        final HashSet identifyingPaths = new HashSet();
        final GroovyScripts scriptsDirectory = this.getScriptsDirectory();
        scriptsDirectory.checkExistence();
        deltaDetector.detect(new ModifiableFileDeltaDetector.IProvider(){

            @Override
            public IModifiableFileDeltaKey getKey() {
                return GroovyExtension.this;
            }

            @Override
            public DirectoryPath getDirectoryPath() {
                return scriptsDirectory;
            }

            @Override
            public List<IFileType> getFileTypes() {
                return Arrays.asList(new IFileType[]{CoreFileType.GROOVY_SCRIPT, CoreFileType.RUN_CONFIGURATION});
            }

            @Override
            public boolean accept(TFile file) {
                if (!$assertionsDisabled && file == null) {
                    throw new AssertionError((Object)"Parameter 'file' of method 'accept' must not be null");
                }
                String identifyingPath = FileUtility.calculateRelativePath((TFile)file, (TFile)scriptsDirectory.getFile());
                String normalizedIdentifyingPath = identifyingPath.toLowerCase();
                if (identifyingPaths.add(normalizedIdentifyingPath)) {
                    return true;
                }
                result.addWarning(GroovyMessageCause.IGNORED_SCRIPT, "Ignored '" + identifyingPath + "' which differs only in case from already processed script.", new Object[0]);
                return false;
            }

            @Override
            public String getImageResource(IFileType fileType) {
                if (!$assertionsDisabled && fileType == null) {
                    throw new AssertionError((Object)"Parameter 'fileType' of method 'getImageResource' must not be null");
                }
                if (fileType == CoreFileType.GROOVY_SCRIPT) {
                    return GroovyScript.class.getSimpleName();
                }
                if (!$assertionsDisabled && fileType != CoreFileType.RUN_CONFIGURATION) {
                    throw new AssertionError((Object)("Unexpected file type: " + String.valueOf(fileType)));
                }
                return FileBasedRunConfiguration.class.getSimpleName();
            }
        });
    }

    @Override
    public void refreshFiles(IWorkerContext workerContext, ModifiableFileDelta delta, EnumSet<Modification> modifications, final OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'refreshFiles' must not be null";
        assert (result != null) : "Parameter 'result' of method 'refreshFiles' must not be null";
        assert (delta != null) : "Parameter 'delta' of method 'refreshFiles' must not be null";
        delta.visit(new ModifiableFileDelta.IVisitor(){

            @Override
            public IModifiableFileDeltaKey getKey() {
                return GroovyExtension.this;
            }

            @Override
            public void visitModified(IModifiableFile modified) {
                if (!$assertionsDisabled && modified == null) {
                    throw new AssertionError((Object)"Parameter 'modified' of method 'visitModified' must not be null");
                }
                if (modified.getFileType() == CoreFileType.GROOVY_SCRIPT) {
                    if (!$assertionsDisabled && !(modified instanceof GroovyScript)) {
                        throw new AssertionError((Object)("Unexpected class in method 'visitModified': " + String.valueOf(modified)));
                    }
                    GroovyScript script = (GroovyScript)modified;
                    result.addMessagesFrom(GroovyExtension.this.addScript(modified.getFile(), modified.getFile(), script, false));
                } else {
                    if (!$assertionsDisabled && !(modified instanceof FileBasedRunConfiguration)) {
                        throw new AssertionError((Object)("Unexpected class in method 'visitModified': " + String.valueOf(modified)));
                    }
                    FileBasedRunConfiguration runConfiguration = (FileBasedRunConfiguration)modified;
                    result.addMessagesFrom(GroovyExtension.this.addRunConfiguration(modified.getFile(), modified.getFile(), runConfiguration, false));
                }
            }

            @Override
            public void visitDeleted(IModifiableFile deleted) {
                if (!$assertionsDisabled && deleted == null) {
                    throw new AssertionError((Object)"Parameter 'deleted' of method 'visitDeleted' must not be null");
                }
                if (deleted.getFileType() == CoreFileType.GROOVY_SCRIPT) {
                    if (!$assertionsDisabled && !(deleted instanceof GroovyScript)) {
                        throw new AssertionError((Object)("Unexpected class in method 'visitDeleted': " + String.valueOf(deleted)));
                    }
                    GroovyExtension.this.removeAutomatedScriptContent(deleted.getIdentifyingPath());
                    ((GroovyScript)deleted).remove();
                } else {
                    if (!$assertionsDisabled && !(deleted instanceof FileBasedRunConfiguration)) {
                        throw new AssertionError((Object)("Unexpected class in method 'visitDeleted': " + String.valueOf(deleted)));
                    }
                    ((FileBasedRunConfiguration)deleted).remove();
                }
            }

            @Override
            public void visitAdded(ModifiableFileCandidate added) {
                if (!$assertionsDisabled && added == null) {
                    throw new AssertionError((Object)"Parameter 'added' of method 'visitAdded' must not be null");
                }
                if (added.getFileType() == CoreFileType.GROOVY_SCRIPT) {
                    String scriptName = added.getFile().getName();
                    if (!GroovyExtension.this.isFileNameAJavaIdentifier(scriptName)) {
                        result.addWarning((OperationResult.IMessageCause)ScriptMessageCause.INVALID_SCRIPT_NAME, "Name '" + scriptName + "' is invalid.", new Object[0]);
                        return;
                    }
                    result.addMessagesFrom(GroovyExtension.this.addScript(added.getFile(), added.getFile(), null, false));
                } else {
                    result.addMessagesFrom(GroovyExtension.this.addRunConfiguration(added.getFile(), added.getFile(), null, false));
                }
            }

            @Override
            public void visitAdded(ModifiableDirectoryPathCandidate added) {
                if (!$assertionsDisabled && added == null) {
                    throw new AssertionError((Object)"Parameter 'added' of method 'visitAdded' must not be null");
                }
                String pathName = added.getFile().getName();
                if (!GroovyExtension.this.isFileNameAJavaIdentifier(pathName)) {
                    result.addWarning((OperationResult.IMessageCause)ScriptMessageCause.INVALID_SCRIPT_DIRECTORY_NAME, "Name '" + pathName + "' is invalid.", new Object[0]);
                    return;
                }
                final Files files = GroovyExtension.this.getSoftwareSystem().getUniqueExistingChild(Files.class);
                files.getGroovyScripts().getDirectoryPath(new DirectoryPath.IDirectoryPathCreator(){

                    @Override
                    public DirectoryPath create(NamedElement parent, TFile directory) {
                        return new ScriptDirectory(parent, directory, files);
                    }
                }, added.getFile());
            }

            @Override
            public void visitDeleted(IModifiableDirectory deleted) {
                if (!($assertionsDisabled || deleted != null && deleted instanceof ScriptDirectory)) {
                    throw new AssertionError((Object)("Unexpected class in method 'visitDeleted': " + String.valueOf(deleted)));
                }
                ((ScriptDirectory)deleted).remove();
            }
        }, true);
        if (delta.containsFiles(this)) {
            ScriptRunnerConfiguration config = this.getScriptRunnerConfiguration();
            if (config != null) {
                this.initAutomationStatus(config);
            }
            this.checkScriptRunnerConfiguration();
        }
    }

    private OperationResult addRunConfiguration(TFile contentFile, TFile modelFile, FileBasedRunConfiguration runConfiguration, boolean saveToDisk) {
        String scriptName;
        assert (contentFile != null) : "Parameter 'contentFile' of method 'addRunConfiguration' must not be null";
        assert (modelFile != null) : "Parameter 'modelFile' of method 'addRunConfiguration' must not be null";
        OperationResult result = new OperationResult((runConfiguration != null ? "Modify " : "Add") + " Run Configuration");
        final Files files = this.getSoftwareSystem().getUniqueExistingChild(Files.class);
        String relPath = FileUtility.calculateRelativePath((TFile)modelFile.getParentFile(), (TFile)files.getGroovyScripts().getFile());
        String scriptPath = relPath + "/" + (scriptName = FileBasedRunConfiguration.getScriptName(modelFile)) + CoreFileType.GROOVY_SCRIPT.getDefaultExtension();
        GroovyScript script = this.getScript(scriptPath);
        if (script == null) {
            int i = 1;
            while (i < CoreFileType.GROOVY_SCRIPT.getExtensions().length) {
                scriptPath = relPath + "/" + scriptName + CoreFileType.GROOVY_SCRIPT.getExtensions()[i];
                script = this.getScript(scriptPath);
                if (script != null) break;
                ++i;
            }
        }
        if (script == null) {
            result.addError((OperationResult.IMessageCause)ScriptMessageCause.MISSING_SCRIPT, "Script '" + scriptPath + "' no longer exists or could not be loaded", new Object[0]);
            return result;
        }
        boolean runConfigurationCreated = false;
        if (runConfiguration == null) {
            files.getGroovyScripts().getDirectoryPath(new DirectoryPath.IDirectoryPathCreator(){

                @Override
                public DirectoryPath create(NamedElement parent, TFile file) {
                    return new ScriptDirectory(parent, file, files);
                }
            }, modelFile.getParentFile());
            ScriptContent scriptContent = script.getScriptContent();
            RunConfigurationParameters data = new RunConfigurationParameters();
            runConfiguration = new FileBasedRunConfiguration(scriptContent, modelFile, data, scriptContent, files);
            scriptContent.addChild(runConfiguration);
            runConfigurationCreated = true;
        } else assert (modelFile == runConfiguration.getFile()) : "'modelFile' of method 'addRunConfiguration' must match: " + String.valueOf(runConfiguration.getFile());
        RunConfigurationPersistence runConfigurationPersistence = this.getRunConfigurationPersistence();
        result.addMessagesFrom(runConfigurationPersistence.load(contentFile, runConfiguration));
        if (result.isFailure()) {
            return result;
        }
        if (!runConfigurationCreated) {
            runConfiguration.reloaded(contentFile.lastModified());
        }
        this.addAutomatedScriptContent(script.getIdentifyingPath(), script.getScriptContent());
        if (saveToDisk) {
            OperationResult saveResult = runConfigurationPersistence.save(runConfiguration, modelFile);
            result.addMessagesFrom(saveResult);
            TrueZipFacade.clear((TFile)modelFile);
            if (saveResult.isSuccess()) {
                runConfiguration.resetTimestamp();
            }
        }
        return result;
    }

    @Override
    public void compileScript(IWorkerContext workerContext, GroovyScript script) {
        assert (script != null) : "Parameter 'script' of method 'compileScript' must not be null";
        this.compile(script, null, script.getResultSet(), null, false, script);
        EventManager.getInstance().dispatch((Object)this, (Event)new ScriptCompiledEvent((ISoftwareSystemProvider)this.getSoftwareSystem().getExtension(ISoftwareSystemController.class), script));
        this.m_finishModelProcessor.finishModification(this.getSoftwareSystem(), EnumSet.noneOf(Modification.class));
    }

    private void runAutomatedScript(AutomatedGroovyScript automatedScript, IRunConfiguration runConfiguration, GroovyScript groovyScript) {
        block9: {
            assert (automatedScript != null) : "Parameter 'automatedScript' of method 'run' must not be null";
            assert (automatedScript.isExecutable()) : "'automatedScript' of method 'run' not executable";
            assert (runConfiguration != null) : "Parameter 'runConfiguration' of method 'runAutomatedScript' must not be null";
            assert (groovyScript != null) : "Parameter 'groovyScript' of method 'runAutomatedScript' must not be null";
            Runnable scriptExecutor = () -> {
                automatedScript.getResultSet().reset();
                this.getShell().run(automatedScript, runConfiguration, true, groovyScript);
            };
            Thread scriptExecutorThread = new Thread(scriptExecutor, automatedScript.getIdentifyingPath());
            boolean timedOut = false;
            try {
                long startTime = System.currentTimeMillis();
                scriptExecutorThread.start();
                int duration = runConfiguration.getTimeout() * 1000;
                do {
                    Thread.sleep(10L);
                    boolean bl = timedOut = System.currentTimeMillis() - startTime > (long)duration;
                } while (!timedOut && scriptExecutorThread.isAlive());
                if (timedOut) {
                    if (!this.stopScriptThread(scriptExecutorThread, 10L) && !scriptExecutorThread.isInterrupted()) {
                        LOGGER.warn("Timeout: Thread for automated script {} did not stop within {} millis and has not yet been interruped. State {}", new Object[]{automatedScript.getIdentifyingPath(), 10L, scriptExecutorThread.getState()});
                    }
                    automatedScript.setStatus(IGroovyScript.Status.TIMED_OUT);
                    groovyScript.addIssue(new AutomatedScriptRuntimeError(groovyScript, "Script timed out [" + runConfiguration.getTimeout() + " sec] exceeded"));
                }
            }
            catch (InterruptedException ex) {
                if (this.stopScriptThread(scriptExecutorThread, 10L)) break block9;
                LOGGER.warn("Cancel: Failed to stop thread for automated script {}", (Object)automatedScript.getIdentifyingPath());
            }
        }
    }

    @Override
    public AutomatedGroovyScript runAutomatedScript(NamedElement parent, String identifyingPath, String runConfigurationName, IMetricIdProvider metricIdProvider) {
        assert (parent != null) : "Parameter 'parent' of method 'runAutomatedScript' must not be null";
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'runAutomatedScript' must not be empty";
        assert (runConfigurationName != null && runConfigurationName.length() > 0) : "Parameter 'runConfigurationName' of method 'runAutomatedScript' must not be empty";
        assert (metricIdProvider != null) : "Parameter 'metricIdProvider' of method 'runAutomatedScript' must not be null";
        ScriptContent scriptContent = this.getAutomatedScriptContent(identifyingPath);
        if (scriptContent != null) {
            GroovyScript groovyScript = this.getScript(identifyingPath);
            assert (groovyScript != null) : "'groovyScript' instance for script path '" + identifyingPath + "' must not be null";
            IRunConfiguration runConfiguration = scriptContent.getRunConfiguration(runConfigurationName);
            if (runConfiguration != null) {
                AutomatedGroovyScript automatedGroovyScript = new AutomatedGroovyScript(parent, identifyingPath);
                scriptContent.setParent(automatedGroovyScript);
                automatedGroovyScript.addChild(scriptContent);
                parent.addChild(automatedGroovyScript);
                this.compile(automatedGroovyScript, runConfiguration, automatedGroovyScript.getResultSet(), metricIdProvider, true, groovyScript);
                if (automatedGroovyScript.isExecutable()) {
                    this.runAutomatedScript(automatedGroovyScript, runConfiguration, groovyScript);
                    if (automatedGroovyScript.getStatus() == IGroovyScript.Status.FINISHED_NORMALLY) {
                        automatedGroovyScript.getResultSet().finishModification();
                        automatedGroovyScript.setCompiledScript(null);
                        return automatedGroovyScript;
                    }
                    automatedGroovyScript.setCompiledScript(null);
                }
            }
        }
        return null;
    }

    @Override
    public void runScript(IWorkerContext workerContext, GroovyScript script, IRunConfiguration runConfiguration) {
        assert (script != null) : "Parameter 'script' of method 'run' must not be null";
        assert (runConfiguration != null) : "Parameter 'runConfiguration' of method 'runScript' must not be null";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'runScript' must not be null";
        this.getSoftwareSystem().getExtension(IAnalyzerController.class).waitForAnalyzersToComplete(workerContext);
        if (workerContext.hasBeenCanceled()) {
            return;
        }
        this.compile(script, runConfiguration, script.getResultSet(), new ScriptMetricRepository(), false, script);
        if (!script.isExecutable()) {
            script.setCompiledScript(null);
            return;
        }
        Thread previousExecutionThread = this.m_manualScriptExecutionsMap.put(script.getFileId(), Thread.currentThread());
        assert (previousExecutionThread == null) : "no previous thread for executing the script must exist";
        Runnable scriptExecutor = () -> {
            script.getResultSet().reset();
            this.getShell().run(script, runConfiguration, false, script);
            this.m_finishModelProcessor.finishModification(this.getSoftwareSystem(), EnumSet.noneOf(Modification.class));
            EventManager.getInstance().dispatch((Object)this, (Event)new ScriptExecutedEvent((ISoftwareSystemProvider)this.getSoftwareSystem().getExtension(ISoftwareSystemController.class), script));
            this.m_manualScriptExecutionsMap.remove(script.getFileId());
        };
        Thread currentExecutionThread = new Thread(scriptExecutor, script.getName());
        this.m_manualScriptExecutionsMap.put(script.getFileId(), currentExecutionThread);
        script.setStatus(IGroovyScript.Status.SCHEDULED_FOR_EXECUTION);
        currentExecutionThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                if (!$assertionsDisabled && thread == null) {
                    throw new AssertionError((Object)"Parameter 'thread' of method 'uncaughtException' must not be null");
                }
                if (!$assertionsDisabled && throwable == null) {
                    throw new AssertionError((Object)"Parameter 'throwable' of method 'uncaughtException' must not be null");
                }
                EventManager.getInstance().dispatch((Object)this, (Event)new ExceptionEvent(GroovyExtension.this.getSoftwareSystem().getExtension(ISoftwareSystemProvider.class), new BackgroundTaskException("Exception caught during manual script execution: " + thread.getName(), throwable)));
            }
        });
        currentExecutionThread.start();
        long start = System.currentTimeMillis();
        boolean scriptHasBeenStarted = false;
        while (this.m_manualScriptExecutionsMap.containsKey(script.getFileId())) {
            if (script.getStatus() != IGroovyScript.Status.SCHEDULED_FOR_EXECUTION) {
                scriptHasBeenStarted = true;
            }
            if (scriptHasBeenStarted) {
                LOGGER.debug(" Script is executing");
                if (script.getStatus() != IGroovyScript.Status.EXECUTING) {
                    LOGGER.debug("Script has already been finished");
                }
            }
            if (workerContext.hasBeenCanceled()) {
                boolean stopped;
                LOGGER.debug("Cancelling script");
                Thread thread = this.m_manualScriptExecutionsMap.get(script.getFileId());
                if (thread == null || script.getStatus() != IGroovyScript.Status.EXECUTING || (stopped = this.stopScriptThread(thread, 500L))) break;
                workerContext.working("Stopping script execution", true);
                LOGGER.warn("Script '" + script.getName() + "' could not be stopped within 500 millis. Trying again.");
                continue;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (script.getStatus() == IGroovyScript.Status.EXECUTING) {
                workerContext.working("Executing script '" + script.getShortName() + "' for " + (System.currentTimeMillis() - start) / 1000L + " seconds", true);
                continue;
            }
            if (script.getStatus() != IGroovyScript.Status.FINISHED_NORMALLY) continue;
            workerContext.working("Finished executing script. Updating result info.", true);
        }
    }

    private boolean stopScriptThread(Thread scriptThread, long timeout) {
        assert (scriptThread != null) : "Parameter 'scriptThread' of method 'stopScriptThread' must not be null";
        if (!scriptThread.isAlive() || scriptThread.isInterrupted()) {
            LOGGER.warn(String.format("Thread '%s' for script has already been stopped.", scriptThread.getName()));
            return true;
        }
        scriptThread.interrupt();
        try {
            scriptThread.join(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return !scriptThread.isAlive();
    }

    OperationResult saveScript(GroovyScript script, IModificationOnSave modificationOnSave) {
        String modifiedContent;
        assert (script != null) : "Parameter 'script' of method 'save' must not be null";
        assert (script.needsSave()) : "Does not need save: " + script.getName();
        String content = script.getScriptContent().getSource();
        if (modificationOnSave != null && !(modifiedContent = modificationOnSave.apply(content)).equals(content)) {
            script.getScriptContent().setSource(modifiedContent);
        }
        script.setNeedsSave(true);
        OperationResult result = new OperationResult("Save script");
        if (!script.isExecutable()) {
            this.compile(script, null, script.getResultSet(), null, false, script);
        }
        this.getScriptPersistence().storeScriptToFile(script.getFile(), script.getScriptContent(), result);
        script.setNeedsSave(!result.isSuccess());
        if (!this.isAutomated(script, null)) {
            ScriptContent automatedContent = this.getAutomatedScriptContent(script.getIdentifyingPath());
            assert (automatedContent != null) : "'automatedContent' of method 'saveScript' must not be null";
            automatedContent.setSource(content);
        }
        return result;
    }

    private OperationResult addScript(TFile contentFile, TFile modelFile, GroovyScript script, boolean saveToDisk) {
        assert (contentFile != null) : "Parameter 'contentFile' of method 'createScript' must not be null";
        assert (modelFile != null) : "Parameter 'modelFile' of method 'createScript' must not be null";
        OperationResult loadScriptResult = new OperationResult("Load script content from file");
        ScriptPersistence scriptPersistence = this.getScriptPersistence();
        Pair<ScriptContent, List<String>> scriptContentAndLanguageIssueInfo = scriptPersistence.loadScriptFromFile(contentFile, loadScriptResult);
        ScriptContent scriptContent = null;
        if (loadScriptResult.isFailure()) {
            LOGGER.error("Failed to load script {}", (Object)contentFile.getNormalizedAbsolutePath());
            scriptContent = new ScriptContent.Builder().build();
            StringBuilder builder = new StringBuilder();
            builder.append("/* Error: Content could not be loaded from file: ");
            builder.append(StringUtility.LINE_SEPARATOR);
            builder.append("    ");
            builder.append(contentFile.getNormalizedAbsolutePath());
            builder.append(StringUtility.LINE_SEPARATOR);
            builder.append(StringUtility.LINE_SEPARATOR);
            builder.append(loadScriptResult.toString());
            builder.append(StringUtility.LINE_SEPARATOR);
            builder.append("*/");
            scriptContent.setSource(builder.toString());
            return loadScriptResult;
        }
        assert (scriptContentAndLanguageIssueInfo != null) : "'scriptContentAndLanguageIssueInfo' of method 'addScript' must not be null";
        scriptContent = (ScriptContent)scriptContentAndLanguageIssueInfo.getFirst();
        assert (scriptContent != null) : "'scriptContent' of method 'addScript' must not be null";
        if (script == null) {
            final Files files = this.getSoftwareSystem().getUniqueExistingChild(Files.class);
            DirectoryPath directoryPath = files.getGroovyScripts().getDirectoryPath(new DirectoryPath.IDirectoryPathCreator(){

                @Override
                public DirectoryPath create(NamedElement parent, TFile file) {
                    return new ScriptDirectory(parent, file, files);
                }
            }, modelFile.getParentFile());
            script = new GroovyScript(directoryPath, modelFile, scriptContent, files);
            directoryPath.addChild(script);
            script.setTimestamp(contentFile.lastModified());
        } else {
            assert (modelFile == script.getFile()) : "'modelFile' of method 'addScript' must match: " + String.valueOf(script.getFile());
            List<FileBasedRunConfiguration> existingFileBasedRunConfigs = script.getScriptContent().getChildren(FileBasedRunConfiguration.class);
            script.setScriptContent(scriptContent, true, false, contentFile.lastModified());
            for (FileBasedRunConfiguration next : existingFileBasedRunConfigs) {
                next.changeParent(scriptContent, true);
            }
        }
        List languageIssueInfo = (List)scriptContentAndLanguageIssueInfo.getSecond();
        assert (languageIssueInfo != null) : "Parameter 'languageIssueInfo' of method 'restoreFile' must not be null";
        for (String nextInfo : languageIssueInfo) {
            script.addIssue(new ScriptApiLanguageIssue(script, nextInfo));
        }
        ILicenseProvider licenseProvider = this.m_finishModelProcessor.getLicenseProvider();
        if (!scriptContent.getSource().isEmpty() && licenseProvider.isFeatureAvailable(SonargraphFeature.SCRIPTS_AUTOMATED) && this.isAutomated(script, script.getScriptContent().getDefaultRunConfiguration())) {
            this.compile(script, null, script.getResultSet(), null, true, script);
        }
        if (saveToDisk) {
            OperationResult saveResult = new OperationResult("Store script");
            scriptPersistence.storeScriptToFile(modelFile, scriptContent, saveResult);
            loadScriptResult.addMessagesFrom(saveResult);
            if (saveResult.isSuccess()) {
                script.setExistsOnDisk(true);
                script.resetTimestamp();
            }
            TrueZipFacade.clear((TFile)modelFile);
        }
        if (licenseProvider.isFeatureAvailable(SonargraphFeature.SCRIPTS_AUTOMATED)) {
            this.addAutomatedScriptContent(script.getIdentifyingPath(), script.getScriptContent());
        }
        return loadScriptResult;
    }

    OperationResult saveRunConfiguration(FileBasedRunConfiguration runConfiguration) {
        assert (runConfiguration != null) : "Parameter 'runConfiguration' of method 'saveRunConfiguration' must not be null";
        assert (runConfiguration.needsSave()) : "Does not need save: " + String.valueOf(runConfiguration);
        OperationResult result = this.getRunConfigurationPersistence().save(runConfiguration, runConfiguration.getFile());
        if (result.isSuccess()) {
            runConfiguration.setNeedsSave(false);
            runConfiguration.resetTimestamp();
        }
        return result;
    }

    private void finishWithScriptRunnerConfigurationUpdate(IWorkerContext workerContext, boolean save, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'updateScriptRunnerConfiguration' must not be null";
        assert (result != null) : "Parameter 'result' of method 'updateScriptRunnerConfiguration' must not be null";
        IAnalyzerController analyzerExtension = this.getSoftwareSystem().getExtension(IAnalyzerController.class);
        analyzerExtension.cancelAndResetAllAnalyzers(ResetMode.ALL);
        AnalyzerConfigurationFile scriptRunnerFile = this.getScriptRunnerConfigurationFile();
        assert (scriptRunnerFile != null) : "'scriptRunnerFile' must not be null";
        scriptRunnerFile.setNeedsSave(true);
        if (save) {
            result.addMessagesFrom(analyzerExtension.save(scriptRunnerFile));
        }
        this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), result);
        analyzerExtension.runAutomatedAnalyzers(workerContext);
    }

    @Override
    public OperationResult delete(IWorkerContext workerContext, List<? extends Element> scriptElements) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'delete' must not be null";
        assert (this.areDeletableScriptElements(scriptElements)) : "Not deletable script elements: " + String.valueOf(scriptElements);
        OperationResult result = new OperationResult("Delete script element(s)");
        this.checkOutOfSync(result);
        if (result.isFailure()) {
            return result;
        }
        Set<NamedElement> normalized = this.getNormalizedScriptElementsToDelete(scriptElements, result);
        if (result.isFailure()) {
            return result;
        }
        ArrayList<Pair> removedAutomatedEntries = new ArrayList<Pair>();
        ScriptRunnerConfiguration configuration = this.getScriptRunnerConfiguration();
        for (NamedElement nextNamedElement : normalized) {
            if (nextNamedElement instanceof GroovyScript) {
                GroovyScript script = (GroovyScript)nextNamedElement;
                for (FileBasedRunConfiguration fileBasedRunConfiguration : script.getScriptContent().getChildren(FileBasedRunConfiguration.class)) {
                    SoftwareSystemFilesDirectory.removeFile(fileBasedRunConfiguration.getFile(), false, result);
                    fileBasedRunConfiguration.remove();
                }
                String string = script.getIdentifyingPath();
                if (configuration != null && configuration.isAutomated(string, null)) {
                    removedAutomatedEntries.add(new Pair((Object)string, null));
                }
                this.removeAutomatedScriptContent(string);
                SoftwareSystemFilesDirectory.removeFile(script.getFile(), false, result);
                script.remove();
                continue;
            }
            if (nextNamedElement instanceof FileBasedRunConfiguration) {
                FileBasedRunConfiguration runConfiguration = (FileBasedRunConfiguration)nextNamedElement;
                GroovyScript groovyScript = runConfiguration.getParent(GroovyScript.class, new Class[0]);
                assert (groovyScript != null) : "'script' of method 'delete' must not be null";
                String scriptIdentifyingPath = groovyScript.getIdentifyingPath();
                if (configuration != null && configuration.isAutomated(scriptIdentifyingPath, null)) {
                    removedAutomatedEntries.add(new Pair((Object)scriptIdentifyingPath, (Object)runConfiguration.getRunConfigurationName()));
                }
                SoftwareSystemFilesDirectory.removeFile(runConfiguration.getFile(), false, result);
                runConfiguration.remove();
                this.addAutomatedScriptContent(scriptIdentifyingPath, groovyScript.getScriptContent());
                continue;
            }
            if (nextNamedElement instanceof ScriptDirectory) {
                ScriptDirectory directoryPath = (ScriptDirectory)nextNamedElement;
                for (FileBasedRunConfiguration fileBasedRunConfiguration : directoryPath.getChildrenRecursively(FileBasedRunConfiguration.class, FileBasedRunConfiguration.class)) {
                    fileBasedRunConfiguration.remove();
                }
                for (GroovyScript groovyScript : directoryPath.getChildrenRecursively(GroovyScript.class, GroovyScript.class)) {
                    String scriptIdentifyingPath = groovyScript.getIdentifyingPath();
                    if (configuration != null && configuration.isAutomated(scriptIdentifyingPath, null)) {
                        removedAutomatedEntries.add(new Pair((Object)scriptIdentifyingPath, null));
                    }
                    this.removeAutomatedScriptContent(scriptIdentifyingPath);
                    groovyScript.remove();
                }
                SoftwareSystemFilesDirectory.removeFile(directoryPath.getFile(), true, result);
                directoryPath.remove();
                continue;
            }
            assert (false) : "Unhandled script element type: " + String.valueOf(nextNamedElement);
        }
        if (!removedAutomatedEntries.isEmpty()) {
            assert (configuration != null) : "'configuration' of method 'delete' must not be null";
            List<ScriptRunnerData> data = configuration.getScriptRunnerData();
            Iterator<ScriptRunnerData> dataIterator = data.iterator();
            block4: while (dataIterator.hasNext()) {
                ScriptRunnerData nextData = dataIterator.next();
                for (Pair pair : removedAutomatedEntries) {
                    String nextRunConfigurationName;
                    if (!nextData.getIdentifyingScriptPath().equals(pair.getFirst()) || (nextRunConfigurationName = (String)pair.getSecond()) != null && !nextData.getRunConfigurationName().equals(nextRunConfigurationName)) continue;
                    dataIterator.remove();
                    continue block4;
                }
            }
            configuration.setScriptRunnerData(data);
            this.finishWithScriptRunnerConfigurationUpdate(workerContext, true, result);
            result.setIsSuccess(true);
            return result;
        }
        this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), result);
        return result;
    }

    @Override
    public OperationResult createDirectory(IWorkerContext workerContext, DirectoryPath parentDirectory, String directoryName) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createDirectory' must not be null";
        assert (parentDirectory != null) : "Parameter 'parentDirectory' of method 'createDirectory' must not be null";
        assert (directoryName != null && directoryName.length() > 0) : "Parameter 'directoryName' of method 'createDirectory' must not be empty";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Create Groovy scripts directory");
        this.checkOutOfSync((OperationResult)result);
        if (result.isFailure()) {
            return result;
        }
        TFile directory = new TFile((File)parentDirectory.getFile(), directoryName);
        if (!(directory.exists() && directory.isDirectory() || directory.mkdir())) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_CREATE_DIRECTORY, "Failed to create scripts directory '" + String.valueOf(directory) + "'", new Object[0]);
        }
        if (result.isSuccess()) {
            ScriptDirectory scriptDirectory = new ScriptDirectory((NamedElement)parentDirectory, directory, this.getSoftwareSystem().getUniqueExistingChild(Files.class));
            parentDirectory.addChild(scriptDirectory);
            this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), (OperationResult)result);
        }
        return result;
    }

    @Override
    public OperationResultWithOutcome<GroovyScript> saveScriptAs(GroovyScript script, String modifiedName, TFile baseDir, String modifiedDescription) {
        assert (script != null) : "Parameter 'script' of method 'saveScriptAs' must not be null";
        assert (modifiedName != null && modifiedName.length() > 0) : "Parameter 'modifiedName' of method 'saveScriptAs' must not be empty";
        assert (baseDir != null) : "Parameter 'baseDir' of method 'saveScriptAs' must not be null";
        assert (modifiedDescription != null) : "Parameter 'modifiedDescription' of method 'saveScriptAs' must not be null";
        assert (false) : "Not yet implemented - see SGNG-1014";
        OperationResultWithOutcome result = new OperationResultWithOutcome("Save script '" + script.getName() + "' to a different location");
        if (modifiedName.equals(FileUtility.getFileNameWithoutExtension((TFile)script.getFile())) || this.getScriptNameValidator(script.getParent(DirectoryPath.class, new Class[0])).isValid(script.getName(), modifiedName).isFailure()) {
            result.addError((OperationResult.IMessageCause)ScriptMessageCause.INVALID_SCRIPT_NAME, "Name '" + modifiedName + "' is invalid.", new Object[0]);
            return result;
        }
        return null;
    }

    public List<IModifiableFile> getAvailableFiles() {
        ArrayList<IModifiableFile> result = new ArrayList<IModifiableFile>();
        GroovyScripts groovyScripts = this.getSoftwareSystem().getUniqueExistingChild(Files.class).getGroovyScripts();
        result.addAll(groovyScripts.getChildrenRecursively(GroovyScript.class, new Class[0]));
        result.addAll(groovyScripts.getChildrenRecursively(FileBasedRunConfiguration.class, new Class[0]));
        return result;
    }

    @Override
    public boolean exports(IModifiableFile modifiableFile) {
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'exports' must not be null";
        IFileType fileType = modifiableFile.getFileType();
        return CoreFileType.GROOVY_SCRIPT.equals(fileType) || CoreFileType.RUN_CONFIGURATION.equals(fileType);
    }

    @Override
    public String getExportBaseDirectory() {
        return "Scripts";
    }

    @Override
    public void exportFile(IModifiableFile modifiableFile, TFile realFile, OperationResult result) {
        assert (modifiableFile != null) : "Parameter 'modifiableFile' of method 'exportFile' must not be null";
        if (modifiableFile instanceof GroovyScript) {
            GroovyScript script = (GroovyScript)modifiableFile;
            this.getScriptPersistence().storeScriptToFile(realFile, script.getScriptContent(), result);
        } else if (modifiableFile instanceof FileBasedRunConfiguration) {
            FileBasedRunConfiguration runConfiguration = (FileBasedRunConfiguration)modifiableFile;
            result.addMessagesFrom(this.getRunConfigurationPersistence().save(runConfiguration, realFile));
        } else assert (false) : "Unhandled file: " + String.valueOf(modifiableFile);
    }

    @Override
    public void importFiles(IWorkerContext workerContext, ImportQualityModel importQualityModel, EnumSet<Modification> modfications, OperationResult result) {
        assert (importQualityModel != null) : "Parameter 'importQualityModel' of method 'importFiles' must not be null";
        GroovyScripts scripts = this.getSoftwareSystem().getUniqueExistingChild(Files.class).getGroovyScripts();
        List<ImportQualityModel.ImportQualityModelCandidate> candidates = importQualityModel.getCandidatesByFileType(CoreFileType.GROOVY_SCRIPT);
        block0: for (ImportQualityModel.ImportQualityModelCandidate nextImportQualityModelCandidate : candidates) {
            if (!nextImportQualityModelCandidate.isIncluded()) continue;
            TFile contentFile = nextImportQualityModelCandidate.getModifiableFile().getFile();
            String contentFileIdentifyingPath = nextImportQualityModelCandidate.getModifiableFile().getIdentifyingPath();
            if (importQualityModel.discardCurrentContent() || !nextImportQualityModelCandidate.isAlreadyInModel()) {
                TFile targetFile = new TFile((File)scripts.getFile(), contentFileIdentifyingPath);
                result.addMessagesFrom(this.addScript(contentFile, targetFile.getNormalizedFile(), null, true));
                continue;
            }
            if (importQualityModel.discardCurrentContent()) continue;
            for (IModifiableFile nextAvailable : this.getAvailableFiles()) {
                if (!(nextAvailable instanceof GroovyScript) || !nextAvailable.getIdentifyingPath().equals(contentFileIdentifyingPath)) continue;
                result.addMessagesFrom(this.addScript(contentFile, nextAvailable.getFile(), (GroovyScript)nextAvailable, true));
                continue block0;
            }
        }
        List<ImportQualityModel.ImportQualityModelCandidate> rcCandidates = importQualityModel.getCandidatesByFileType(CoreFileType.RUN_CONFIGURATION);
        block2: for (ImportQualityModel.ImportQualityModelCandidate nextImportQualityModelCandidate : rcCandidates) {
            if (!nextImportQualityModelCandidate.isIncluded()) continue;
            TFile contentFile = nextImportQualityModelCandidate.getModifiableFile().getFile();
            String contentFileIdentifyingPath = nextImportQualityModelCandidate.getModifiableFile().getIdentifyingPath();
            if (importQualityModel.discardCurrentContent() || !nextImportQualityModelCandidate.isAlreadyInModel()) {
                TFile targetFile = new TFile((File)scripts.getFile(), contentFileIdentifyingPath);
                result.addMessagesFrom(this.addRunConfiguration(contentFile, targetFile.getNormalizedFile(), null, true));
                continue;
            }
            if (importQualityModel.discardCurrentContent()) continue;
            for (IModifiableFile nextAvailable : this.getAvailableFiles()) {
                if (!(nextAvailable instanceof FileBasedRunConfiguration) || !nextAvailable.getIdentifyingPath().equals(contentFileIdentifyingPath)) continue;
                result.addMessagesFrom(this.addRunConfiguration(contentFile, nextAvailable.getFile(), (FileBasedRunConfiguration)nextAvailable, true));
                continue block2;
            }
        }
    }

    @Override
    public void importFinished(IWorkerContext workerContext, EnumSet<Modification> modifications, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'importFinished' must not be null";
        assert (result != null) : "Parameter 'result' of method 'importFinished' must not be null";
        ScriptRunnerConfiguration config = this.getScriptRunnerConfiguration();
        if (config != null) {
            this.initAutomationStatus(config);
            this.checkScriptRunnerConfiguration();
        }
    }

    @Override
    public void discardFiles(IWorkerContext workerContext, EnumSet<Modification> modfications, OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'discardFiles' must not be null";
        this.removeAllScripts(result);
    }

    private void checkScriptRunnerConfiguration() {
        AnalyzerConfigurationFile analyzerConfigurationFile = this.getSoftwareSystem().getExtension(IAnalyzerController.class).getAnalyzerConfigurationFile(CoreAnalyzerId.SCRIPT_RUNNER);
        if (analyzerConfigurationFile != null) {
            analyzerConfigurationFile.removeIssues();
            ScriptRunnerConfiguration scriptRunnerConfiguration = this.getScriptRunnerConfiguration();
            if (scriptRunnerConfiguration != null) {
                scriptRunnerConfiguration.resetWarnings();
                List<ScriptRunnerData> scriptRunnerData = scriptRunnerConfiguration.getScriptRunnerData();
                if (!scriptRunnerData.isEmpty()) {
                    for (ScriptRunnerData next : scriptRunnerData) {
                        String nextIdentifyingScriptPath = next.getIdentifyingScriptPath();
                        String nextRunConfigurationName = next.getRunConfigurationName();
                        ScriptContent nextScriptContent = this.getAutomatedScriptContent(nextIdentifyingScriptPath);
                        if (nextScriptContent == null) {
                            analyzerConfigurationFile.addIssue(new ScriptRunnerConfigurationInconsistent(analyzerConfigurationFile, "Script file '" + nextIdentifyingScriptPath + "' not found (entry: " + nextIdentifyingScriptPath + ":" + nextRunConfigurationName + ")."));
                            scriptRunnerConfiguration.setWarning(nextIdentifyingScriptPath, nextRunConfigurationName, "Script file not found.");
                            continue;
                        }
                        IRunConfiguration runConfiguration = nextScriptContent.getRunConfiguration(nextRunConfigurationName);
                        if (runConfiguration != null) continue;
                        analyzerConfigurationFile.addIssue(new ScriptRunnerConfigurationInconsistent(analyzerConfigurationFile, "Run configuration file '" + nextRunConfigurationName + "' not found (entry: " + nextIdentifyingScriptPath + ":" + nextRunConfigurationName + ")."));
                        scriptRunnerConfiguration.setWarning(nextIdentifyingScriptPath, nextRunConfigurationName, "Run configuration file not found.");
                    }
                }
            }
        }
    }

    @Override
    public void initialized(IWorkerContext workerContext, SoftwareSystem softwareSystem, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'initialized' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'initialized' must not be null";
        this.checkScriptRunnerConfiguration();
    }

    @Override
    public void componentModelModified(IWorkerContext workerContext, SoftwareSystem softwareSystem, boolean onSystemOpen) {
        if (!onSystemOpen) {
            this.resetScriptResults();
        }
    }

    @Override
    public void cleared(IWorkerContext workerContext, SoftwareSystem softwareSystem, List<SoftwareSystemEvent> eventsToBeDisptached, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'cleared' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'cleared' must not be null";
        assert (eventsToBeDisptached != null) : "Parameter 'eventsToBeDisptached' of method 'cleared' must not be null";
        this.resetScriptResults();
    }

    @Override
    public void updateAutomatedScript(GroovyScript script) {
        assert (script != null) : "Parameter 'script' of method 'updateAutomatedScript' must not be null";
        assert (this.canContentBeTransferedToAutomatedScript(script).isSuccess()) : "GroovyScript cannot be transfered. Check with canContentBeTransferedToAutomatedScript() first";
        IAnalyzerController analyzerExtension = this.getSoftwareSystem().getExtension(IAnalyzerController.class);
        Set<AnalyzerGroup> allToRestart = analyzerExtension.cancelAndResetAnalyzerGroups(Collections.singleton(AnalyzerGroup.SCRIPTS), ResetMode.ALL);
        this.addAutomatedScriptContent(script.getIdentifyingPath(), script.getScriptContent());
        this.m_finishModelProcessor.finishModification(this.getSoftwareSystem(), EnumSet.noneOf(Modification.class));
        if (!analyzerExtension.runAnalyzerGroups(allToRestart).contains((Object)AnalyzerGroup.SCRIPTS)) {
            this.compile(script, null, script.getResultSet(), null, true, script);
            this.m_finishModelProcessor.finishModification(this.getSoftwareSystem(), EnumSet.noneOf(Modification.class));
        }
    }

    @Override
    public OperationResult editScriptsDirectory(IWorkerContext workerContext, ScriptDirectory directoryToBeModified, String modifiedName) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'editScriptsDirectory' must not be null";
        assert (directoryToBeModified != null) : "Parameter 'directoryToBeModified' of method 'renameScriptsDirectory' must not be null";
        assert (modifiedName != null && modifiedName.length() > 0) : "Parameter 'modifiedName' of method 'renameScriptsDirectory' must not be empty";
        assert (directoryToBeModified.getParent() != this.getSoftwareSystem().getUniqueExistingChild(Files.class)) : "Must not rename " + this.getSoftwareSystem().getUniqueExistingChild(Files.class).getGroovyScripts().getIdentifyingPath();
        assert (this.getDirectoryNameValidator(directoryToBeModified.getParent(DirectoryPath.class, new Class[0])).isValid(directoryToBeModified.getShortName(), modifiedName).isSuccess()) : "modifiedName '" + modifiedName + "' is invalid";
        OperationResult result = new OperationResult("Rename script directory '" + directoryToBeModified.getIdentifyingPath() + "' to '" + modifiedName + "'");
        this.checkOutOfSync(result);
        if (result.isFailure()) {
            return result;
        }
        TFile originalDirectory = directoryToBeModified.getFile();
        TFile parentDirectory = originalDirectory.getParentFile();
        TFile newDirectory = new TFile((File)parentDirectory, modifiedName);
        try {
            newDirectory.mkdir(false);
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_CREATE_DIRECTORY, (Throwable)ex);
            return result;
        }
        try {
            originalDirectory.cp_rp((File)newDirectory);
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_COPY, (Throwable)ex);
            try {
                newDirectory.rm_r();
            }
            catch (IOException ex2) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_DELETE_DIRECTORY, (Throwable)ex, "Failed to delete new directory", new Object[0]);
            }
            return result;
        }
        try {
            originalDirectory.rm_r();
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_DELETE_DIRECTORY, (Throwable)ex);
            return result;
        }
        directoryToBeModified.setPath(newDirectory);
        for (ScriptDirectory nextDirectory : directoryToBeModified.getChildrenRecursively(ScriptDirectory.class, new Class[0])) {
            nextDirectory.reallocate();
        }
        ScriptRunnerConfiguration configuration = this.getScriptRunnerConfiguration();
        boolean scriptMatchesAutomatedEntryBeforeIdentifyingPathChange = false;
        boolean scriptMatchesAutomatedEntryAfterIdentifyingPathChange = false;
        HashMap<String, String> scriptNameChanges = new HashMap<String, String>();
        for (GroovyScript groovyScript : directoryToBeModified.getChildrenRecursively(GroovyScript.class, GroovyScript.class)) {
            String nextPreviousIdentifyingPath = groovyScript.getIdentifyingPath();
            groovyScript.reallocate();
            scriptNameChanges.put(nextPreviousIdentifyingPath, groovyScript.getIdentifyingPath());
            if (configuration == null) continue;
            if (configuration.isAutomated(nextPreviousIdentifyingPath, null)) {
                scriptMatchesAutomatedEntryBeforeIdentifyingPathChange = true;
                continue;
            }
            if (!configuration.isAutomated(groovyScript.getIdentifyingPath(), null)) continue;
            scriptMatchesAutomatedEntryAfterIdentifyingPathChange = true;
        }
        for (FileBasedRunConfiguration fileBasedRunConfiguration : directoryToBeModified.getChildrenRecursively(FileBasedRunConfiguration.class, new Class[0])) {
            fileBasedRunConfiguration.reallocate();
        }
        for (Map.Entry entry : scriptNameChanges.entrySet()) {
            this.changeIdentifyingPathOfAutomatedScriptContent((String)entry.getKey(), (String)entry.getValue());
        }
        if (scriptMatchesAutomatedEntryBeforeIdentifyingPathChange) {
            assert (configuration != null) : "'configuration' of method 'editScriptsDirectory' must not be null";
            this.updateNames(Collections.emptyMap(), scriptNameChanges, configuration);
            this.finishWithScriptRunnerConfigurationUpdate(workerContext, true, result);
        } else if (scriptMatchesAutomatedEntryAfterIdentifyingPathChange) {
            assert (configuration != null) : "'configuration' of method 'editScriptsDirectory' must not be null";
            this.finishWithScriptRunnerConfigurationUpdate(workerContext, true, result);
        } else {
            this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), result);
        }
        return result;
    }

    @Override
    public OperationResult createRunConfiguration(IWorkerContext workerContext, GroovyScript script, String name, String description, RunConfigurationParameters parameters) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createRunConfiguration' must not be null";
        assert (script != null) : "Parameter 'script' of method 'createRunConfiguration' must not be null";
        assert (this.getRunConfigurationNameValidator(script, null).isValid(null, name).isSuccess()) : "Name not valid:" + name;
        assert (description != null) : "Parameter 'description' of method 'createRunConfiguration' must not be null";
        assert (parameters != null) : "Parameter 'parameters' of method 'createRunConfiguration' must not be null";
        OperationResult result = new OperationResult("Create run configuration '" + name + "' for script '" + script.getName() + "'");
        this.checkOutOfSync(result);
        if (result.isFailure()) {
            return result;
        }
        String runConfigurationFileName = FileBasedRunConfiguration.getFileName(FileUtility.getFileNameWithoutExtension((TFile)script.getFile()), name);
        TFile runConfigurationFile = new TFile(script.getFile().getParent(), runConfigurationFileName);
        ScriptContent scriptContent = script.getScriptContent();
        FileBasedRunConfiguration runConfiguration = new FileBasedRunConfiguration(scriptContent, runConfigurationFile, parameters, scriptContent, this.getSoftwareSystem().getUniqueExistingChild(Files.class));
        runConfiguration.setDescription(description);
        result.addMessagesFrom(this.getRunConfigurationPersistence().save(runConfiguration, runConfigurationFile));
        if (result.isFailure()) {
            return result;
        }
        TrueZipFacade.clear((TFile)runConfigurationFile);
        runConfiguration.resetTimestamp();
        scriptContent.addChild(runConfiguration);
        this.addAutomatedScriptContent(script.getIdentifyingPath(), scriptContent);
        this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), result);
        return result;
    }

    private void moveFileBasedRunConfigurations(ScriptContent fromContent, ScriptContent toContent, boolean markAsModifiedIfValuesRemoved) {
        assert (fromContent != null) : "Parameter 'fromContent' of method 'addFileBasedRunConfigurations' must not be null";
        assert (toContent != null) : "Parameter 'toContent' of method 'addFileBasedRunConfigurations' must not be null";
        assert (fromContent != toContent) : "Must not be the same content";
        RunConfigurationParameters defaultRunConfigurationParameters = toContent.getDefaultRunConfiguration().getRunConfigurationParameters();
        for (FileBasedRunConfiguration nextRunConfiguration : fromContent.getChildren(FileBasedRunConfiguration.class)) {
            nextRunConfiguration.changeParent(toContent, true);
            RunConfigurationParameters nextRunConfigurationParameters = nextRunConfiguration.getRunConfigurationParameters();
            Set<String> missing = defaultRunConfigurationParameters.getMissingParameters(nextRunConfigurationParameters);
            for (String nextMissing : missing) {
                nextRunConfigurationParameters.removeParameterValue(nextMissing);
            }
            if (markAsModifiedIfValuesRemoved && !missing.isEmpty()) {
                nextRunConfiguration.setNeedsSave(true);
            }
            nextRunConfiguration.setParameterDefinitionProvider(toContent);
        }
    }

    void restoreScript(GroovyScript script, TFile restoredPath, ScriptContent restoredContent, List<String> languageIssueInfo) {
        assert (script != null) : "Parameter 'script' of method 'restoreScript' must not be null";
        assert (restoredContent != null) : "Parameter 'content' of method 'restoreScript' must not be null";
        assert (languageIssueInfo != null) : "Parameter 'languageIssueInfo' of method 'restoreScript' must not be null";
        if (restoredPath != null) {
            String oldIdentifyingPath = script.getIdentifyingPath();
            script.setPath(restoredPath);
            this.changeIdentifyingPathOfAutomatedScriptContent(oldIdentifyingPath, script.getIdentifyingPath());
        }
        this.moveFileBasedRunConfigurations(script.getScriptContent(), restoredContent, false);
        script.removeChildren(ScriptContent.class);
        restoredContent.setParent(script);
        script.addChild(restoredContent);
        this.getShell().reset(script, false, script);
        languageIssueInfo.forEach(i -> script.addIssue(new ScriptApiLanguageIssue(script, (String)i)));
    }

    private void updateNames(Map<String, Map<String, String>> runConfigurationNameChanges, Map<String, String> scriptNameChanges, ScriptRunnerConfiguration configuration) {
        assert (scriptNameChanges != null) : "Parameter 'scriptNameChanges' of method 'updateNames' must not be null";
        assert (runConfigurationNameChanges != null) : "Parameter 'runConfigurationNameChanges' of method 'updateNames' must not be null";
        assert (!scriptNameChanges.isEmpty() || !runConfigurationNameChanges.isEmpty()) : "No changes";
        assert (configuration != null) : "Parameter 'configuration' of method 'updateNames' must not be null";
        List<ScriptRunnerData> data = configuration.getScriptRunnerData();
        for (ScriptRunnerData nextData : data) {
            String nextNewName;
            Map<String, String> nextChanges = runConfigurationNameChanges.get(nextData.getIdentifyingScriptPath());
            if (nextChanges == null || (nextNewName = nextChanges.get(nextData.getRunConfigurationName())) == null) continue;
            assert (nextNewName.length() > 0) : "'nextNewName' of method 'updateNames' must not be empty";
            nextData.setRunConfigurationName(nextNewName);
        }
        for (ScriptRunnerData nextData : data) {
            String nextNewName = scriptNameChanges.get(nextData.getIdentifyingScriptPath());
            if (nextNewName == null) continue;
            assert (nextNewName.length() > 0) : "'nextNewName' of method 'updateNames' must not be empty";
            nextData.setIdentifyingScriptPath(nextNewName);
        }
        configuration.setScriptRunnerData(new ArrayList<ScriptRunnerData>(new LinkedHashSet<ScriptRunnerData>(data)));
    }

    @Override
    public OperationResult modifyScriptConfiguration(IWorkerContext workerContext, GroovyScript script, String newName, ScriptContent newContent) {
        boolean isAutomated;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'modifyScriptConfiguration' must not be null";
        assert (script != null) : "Parameter 'script' of method 'modifyScriptConfiguration' must not be null";
        assert (newName != null) : "Parameter 'newName' of method 'modifyScriptConfiguration' must not be null";
        OperationResult result = new OperationResult("Modify script configuration");
        EnumSet<GroovyProvider.ScriptDiff> diff = this.getDifferencesOfScriptConfiguration(script, newName, newContent);
        if (diff.isEmpty()) {
            LOGGER.debug("Nothing to be updated for script '" + script.getName() + "', no differences detected.");
            return result;
        }
        ScriptContent currentContent = script.getScriptContent();
        LinkedHashMap<FileBasedRunConfiguration, Pair> fileBasedRunConfigurationToOriginalAndNewFile = null;
        String currentIdentifyingName = script.getIdentifyingPath();
        ScriptRunnerConfiguration configuration = this.getScriptRunnerConfiguration();
        boolean bl = isAutomated = configuration != null ? configuration.isAutomated(currentIdentifyingName, null) : false;
        if (diff.contains((Object)GroovyProvider.ScriptDiff.NAME)) {
            ArrayList<TFile> toBeDeleted = new ArrayList<TFile>();
            if (this.getScriptNameValidator(script.getParent(DirectoryPath.class, new Class[0])).isValid(script.getName(), newName).isFailure()) {
                result.addError((OperationResult.IMessageCause)ScriptMessageCause.INVALID_SCRIPT_NAME, "Name '" + newName + "' is invalid.", new Object[0]);
                return result;
            }
            TFile newPath = new TFile((File)script.getFile().getParentFile(), newName + CoreFileType.GROOVY_SCRIPT.getDefaultExtension());
            try {
                script.getFile().cp((File)newPath);
                toBeDeleted.add(script.getFile());
            }
            catch (IOException iOException) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_COPY, (Throwable)iOException);
                return result;
            }
            fileBasedRunConfigurationToOriginalAndNewFile = new LinkedHashMap<FileBasedRunConfiguration, Pair>();
            for (FileBasedRunConfiguration fileBasedRunConfiguration : currentContent.getChildren(FileBasedRunConfiguration.class)) {
                String nextNewRunConfigurationFileName = FileBasedRunConfiguration.getFileName(newName, fileBasedRunConfiguration.getRunConfigurationName());
                TFile nextNewRunConfigurationFile = new TFile(newPath.getParent(), nextNewRunConfigurationFileName);
                TFile nextOriginalRunConfigurationFile = fileBasedRunConfiguration.getFile();
                try {
                    fileBasedRunConfiguration.getFile().cp((File)nextNewRunConfigurationFile);
                    toBeDeleted.add(nextOriginalRunConfigurationFile);
                }
                catch (IOException e) {
                    result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_COPY, (Throwable)e);
                    return result;
                }
                fileBasedRunConfigurationToOriginalAndNewFile.put(fileBasedRunConfiguration, new Pair((Object)nextOriginalRunConfigurationFile, (Object)nextNewRunConfigurationFile));
            }
            script.setPath(newPath);
            script.setNeedsSave(true);
            this.changeIdentifyingPathOfAutomatedScriptContent(currentIdentifyingName, script.getIdentifyingPath());
            if (isAutomated) {
                assert (configuration != null) : "'configuration' of method 'modifyScriptConfiguration' must not be null";
                this.updateNames(Collections.emptyMap(), Collections.singletonMap(currentIdentifyingName, script.getIdentifyingPath()), configuration);
            }
            for (Map.Entry entry : fileBasedRunConfigurationToOriginalAndNewFile.entrySet()) {
                FileBasedRunConfiguration next = (FileBasedRunConfiguration)entry.getKey();
                next.setPath((TFile)((Pair)entry.getValue()).getSecond());
                next.setTimestamp(((TFile)((Pair)entry.getValue()).getFirst()).lastModified());
                next.setNeedsSave(true);
            }
            for (TFile tFile : toBeDeleted) {
                SoftwareSystemFilesDirectory.removeFile(tFile, false, result);
            }
        }
        if (diff.contains((Object)GroovyProvider.ScriptDiff.DESCRIPTION) || diff.contains((Object)GroovyProvider.ScriptDiff.LANGUAGES) || diff.contains((Object)GroovyProvider.ScriptDiff.PARAMETER_DEFINITIONS)) {
            script.setNeedsSave(true);
            this.moveFileBasedRunConfigurations(currentContent, newContent, true);
            script.removeChild(currentContent);
            newContent.setParent(script);
            script.addChild(newContent);
        }
        this.compile(script, null, script.getResultSet(), null, false, script);
        if (diff.contains((Object)GroovyProvider.ScriptDiff.NAME)) {
            assert (fileBasedRunConfigurationToOriginalAndNewFile != null) : "Parameter 'fileBasedRunConfigurationToOriginalAndNewFile' of method 'modifyScriptConfiguration' must not be null";
            result.addMessagesFrom(this.saveScript(script, null));
            RunConfigurationPersistence runConfigPersistence = this.getRunConfigurationPersistence();
            for (Map.Entry nextEntry : fileBasedRunConfigurationToOriginalAndNewFile.entrySet()) {
                TFile nextNewFile;
                FileBasedRunConfiguration next = (FileBasedRunConfiguration)nextEntry.getKey();
                OperationResult saveResult = runConfigPersistence.save(next, nextNewFile = (TFile)((Pair)nextEntry.getValue()).getSecond());
                if (saveResult.isSuccess()) {
                    next.setNeedsSave(false);
                    next.setTimestamp(nextNewFile.lastModified());
                }
                result.addMessagesFrom(saveResult);
            }
        }
        result.setIsSuccess(true);
        if (isAutomated) {
            EnumSet<GroovyProvider.ScriptDiff> automatedScriptDiff = this.getDifferencesOfAutmatedScript(script);
            if (!automatedScriptDiff.isEmpty()) {
                result.addInfo((OperationResult.IMessageCause)GroovyMessageCause.AUTOMATED_SCRIPT_CAN_BE_UPDATED, "The script '" + script.getShortName() + "' is configured to run automatically." + StringUtility.LINE_SEPARATOR + "After having successfully saved your changes you might consider to update the corresponding automated script content.");
            }
            this.finishWithScriptRunnerConfigurationUpdate(workerContext, true, result);
        } else if (diff.contains((Object)GroovyProvider.ScriptDiff.NAME) && this.isAutomated(script, null)) {
            this.finishWithScriptRunnerConfigurationUpdate(workerContext, true, result);
        } else {
            this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), result);
        }
        return result;
    }

    @Override
    public void modifyScriptSource(GroovyScript script, String content, IOriginator originator) {
        assert (script != null) : "Parameter 'script' of method 'modifyScriptSource' must not be null";
        assert (content != null) : "Parameter 'content' of method 'modifyScriptSource' must not be null";
        assert (originator != null) : "Parameter 'originator' of method 'modifyScriptSource' must not be null";
        script.getScriptContent().setSource(content);
        if (!script.needsSave()) {
            script.setNeedsSave(true);
            this.getShell().reset(script, false, script);
            this.m_finishModelProcessor.finishModification((IWorkerContext)DefaultWorkerContext.INSTANCE, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), originator, new OperationResult("Modify script source"));
        }
    }

    @Override
    public OperationResult modifyRunConfiguration(IWorkerContext workerContext, FileBasedRunConfiguration runConfiguration, String name, String description, RunConfigurationParameters parameters) {
        EnumSet<GroovyProvider.ScriptDiff> automatedScriptDiff;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'modifyRunConfiguration' must not be null";
        assert (runConfiguration != null) : "Parameter 'runConfiguration' of method 'modifyRunConfiguration' must not be null";
        assert (name != null) : "Parameter 'name' of method 'modifyRunConfiguration' must not be null";
        assert (description != null) : "Parameter 'description' of method 'modifyRunConfiguration' must not be null";
        assert (parameters != null) : "Parameter 'parameters' of method 'modifyRunConfiguration' must not be null";
        GroovyScript script = runConfiguration.getParent(GroovyScript.class, new Class[0]);
        assert (script != null) : "'script' of method 'modifyRunConfiguration' must not be null";
        OperationResult result = new OperationResult("Modify run configuration '" + runConfiguration.getName() + "'");
        boolean nameChanged = false;
        boolean descriptionChanged = false;
        boolean parametersChanged = false;
        String identifyingScriptPath = script.getIdentifyingPath();
        ScriptRunnerConfiguration configuration = this.getScriptRunnerConfiguration();
        boolean isAutomated = configuration != null ? configuration.isAutomated(identifyingScriptPath, runConfiguration.getRunConfigurationName()) : false;
        String currentRunConfigurationName = runConfiguration.getRunConfigurationName();
        if (!currentRunConfigurationName.equals(name)) {
            assert (this.getRunConfigurationNameValidator(script, runConfiguration).isValid(null, name).isSuccess()) : "Name not valid: " + name;
            TFile runConfigurationFile = runConfiguration.getFile();
            TFile targetFile = new TFile((File)runConfigurationFile.getParentFile(), FileBasedRunConfiguration.getFileName(FileUtility.getFileNameWithoutExtension((TFile)script.getFile()), name));
            try {
                runConfigurationFile.mv((File)targetFile);
            }
            catch (IOException e) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_MOVE, (Throwable)e);
                return result;
            }
            if (isAutomated) {
                assert (configuration != null) : "'configuration' of method 'modifyRunConfiguration' must not be null";
                this.updateNames(Collections.singletonMap(identifyingScriptPath, Collections.singletonMap(currentRunConfigurationName, name)), Collections.emptyMap(), configuration);
            }
            runConfiguration.setNeedsSave(true);
            runConfiguration.setPath(targetFile);
            runConfiguration.setNeedsSave(false);
            nameChanged = true;
        }
        if (!runConfiguration.getDescription().equals(description)) {
            runConfiguration.setDescription(description);
            descriptionChanged = true;
        }
        if (!runConfiguration.getRunConfigurationParameters().equals(parameters)) {
            runConfiguration.setRunConfigurationParameters(new RunConfigurationParameters(parameters));
            parametersChanged = true;
        }
        assert (nameChanged || descriptionChanged || parametersChanged) : "No modifications for: " + String.valueOf(runConfiguration);
        if (nameChanged) {
            this.changeRunConfigurationName(identifyingScriptPath, currentRunConfigurationName, name);
        } else {
            runConfiguration.setNeedsSave(true);
        }
        if (isAutomated && !(automatedScriptDiff = this.getDifferencesOfAutmatedScript(script)).isEmpty()) {
            result.addInfo((OperationResult.IMessageCause)GroovyMessageCause.AUTOMATED_SCRIPT_CAN_BE_UPDATED, "The run configuration '" + runConfiguration.getShortName() + "' is configured to run automatically." + StringUtility.LINE_SEPARATOR + "Consider to update the corresponding automated script content.");
        }
        if (nameChanged && isAutomated) {
            this.finishWithScriptRunnerConfigurationUpdate(workerContext, true, result);
        } else if (nameChanged && this.isAutomated(script, runConfiguration)) {
            this.finishWithScriptRunnerConfigurationUpdate(workerContext, true, result);
        } else {
            this.m_finishModelProcessor.finishModification(workerContext, this.getSoftwareSystem(), EnumSet.noneOf(Modification.class), result);
        }
        return result;
    }

    @Override
    public void analyzerConfigurationChanged(IWorkerContext workerContext, AnalyzerConfigurationChangeMode mode, AnalyzerConfiguration configuration, EnumSet<Modification> modifications, OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'loaded' must not be null";
        assert (configuration != null) : "Parameter 'configuration' of method 'loaded' must not be null";
        assert (result != null) : "Parameter ' result' of method 'loaded' must not be null";
        if (!(configuration instanceof ScriptRunnerConfiguration)) {
            return;
        }
        ScriptRunnerConfiguration config = (ScriptRunnerConfiguration)configuration;
        this.initAutomationStatus(config);
        this.getOutputStreamProvider().automatedScriptsUpdate(config.getScriptRunnerData());
        if (modifications != null) {
            this.checkScriptRunnerConfiguration();
        }
    }

    private void initAutomationStatus(ScriptRunnerConfiguration config) {
        assert (config != null) : "Parameter 'config' of method 'initAutomationStatus' must not be null";
        List<ScriptRunnerData> scriptRunnerData = config.getScriptRunnerData();
        for (GroovyScript nextScript : this.getAvailableScripts()) {
            for (IRunConfiguration nextConfig : nextScript.getUniqueExistingChild(ScriptContent.class).getChildren(IRunConfiguration.class)) {
                ScriptRunnerData data = new ScriptRunnerData(nextScript.getIdentifyingPath(), nextConfig.getRunConfigurationName());
                if (nextConfig instanceof FileBasedRunConfiguration) {
                    FileBasedRunConfiguration fileBasedConfig = (FileBasedRunConfiguration)nextConfig;
                    fileBasedConfig.setAutomated(scriptRunnerData.contains(data));
                    continue;
                }
                assert (nextConfig instanceof DefaultRunConfiguration) : "Unexpected class '" + nextConfig.getClass().getName() + "'";
                DefaultRunConfiguration defaultConfig = (DefaultRunConfiguration)nextConfig;
                boolean changed = defaultConfig.setAutomated(scriptRunnerData.contains(data));
                if (!changed) continue;
                nextScript.defaultConfigAutomationStatusChanged();
            }
        }
    }

    @Override
    public void setQualityModelRoot(TFile qualityModel) {
        assert (qualityModel != null) : "Parameter 'qualityModel' of method 'setQualityModelRoot' must not be null";
        Files files = this.getSoftwareSystem().getUniqueExistingChild(Files.class);
        GroovyScripts groovyScripts = files.getGroovyScripts();
        groovyScripts.setPath(new TFile((File)qualityModel, "./Scripts"));
    }

    private OperationResult updateScriptRunnerConfiguration(IWorkerContext workerContext, List<Element> elements, boolean automate) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'updateScriptRunnerConfiguration' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'updateScriptRunnerConfiguration' must not be empty";
        OperationResult result = new OperationResult(automate ? "Add script run configuration(s) to script runner configuration" : "Remove script run configuration(s) from script runner configuration");
        IAnalyzerController analyzerExtension = this.getSoftwareSystem().getExtension(IAnalyzerController.class);
        AnalyzerConfiguration config = analyzerExtension.getConfigurationForEdit(CoreAnalyzerId.SCRIPT_RUNNER);
        assert (config != null && config instanceof ScriptRunnerConfiguration) : "Unexpected class in method 'updateScriptRunnerConfiguration': " + String.valueOf(config);
        ScriptRunnerConfiguration configuration = (ScriptRunnerConfiguration)config;
        List<ScriptRunnerData> data = configuration.getScriptRunnerData();
        for (Element next : elements) {
            String runConfigurationName;
            GroovyScript nextScript;
            if (next instanceof DefaultRunConfiguration) {
                DefaultRunConfiguration defaultRunConfiguration = (DefaultRunConfiguration)next;
                nextScript = defaultRunConfiguration.getParent(GroovyScript.class, new Class[0]);
                runConfigurationName = defaultRunConfiguration.getRunConfigurationName();
            } else {
                assert (next != null && next instanceof FileBasedRunConfiguration) : "Unexpected class in method 'updateScriptRunnerConfiguration': " + String.valueOf(next);
                FileBasedRunConfiguration fileBasedRunConfiguration = (FileBasedRunConfiguration)next;
                nextScript = fileBasedRunConfiguration.getParent(GroovyScript.class, new Class[0]);
                runConfigurationName = fileBasedRunConfiguration.getRunConfigurationName();
            }
            assert (nextScript != null) : "Parameter 'nextScript' of method 'updateScriptRunnerConfiguration' must not be null";
            ScriptRunnerData scriptRunnerData = new ScriptRunnerData(nextScript.getIdentifyingPath(), runConfigurationName);
            if (automate) {
                this.compile(nextScript, null, nextScript.getResultSet(), null, true, nextScript);
                data.add(scriptRunnerData);
                continue;
            }
            data.remove(scriptRunnerData);
            this.getShell().reset(nextScript, true, nextScript);
        }
        configuration.setScriptRunnerData(data);
        result.addMessagesFrom(analyzerExtension.applyEditedConfiguration(workerContext, configuration));
        return result;
    }

    @Override
    public OperationResult addToScriptRunner(IWorkerContext workerContext, List<Element> elements) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'addToAutomated' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'addToScriptRunner' must not be empty";
        assert (this.mayBeAddedToScriptRunnerExecution(elements)) : "Not possible to add elements to automated script execution";
        return this.updateScriptRunnerConfiguration(workerContext, elements, true);
    }

    @Override
    public OperationResult removeFromScriptRunner(IWorkerContext workerContext, List<Element> elements) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'removeFromAutomated' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'removeFromScriptRunner' must not be empty";
        assert (this.mayBeRemovedFromScriptRunner(elements)) : "Not possible to add elements to automated script execution";
        return this.updateScriptRunnerConfiguration(workerContext, elements, false);
    }
}

