/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderAccessor;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.model.dashboard.Dashboard;
import com.hello2morrow.sonargraph.core.model.dashboard.Dashboards;
import com.hello2morrow.sonargraph.core.model.dashboard.IDashboardProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.OptionalExtension;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.persistence.dashboard.DashboardPersistence;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DashboardExtension
extends OptionalExtension
implements IDashboardProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DashboardExtension.class);
    private static final String DEFAULT_DASHBOARD = "Architect";
    private final IFinishModelProcessor m_finishModelProcessor;
    private final LanguageProviderAccessor m_languageProviderAccessor;
    private final Installation m_installation;
    private final SoftwareSystem m_softwareSystem;
    private Dashboard m_currentDashboard;

    public DashboardExtension(Installation installation, SoftwareSystem softwareSystem, IFinishModelProcessor finishModelProcessor, LanguageProviderAccessor accessor, boolean enabled) {
        super(enabled);
        assert (installation != null) : "Parameter 'installation' of method 'DashboardFunctionalExtension' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'DashboardExtension' must not be null";
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'DashboardFunctionalExtension' must not be null";
        assert (accessor != null) : "Parameter 'accessor' of method 'DashboardExtension' must not be null";
        this.m_installation = installation;
        this.m_softwareSystem = softwareSystem;
        this.m_finishModelProcessor = finishModelProcessor;
        this.m_languageProviderAccessor = accessor;
    }

    private DashboardPersistence getPersistence() {
        return new DashboardPersistence(this.m_installation.getVersion(), this.m_softwareSystem.getClassLoader(), this.m_softwareSystem.getExtension(ISoftwareSystemProvider.class).getInstallation().getExtension(IMetricsProvider.class), this.m_languageProviderAccessor.getAvailableLanguages());
    }

    private Dashboard createDefaultDashboard(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'createDefaultDashboard' must not be empty";
        String dashboardPath = "./" + name + CoreFileType.DASHBOARD.getDefaultExtension();
        Dashboards dashboards = this.m_softwareSystem.getUniqueExistingChild(Files.class).getDashboards();
        Dashboard defaultDashboard = new Dashboard((NamedElement)dashboards, new TFile((File)dashboards.getFile(), dashboardPath), this.m_softwareSystem.getUniqueExistingChild(Files.class));
        dashboards.addChild(defaultDashboard);
        return defaultDashboard;
    }

    @Override
    public void finishSoftwareSystemInitialization(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'finishSoftwareSystemInitialization' must not be null";
        if (this.isEnabled()) {
            String licenseType = this.m_finishModelProcessor.getLicenseProvider().getLicenseType();
            String dashboardName = licenseType.isEmpty() || licenseType.equals("PluginDevelopment") ? DEFAULT_DASHBOARD : licenseType;
            Dashboard dashboard = this.createDefaultDashboard(dashboardName);
            OperationResult loadResult = this.getPersistence().loadFromClasspath(dashboardName, dashboard);
            if (loadResult.isFailure() && !licenseType.isEmpty() && !dashboardName.equals(DEFAULT_DASHBOARD)) {
                LOGGER.warn("Unable to load dashboard: " + dashboardName);
                dashboard.remove();
                dashboard = this.createDefaultDashboard(DEFAULT_DASHBOARD);
                loadResult = this.getPersistence().loadFromClasspath(DEFAULT_DASHBOARD, dashboard);
            }
            result.addMessagesFrom(loadResult);
            this.m_currentDashboard = dashboard;
        }
    }

    @Override
    public Dashboard getDashboard() {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (this.m_currentDashboard != null) : "'m_currentDashboard' of method 'getDashboard' must not be null";
        return this.m_currentDashboard;
    }
}

