/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.settings;

import com.hello2morrow.sonargraph.core.model.system.settings.InstallationConfigCause;
import com.hello2morrow.sonargraph.core.model.system.settings.SearchPathValidator;
import com.hello2morrow.sonargraph.foundation.file.SearchPath;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import de.schlichtherle.truezip.file.TFile;

public class InstSpecDirSearchPathValidator
extends SearchPathValidator {
    private TFile m_instSpecDir;
    private boolean m_isModifiedInstSpecDir;

    public void setInstSpecDir(TFile dir, boolean isModified) {
        this.m_instSpecDir = dir;
        this.m_isModifiedInstSpecDir = isModified;
    }

    @Override
    public void validate(SearchPath searchPath, TFile newPath, OperationResult result) {
        super.validate(searchPath, newPath, result);
        if (result.isFailure()) {
            return;
        }
        if (!this.m_isModifiedInstSpecDir && this.m_instSpecDir.getNormalizedAbsolutePath().equals(newPath.getNormalizedAbsolutePath())) {
            result.addError((OperationResult.IMessageCause)InstallationConfigCause.SEARCH_PATH_DIR_DUPLICATED, "Directory '" + this.m_instSpecDir.getNormalizedAbsolutePath() + "'" + StringUtility.LINE_SEPARATOR + "cannot be added to search path, because it is already used for installation specific settings.", new Object[0]);
        }
    }
}

