/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IArchitecturalViewExtension;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocusProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewOnDemand;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;

public final class LoadArchitecturalViewOnDemandCommand
extends ArchitecturalViewCommand<ILoadArchitecturalViewOnDemandInteraction> {
    public LoadArchitecturalViewOnDemandCommand(ISoftwareSystemProvider provider, ILoadArchitecturalViewOnDemandInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.LOAD_EXPLORATION_VIEW;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    public ActivityMode getActivityMode() {
        return ActivityMode.MODAL_CANCELABLE;
    }

    @Override
    public boolean providesProgress() {
        return true;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        assert (this.getController().hasSoftwareSystem()) : "No system available";
        LoadArchitecturalViewOnDemandData data = new LoadArchitecturalViewOnDemandData();
        if (!((ILoadArchitecturalViewOnDemandInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        OperationResult result = this.getController().getSoftwareSystem().getExtension(IArchitecturalViewExtension.class).loadOnDemand(workerContext, data.getOnDemand(), data.getPresentationMode(), data.getFocusProperties());
        if (workerContext.hasBeenCanceled()) {
            ((ILoadArchitecturalViewOnDemandInteraction)this.getInteraction()).processCancelled();
        } else {
            ((ILoadArchitecturalViewOnDemandInteraction)this.getInteraction()).processLoadOnDemandResult(result);
        }
    }

    public static interface ILoadArchitecturalViewOnDemandInteraction
    extends IArchitecturalViewCommandInteraction {
        public boolean collect(LoadArchitecturalViewOnDemandData var1);

        public void processLoadOnDemandResult(OperationResult var1);

        public void processCancelled();
    }

    public static final class LoadArchitecturalViewOnDemandData
    implements IArchitecturalViewCommandInteractionData {
        private ExplorationViewOnDemand m_onDemand;
        private PresentationMode m_presentationMode;
        private ExplorationViewFocusProperties m_focusProperties;

        LoadArchitecturalViewOnDemandData() {
        }

        public void setData(ExplorationViewOnDemand onDemand, PresentationMode presentationMode, ExplorationViewFocusProperties focusProperties) {
            assert (onDemand != null) : "Parameter 'onDemand' of method 'setOnDemand' must not be null";
            assert (presentationMode != null) : "Parameter 'presentationMode' of method 'setOnDemand' must not be null";
            this.m_onDemand = onDemand;
            this.m_presentationMode = presentationMode;
            this.m_focusProperties = focusProperties;
        }

        ExplorationViewOnDemand getOnDemand() {
            assert (this.m_onDemand != null) : "'m_onDemand' of method 'getOnDemand' must not be null";
            return this.m_onDemand;
        }

        PresentationMode getPresentationMode() {
            assert (this.m_presentationMode != null) : "'m_presentationMode' of method 'getPresentationMode' must not be null";
            return this.m_presentationMode;
        }

        ExplorationViewFocusProperties getFocusProperties() {
            return this.m_focusProperties;
        }
    }
}

