/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocusProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocusRequest;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;

public final class ApplyFocusOperationCommand
extends ArchitecturalViewCommand<IApplyFocusOperationInteraction> {
    public ApplyFocusOperationCommand(ISoftwareSystemProvider provider, IApplyFocusOperationInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.APPLY_ARCHITECTURAL_VIEW_FOCUS_OPERATION;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (this.getController().hasSoftwareSystem()) : "No system available";
        FocusOperationtData data = new FocusOperationtData();
        if (!((IApplyFocusOperationInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        IArchitecturalViewProvider provider = this.getController().getSoftwareSystem().getExtension(IArchitecturalViewProvider.class);
        ExplorationViewFocusRequest request = data.getRequest();
        ExplorationViewFocusProperties properties = provider.getFocusProperties(data.getFocusType(), request);
        if (properties.getFocusType().supportUserInteraction() && !((IApplyFocusOperationInteraction)this.getInteraction()).collect(properties)) {
            return;
        }
        OperationResult result = provider.applyFocus(workerContext, properties, request);
        ((IApplyFocusOperationInteraction)this.getInteraction()).processApplyResult(result);
    }

    public static final class FocusOperationtData
    implements IArchitecturalViewCommandInteractionData {
        private ExplorationViewFocusProperties.FocusType m_operation;
        private ExplorationViewFocusRequest m_request;

        FocusOperationtData() {
        }

        public void set(ExplorationViewFocusProperties.FocusType focusType, ExplorationViewFocusRequest request) {
            assert (focusType != null) : "Parameter 'focusType' of method 'set' must not be null";
            assert (request != null) : "Parameter 'request' of method 'set' must not be null";
            this.m_operation = focusType;
            this.m_request = request;
        }

        ExplorationViewFocusProperties.FocusType getFocusType() {
            assert (this.m_operation != null) : "'m_operation' of method 'getFocusType' must not be null";
            return this.m_operation;
        }

        ExplorationViewFocusRequest getRequest() {
            assert (this.m_request != null) : "'m_request' of method 'getRequest' must not be null";
            return this.m_request;
        }
    }

    public static interface IApplyFocusOperationInteraction
    extends IArchitecturalViewCommandInteraction {
        public boolean collect(FocusOperationtData var1);

        public boolean collect(ExplorationViewFocusProperties var1);

        public void processApplyResult(OperationResult var1);
    }
}

