/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.InstallationBasedCommand;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import java.util.Collections;
import java.util.Map;

public final class ApplyInstallationSpecificParametersCommand
extends InstallationBasedCommand<IInteraction> {
    public ApplyInstallationSpecificParametersCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.APPLY_INST_PARAMETERS;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        InteractionData data = new InteractionData();
        if (!((IInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        OperationResult result = this.getController().applyInstallationSpecificParameters(data.getInstallationSpecificParameters());
        ((IInteraction)this.getInteraction()).processResult(result);
    }

    public static interface IInteraction
    extends ICommandInteraction {
        public boolean collect(InteractionData var1);

        public void processResult(OperationResult var1);
    }

    public final class InteractionData
    implements ICommandInteractionData {
        private Map<String, String> m_instSpecificParameters;

        public Map<String, String> getInstallationSpecificParameters() {
            return Collections.unmodifiableMap(this.m_instSpecificParameters);
        }

        public void setInstSpecificParameters(Map<String, String> instSpecificParameters) {
            this.m_instSpecificParameters = instSpecificParameters;
        }
    }
}

