/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.classfile;

import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.path.DirectoryFragment;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.IDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.NamespaceFragment;
import com.hello2morrow.sonargraph.core.model.workspace.IFilePathListener;
import com.hello2morrow.sonargraph.core.model.workspace.IModule;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.DependencyToTypeProcessor;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.IJavaGlobalModel;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.IJavaModuleModel;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.InternalTypeCreationResult;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base.SyntheticsHelper;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.classfile.AnnotationVisitorImpl;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.classfile.AsmAccessFlagMapper;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.classfile.FieldSignatureVisitorImpl;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.classfile.FieldVisitorImpl;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.classfile.IClassFileParserContext;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.classfile.MethodSignatureVisitorImpl;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.classfile.MethodVisitorImpl;
import com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.classfile.TypeSignatureVisitorImpl;
import com.hello2morrow.sonargraph.languageprovider.java.foundation.common.JavaNameUtility;
import com.hello2morrow.sonargraph.languageprovider.java.model.element.ClassFileDuplicate;
import com.hello2morrow.sonargraph.languageprovider.java.model.element.ClassFileMisplaced;
import com.hello2morrow.sonargraph.languageprovider.java.model.element.ClassFileUnparseable;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaClassFile;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaDirectoryFragment;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaFileType;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElement;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElementFlag;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaField;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaInternalCompilationUnit;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaMember;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaMethod;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaType;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.KotlinFunction;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.KotlinGhostProxy;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.dependency.JavaDependencyType;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.ModuleVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassFileParser
extends ClassVisitor
implements IClassFileParserContext {
    private static final String PACKAGE_INFO = "package-info";
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassFileParser.class);
    private static final String PACKAGE_INFO_JAVA = "package-info.java";
    private static final String KOTLIN_METADATA_ANNOTATION = "Lkotlin/Metadata;";
    private final FieldVisitorImpl m_fieldVisitor;
    private final MethodVisitorImpl m_methodVisitor;
    private final AnnotationVisitorImpl m_annotationVisitor;
    private final IJavaGlobalModel m_globalModel;
    private final IJavaModuleModel m_moduleModel;
    private RootDirectoryPath m_currentRootDirectory;
    private TFile m_currentFile;
    private IFilePathListener m_filePathListener;
    private String m_currentFqTypeName;
    private JavaClassFile m_currentClassFile;
    private JavaElement m_currentElement;
    private InternalTypeCreationResult m_typeCreationResult;
    private JavaType m_currentType;
    private JavaField m_currentField;
    private JavaMethod m_currentMethod;
    private String m_currentSourceName;
    private int m_currentSize;
    private boolean m_currentMethodIsSynthetic;
    private boolean m_currentTypeIsPotentiallyAnonymous;
    private boolean m_firstInstructionLineNumberOfPotentiallyAnonymousTypeAdded;

    public ClassFileParser(IJavaGlobalModel javaProgrammingModel, IJavaModuleModel moduleModel) {
        super(589824);
        assert (javaProgrammingModel != null) : "Parameter 'javaProgrammingModel' of method 'ClassFileParser' must not be null";
        assert (moduleModel != null) : "Parameter 'moduleModel' of method 'ClassFileParser' must not be null";
        this.m_globalModel = javaProgrammingModel;
        this.m_moduleModel = moduleModel;
        this.m_fieldVisitor = new FieldVisitorImpl(this);
        this.m_methodVisitor = new MethodVisitorImpl(this);
        this.m_annotationVisitor = new AnnotationVisitorImpl(this, JavaDependencyContext.TYPE);
    }

    public static void initializeAsUnparsed(JavaType type, boolean reset) {
        assert (type != null) : "Parameter 'type' of method 'initializeAsUnparsed' must not be null";
        type.accept(new InitializationVisitor(reset));
    }

    public static void initializeNewlyCreatedMethod(JavaMethod method) {
        assert (method != null) : "Parameter 'method' of method 'initializeNewlyCreatedMethod' must not be null";
        method.setLineNumber(-1);
        method.addFlag(JavaElementFlag.EXTERNAL);
        method.addFlag(JavaElementFlag.NOT_DEFINED_IN_ENCLOSING_TYPE);
        method.setNumberOfParameters(Type.getArgumentTypes((String)method.getMethodDescriptor()).length);
    }

    public static void initializeNewlyCreatedField(JavaField field) {
        assert (field != null) : "Parameter 'field' of method 'initializeNewlyCreatedField' must not be null";
        field.setLineNumber(-1);
        field.addFlag(JavaElementFlag.EXTERNAL);
        field.addFlag(JavaElementFlag.NOT_DEFINED_IN_ENCLOSING_TYPE);
    }

    private void performRemovalCheck(JavaMember member) {
        assert (member != null) : "Parameter 'member' of method 'performRemovalCheck' must not be null";
        boolean definitionNotFoundInReparse = member.hasFlag(JavaElementFlag.DEFINITION_NOT_FOUND_IN_REPARSE);
        if (definitionNotFoundInReparse) {
            member.removeFlag(JavaElementFlag.DEFINITION_NOT_FOUND_IN_REPARSE);
            member.removeFlag(JavaElementFlag.INLINEABLE);
        }
        if (definitionNotFoundInReparse && !member.hasFlag(JavaElementFlag.NOT_DEFINED_IN_ENCLOSING_TYPE) && !member.hasFlag(JavaElementFlag.KEEP)) {
            this.m_globalModel.addRemovedMember(member);
        }
    }

    public void parse(RootDirectoryPath rootDirectory, TFile classFile, IFilePathListener listener) {
        assert (rootDirectory != null) : "Parameter 'rootDirectory' of method 'parse' must not be null";
        assert (classFile != null) : "Parameter 'classFile' of method 'parse' must not be null";
        this.m_currentRootDirectory = rootDirectory;
        this.m_currentFile = classFile;
        this.m_filePathListener = listener;
        try {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (BufferedInputStream classFileStream = new BufferedInputStream((InputStream)new TFileInputStream((File)classFile));){
                    ClassReader cr = new ClassReader((InputStream)classFileStream);
                    cr.accept((ClassVisitor)this, 4);
                    if (this.m_currentType != null) {
                        this.m_currentType.getChildren(JavaMember.class).forEach(m -> this.performRemovalCheck((JavaMember)m));
                        this.m_currentClassFile.setSize(this.m_currentSize);
                        Object sourceName = null;
                        if (this.m_currentSourceName != null && this.m_currentSourceName.length() > 0) {
                            JavaFileType fileType;
                            sourceName = FileUtility.convertPathToUniversalForm((String)this.m_currentSourceName);
                            int pos = ((String)sourceName).lastIndexOf(47);
                            if (pos != -1) {
                                sourceName = ((String)sourceName).substring(pos + 1);
                            }
                            if ((fileType = JavaFileType.determine((String)sourceName)) == null) {
                                if (!PACKAGE_INFO_JAVA.equalsIgnoreCase((String)sourceName)) {
                                    LOGGER.warn("Not a valid source name '" + (String)sourceName + "' in class file:" + classFile.getAbsolutePath());
                                }
                                sourceName = null;
                            }
                        }
                        if (sourceName == null) {
                            sourceName = JavaNameUtility.getMainTypeName(this.m_currentType.getFqName()) + (this.m_currentType.hasFlag(JavaElementFlag.KOTLIN_TYPE) ? JavaFileType.KOTLIN_FILE.getDefaultExtension() : JavaFileType.JAVA_FILE.getDefaultExtension());
                        }
                        String packageName = JavaNameUtility.getPackageNameFromFullyQualifiedTypeName(this.m_currentType.getFqName());
                        String relSourcePath = JavaNameUtility.getRelativePath(packageName, (String)sourceName);
                        this.m_moduleModel.finishClassFileParsing(this.m_currentType, relSourcePath);
                        NamedElement inParent = (NamedElement)this.m_currentType.getParent(NamespaceFragment.class, new Class[0]);
                        if (inParent == null) {
                            inParent = (NamedElement)this.m_currentType.getParent(RootDirectoryPath.class, new Class[0]);
                        }
                        JavaInternalCompilationUnit internalCompilationUnit = this.m_globalModel.getOrCreateInternalCompilationUnit(inParent, relSourcePath, (String)sourceName);
                        this.m_currentType.changeParent((NamedElement)internalCompilationUnit, true);
                        String packageNameFromRelClassFilePath = JavaNameUtility.getPackageNameFromRelativeFilePath(FileUtility.calculateRelativePath((TFile)classFile, (TFile)rootDirectory.getFile()));
                        if (!packageName.equals(packageNameFromRelClassFilePath)) {
                            ClassFileMisplaced issue = new ClassFileMisplaced((NamedElement)this.m_currentClassFile, "Expected in sub-directory '" + JavaNameUtility.getRelativeDirectoryPathFromPackageName(packageName) + "' but found in '" + JavaNameUtility.getRelativeDirectoryPathFromPackageName(packageNameFromRelClassFilePath) + "'");
                            this.m_globalModel.addDeferredIssue((Issue)issue);
                        }
                    } else {
                        JavaType type = this.m_typeCreationResult.getType();
                        StringBuilder description = new StringBuilder("Ignoring Java class file ''");
                        description.append(this.m_currentClassFile.getAbsolutePath()).append("'. Java class file for fully qualified name '").append(type.getFqName()).append("' already added");
                        JavaClassFile primaryClassFile = (JavaClassFile)((Object)type.getFirstChild(JavaClassFile.class));
                        if (primaryClassFile != null) {
                            description.append(" from '").append(primaryClassFile.getAbsolutePath()).append("'");
                        }
                        description.append(".");
                        ClassFileDuplicate issue = new ClassFileDuplicate((NamedElement)this.m_currentClassFile, description.toString());
                        this.m_globalModel.addDeferredIssue((Issue)issue);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Throwable t) {
                String relPath = FileUtility.calculateRelativePath((TFile)this.m_currentFile.getParentFile(), (TFile)this.m_currentRootDirectory.getDirectoryFile());
                IDirectoryPath directoryPath = DirectoryFragment.getDirectoryFragmentOrSpecifiedParent((IModelServiceProvider)this.m_globalModel.getModelServiceProvider(), (IDirectoryPath)this.m_currentRootDirectory, (String)relPath, (DirectoryFragment.IDirectoryFragmentCreator)new DirectoryFragment.IDirectoryFragmentCreator(){

                    public DirectoryFragment create(IModelServiceProvider msp, NamedElement parent, String name) {
                        return new JavaDirectoryFragment(msp, parent, name);
                    }
                });
                this.m_currentClassFile = new JavaClassFile(directoryPath.getNamedElement(), this.m_currentFile, this.m_currentRootDirectory);
                directoryPath.getNamedElement().addChild((NamedElement)this.m_currentClassFile);
                ClassFileUnparseable issue = new ClassFileUnparseable((NamedElement)this.m_currentClassFile, ExceptionUtility.collectLast((Throwable)t));
                this.m_globalModel.addDeferredIssue((Issue)issue);
                if (this.m_filePathListener != null) {
                    this.m_filePathListener.filePathCreated((IModule)this.m_moduleModel.getModule(), (FilePath)this.m_currentClassFile);
                }
                this.m_currentRootDirectory = null;
                this.m_filePathListener = null;
                this.m_currentElement = null;
                this.m_typeCreationResult = null;
                this.m_currentType = null;
                this.m_currentField = null;
                this.m_currentMethod = null;
                this.m_currentTypeIsPotentiallyAnonymous = false;
                this.m_firstInstructionLineNumberOfPotentiallyAnonymousTypeAdded = false;
                this.m_currentMethodIsSynthetic = false;
                this.m_currentFile = null;
                this.m_currentClassFile = null;
                this.m_currentSourceName = null;
                this.m_currentSize = 0;
            }
        }
        finally {
            this.m_currentRootDirectory = null;
            this.m_filePathListener = null;
            this.m_currentElement = null;
            this.m_typeCreationResult = null;
            this.m_currentType = null;
            this.m_currentField = null;
            this.m_currentMethod = null;
            this.m_currentTypeIsPotentiallyAnonymous = false;
            this.m_firstInstructionLineNumberOfPotentiallyAnonymousTypeAdded = false;
            this.m_currentMethodIsSynthetic = false;
            this.m_currentFile = null;
            this.m_currentClassFile = null;
            this.m_currentSourceName = null;
            this.m_currentSize = 0;
        }
    }

    private void setJdkVersion(int version) {
        assert (this.m_currentType != null) : "'m_currentJavaType' of method 'setJdkVersion' must not be null";
        int v = version < 0 ? version & 0xFF : version;
        switch (v) {
            case 196653: {
                this.m_currentClassFile.setJdkVersion("1.1");
                break;
            }
            case 46: {
                this.m_currentClassFile.setJdkVersion("1.2");
                break;
            }
            case 47: {
                this.m_currentClassFile.setJdkVersion("1.3");
                break;
            }
            case 48: {
                this.m_currentClassFile.setJdkVersion("1.4");
                break;
            }
            case 49: {
                this.m_currentClassFile.setJdkVersion("1.5");
                break;
            }
            case 50: {
                this.m_currentClassFile.setJdkVersion("1.6");
                break;
            }
            case 51: {
                this.m_currentClassFile.setJdkVersion("1.7");
                break;
            }
            case 52: {
                this.m_currentClassFile.setJdkVersion("1.8");
                break;
            }
            case 53: {
                this.m_currentClassFile.setJdkVersion("9");
                break;
            }
            case 54: {
                this.m_currentClassFile.setJdkVersion("10");
                break;
            }
            case 55: {
                this.m_currentClassFile.setJdkVersion("11");
                break;
            }
            case 56: {
                this.m_currentClassFile.setJdkVersion("12");
                break;
            }
            case 57: {
                this.m_currentClassFile.setJdkVersion("13");
                break;
            }
            case 58: {
                this.m_currentClassFile.setJdkVersion("14");
                break;
            }
            case 59: {
                this.m_currentClassFile.setJdkVersion("15");
                break;
            }
            case 60: {
                this.m_currentClassFile.setJdkVersion("16");
                break;
            }
            case 61: {
                this.m_currentClassFile.setJdkVersion("17");
                break;
            }
            case 62: {
                this.m_currentClassFile.setJdkVersion("18");
                break;
            }
            case 63: {
                this.m_currentClassFile.setJdkVersion("19");
                break;
            }
            case 64: {
                this.m_currentClassFile.setJdkVersion("20");
                break;
            }
            case 65: {
                this.m_currentClassFile.setJdkVersion("21");
                break;
            }
            case 66: {
                this.m_currentClassFile.setJdkVersion("22");
                break;
            }
            case 67: {
                this.m_currentClassFile.setJdkVersion("23");
                break;
            }
            case 68: {
                this.m_currentClassFile.setJdkVersion("24");
                break;
            }
            case 69: {
                this.m_currentClassFile.setJdkVersion("25");
                break;
            }
            default: {
                LOGGER.warn("Unknown version: " + version + " [" + v + "]");
                this.m_currentClassFile.setJdkVersion("Unknown");
            }
        }
    }

    private Type[] getNonSyntheticArgumentTypes(String methodName, String desc) {
        assert (methodName != null) : "Parameter 'methodName' of method 'getNonSyntheticArgumentTypes' must not be null";
        assert (desc != null && desc.length() > 0) : "Parameter 'desc' of method 'getNonSyntheticArgumentTypes' must not be empty";
        assert (this.m_currentType != null) : "'m_CurrentJavaType' of method 'getNonSyntheticArgumentTypes' must not be null";
        if (this.m_currentType.hasFlag(JavaElementFlag.ENUM) && methodName.equals("<init>")) {
            ArrayList<Type> argumentTypes = new ArrayList<Type>(Arrays.asList(Type.getArgumentTypes((String)desc)));
            argumentTypes.remove(0);
            argumentTypes.remove(0);
            return argumentTypes.toArray(new Type[argumentTypes.size()]);
        }
        return Type.getArgumentTypes((String)desc);
    }

    public void visit(int version, int accessFlags, String name, String signature, String superName, String[] interfaces) {
        this.m_currentFqTypeName = this.convertToFqName(name);
        this.m_currentTypeIsPotentiallyAnonymous = JavaNameUtility.isPotentialAnonymousType(this.m_currentFqTypeName);
        this.m_typeCreationResult = this.m_globalModel.addInternalType(this.m_moduleModel.getModule(), this.m_currentRootDirectory, this.m_moduleModel.getTypesToBeReparsed(), this.m_currentFqTypeName, signature);
        this.m_currentClassFile = new JavaClassFile((NamedElement)this.m_typeCreationResult.getType(), this.m_currentFile, this.m_currentRootDirectory);
        this.m_typeCreationResult.getType().addChild((NamedElement)this.m_currentClassFile);
        if (this.m_filePathListener != null) {
            this.m_filePathListener.filePathCreated((IModule)this.m_moduleModel.getModule(), (FilePath)this.m_currentClassFile);
        }
        if (!this.m_typeCreationResult.isDuplicate()) {
            this.m_currentType = this.m_typeCreationResult.getType();
            this.m_currentElement = this.m_currentType;
            if (SyntheticsHelper.isSynthetic(accessFlags) && !this.m_currentFile.getName().contains(PACKAGE_INFO)) {
                this.m_globalModel.addSyntheticType(this.m_currentType);
            } else {
                this.incrementSize();
            }
            this.setJdkVersion(version);
            this.m_currentType.removeFlag(JavaElementFlag.EXTERNAL);
            this.m_currentType.removeFlag(JavaElementFlag.CLASS);
            AsmAccessFlagMapper.setElementFlags(accessFlags, this.m_currentElement);
            if (this.m_currentFile.getName().contains(PACKAGE_INFO)) {
                this.m_currentType.removeFlag(JavaElementFlag.SYNTHETIC);
            }
            if (superName != null && superName.length() > 0) {
                String convertedFqName = this.convertToFqName(superName);
                if (!this.m_globalModel.getIgnoreAccess().ignoreTypeAccess(null, JavaDependencyType.EXTENDS, convertedFqName)) {
                    this.m_globalModel.addDependencyProcessor(new DependencyToTypeProcessor(this.getCurrentJavaElement(), -1, null, JavaDependencyType.EXTENDS, this.m_moduleModel.getModule(), convertedFqName));
                }
            }
            if (interfaces != null && interfaces.length > 0) {
                String[] stringArray = interfaces;
                int n = interfaces.length;
                int n2 = 0;
                while (n2 < n) {
                    String nextInterface = stringArray[n2];
                    String convertedFqName = this.convertToFqName(nextInterface);
                    if (this.m_currentType.hasFlag(JavaElementFlag.INTERFACE)) {
                        if (!this.m_globalModel.getIgnoreAccess().ignoreTypeAccess(null, JavaDependencyType.EXTENDS, convertedFqName)) {
                            dependencyProcessor = new DependencyToTypeProcessor(this.getCurrentJavaElement(), -1, null, JavaDependencyType.EXTENDS, this.m_moduleModel.getModule(), convertedFqName);
                            dependencyProcessor.setTargetElementFlags(JavaElementFlag.INTERFACE);
                            this.m_globalModel.addDependencyProcessor(dependencyProcessor);
                        }
                    } else if (!this.m_globalModel.getIgnoreAccess().ignoreTypeAccess(null, JavaDependencyType.IMPLEMENTS, convertedFqName)) {
                        dependencyProcessor = new DependencyToTypeProcessor(this.getCurrentJavaElement(), -1, null, JavaDependencyType.IMPLEMENTS, this.m_moduleModel.getModule(), convertedFqName);
                        dependencyProcessor.setTargetElementFlags(JavaElementFlag.INTERFACE);
                        this.m_globalModel.addDependencyProcessor(dependencyProcessor);
                    }
                    ++n2;
                }
            }
            if (signature != null && signature.length() > 0) {
                try {
                    TypeSignatureVisitorImpl sv = new TypeSignatureVisitorImpl((IClassFileParserContext)this, this.m_currentType.hasFlag(JavaElementFlag.INTERFACE));
                    new SignatureReader(signature).accept((SignatureVisitor)sv);
                }
                catch (Throwable t) {
                    this.m_currentType.setSignature(null);
                    LOGGER.warn("Unable to parse type signature '" + signature + "' of (type): " + this.m_currentType.getFqName());
                }
                this.m_currentType.addFlag(JavaElementFlag.GENERIC);
            }
        }
    }

    private boolean mayBeInlined(int accessFlags, Type fieldType, Object value) {
        assert (fieldType != null) : "Parameter 'fieldType' of method 'mayBeInlined' must not be null";
        if ((accessFlags & 0x10) != 0 && value != null) {
            if (fieldType.getSort() >= 1 && fieldType.getSort() <= 8) {
                return true;
            }
            if (fieldType.getSort() == 10) {
                return "java.lang.String".equals(this.convertToFqName(fieldType.getClassName()));
            }
        }
        return false;
    }

    public ModuleVisitor visitModule(String name, int access, String version) {
        return super.visitModule(name, access, version);
    }

    public FieldVisitor visitField(int accessFlags, String fieldName, String desc, String signature, Object value) {
        if (this.m_currentType != null) {
            assert (this.m_currentFile != null) : "Parameter 'm_ClassFile' of method 'visitField' must not be null";
            this.m_currentMethod = null;
            this.m_currentField = this.m_globalModel.addField(this.m_currentType, fieldName, signature);
            this.m_currentElement = this.m_currentField;
            boolean isSynthetic = SyntheticsHelper.isSynthetic(accessFlags);
            if (isSynthetic) {
                this.m_globalModel.addSyntheticField(this.m_currentField);
            } else {
                this.incrementSize();
            }
            AsmAccessFlagMapper.setElementFlags(accessFlags, this.m_currentElement);
            this.m_currentField.removeFlag(JavaElementFlag.DEFINITION_NOT_FOUND_IN_REPARSE);
            this.m_currentField.removeFlag(JavaElementFlag.EXTERNAL);
            this.m_currentField.removeFlag(JavaElementFlag.NOT_DEFINED_IN_ENCLOSING_TYPE);
            if (SyntheticsHelper.isOuterClassReference(fieldName)) {
                this.m_currentType.addFlag(JavaElementFlag.INNER);
            }
            Type fieldType = Type.getType((String)desc);
            this.addDependencyToType(fieldType, -1, null, JavaDependencyType.FIELD);
            if (!isSynthetic && this.mayBeInlined(accessFlags, fieldType, value)) {
                this.m_currentField.addFlag(JavaElementFlag.INLINEABLE);
                this.m_globalModel.addPotentialInlineField(this.m_currentField);
            }
            if (signature != null && signature.length() > 0) {
                try {
                    FieldSignatureVisitorImpl sv = new FieldSignatureVisitorImpl(this);
                    new SignatureReader(signature).accept((SignatureVisitor)sv);
                }
                catch (Throwable t) {
                    this.m_currentField.setSignature(null);
                    LOGGER.warn("Unable to parse field signature '" + signature + "' of (type/field): " + this.m_currentType.getFqName() + "/" + this.m_currentField.getShortName());
                }
                this.m_currentField.addFlag(JavaElementFlag.GENERIC);
            }
            return this.m_fieldVisitor;
        }
        return null;
    }

    public MethodVisitor visitMethod(int accessFlags, String methodName, String desc, String signature, String[] exceptions) {
        if (this.m_currentType != null) {
            assert (this.m_currentFile != null) : "Parameter 'm_ClassFile' of method 'visitMethod' must not be null";
            Type[] argumentTypes = this.getNonSyntheticArgumentTypes(methodName, desc);
            boolean isSynthetic = SyntheticsHelper.isSynthetic(accessFlags);
            this.m_currentField = null;
            this.m_currentMethod = this.m_globalModel.addMethod(this.m_currentType, methodName, desc, signature);
            this.m_currentMethod.setNumberOfParameters(argumentTypes.length);
            this.m_currentElement = this.m_currentMethod;
            if (isSynthetic) {
                if (SyntheticsHelper.isLambdaMethod(methodName)) {
                    this.m_currentMethod.addFlag(JavaElementFlag.LAMBDA);
                } else if (SyntheticsHelper.isBridge(accessFlags, methodName)) {
                    this.m_currentMethod.addFlag(JavaElementFlag.BRIDGE);
                }
                this.m_globalModel.addSyntheticMethod(this.m_currentMethod);
            } else {
                this.incrementSize();
            }
            AsmAccessFlagMapper.setElementFlags(accessFlags, this.m_currentElement);
            this.m_currentMethod.removeFlag(JavaElementFlag.DEFINITION_NOT_FOUND_IN_REPARSE);
            this.m_currentMethod.removeFlag(JavaElementFlag.EXTERNAL);
            this.m_currentMethod.removeFlag(JavaElementFlag.NOT_DEFINED_IN_ENCLOSING_TYPE);
            if (SyntheticsHelper.isCompilerGeneratedMethod(this.m_currentType, methodName, accessFlags, desc)) {
                this.m_currentMethod.addFlag(JavaElementFlag.COMPILER_GENERATED);
            }
            Type returnType = Type.getReturnType((String)desc);
            this.addDependencyToType(returnType, -1, null, JavaDependencyType.RETURNS);
            Object[] objectArray = argumentTypes;
            int n = argumentTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Type nextArgumentType = objectArray[n2];
                this.addDependencyToType(nextArgumentType, -1, null, JavaDependencyType.PARAMETER);
                ++n2;
            }
            if (exceptions != null && exceptions.length > 0) {
                objectArray = exceptions;
                n = exceptions.length;
                n2 = 0;
                while (n2 < n) {
                    Type nextException = objectArray[n2];
                    String convertedFqName = this.convertToFqName((String)nextException);
                    if (!this.m_globalModel.getIgnoreAccess().ignoreTypeAccess(null, JavaDependencyType.THROWS, convertedFqName)) {
                        this.m_globalModel.addDependencyProcessor(new DependencyToTypeProcessor(this.getCurrentJavaElement(), -1, null, JavaDependencyType.THROWS, this.m_moduleModel.getModule(), convertedFqName));
                    }
                    ++n2;
                }
            }
            if (signature != null && signature.length() > 0) {
                try {
                    MethodSignatureVisitorImpl sv = new MethodSignatureVisitorImpl(this);
                    new SignatureReader(signature).accept((SignatureVisitor)sv);
                }
                catch (Throwable t) {
                    this.m_currentMethod.setSignature(null);
                    LOGGER.warn("Unable to parse method signature '" + signature + "' of (type/method): " + this.m_currentType.getFqName() + "/" + this.m_currentMethod.getShortName());
                }
                this.m_currentMethod.addFlag(JavaElementFlag.GENERIC);
            }
            this.m_currentMethodIsSynthetic = isSynthetic;
            return this.m_methodVisitor;
        }
        return null;
    }

    public void visitSource(String source, String debug) {
        if (source != null && source.length() > 0) {
            this.m_currentSourceName = source;
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (this.m_currentType != null) {
            if (KOTLIN_METADATA_ANNOTATION.equals(desc)) {
                this.m_currentType.addFlag(JavaElementFlag.KOTLIN_TYPE);
            } else {
                this.addDependencyToType(Type.getType((String)desc), -1, JavaDependencyContext.TYPE, JavaDependencyType.HAS_ANNOTATION);
            }
            this.m_annotationVisitor.setDependencyContext(JavaDependencyContext.TYPE, -1);
            return this.m_annotationVisitor;
        }
        return null;
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        if (this.m_currentType != null) {
            JavaDependencyContext dependencyContext = JavaDependencyContext.TYPE;
            this.addDependencyToType(Type.getType((String)desc), -1, dependencyContext, JavaDependencyType.HAS_TYPE_ANNOTATION);
            this.m_annotationVisitor.setDependencyContext(dependencyContext, -1);
            return this.m_annotationVisitor;
        }
        return null;
    }

    public void visitOuterClass(String outerClass, String methodName, String methodDescriptor) {
        String outerFqTypeName;
        assert (outerClass != null && outerClass.length() > 0) : "Parameter 'outerClass' of method 'visitOuterClass' must not be empty";
        if (this.m_currentType != null && this.m_currentFqTypeName.startsWith(outerFqTypeName = this.convertToFqName(outerClass)) && outerFqTypeName.length() < this.m_currentFqTypeName.length()) {
            this.m_moduleModel.addOuterTypeInfo(this.m_currentRootDirectory, this.m_currentType, outerFqTypeName);
        }
    }

    public void visitInnerClass(String nameInnerClass, String nameOuterClass, String shortNameInnerClass, int accessFlags) {
        if (this.m_currentType != null) {
            String innerFqTypeName = this.convertToFqName(nameInnerClass);
            if (innerFqTypeName.equals(this.m_currentFqTypeName)) {
                AsmAccessFlagMapper.setElementFlags(accessFlags, this.m_currentType);
                if (SyntheticsHelper.isSynthetic(accessFlags)) {
                    this.m_globalModel.addSyntheticType(this.m_currentType);
                }
                this.m_moduleModel.addNestedTypeInfo(this.m_currentRootDirectory, this.m_currentType, (String)(shortNameInnerClass != null && shortNameInnerClass.isEmpty() ? null : shortNameInnerClass), SyntheticsHelper.isSynthetic(accessFlags), (accessFlags & 8) != 0);
            } else if (nameOuterClass == null || nameOuterClass.isEmpty()) {
                if (innerFqTypeName.startsWith(this.m_currentFqTypeName)) {
                    this.m_moduleModel.addNestedTypeInfo(this.m_currentRootDirectory, this.m_currentType, innerFqTypeName, (String)(shortNameInnerClass != null && shortNameInnerClass.isEmpty() ? null : shortNameInnerClass), SyntheticsHelper.isSynthetic(accessFlags), (accessFlags & 8) != 0);
                }
            } else {
                String outerFqTypeName = this.convertToFqName(nameOuterClass);
                if (innerFqTypeName.startsWith(outerFqTypeName)) {
                    this.m_moduleModel.addNestedTypeInfo(this.m_currentRootDirectory, outerFqTypeName, innerFqTypeName, (String)(shortNameInnerClass != null && shortNameInnerClass.isEmpty() ? null : shortNameInnerClass), SyntheticsHelper.isSynthetic(accessFlags), (accessFlags & 8) != 0);
                }
            }
        }
    }

    public void visitPermittedSubclass(String permittedSubclass) {
        if (permittedSubclass != null && !permittedSubclass.isEmpty()) {
            String convertedFqName = this.convertToFqName(permittedSubclass);
            if (!this.m_globalModel.getIgnoreAccess().ignoreTypeAccess(null, JavaDependencyType.PERMITS, convertedFqName)) {
                this.m_globalModel.addDependencyProcessor(new DependencyToTypeProcessor(this.getCurrentJavaElement(), -1, null, JavaDependencyType.PERMITS, this.m_moduleModel.getModule(), convertedFqName));
            }
        }
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitEnd() {
    }

    @Override
    public IJavaGlobalModel getGlobalModel() {
        assert (this.m_globalModel != null) : "Parameter 'm_JavaProgrammingModel' of method 'getJavaProgrammingModel' must not be null";
        return this.m_globalModel;
    }

    @Override
    public IJavaModuleModel getModuleModel() {
        return this.m_moduleModel;
    }

    @Override
    public JavaModule getCurrentModule() {
        return this.m_moduleModel.getModule();
    }

    @Override
    public TFile getCurrentClassFile() {
        assert (this.m_currentFile != null) : "'m_currentClassFile' of method 'getCurrentClassFile' must not be null";
        return this.m_currentFile;
    }

    @Override
    public JavaElement getCurrentJavaElement() {
        assert (this.m_currentElement != null) : "'m_currentJavaElement' of method 'getCurrentJavaElement' must not be null";
        return this.m_currentElement;
    }

    @Override
    public JavaType getCurrentJavaType() {
        assert (this.m_currentType != null) : "'m_currentJavaType' of method 'getCurrentJavaType' must not be null";
        return this.m_currentType;
    }

    @Override
    public boolean isCurrentTypePotentiallyAnonymous() {
        return this.m_currentTypeIsPotentiallyAnonymous;
    }

    @Override
    public void setFirstInstructionLineNumberOfPotentiallyAnonymousTypeAdded() {
        this.m_firstInstructionLineNumberOfPotentiallyAnonymousTypeAdded = true;
    }

    @Override
    public boolean hasFirstInstructionLineNumberOfPotentiallyAnonymousTypeBeenAdded() {
        return this.m_firstInstructionLineNumberOfPotentiallyAnonymousTypeAdded;
    }

    @Override
    public JavaMethod getCurrentJavaMethod() {
        return this.m_currentMethod;
    }

    @Override
    public JavaField getCurrentJavaField() {
        return this.m_currentField;
    }

    @Override
    public String convertToFqName(String fqName) {
        assert (fqName != null) : "Parameter 'fqName' of method 'convertToFqName' must not be null";
        return fqName.replace('/', '.');
    }

    @Override
    public void incrementSize() {
        if (this.m_currentMethod == null || !this.m_currentMethodIsSynthetic) {
            ++this.m_currentSize;
        }
    }

    @Override
    public void addDependencyToTypeReference(String typeName, int lineNumber, JavaDependencyContext context, JavaDependencyType dependencyType) {
        assert (typeName != null && typeName.length() > 0) : "Parameter 'typeName' of method 'addDependencyToTypeReference' must not be empty";
        assert (dependencyType != null) : "Parameter 'dependencyType' of method 'addDependencyToTypeReference' must not be null";
        if (!this.m_globalModel.getIgnoreAccess().ignoreTypeAccess(context, dependencyType, typeName)) {
            this.m_globalModel.addDependencyProcessor(new DependencyToTypeProcessor(this.getCurrentJavaElement(), lineNumber, context, dependencyType, this.m_moduleModel.getModule(), typeName));
        }
    }

    @Override
    public void addDependencyToType(Type type, int lineNumber, JavaDependencyContext dependencyContext, JavaDependencyType dependencyType) {
        assert (type != null) : "'type' must not be null";
        switch (type.getSort()) {
            case 9: {
                type = type.getElementType();
                if (type.getSort() < 9) break;
                this.addDependencyToType(type, lineNumber, dependencyContext, dependencyType);
                break;
            }
            case 10: {
                this.addDependencyToTypeReference(type.getClassName(), lineNumber, dependencyContext, dependencyType);
            }
        }
    }

    private static class InitializationVisitor
    extends NamedElementVisitor
    implements JavaField.IVisitor,
    JavaMethod.IVisitor,
    KotlinFunction.IVisitor,
    JavaType.IVisitor,
    KotlinGhostProxy.IVisitor {
        private final List<KotlinGhostProxy> m_proxiesToDelete = new ArrayList<KotlinGhostProxy>();
        private final boolean m_reset;
        private boolean m_nested = false;

        private InitializationVisitor(boolean reset) {
            this.m_reset = reset;
        }

        @Override
        public void visitJavaType(JavaType element) {
            assert (element != null) : "Parameter 'element' of method 'visitJavaType' must not be null";
            if (!this.m_nested) {
                this.m_nested = true;
                element.removeOutgoingDependencies(false);
                element.setLineNumber(-1);
                element.resetFlagsExceptKeep();
                element.addFlag(JavaElementFlag.CLASS);
                element.addFlag(JavaElementFlag.EXTERNAL);
                this.visitChildrenOf((NamedElement)element);
                this.m_proxiesToDelete.forEach(p -> p.remove());
            }
        }

        @Override
        public void visitKotlinGhostProxy(KotlinGhostProxy element) {
            assert (element != null) : "Parameter 'element' of method 'visitKotlinGhostProxy' must not be null";
            this.m_proxiesToDelete.add(element);
        }

        @Override
        public void visitKotlinFunction(KotlinFunction element) {
            assert (element != null) : "Parameter 'element' of method 'visitKotlinFunction' must not be null";
            element.removeOutgoingDependencies(false);
            element.setLineNumber(-1);
            element.resetFlagsExceptKeep();
            if (this.m_reset) {
                element.addFlag(JavaElementFlag.DEFINITION_NOT_FOUND_IN_REPARSE);
            }
        }

        @Override
        public void visitJavaMethod(JavaMethod element) {
            assert (element != null) : "Parameter 'element' of method 'visitJavaMethod' must not be null";
            element.removeOutgoingDependencies(false);
            element.setLineNumber(-1);
            element.setNumberOfParameters(Type.getArgumentTypes((String)element.getMethodDescriptor()).length);
            element.resetFlagsExceptKeep();
            element.addFlag(JavaElementFlag.EXTERNAL);
            if (this.m_reset) {
                element.addFlag(JavaElementFlag.DEFINITION_NOT_FOUND_IN_REPARSE);
            }
            this.visitChildrenOf((NamedElement)element);
        }

        @Override
        public void visitJavaField(JavaField element) {
            assert (element != null) : "Parameter 'element' of method 'visitJavaField' must not be null";
            element.removeOutgoingDependencies(false);
            element.setLineNumber(-1);
            element.resetFlagsExceptKeep();
            element.addFlag(JavaElementFlag.EXTERNAL);
            if (this.m_reset) {
                element.addFlag(JavaElementFlag.DEFINITION_NOT_FOUND_IN_REPARSE);
            }
            this.visitChildrenOf((NamedElement)element);
        }
    }
}

