/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.java.controller.system.parser.base;

import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaElementFlag;
import com.hello2morrow.sonargraph.languageprovider.java.model.programming.JavaType;
import java.util.ArrayList;
import java.util.List;

public final class AnonymousNestedTypesHelper {
    private AnonymousNestedTypesHelper() {
    }

    private static int getAnonymousTypeIndex(JavaType type) {
        String name = type.getName();
        int dollarPos = name.lastIndexOf(36);
        assert (dollarPos > 0);
        return Integer.parseInt(name.substring(dollarPos + 1));
    }

    public static List<JavaType> getNestedAnonymousTypes(JavaType type) {
        assert (type != null) : "Parameter 'type' of method 'getNestedAnonymousTypes' must not be null";
        List allNestedTypes = type.getChildren(JavaType.class);
        ArrayList<JavaType> nestedAnonymousTypes = new ArrayList<JavaType>(allNestedTypes.size());
        for (JavaType nextNestedType : allNestedTypes) {
            if (!nextNestedType.isAnonymous() || nextNestedType.hasFlag(JavaElementFlag.SYNTHETIC) || nextNestedType.getLineNumber() != -1) continue;
            nestedAnonymousTypes.add(nextNestedType);
        }
        nestedAnonymousTypes.sort((t1, t2) -> AnonymousNestedTypesHelper.getAnonymousTypeIndex(t1) - AnonymousNestedTypesHelper.getAnonymousTypeIndex(t2));
        return nestedAnonymousTypes;
    }
}

