/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.angular;

import com.hello2morrow.sonargraph.plugin.angular.HtmlFile;
import com.hello2morrow.sonargraph.plugin.angular.IExecutionContext;
import com.hello2morrow.sonargraph.plugin.angular.JsonFileManager;
import com.hello2morrow.sonargraph.plugin.angular.TsConfigJsonFile;
import com.hello2morrow.sonargraph.plugin.angular.TypeScriptFile;
import com.hello2morrow.sonargraph.plugin.angular.Usage;
import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DependencyRetriever {
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyRetriever.class);

    private DependencyRetriever() {
    }

    static Collection<Path> detectSourceRoots(String tsConfigFilePath, IExecutionContext context) throws IOException {
        assert (tsConfigFilePath != null && tsConfigFilePath.length() > 0) : "Parameter 'tsConfigFilePath' of method 'detectSourceRoots' must not be empty";
        assert (context != null) : "Parameter 'context' of method 'detectSourceRoots' must not be null";
        TsConfigJsonFile tsConfigJsonFile = new TsConfigJsonFile(Path.of(tsConfigFilePath, new String[0]), new JsonFileManager(), context);
        return tsConfigJsonFile.getSourceRoots();
    }

    static List<TypeScriptFile.Dependency> retrieveDependencies(Collection<Path> srcRoots, IExecutionContext context) throws IOException {
        assert (srcRoots != null && !srcRoots.isEmpty()) : "Parameter 'srcRoots' of method 'retrieveDependencies' must not be empty";
        assert (context != null) : "Parameter 'context' of method 'retrieveDependencies' must not be null";
        THashMap components = new THashMap();
        THashMap pipes = new THashMap();
        for (Path nextPath : srcRoots) {
            if (context.hasBeenCanceled()) {
                return Collections.emptyList();
            }
            for (Path nextFile : Files.find(nextPath, 999, (path, basicFileAttributes) -> basicFileAttributes.isRegularFile() && path.toString().endsWith(".ts"), new FileVisitOption[0]).collect(Collectors.toList())) {
                if (context.hasBeenCanceled()) {
                    return Collections.emptyList();
                }
                TypeScriptFile nextTypescriptFile = new TypeScriptFile(nextFile, Files.readString(nextFile));
                if (!nextTypescriptFile.isComponent() && !nextTypescriptFile.isDirective() && !nextTypescriptFile.isPipe()) continue;
                if (nextTypescriptFile.isPipe()) {
                    pipes.put((Object)nextTypescriptFile.getName(), (Object)nextTypescriptFile);
                    continue;
                }
                components.put((Object)nextTypescriptFile.getSelector(), (Object)nextTypescriptFile);
                String templatePath = nextTypescriptFile.getTemplatePath();
                String template = nextTypescriptFile.getTemplate();
                if (templatePath == null && template == null) continue;
                List<Usage> componentUsages = template != null ? HtmlFile.findUsages(template) : HtmlFile.findUsages(new File(templatePath));
                nextTypescriptFile.addUsedElements(componentUsages);
            }
        }
        for (TypeScriptFile next : components.values()) {
            if (context.hasBeenCanceled()) {
                return Collections.emptyList();
            }
            next.computeDependencies((Map<String, TypeScriptFile>)components, (Map<String, TypeScriptFile>)pipes, context);
        }
        ArrayList<TypeScriptFile.Dependency> dependencies = new ArrayList<TypeScriptFile.Dependency>();
        for (TypeScriptFile next : components.values()) {
            if (context.hasBeenCanceled()) {
                return Collections.emptyList();
            }
            dependencies.addAll(next.getDependencies());
        }
        return dependencies;
    }

    public static void main(String[] args) {
        if (args == null || args.length != 1 || args[0] == null || args[0].length() == 0) {
            LOGGER.error("Exactly 1 argument expected: path to TS config file");
            return;
        }
        try {
            String tsConfigFilePath = args[0];
            LOGGER.info("Using TS config file: " + tsConfigFilePath);
            Collection<Path> sourceRoots = DependencyRetriever.detectSourceRoots(tsConfigFilePath, new IExecutionContext(){

                @Override
                public boolean hasBeenCanceled() {
                    return false;
                }
            });
            if (!sourceRoots.isEmpty()) {
                LOGGER.info("Retrieve dependencies from " + sourceRoots.size() + " source root directories");
                List<TypeScriptFile.Dependency> dependencies = DependencyRetriever.retrieveDependencies(sourceRoots, new IExecutionContext(){

                    @Override
                    public boolean hasBeenCanceled() {
                        return false;
                    }
                });
                LOGGER.info("Retrieve dependencies from " + sourceRoots.size() + " source root directories - done [" + dependencies.size() + " dependencies found]");
                int i = 1;
                for (TypeScriptFile.Dependency next : dependencies) {
                    TypeScriptFile nextFrom = next.getFrom();
                    TypeScriptFile nextTo = next.getTo();
                    LOGGER.info("Dependency [" + i + "]:\n  " + String.valueOf(nextFrom) + " (" + nextFrom.getClassName() + ")\n  -> " + String.valueOf(nextTo) + " (" + nextTo.getClassName() + ") [" + next.getLine() + "]");
                    ++i;
                }
            } else {
                LOGGER.info("No source roots detected");
            }
        }
        catch (IOException e) {
            LOGGER.error("Unable to detect source roots", (Throwable)e);
        }
    }
}

