/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.build.api;

import com.hello2morrow.sonargraph.build.api.ModuleInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class SystemInfo {
    private final String m_id;
    private final String m_name;
    private final String m_absolutePath;
    private final List<ModuleInfo> m_modules = new ArrayList<ModuleInfo>();
    private final String m_description;
    private File m_systemRoot;
    private File m_tsConfigFile;
    private File m_pythonRoot;
    private File m_pythonVirtualEnvironment;

    public SystemInfo(String id, String name, String description, String absolutePath) {
        assert (id != null && id.length() > 0) : "Parameter 'id' of method 'SystemInfo' must not be empty";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'SystemInfo' must not be empty";
        assert (absolutePath != null && absolutePath.length() > 0) : "Parameter 'absolutePath' of method 'SystemInfo' must not be empty";
        this.m_id = id;
        this.m_name = name;
        this.m_absolutePath = absolutePath;
        this.m_description = description == null ? "" : description;
    }

    public File getSystemRoot() {
        return this.m_systemRoot;
    }

    public void setSystemRoot(File systemRoot) {
        this.m_systemRoot = systemRoot;
    }

    public String getDescription() {
        return this.m_description;
    }

    public String getName() {
        return this.m_name;
    }

    public String getAbsolutePath() {
        return this.m_absolutePath;
    }

    public String getId() {
        return this.m_id;
    }

    public boolean hasModules() {
        return this.m_modules.size() > 0;
    }

    public void addModule(ModuleInfo module) {
        this.m_modules.add(module);
    }

    public List<ModuleInfo> getModules() {
        return Collections.unmodifiableList(this.m_modules);
    }

    public File getTsConfigFile() {
        return this.m_tsConfigFile;
    }

    public void setTsConfigFile(File tsConfigFile) {
        this.m_tsConfigFile = tsConfigFile;
    }

    public File getPythonRoot() {
        return this.m_pythonRoot;
    }

    public void setPythonRoot(File pythonRoot) {
        this.m_pythonRoot = pythonRoot;
    }

    public File getPythonVirtualEnvironment() {
        return this.m_pythonVirtualEnvironment;
    }

    public void setPythonVirtualEnvironment(File pythonVirtualEnv) {
        this.m_pythonVirtualEnvironment = pythonVirtualEnv;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("System Name: ").append(this.m_name).append('\n');
        sb.append("Id: ").append(this.m_id).append('\n');
        sb.append("Location: ").append(this.m_absolutePath).append('\n');
        sb.append("Modules: ").append(this.m_modules).append('\n');
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_absolutePath == null ? 0 : this.m_absolutePath.hashCode());
        result = 31 * result + (this.m_description == null ? 0 : this.m_description.hashCode());
        result = 31 * result + (this.m_id == null ? 0 : this.m_id.hashCode());
        result = 31 * result + (this.m_modules == null ? 0 : this.m_modules.hashCode());
        result = 31 * result + (this.m_name == null ? 0 : this.m_name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SystemInfo other = (SystemInfo)obj;
        if (this.m_absolutePath == null ? other.m_absolutePath != null : !this.m_absolutePath.equals(other.m_absolutePath)) {
            return false;
        }
        if (this.m_description == null ? other.m_description != null : !this.m_description.equals(other.m_description)) {
            return false;
        }
        if (this.m_id == null ? other.m_id != null : !this.m_id.equals(other.m_id)) {
            return false;
        }
        if (this.m_modules == null ? other.m_modules != null : !this.m_modules.equals(other.m_modules)) {
            return false;
        }
        return !(this.m_name == null ? other.m_name != null : !this.m_name.equals(other.m_name));
    }
}

