/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.script.runconfiguration;

import com.hello2morrow.sonargraph.core.model.script.FileBasedRunConfiguration;
import com.hello2morrow.sonargraph.core.model.script.GroovyScripts;
import com.hello2morrow.sonargraph.core.model.script.IParameterDefinitionProvider;
import com.hello2morrow.sonargraph.core.model.script.ParameterDefinition;
import com.hello2morrow.sonargraph.core.model.script.RunConfigurationParameters;
import com.hello2morrow.sonargraph.core.model.script.ScriptResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.persistence.base.JaxbAccess;
import com.hello2morrow.sonargraph.core.persistence.base.ValidationEventHandlerImpl;
import com.hello2morrow.sonargraph.core.persistence.script.runconfiguration.ObjectFactory;
import com.hello2morrow.sonargraph.core.persistence.script.runconfiguration.XsdParameterValue;
import com.hello2morrow.sonargraph.core.persistence.script.runconfiguration.XsdRunConfiguration;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.ResourceProviderRegistry;
import com.hello2morrow.sonargraph.foundation.utilities.Version;
import com.hello2morrow.sonargraph.integration.access.persistence.JaxbAdapter;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlPersistenceContext;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import de.schlichtherle.truezip.file.TFileOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystemException;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.ValidationEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RunConfigurationPersistence {
    private static final Logger LOGGER = LoggerFactory.getLogger(RunConfigurationPersistence.class);
    private static final String XSD_NAMESPACE = "com.hello2morrow.sonargraph.core.persistence.script.runconfiguration";
    private static final String SCHEMA_URL = "com.hello2morrow.sonargraph.core.persistence.script.runconfiguration".replace('.', '/');
    private final GroovyScripts m_groovyScripts;
    private final Version m_version;

    public RunConfigurationPersistence(GroovyScripts groovyScripts, Version version) {
        assert (groovyScripts != null) : "Parameter 'groovyScripts' of method 'RunConfigurationPersistence' must not be null";
        assert (version != null) : "Parameter 'version' of method 'RunConfigurationPersistence' must not be null";
        this.m_groovyScripts = groovyScripts;
        this.m_version = version;
    }

    private void convertXmlToPojo(XsdRunConfiguration runConfigurationXml, FileBasedRunConfiguration runConfiguration) {
        assert (runConfigurationXml != null) : "Parameter 'runConfigurationXml' of method 'convertXmlToPojo' must not be null";
        assert (runConfiguration != null) : "Parameter 'runConfiguration' of method 'convertXmlToPojo' must not be null";
        runConfiguration.setDescription(runConfigurationXml.getDescription());
        RunConfigurationParameters parameters = new RunConfigurationParameters();
        IParameterDefinitionProvider parameterDefinitionProvider = runConfiguration.getParameterDefinitionProvider();
        for (XsdParameterValue next : runConfigurationXml.getParameterValue()) {
            String nextParameterName = next.getName();
            String nextParameterValue = next.getValue();
            ParameterDefinition<?> definition = parameterDefinitionProvider.getParameterDefinition(nextParameterName);
            if (definition == null) continue;
            Object nextParsedValue = definition.parse(nextParameterValue);
            if ("timeout".equals(nextParameterName)) {
                assert (nextParsedValue != null && nextParsedValue instanceof Integer) : "Unexpected class in method 'convertXmlToPojo': " + String.valueOf(nextParsedValue);
                if ((Integer)nextParsedValue < 1) {
                    nextParsedValue = 10;
                }
            }
            parameters.setParameterValue(definition.getName(), nextParsedValue);
        }
        runConfiguration.setRunConfigurationParameters(parameters);
    }

    private JAXBElement<XsdRunConfiguration> convertPojoToXml(FileBasedRunConfiguration runConfiguration) {
        assert (runConfiguration != null) : "Parameter 'runConfiguration' of method 'convertPojoToXml' must not be null";
        ObjectFactory objectFactory = new ObjectFactory();
        XsdRunConfiguration xsdRunConfiguration = objectFactory.createXsdRunConfiguration();
        JAXBElement<XsdRunConfiguration> xsdElement = objectFactory.createRunConfiguration(xsdRunConfiguration);
        xsdRunConfiguration.setVersion(this.m_version.toString());
        xsdRunConfiguration.setDescription(runConfiguration.getDescription());
        for (Map.Entry<String, Object> nextEntry : runConfiguration.getRunConfigurationParameters().getParameters().entrySet()) {
            XsdParameterValue pv = objectFactory.createXsdParameterValue();
            pv.setName(nextEntry.getKey());
            pv.setValue(nextEntry.getValue().toString());
            xsdRunConfiguration.getParameterValue().add(pv);
        }
        return xsdElement;
    }

    private JaxbAdapter<JAXBElement<XsdRunConfiguration>> createJaxbAadpter() {
        XmlPersistenceContext context = new XmlPersistenceContext(XSD_NAMESPACE, ScriptResourceProviderAdapter.getInstance().getResourceUrl((ResourceProviderRegistry.IResourceType)ResourceProviderRegistry.ResourceType.XSD, SCHEMA_URL));
        ClassLoader classLoader = ObjectFactory.class.getClassLoader();
        return JaxbAccess.createJaxbAdapter(classLoader, context);
    }

    private void saveRunConfiguration(FileBasedRunConfiguration content, OutputStream stream, OperationResult result) {
        assert (content != null) : "Parameter 'content' of method 'save' must not be null";
        assert (stream != null) : "Parameter 'stream' of method 'save' must not be null";
        assert (result != null) : "Parameter 'result' of method 'save' must not be null";
        JAXBElement<XsdRunConfiguration> xsdElement = this.convertPojoToXml(content);
        JaxbAdapter<JAXBElement<XsdRunConfiguration>> jaxbAdapter = this.createJaxbAadpter();
        try {
            jaxbAdapter.save(xsdElement, stream);
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, (Throwable)ex);
        }
    }

    public OperationResult load(InputStream inputStream, FileBasedRunConfiguration runConfiguration) {
        assert (inputStream != null) : "Parameter 'inputStream' of method 'loadRunConfigurationFromStream' must not be null";
        assert (runConfiguration != null) : "Parameter 'runConfiguration' of method 'load' must not be null";
        OperationResult result = new OperationResult("Load run configuration from stream");
        JAXBElement xsdElement = null;
        JaxbAdapter<JAXBElement<XsdRunConfiguration>> jaxbAdapter = this.createJaxbAadpter();
        ValidationEventHandlerImpl eventHandler = new ValidationEventHandlerImpl(result);
        xsdElement = (JAXBElement)jaxbAdapter.load(inputStream, (ValidationEventHandler)eventHandler);
        if (!result.isSuccess()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.WRONG_FORMAT, "Could not load run configuration from stream", new Object[0]);
            return result;
        }
        this.convertXmlToPojo((XsdRunConfiguration)xsdElement.getValue(), runConfiguration);
        return result;
    }

    public OperationResult load(TFile file, FileBasedRunConfiguration runConfiguration) {
        assert (file != null) : "Parameter 'file' of method 'loadRunConfigurationFromFile' must not be null";
        assert (runConfiguration != null) : "Parameter 'runConfiguration' of method 'loadRunConfigurationFromFile' must not be null";
        String relativePath = FileUtility.calculateRelativePath((TFile)file, (TFile)this.m_groovyScripts.getDirectoryFile());
        OperationResult result = new OperationResult("Load run configuration file '" + relativePath + "'");
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (TFileInputStream inputStream = new TFileInputStream((File)file);){
                OperationResult loadResult = this.load((InputStream)inputStream, runConfiguration);
                if (loadResult.isFailure()) {
                    result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, "Failed to load run configuration from file '" + relativePath + "'", new Object[0]);
                }
                result.addMessagesFrom(loadResult);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, "Failed to load run configuration from file '" + relativePath + "'", new Object[]{e});
        }
        return result;
    }

    public OperationResult save(FileBasedRunConfiguration runConfiguration, TFile targetFile) {
        assert (runConfiguration != null) : "Parameter 'runConfiguration' of method 'storeRunConfigurationToFile' must not be null";
        LOGGER.debug("storeRunConfigurationToFile runconfiguration: {} file: {}", (Object)runConfiguration.getName(), (Object)targetFile.getAbsolutePath());
        OperationResult result = new OperationResult("Save run configuration to file '" + targetFile.getAbsolutePath() + "'");
        TFile parentDirectory = targetFile.getParentFile();
        boolean parentDirectoryExists = true;
        if (!parentDirectory.exists()) {
            LOGGER.debug("create parent directory {}", (Object)parentDirectory.getAbsolutePath());
            parentDirectoryExists = parentDirectory.mkdirs();
            if (!parentDirectoryExists) {
                LOGGER.debug("create parent directory failed");
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_CREATE_DIRECTORY, "Unknown error occured creating directory: " + parentDirectory.getAbsolutePath(), new Object[0]);
            }
        }
        if (parentDirectoryExists) {
            try {
                Throwable throwable = null;
                Object var7_10 = null;
                try (TFileOutputStream out = new TFileOutputStream((File)targetFile);){
                    this.saveRunConfiguration(runConfiguration, (OutputStream)out, result);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException ex) {
                if (ex.getCause() != null && ex.getCause() instanceof FileSystemException) {
                    result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, ex.getCause());
                } else {
                    result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, (Throwable)ex);
                }
            }
            catch (IOException ex1) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.WRITE_ERROR, (Throwable)ex1);
            }
        }
        return result;
    }

    public void save(OutputStream targetStream, FileBasedRunConfiguration runConfiguration, OperationResult result) {
        this.saveRunConfiguration(runConfiguration, targetStream, result);
    }
}

