/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.persistence.diff;

import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.SoftwareSystemDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.workspace.IssueFilterDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.workspace.ModuleDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.workspace.PatternDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.workspace.ProductionCodeFilterDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.workspace.RootDirectoryDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.workspace.WorkspaceDiff;
import com.hello2morrow.sonargraph.core.model.system.diff.workspace.WorkspaceFilterDiff;
import com.hello2morrow.sonargraph.core.persistence.diff.AbstractHtmlInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class WorkspaceInfo
extends AbstractHtmlInfo {
    private final WorkspaceDiff m_workspaceDiff;

    public WorkspaceInfo(SoftwareSystemDiff softwareSystemDiff) {
        super(softwareSystemDiff);
        this.m_workspaceDiff = softwareSystemDiff.getUniqueExistingChild(WorkspaceDiff.class);
    }

    public boolean hasChanges() {
        return this.m_workspaceDiff.getChange() != IDiffElement.Change.UNMODIFIED;
    }

    public List<PatternDiff> getWorkspaceFilterPatterns() {
        WorkspaceFilterDiff workspaceFilterDiff = this.m_workspaceDiff.getUniqueChild(WorkspaceFilterDiff.class);
        if (workspaceFilterDiff == null) {
            return Collections.emptyList();
        }
        return workspaceFilterDiff.getChildren(PatternDiff.class);
    }

    public List<PatternDiff> getProductionCodeFilterPatterns() {
        ProductionCodeFilterDiff productionCodeFilterDiff = this.m_workspaceDiff.getUniqueChild(ProductionCodeFilterDiff.class);
        if (productionCodeFilterDiff == null) {
            return Collections.emptyList();
        }
        return productionCodeFilterDiff.getChildren(PatternDiff.class);
    }

    public List<PatternDiff> getIssueFilterPatterns() {
        IssueFilterDiff issueFilterDiff = this.m_workspaceDiff.getUniqueChild(IssueFilterDiff.class);
        if (issueFilterDiff == null) {
            return Collections.emptyList();
        }
        return issueFilterDiff.getChildren(PatternDiff.class);
    }

    public List<RootPathInfo> getRootDirectoryChanges() {
        ArrayList<RootPathInfo> result = new ArrayList<RootPathInfo>();
        for (ModuleDiff nextModule : this.m_workspaceDiff.getChildren(ModuleDiff.class)) {
            for (RootDirectoryDiff nextRoot : nextModule.getChildren(RootDirectoryDiff.class)) {
                RootPathInfo info = new RootPathInfo(nextModule.getShortName(), nextRoot.getPresentationName(true), nextRoot.getInformation(), nextRoot.getChange(), nextRoot.getChangeDescription());
                result.add(info);
            }
        }
        return result;
    }

    public static final class RootPathInfo {
        private final String m_changeDescription;
        private final IDiffElement.Change m_change;
        private final String m_information;
        private final String m_path;
        private final String m_moduleName;

        public RootPathInfo(String moduleName, String path, String information, IDiffElement.Change change, String changeDescription) {
            this.m_moduleName = moduleName;
            this.m_path = path;
            this.m_information = information;
            this.m_change = change;
            this.m_changeDescription = changeDescription;
        }

        public String getChangeDescription() {
            return this.m_changeDescription;
        }

        public IDiffElement.Change getChange() {
            return this.m_change;
        }

        public String getInformation() {
            return this.m_information;
        }

        public String getPath() {
            return this.m_path;
        }

        public String getModuleName() {
            return this.m_moduleName;
        }
    }
}

