/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.system;

import de.schlichtherle.truezip.file.TFile;

public final class SystemDirectoryLocationInfo {
    private final TFile m_currentDirectory;
    private final TFile m_newDirectory;
    private final TFile m_baseDirectory;

    public SystemDirectoryLocationInfo(TFile currentDirectory, TFile newDirectory, TFile baseDirectory) {
        assert (currentDirectory != null) : "Parameter 'currentDirectory' of method 'MoveInfo' must not be null";
        assert (newDirectory != null) : "Parameter 'newDirectory' of method 'MoveInfo' must not be null";
        this.m_currentDirectory = currentDirectory.getNormalizedAbsoluteFile();
        this.m_newDirectory = newDirectory.getNormalizedAbsoluteFile();
        this.m_baseDirectory = baseDirectory != null ? baseDirectory.getNormalizedAbsoluteFile() : null;
    }

    public boolean locationIsDifferent() {
        return !this.m_currentDirectory.getAbsolutePath().equals(this.m_newDirectory.getAbsolutePath());
    }

    public TFile getCurrentDirectory() {
        return this.m_currentDirectory;
    }

    public TFile getNewDirectory() {
        return this.m_newDirectory;
    }

    public TFile getBaseDirectory() {
        return this.m_baseDirectory;
    }
}

