/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.script;

import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.common.SourceLineWithContext;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IProviderId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.path.SourceFileReferenceWithLineNumberAndContext;
import com.hello2morrow.sonargraph.core.model.programming.AggregatedDependency;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.script.IScriptMetricId;
import com.hello2morrow.sonargraph.core.model.script.ScriptDependencyTreeNode;
import com.hello2morrow.sonargraph.core.model.script.ScriptElementTreeNode;
import com.hello2morrow.sonargraph.core.model.script.ScriptIssueElementTreeNode;
import com.hello2morrow.sonargraph.core.model.script.ScriptIssueId;
import com.hello2morrow.sonargraph.core.model.script.ScriptIssueSourceFileAndLineTreeNode;
import com.hello2morrow.sonargraph.core.model.script.ScriptIssueSourceFileTreeNode;
import com.hello2morrow.sonargraph.core.model.script.ScriptIssueTreeNode;
import com.hello2morrow.sonargraph.core.model.script.ScriptMetricIdNode;
import com.hello2morrow.sonargraph.core.model.script.ScriptMetricValueTreeNode;
import com.hello2morrow.sonargraph.core.model.script.ScriptNamedTreeNode;
import com.hello2morrow.sonargraph.core.model.script.ScriptProviderId;
import com.hello2morrow.sonargraph.core.model.script.ScriptSeverityTreeNode;
import com.hello2morrow.sonargraph.core.model.script.ScriptTreeNode;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ScriptResultSet
extends NamedElement {
    private final List<NamedElement> m_namedElements = new ArrayList<NamedElement>();
    private final List<AggregatedDependency> m_aggregatedDependencies = new ArrayList<AggregatedDependency>();
    private final List<ParserDependency> m_parserDependencies = new ArrayList<ParserDependency>();
    private final ScriptNamedTreeNode m_treeRootNode = new ScriptNamedTreeNode("Tree");
    private final ScriptNamedTreeNode m_issuesRootNode = new ScriptNamedTreeNode("Issues");
    private final ScriptNamedTreeNode m_metricsRootNode = new ScriptNamedTreeNode("Metrics");
    private final Map<String, ScriptIssueTreeNode> m_issueIdToNode = new HashMap<String, ScriptIssueTreeNode>();
    private final Map<IMetricId, ScriptTreeNode> m_metricIdToNode = new HashMap<IMetricId, ScriptTreeNode>();
    private final String m_identifyingPathOfScript;
    private ScriptSeverityTreeNode m_errorIssueNode = null;
    private ScriptSeverityTreeNode m_warningIssueNode = null;
    private ScriptSeverityTreeNode m_infoIssueNode = null;
    private final Set<IIssueId> m_issueIds = new HashSet<IIssueId>();
    private final Set<IProviderId> m_issueProviderIds = new HashSet<IProviderId>();

    public ScriptResultSet(NamedElement parent, String identifyingPathOfScript) {
        super(parent);
        assert (identifyingPathOfScript != null && identifyingPathOfScript.length() > 0) : "Parameter 'identifyingPathOfScript' of method 'ScriptResultSet' must not be empty";
        this.m_identifyingPathOfScript = identifyingPathOfScript;
    }

    @Override
    @Property
    public String getShortName() {
        return this.m_identifyingPathOfScript;
    }

    public void addMetric(IScriptMetricId id, IMetricLevel level, NamedElement element, Number value) {
        ScriptTreeNode metricNode = this.m_metricIdToNode.get(id);
        if (metricNode == null) {
            metricNode = new ScriptMetricIdNode(id);
            this.m_metricIdToNode.put(id, metricNode);
            this.m_metricsRootNode.addChild(metricNode);
        }
        ScriptMetricValueTreeNode valueNode = new ScriptMetricValueTreeNode(id, level, element, value);
        metricNode.addChild(valueNode);
    }

    public void add(Element element) {
        assert (element != null) : "Parameter 'element' of method 'addToResults' must not be null";
        if (element instanceof NamedElement) {
            this.m_namedElements.add((NamedElement)element);
        } else if (element instanceof AggregatedDependency) {
            this.m_aggregatedDependencies.add((AggregatedDependency)element);
        } else if (element instanceof ParserDependency) {
            this.m_parserDependencies.add((ParserDependency)element);
        }
    }

    public void add(List<? extends Element> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'addAllToResults' must not be null";
        for (Element element : elements) {
            this.add(element);
        }
    }

    public List<NamedElement> getNamedElements() {
        return this.m_namedElements;
    }

    public List<AggregatedDependency> getAggregatedDependencies() {
        return this.m_aggregatedDependencies;
    }

    public List<ParserDependency> getParserDependencies() {
        return this.m_parserDependencies;
    }

    public void resultsCollected() {
        this.m_namedElements.clear();
        this.m_aggregatedDependencies.clear();
        this.m_parserDependencies.clear();
        this.m_treeRootNode.removeAllChildren();
        this.m_issuesRootNode.removeAllChildren();
        this.m_errorIssueNode = null;
        this.m_warningIssueNode = null;
        this.m_infoIssueNode = null;
        this.m_issueIdToNode.clear();
        this.m_metricsRootNode.removeAllChildren();
        this.m_metricIdToNode.clear();
    }

    public void reset() {
        this.resultsCollected();
        this.m_issueIds.clear();
        this.m_issueProviderIds.clear();
    }

    private boolean addIssue(ScriptSeverityTreeNode severityNode, Element element, String issueIdAsString, String description) {
        assert (severityNode != null) : "Parameter 'severityNode' of method 'addIssue' must not be null";
        assert (element != null) : "Parameter 'element' of method 'addIssue' must not be null";
        assert (issueIdAsString != null && issueIdAsString.length() > 0) : "Parameter 'issueIdAsString' of method 'addIssue' must not be empty";
        assert (description != null) : "Parameter 'description' of method 'addIssue' must not be null";
        if (element.isExcluded() || element.ignoreIssues()) {
            return false;
        }
        ScriptIssueTreeNode issueNode = this.m_issueIdToNode.get(issueIdAsString);
        ScriptIssueId issueId = null;
        if (issueNode == null) {
            ScriptProviderId providerId = new ScriptProviderId(this.m_identifyingPathOfScript);
            issueId = new ScriptIssueId(issueIdAsString, severityNode.getSeverity(), providerId);
            issueNode = new ScriptIssueTreeNode(issueId);
            severityNode.addChild(issueNode);
            this.m_issueIdToNode.put(issueIdAsString, issueNode);
        }
        ScriptIssueElementTreeNode treeNode = new ScriptIssueElementTreeNode(element, description);
        issueNode.addChild(treeNode);
        if (element instanceof AggregatedDependency) {
            AggregatedDependency aggregatedDependency = (AggregatedDependency)element;
            for (ParserDependency dep : aggregatedDependency.getParserDependencies()) {
                ScriptIssueElementTreeNode parserDepNode = new ScriptIssueElementTreeNode(dep, description);
                treeNode.addChild(parserDepNode);
            }
        }
        return true;
    }

    public boolean addErrorIssue(Element element, String issueIdAsString, String description) {
        assert (element != null) : "Parameter 'element' of method 'addErrorIssue' must not be null";
        assert (issueIdAsString != null && issueIdAsString.length() > 0) : "Parameter 'issueIdAsString' of method 'addErrorIssue' must not be empty";
        assert (description != null) : "Parameter 'description' of method 'addErrorIssue' must not be null";
        if (this.m_errorIssueNode == null) {
            this.m_errorIssueNode = new ScriptSeverityTreeNode(Severity.ERROR);
            this.m_issuesRootNode.addChild(this.m_errorIssueNode, 0);
        }
        return this.addIssue(this.m_errorIssueNode, element, issueIdAsString, description);
    }

    public boolean addWarningIssue(Element element, String issueIdAsString, String description) {
        assert (element != null) : "Parameter 'element' of method 'addWarningIssue' must not be null";
        assert (issueIdAsString != null && issueIdAsString.length() > 0) : "Parameter 'issueIdAsString' of method 'addWarningIssue' must not be empty";
        assert (description != null) : "Parameter 'description' of method 'addWarningIssue' must not be null";
        if (this.m_warningIssueNode == null) {
            this.m_warningIssueNode = new ScriptSeverityTreeNode(Severity.WARNING);
            this.m_issuesRootNode.addChild(this.m_warningIssueNode, 1);
        }
        return this.addIssue(this.m_warningIssueNode, element, issueIdAsString, description);
    }

    public boolean addInfoIssue(Element element, String issueIdAsString, String description) {
        assert (element != null) : "Parameter 'element' of method 'addInfoIssue' must not be null";
        assert (issueIdAsString != null && issueIdAsString.length() > 0) : "Parameter 'issueIdAsString' of method 'addInfoIssue' must not be empty";
        assert (description != null) : "Parameter 'description' of method 'addInfoIssue' must not be null";
        if (this.m_infoIssueNode == null) {
            this.m_infoIssueNode = new ScriptSeverityTreeNode(Severity.INFO);
            this.m_issuesRootNode.addChild(this.m_infoIssueNode, 2);
        }
        return this.addIssue(this.m_infoIssueNode, element, issueIdAsString, description);
    }

    private void addIssue(ScriptSeverityTreeNode severityNode, SourceFile element, String issueIdAsString, String description, int line) {
        assert (severityNode != null) : "Parameter 'severityNode' of method 'addIssue' must not be null";
        assert (element != null) : "Parameter 'element' of method 'addIssue' must not be null";
        assert (issueIdAsString != null && issueIdAsString.length() > 0) : "Parameter 'issueIdAsString' of method 'addIssue' must not be empty";
        assert (description != null) : "Parameter 'description' of method 'addIssue' must not be null";
        ScriptIssueTreeNode issueNode = this.m_issueIdToNode.get(issueIdAsString);
        ScriptIssueId issueId = null;
        if (issueNode == null) {
            ScriptProviderId providerId = new ScriptProviderId(this.m_identifyingPathOfScript);
            this.m_issueProviderIds.add(providerId);
            issueId = new ScriptIssueId(issueIdAsString, severityNode.getSeverity(), providerId);
            this.m_issueIds.add(issueId);
            issueNode = new ScriptIssueTreeNode(issueId);
            severityNode.addChild(issueNode);
            this.m_issueIdToNode.put(issueIdAsString, issueNode);
        }
        ScriptIssueSourceFileTreeNode treeNode = new ScriptIssueSourceFileTreeNode(element, description, line);
        issueNode.addChild(treeNode);
    }

    private void addIssue(ScriptSeverityTreeNode severityNode, SourceFile element, String issueIdAsString, String description, SourceLineWithContext sourceLine) {
        assert (severityNode != null) : "Parameter 'severityNode' of method 'addIssue' must not be null";
        assert (element != null) : "Parameter 'element' of method 'addIssue' must not be null";
        assert (issueIdAsString != null && issueIdAsString.length() > 0) : "Parameter 'issueIdAsString' of method 'addIssue' must not be empty";
        assert (description != null) : "Parameter 'description' of method 'addIssue' must not be null";
        assert (sourceLine != null) : "Parameter 'sourceLine' of method 'addIssue' must not be null";
        ScriptIssueTreeNode issueNode = this.m_issueIdToNode.get(issueIdAsString);
        ScriptIssueId issueId = null;
        if (issueNode == null) {
            ScriptProviderId providerId = new ScriptProviderId(this.m_identifyingPathOfScript);
            issueId = new ScriptIssueId(issueIdAsString, severityNode.getSeverity(), providerId);
            issueNode = new ScriptIssueTreeNode(issueId);
            severityNode.addChild(issueNode);
            this.m_issueIdToNode.put(issueIdAsString, issueNode);
        }
        ScriptIssueSourceFileAndLineTreeNode treeNode = new ScriptIssueSourceFileAndLineTreeNode(element, description, sourceLine);
        issueNode.addChild(treeNode);
    }

    public void addErrorIssue(SourceFile element, String issueIdAsString, String description, int line) {
        assert (element != null) : "Parameter 'element' of method 'addErrorIssue' must not be null";
        assert (issueIdAsString != null && issueIdAsString.length() > 0) : "Parameter 'issueIdAsString' of method 'addErrorIssue' must not be empty";
        assert (description != null) : "Parameter 'description' of method 'addErrorIssue' must not be null";
        if (this.m_errorIssueNode == null) {
            this.m_errorIssueNode = new ScriptSeverityTreeNode(Severity.ERROR);
            this.m_issuesRootNode.addChild(this.m_errorIssueNode, 0);
        }
        this.addIssue(this.m_errorIssueNode, element, issueIdAsString, description, line);
    }

    public void addErrorIssue(SourceFile element, String issueIdAsString, String description, SourceLineWithContext sourceLine) {
        assert (element != null) : "Parameter 'element' of method 'addErrorIssue' must not be null";
        assert (issueIdAsString != null && issueIdAsString.length() > 0) : "Parameter 'issueIdAsString' of method 'addErrorIssue' must not be empty";
        assert (description != null) : "Parameter 'description' of method 'addErrorIssue' must not be null";
        assert (sourceLine != null) : "Parameter 'sourceLine' of method 'addErrorIssue' must not be null";
        if (this.m_errorIssueNode == null) {
            this.m_errorIssueNode = new ScriptSeverityTreeNode(Severity.ERROR);
            this.m_issuesRootNode.addChild(this.m_errorIssueNode, 0);
        }
        this.addIssue(this.m_errorIssueNode, element, issueIdAsString, description, sourceLine);
    }

    public void addWarningIssue(SourceFile element, String issueIdAsString, String description, int line) {
        assert (element != null) : "Parameter 'element' of method 'addWarningIssue' must not be null";
        assert (issueIdAsString != null && issueIdAsString.length() > 0) : "Parameter 'issueIdAsString' of method 'addWarningIssue' must not be empty";
        assert (description != null) : "Parameter 'description' of method 'addWarningIssue' must not be null";
        if (this.m_warningIssueNode == null) {
            this.m_warningIssueNode = new ScriptSeverityTreeNode(Severity.WARNING);
            this.m_issuesRootNode.addChild(this.m_warningIssueNode, 1);
        }
        this.addIssue(this.m_warningIssueNode, element, issueIdAsString, description, line);
    }

    public void addWarningIssue(SourceFile element, String issueIdAsString, String description, SourceLineWithContext sourceLine) {
        assert (element != null) : "Parameter 'element' of method 'addWarningIssue' must not be null";
        assert (issueIdAsString != null && issueIdAsString.length() > 0) : "Parameter 'issueIdAsString' of method 'addWarningIssue' must not be empty";
        assert (description != null) : "Parameter 'description' of method 'addWarningIssue' must not be null";
        assert (sourceLine != null) : "Parameter 'sourceLine' of method 'addWarningIssue' must not be null";
        if (this.m_warningIssueNode == null) {
            this.m_warningIssueNode = new ScriptSeverityTreeNode(Severity.WARNING);
            this.m_issuesRootNode.addChild(this.m_warningIssueNode, 1);
        }
        this.addIssue(this.m_warningIssueNode, element, issueIdAsString, description, sourceLine);
    }

    public void addInfoIssue(SourceFile element, String issueIdAsString, String description, int line) {
        assert (element != null) : "Parameter 'element' of method 'addInfoIssue' must not be null";
        assert (issueIdAsString != null && issueIdAsString.length() > 0) : "Parameter 'issueIdAsString' of method 'addInfoIssue' must not be empty";
        assert (description != null) : "Parameter 'description' of method 'addInfoIssue' must not be null";
        if (this.m_infoIssueNode == null) {
            this.m_infoIssueNode = new ScriptSeverityTreeNode(Severity.INFO);
            this.m_issuesRootNode.addChild(this.m_infoIssueNode, 2);
        }
        this.addIssue(this.m_infoIssueNode, element, issueIdAsString, description, line);
    }

    public void addInfoIssue(SourceFile element, String issueIdAsString, String description, SourceLineWithContext sourceLine) {
        assert (element != null) : "Parameter 'element' of method 'addInfoIssue' must not be null";
        assert (issueIdAsString != null && issueIdAsString.length() > 0) : "Parameter 'issueIdAsString' of method 'addInfoIssue' must not be empty";
        assert (description != null) : "Parameter 'description' of method 'addInfoIssue' must not be null";
        assert (sourceLine != null) : "Parameter 'sourceLine' of method 'addInfoIssue' must not be null";
        if (this.m_infoIssueNode == null) {
            this.m_infoIssueNode = new ScriptSeverityTreeNode(Severity.INFO);
            this.m_issuesRootNode.addChild(this.m_infoIssueNode, 2);
        }
        this.addIssue(this.m_infoIssueNode, element, issueIdAsString, description, sourceLine);
    }

    private void visitIssueInfo(IIssueInfoVisitor visitor, ScriptSeverityTreeNode severityNode, ScriptIssueTreeNode issueNode) {
        assert (visitor != null) : "Parameter 'visitor' of method 'visitIssueInfo' must not be null";
        assert (severityNode != null) : "Parameter 'severityNode' of method 'visitIssueInfo' must not be null";
        assert (issueNode != null) : "Parameter 'issueNode' of method 'visitIssueInfo' must not be null";
        for (ScriptTreeNode nextChild : issueNode.getChildren()) {
            ScriptTreeNode child;
            if (nextChild instanceof ScriptIssueElementTreeNode) {
                child = (ScriptIssueElementTreeNode)nextChild;
                Element element = ((ScriptIssueElementTreeNode)child).getElement();
                if (element instanceof AggregatedDependency) {
                    this.processIssueNodeChildren(visitor, severityNode, issueNode, (ScriptIssueElementTreeNode)child);
                    continue;
                }
                visitor.issueInfo(element, issueNode.getIssueId(), ((ScriptIssueElementTreeNode)child).getDescription());
                continue;
            }
            if (nextChild instanceof ScriptIssueSourceFileAndLineTreeNode) {
                child = (ScriptIssueSourceFileAndLineTreeNode)nextChild;
                visitor.issueInfo(((ScriptIssueSourceFileAndLineTreeNode)child).getElement().getSourceFile(), issueNode.getIssueId(), ((ScriptIssueSourceFileAndLineTreeNode)child).getDescription(), ((ScriptIssueSourceFileAndLineTreeNode)child).getElement());
                continue;
            }
            if (nextChild instanceof ScriptIssueSourceFileTreeNode) {
                child = (ScriptIssueSourceFileTreeNode)nextChild;
                visitor.issueInfo(((ScriptIssueSourceFileTreeNode)child).getElement().getSourceFile(), issueNode.getIssueId(), ((ScriptIssueSourceFileTreeNode)child).getDescription(), ((ScriptIssueSourceFileTreeNode)child).getLine());
                continue;
            }
            assert (false) : "Unhandled class: " + String.valueOf(nextChild.getClass());
        }
    }

    private void processIssueNodeChildren(IIssueInfoVisitor visitor, ScriptSeverityTreeNode severityNode, ScriptIssueTreeNode issueNode, ScriptIssueElementTreeNode elementNode) {
        assert (visitor != null) : "Parameter 'visitor' of method 'processIssueNode' must not be null";
        assert (severityNode != null) : "Parameter 'severityNode' of method 'processIssueNode' must not be null";
        assert (issueNode != null) : "Parameter 'issueNode' of method 'processIssueNodeChildren' must not be null";
        assert (elementNode != null) : "Parameter 'elementNode' of method 'processIssueNodeChildren' must not be null";
        for (ScriptTreeNode nextChild : elementNode.getChildren()) {
            ScriptTreeNode child;
            if (nextChild instanceof ScriptIssueElementTreeNode) {
                child = (ScriptIssueElementTreeNode)nextChild;
                visitor.issueInfo(((ScriptIssueElementTreeNode)child).getElement(), issueNode.getIssueId(), ((ScriptIssueElementTreeNode)child).getDescription());
                continue;
            }
            if (nextChild instanceof ScriptIssueSourceFileTreeNode) {
                child = (ScriptIssueSourceFileTreeNode)nextChild;
                visitor.issueInfo(((ScriptIssueSourceFileTreeNode)child).getElement().getSourceFile(), issueNode.getIssueId(), ((ScriptIssueSourceFileTreeNode)child).getDescription(), ((ScriptIssueSourceFileTreeNode)child).getLine());
                continue;
            }
            assert (false) : "Unhandled class: " + String.valueOf(nextChild.getClass());
        }
    }

    private void visitIssueInfo(IIssueInfoVisitor visitor, ScriptSeverityTreeNode severityNode) {
        assert (visitor != null) : "Parameter 'visitor' of method 'visitIssueInfo' must not be null";
        assert (severityNode != null) : "Parameter 'severityNode' of method 'visitIssueInfo' must not be null";
        for (ScriptTreeNode nextChild : severityNode.getChildren()) {
            assert (nextChild != null && nextChild instanceof ScriptIssueTreeNode) : "Unexpected class in method 'visitIssueInfo': " + String.valueOf(nextChild);
            this.visitIssueInfo(visitor, severityNode, (ScriptIssueTreeNode)nextChild);
        }
    }

    public void visitIssueInfo(IIssueInfoVisitor visitor) {
        assert (visitor != null) : "Parameter 'visitor' of method 'visitIssueInfo' must not be null";
        if (this.m_errorIssueNode != null) {
            this.visitIssueInfo(visitor, this.m_errorIssueNode);
        }
        if (this.m_warningIssueNode != null) {
            this.visitIssueInfo(visitor, this.m_warningIssueNode);
        }
        if (this.m_infoIssueNode != null) {
            this.visitIssueInfo(visitor, this.m_infoIssueNode);
        }
    }

    public void visitMetricValues(IMetricValueVisitor visitor) {
        assert (visitor != null) : "Parameter 'visitor' of method 'visitMetricValues' must not be null";
        for (ScriptTreeNode node : this.m_metricsRootNode.getChildren()) {
            for (ScriptTreeNode innerNode : node.getChildren()) {
                ScriptMetricValueTreeNode valueNode = (ScriptMetricValueTreeNode)innerNode;
                visitor.visitMetricValue(valueNode.getId(), valueNode.getLevel(), valueNode.getElement(), valueNode.getValue());
            }
        }
    }

    public boolean hasNamedElements() {
        return !this.m_namedElements.isEmpty();
    }

    public boolean hasAggregatedDependencies() {
        return !this.m_aggregatedDependencies.isEmpty();
    }

    public boolean hasParserDependencies() {
        return !this.m_parserDependencies.isEmpty();
    }

    public boolean hasTreeNodes() {
        return this.m_treeRootNode.getNumberOfChildren() > 0;
    }

    public boolean hasIssueNodes() {
        return this.m_issuesRootNode.getNumberOfChildren() > 0;
    }

    public boolean hasMetricNodes() {
        return this.m_metricsRootNode.getNumberOfChildren() > 0;
    }

    public boolean isEmpty() {
        return !this.hasAggregatedDependencies() && !this.hasNamedElements() && !this.hasTreeNodes() && !this.hasIssueNodes();
    }

    public ScriptNamedTreeNode getTreeRootNode() {
        return this.m_treeRootNode;
    }

    public ScriptNamedTreeNode getIssueRootNode() {
        return this.m_issuesRootNode;
    }

    public ScriptNamedTreeNode getMetricRootNode() {
        return this.m_metricsRootNode;
    }

    public ScriptNamedTreeNode addNode(String name, ScriptTreeNode parent) {
        assert (parent != null) : "Parameter 'parent' of method 'addGroup' must not be null";
        ScriptNamedTreeNode node = new ScriptNamedTreeNode(name);
        parent.addChild(node);
        return node;
    }

    public ScriptNamedTreeNode addNode(String name, int index, ScriptTreeNode parent) {
        assert (parent != null) : "Parameter 'parent' of method 'addGroup' must not be null";
        ScriptNamedTreeNode node = new ScriptNamedTreeNode(name);
        parent.addChild(node, index);
        return node;
    }

    public ScriptNamedTreeNode addNode(String name) {
        return this.addNode(name, (ScriptTreeNode)this.getTreeRootNode());
    }

    public ScriptElementTreeNode addNode(Element element, ScriptTreeNode parent) {
        assert (parent != null) : "Parameter 'parent' of method 'addGroup' must not be null";
        ScriptElementTreeNode node = new ScriptElementTreeNode(element);
        parent.addChild(node);
        return node;
    }

    public ScriptElementTreeNode addNode(Element element) {
        return this.addNode(element, (ScriptTreeNode)this.getTreeRootNode());
    }

    public ScriptDependencyTreeNode addDependencyNode(AggregatedDependency dependency, ScriptTreeNode parent) {
        assert (dependency != null) : "Parameter 'dependency' of method 'addIncomingDependencyNode' must not be null";
        assert (parent != null) : "Parameter 'parent' of method 'addIncomingDependencyNode' must not be null";
        ScriptDependencyTreeNode node = new ScriptDependencyTreeNode(dependency);
        parent.addChild(node);
        return node;
    }

    public ScriptDependencyTreeNode addDependencyNode(AggregatedDependency dependency) {
        return this.addDependencyNode(dependency, this.getTreeRootNode());
    }

    public Set<IIssueId> getIssueIds() {
        return this.m_issueIds;
    }

    public Set<IProviderId> getIssueProviderIds() {
        return this.m_issueProviderIds;
    }

    public static interface IIssueInfoVisitor {
        public void issueInfo(Element var1, ScriptIssueId var2, String var3);

        public void issueInfo(SourceFile var1, ScriptIssueId var2, String var3, int var4);

        public void issueInfo(SourceFile var1, ScriptIssueId var2, String var3, SourceFileReferenceWithLineNumberAndContext var4);
    }

    public static interface IMetricValueVisitor {
        public void visitMetricValue(IScriptMetricId var1, IMetricLevel var2, NamedElement var3, Number var4);
    }
}

