/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.script;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.script.ScriptTreeNode;

public final class ScriptElementTreeNode
extends ScriptTreeNode {
    private final Element m_element;
    private boolean m_parentIsPresented;

    public ScriptElementTreeNode(Element element) {
        assert (element != null) : "Parameter 'element' of method 'ScriptElementTreeNode' must not be null";
        this.m_element = element;
    }

    @Override
    public Element getElement() {
        return this.m_element;
    }

    public boolean getParentIsPresented() {
        return this.m_parentIsPresented;
    }

    public void setParentIsPresented(boolean parentIsPresented) {
        this.m_parentIsPresented = parentIsPresented;
    }

    @Override
    public String getName() {
        Element element = this.m_element;
        if (this.m_element instanceof Issue) {
            element = ((Issue)this.m_element).getAffectedElement();
        }
        return this.getNumberOfChildren() > 0 ? element.getPresentationName(false) + " (" + this.getNumberOfChildren() + ")" : element.getPresentationName(this.m_parentIsPresented);
    }

    @Override
    public String getImageResourceName() {
        Element element = this.m_element;
        if (this.m_element instanceof Issue) {
            element = ((Issue)this.m_element).getAffectedElement();
        }
        return element.getImageResourceName();
    }

    @Override
    public String toString() {
        return this.m_element.toString();
    }
}

