/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.script;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.script.ParameterDefinition;
import com.hello2morrow.sonargraph.core.model.script.UniqueNameValidator;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.List;
import java.util.Set;

public final class RunConfigurationNameValidator
extends UniqueNameValidator
implements ITextValidator {
    public RunConfigurationNameValidator(Set<String> existingNames, List<ParameterDefinition<?>> parameterDefinitions) {
        super(existingNames);
        assert (parameterDefinitions != null) : "Parameter 'parameterDefinitions' of method 'RunConfigurationValidator' must not be null";
    }

    @Override
    public ValidationResult isValid(String currentInput, String newInput) {
        ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
        String string = newInput = newInput != null ? newInput.trim() : null;
        if (newInput == null || newInput.isEmpty()) {
            result.addError("Must not be empty");
        } else if (result.inputModified()) {
            if (newInput.indexOf("#") != -1) {
                result.addError("'#' may not be used in name");
            } else if (!this.isNameUnique(newInput)) {
                result.addError("Run configuration with name '" + newInput + "' already exists");
            }
        }
        return result;
    }
}

