/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.refactoring;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.refactoring.ICollisionValidator;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRenameRefactoringElementType;
import com.hello2morrow.sonargraph.core.model.refactoring.MoveRenameRefactoringInfo;
import com.hello2morrow.sonargraph.core.model.refactoring.RefactoringType;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import java.util.Collections;
import java.util.List;

public abstract class RefactoringData {
    public static final String MOVE_TO_ROOT_DIRECTORY = "";
    private final MoveRenameRefactoringInfo m_info;
    private final ICollisionValidator m_collisionValidator;
    private final RootDirectoryPath m_originalRootDirectory;
    private final String m_parentKind;
    private final String m_parentImageResourceName;
    private final String m_elementImageResourceName;
    private final String m_originalParentName;
    private ValidationResult m_collisionValidationResult = new ValidationResult(false);

    protected RefactoringData(MoveRenameRefactoringInfo info, RootDirectoryPath originalRootDirectory, String originalParentName, ICollisionValidator collisionValidator, String parentKind, String parentImageResourceName, String elementImageResourceName) {
        assert (info != null) : "Parameter 'info' of method 'RefactoringData' must not be null";
        assert (originalRootDirectory != null) : "Parameter 'originalRootDirectory' of method 'RefactoringData' must not be null";
        assert (originalParentName != null) : "Parameter 'originalParentName' of method 'RefactoringData' must not be null";
        assert (collisionValidator != null) : "Parameter 'collisionValidator' of method 'RefactoringData' must not be null";
        assert (parentKind != null && parentKind.length() > 0) : "Parameter 'parentKind' of method 'RefactoringData' must not be empty";
        assert (parentImageResourceName != null && parentImageResourceName.length() > 0) : "Parameter 'parentImageResourceName' of method 'RefactoringData' must not be empty";
        assert (elementImageResourceName != null && elementImageResourceName.length() > 0) : "Parameter 'elementImageResourceName' of method 'RefactoringData' must not be empty";
        this.m_info = info;
        this.m_originalRootDirectory = originalRootDirectory;
        this.m_originalParentName = originalParentName;
        this.m_collisionValidator = collisionValidator;
        this.m_parentKind = parentKind;
        this.m_parentImageResourceName = parentImageResourceName;
        this.m_elementImageResourceName = elementImageResourceName;
    }

    public final Language getLanguage() {
        return this.m_info.getLanguage();
    }

    public final RefactoringType getPossibleRefactoringType() {
        return this.m_info.getRefactoringType();
    }

    public final MoveRenameRefactoringElementType getRefactoringElementType() {
        return this.m_info.getRefactoringElementType();
    }

    public final String getRefactoringElementTypePresentationName() {
        return this.m_info.getRefactoringElementTypePresentationName();
    }

    public final RootDirectoryPath getOriginalRootDirectory() {
        return this.m_originalRootDirectory;
    }

    public final String getOriginalParentName() {
        return this.m_originalParentName;
    }

    public final String getParentKind() {
        return this.m_parentKind;
    }

    public final String getParentImageResourceName() {
        return this.m_parentImageResourceName;
    }

    public final String getElementImageResourceName() {
        return this.m_elementImageResourceName;
    }

    public final List<NamedElement> getElements() {
        return this.m_info.getElements();
    }

    public final ValidationResult getCollisionValidationResult() {
        assert (this.m_collisionValidationResult != null) : "'m_collisionValidationResult' of method 'getCollisionValidationResult' must not be null";
        return this.m_collisionValidationResult;
    }

    public String getTargetParentName() {
        return this.getOriginalParentName();
    }

    protected abstract boolean useTargetNameForCollisionCheck();

    protected final ValidationResult validateCollision() {
        String targetName;
        String targetParentName = this.getTargetParentName();
        this.m_collisionValidationResult = targetParentName != null ? (this.useTargetNameForCollisionCheck() ? ((targetName = this.getTargetName()) != null && this.getTargetRootDirectory() != null ? this.m_collisionValidator.isValid(this.getTargetRootDirectory(), targetParentName, targetName) : new ValidationResult(false)) : this.m_collisionValidator.isValid(this.getTargetRootDirectory(), targetParentName)) : new ValidationResult(false);
        return this.m_collisionValidationResult;
    }

    public final void validate() {
        this.validateCollision();
    }

    public List<String> getAvailableTargetModules() {
        return Collections.singletonList(this.getTargetModule());
    }

    public List<String> getAvailableTargetRootDirectories(String moduleName) {
        assert (moduleName != null) : "Parameter 'module' of method 'getAvailableTargetRootDirectoryPaths' must not be null";
        return Collections.singletonList(this.getOriginalRootDirectory().getIdentifyingPath());
    }

    public String getTargetModule() {
        return this.getOriginalRootDirectory().getParent(Module.class, new Class[0]).getName();
    }

    public RootDirectoryPath getTargetRootDirectory() {
        return this.getOriginalRootDirectory();
    }

    public ValidationResult setTargetModule(String moduleName) {
        assert (false) : "setTargetModule not supported";
        return null;
    }

    public ITextValidator getModuleNameValidator() {
        assert (false) : "getModuleNameValidator() not supported";
        return null;
    }

    public ValidationResult setTargetRootDirectoryPath(RootDirectoryPath rootDirectoryPath) {
        assert (false) : "setTargetRootDirectoryPath not supported";
        return null;
    }

    public ValidationResult setTargetRootDirectoryPath(String selected) {
        assert (false) : "setTargetRootDirectoryPath not supported";
        return null;
    }

    public ITextValidator getTargetRootDirectoryValidator() {
        assert (false) : "getTargetRootDirectoryValidator not supported";
        return null;
    }

    public ITextValidator getTargetParentNameValidator() {
        assert (false) : "getTargetParentNameValidator not supported";
        return null;
    }

    public ValidationResult setTargetParentName(String targetParentName) {
        assert (false) : "setTargetParentName() not supported";
        return null;
    }

    public List<String> getAvailableTargetParentNames() {
        return Collections.singletonList(this.getOriginalParentName());
    }

    public ITextValidator getTargetNameValidator() {
        assert (false) : "getNameValidator() not supported";
        return null;
    }

    public ValidationResult setTargetName(String name) {
        assert (false) : "setTargetName() not supported";
        return null;
    }

    public String getTargetName() {
        assert (false) : "getTargetName() not supported";
        return null;
    }

    public abstract boolean hasBeenModified();

    public boolean hasValidData() {
        return this.m_collisionValidationResult.isSuccess();
    }

    public RefactoringType getEffectiveRefactoringType() {
        if (!this.hasBeenModified()) {
            return RefactoringType.NONE;
        }
        return this.getPossibleRefactoringType();
    }

    public String getModuleForName(String name) {
        assert (false) : "getModuleForName() not supported";
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

