/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.programming;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.PhysicalRecursiveElement;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import java.util.StringTokenizer;

public abstract class NamespaceFragment
extends PhysicalRecursiveElement
implements LogicalNamespace.ISourceNamespace {
    public static final String NAMESPACE_FRAGMENT = "NamespaceFragment";
    public static final String NAMESPACE_FRAGMENT_PART = "NamespaceFragmentPart";
    private LogicalNamespace m_moduleNamespace;
    private LogicalNamespace m_systemNamespace;

    public NamespaceFragment(NamedElement parent) {
        super(parent);
    }

    public NamespaceFragment(IModelServiceProvider msp, NamedElement parent, String shortName) {
        super(msp, parent, shortName);
    }

    @Override
    public final String getPresentationKind() {
        Language language = this.getLanguage();
        assert (language != null) : "Parameter 'language' of method 'getPresentationKind' must not be null";
        return language.getPresentationName() + " Module " + language.getNamespacePresentationName();
    }

    public static NamedElement getNamespaceFragmentOrSpecifiedParent(IModelServiceProvider msp, NamedElement parent, String namespace, INamespaceFragmentCreator creator) {
        assert (parent != null) : "Parameter 'parent' of method 'getNamespaceOrSpecifiedParent' must not be null";
        assert (namespace != null) : "Parameter 'namespace' of method 'getNamespaceOrSpecifiedParent' must not be null";
        assert (creator != null) : "Parameter 'creator' of method 'getNamespaceFragmentOrSpecifiedParent' must not be null";
        if (namespace.length() == 0) {
            return parent;
        }
        String separator = parent.getLanguage().getNamespaceSeparator();
        StringTokenizer tokenizer = new StringTokenizer(namespace, separator);
        NamedElement current = parent;
        while (tokenizer.hasMoreTokens()) {
            String nextNamespaceName = tokenizer.nextToken();
            assert (nextNamespaceName != null && nextNamespaceName.length() > 0) : "'nextNamespaceName' of method 'getNamespaceOrSpecifiedParent' must not be empty";
            NamespaceFragment found = null;
            for (NamespaceFragment nextNamespaceFragment : current.getChildren(NamespaceFragment.class)) {
                if (!nextNamespaceFragment.getShortName().equals(nextNamespaceName)) continue;
                if (!creator.accept(nextNamespaceFragment)) break;
                found = nextNamespaceFragment;
            }
            if (found == null) {
                found = creator.create(msp, current, nextNamespaceName);
                NamedElement parentUsed = found.getParent();
                assert (parentUsed != null) : "Parameter 'parentUsed' of method 'getNamespaceFragmentOrSpecifiedParent' must not be null";
                parentUsed.addChild(found);
            }
            current = found;
        }
        return current;
    }

    @Override
    public final String getImageResourceName() {
        if (this.isPart()) {
            return NAMESPACE_FRAGMENT_PART;
        }
        return NAMESPACE_FRAGMENT;
    }

    @Override
    public final String getImageResource() {
        return NAMESPACE_FRAGMENT;
    }

    @Override
    public final String getImageResourcePart() {
        return NAMESPACE_FRAGMENT_PART;
    }

    @Override
    public final LogicalNamespace getModuleNamespace() {
        return this.m_moduleNamespace;
    }

    @Override
    public final void setModuleNamespace(LogicalNamespace moduleNamespace) {
        this.m_moduleNamespace = moduleNamespace;
    }

    @Override
    public final LogicalNamespace getSystemNamespace() {
        return this.m_systemNamespace;
    }

    @Override
    public final void setSystemNamespace(LogicalNamespace systemNamespace) {
        this.m_systemNamespace = systemNamespace;
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitNamespaceFragment(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface INamespaceFragmentCreator {
        public static final /* synthetic */ boolean $assertionsDisabled;

        public NamespaceFragment create(IModelServiceProvider var1, NamedElement var2, String var3);

        default public boolean accept(NamespaceFragment found) {
            assert (found != null) : "Parameter 'found' of method 'accept' must not be null";
            return true;
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitNamespaceFragment(NamespaceFragment var1);
    }
}

