/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFinding;
import com.hello2morrow.sonargraph.core.model.explorationview.ITargetArchitectureFileValidator;
import com.hello2morrow.sonargraph.core.model.explorationview.TransferPartExecutionInfo;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class TransferArchitectureExecutionInfo
extends TransferPartExecutionInfo {
    private final Map<ArchitecturalViewFinding, List<ParserDependency>> m_ignoredViolationsInfo;
    private final ITargetArchitectureFileValidator m_targetFileValidator;
    private final String m_targetFileNameProposal;
    private final boolean m_createIgnoreViolationResolutionsIsPossible;
    private String m_fileName;
    private String m_description = "";
    private boolean m_addToArchitectureCheck = true;
    private boolean m_createIgnoreViolationResolutions;

    public TransferArchitectureExecutionInfo(ITargetArchitectureFileValidator targetFileValidator, String targetFileNameProposal, Map<ArchitecturalViewFinding, List<ParserDependency>> ignoredViolationsInfo, boolean createIgnoreViolationResolutionsIsPossible) {
        assert (targetFileValidator != null) : "Parameter 'targetFileValidator' of method 'TransferArchitectureExecutionInfo' must not be null";
        assert (targetFileNameProposal != null && targetFileNameProposal.length() > 0) : "Parameter 'targetFileNameProposal' of method 'TransferArchitectureExecutionInfo' must not be empty";
        assert (ignoredViolationsInfo != null) : "Parameter 'ignoredViolationsInfo' of method 'TransferArchitectureExecutionInfo' must not be null";
        this.m_targetFileValidator = targetFileValidator;
        this.m_targetFileNameProposal = targetFileNameProposal;
        this.m_fileName = targetFileNameProposal;
        this.m_ignoredViolationsInfo = ignoredViolationsInfo;
        this.m_createIgnoreViolationResolutions = !this.m_ignoredViolationsInfo.isEmpty() && createIgnoreViolationResolutionsIsPossible;
        this.m_createIgnoreViolationResolutionsIsPossible = createIgnoreViolationResolutionsIsPossible;
    }

    public ITargetArchitectureFileValidator getTargetFileValidator() {
        return this.m_targetFileValidator;
    }

    public String getTargetFileNameProposal() {
        return this.m_targetFileNameProposal;
    }

    public Map<ArchitecturalViewFinding, List<ParserDependency>> getIgnoredViolationsInfo() {
        return Collections.unmodifiableMap(this.m_ignoredViolationsInfo);
    }

    public void setFileName(String fileName) {
        assert (fileName != null) : "Parameter 'fileName' of method 'setFileName' must not be null";
        this.m_fileName = fileName;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public void setDescription(String description) {
        assert (description != null) : "Parameter 'description' of method 'setDescription' must not be null";
        this.m_description = description;
    }

    @Override
    public boolean isValid() {
        return this.m_fileName.length() > 0;
    }

    public String getDescription() {
        return this.m_description;
    }

    public TFile getTargetFile() {
        return new TFile((File)this.m_targetFileValidator.getDirectory(), this.m_fileName + CoreFileType.ARCHITECTURE.getDefaultExtension());
    }

    public boolean isAddToArchitectureCheckPossible() {
        return this.transfer();
    }

    public boolean addToArchitectureCheck() {
        return this.m_addToArchitectureCheck;
    }

    public void addToArchitectureCheck(boolean addToArchitectureCheck) {
        assert (this.isAddToArchitectureCheckPossible()) : "Not possible";
        this.m_addToArchitectureCheck = addToArchitectureCheck;
    }

    public boolean isCreateIgnoreViolationResolutionsPossible() {
        return this.transfer() && this.m_addToArchitectureCheck && !this.m_ignoredViolationsInfo.isEmpty() && this.m_createIgnoreViolationResolutionsIsPossible;
    }

    public boolean createIgnoreViolationResolutions() {
        return this.m_createIgnoreViolationResolutions;
    }

    public void createIgnoreViolationResolutions(boolean create) {
        assert (this.isCreateIgnoreViolationResolutionsPossible()) : "Not possible";
        this.m_createIgnoreViolationResolutions = create;
    }

    public boolean transferIgnoreViolationResolutions() {
        return this.isCreateIgnoreViolationResolutionsPossible() && this.m_createIgnoreViolationResolutions;
    }
}

