/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.EmptyNodeProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import java.util.Collection;
import java.util.Collections;

public abstract class ProgrammingElementAggregatingNode
extends ArchitecturalViewNode {
    private final Collection<ProgrammingElement> m_programmingElements;
    private final EmptyNodeProgrammingElement m_emptyNodeProgrammingElement;

    protected ProgrammingElementAggregatingNode(ArchitecturalViewElement parent, PresentationMode presentationMode, boolean isReadOnly, Collection<ProgrammingElement> programmingElements) {
        super(parent, presentationMode, isReadOnly);
        assert (programmingElements != null) : "Parameter 'programmingElements' of method 'ProgrammingElementAggregatingNode' must not be null";
        this.m_programmingElements = programmingElements;
        this.m_emptyNodeProgrammingElement = new EmptyNodeProgrammingElement(this);
        this.addProgrammingElement(this.m_emptyNodeProgrammingElement);
    }

    protected ProgrammingElementAggregatingNode(ArchitecturalViewElement parent, ProgrammingElementAggregatingNode copyOf, Collection<ProgrammingElement> programmingElements) {
        super(parent, copyOf);
        assert (copyOf != null) : "Parameter 'copyOf' of method 'ProgrammingElementAggregatingNode' must not be null";
        assert (programmingElements != null) : "Parameter 'programmingElements' of method 'ProgrammingElementAggregatingNode' must not be null";
        this.m_programmingElements = programmingElements;
        this.m_emptyNodeProgrammingElement = new EmptyNodeProgrammingElement(this);
        this.addProgrammingElement(this.m_emptyNodeProgrammingElement);
    }

    @Override
    public final EmptyNodeProgrammingElement getEmptyNodeProgrammingElement() {
        return this.m_emptyNodeProgrammingElement;
    }

    @Override
    public void finishModification() {
        this.m_emptyNodeProgrammingElement.setShortName(this.getRelativePath());
        super.finishModification();
    }

    @Override
    public final Collection<ProgrammingElement> getProgrammingElements() {
        return Collections.unmodifiableCollection(this.m_programmingElements);
    }

    protected final Collection<ProgrammingElement> getProgrammingElementsCollection() {
        return this.m_programmingElements;
    }

    @Override
    public final int getNumberOfProgrammingElements() {
        return this.getRelevantProgrammingElements().parallelStream().mapToInt(p -> p instanceof EmptyNodeProgrammingElement ? 0 : 1).sum();
    }

    public final void addProgrammingElement(ProgrammingElement element) {
        assert (element != null) : "Parameter 'element' of method 'addProgrammingElement' must not be null";
        this.m_programmingElements.add(element);
    }

    public final void addProgrammingElements(Collection<ProgrammingElement> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'addProgrammingElements' must not be null";
        this.m_programmingElements.addAll(elements);
    }

    public final void removeProgrammingElement(ProgrammingElement element) {
        assert (element != null) : "Parameter 'element' of method 'removeProgrammingElement' must not be null";
        this.m_programmingElements.remove(element);
    }

    public final void removeProgrammingElements(Collection<ProgrammingElement> elements) {
        assert (elements != null) : "Parameter 'elements' of method 'removeProgrammingElements' must not be null";
        this.m_programmingElements.removeAll(elements);
    }

    @Override
    public String getDebugInfo() {
        int i;
        StringBuilder builder = new StringBuilder(super.getDebugInfo());
        builder.append("\n").append(this.m_emptyNodeProgrammingElement.getClass().getSimpleName()).append(": ").append(this.m_emptyNodeProgrammingElement.getShortName()).append(" [").append(Integer.toHexString(this.m_emptyNodeProgrammingElement.hashCode())).append("]");
        builder.append("\nProgramming elements: " + this.m_programmingElements.size());
        Collection<ProgrammingElement> relevantProgrammingElements = this.getRelevantProgrammingElements();
        builder.append("\nRelevant programming elements: " + relevantProgrammingElements.size());
        if (!this.m_programmingElements.isEmpty()) {
            builder.append("\nProgramming elements (").append(this.m_programmingElements.size()).append("):");
            i = 1;
            for (ProgrammingElement next : this.m_programmingElements) {
                builder.append("\n[").append(i).append("] ").append(next.getName()).append(" (").append(next.getClass().getSimpleName()).append(")").append(" [").append(Integer.toHexString(next.hashCode())).append("]");
                ++i;
            }
        }
        if (!relevantProgrammingElements.isEmpty()) {
            builder.append("\nRelevant programming elements (").append(relevantProgrammingElements.size()).append("):");
            i = 1;
            for (ProgrammingElement next : relevantProgrammingElements) {
                builder.append("\n[").append(i).append("] ").append(next.getName()).append(" (").append(next.getClass().getSimpleName()).append(")").append(" [").append(Integer.toHexString(next.hashCode())).append("]");
                ++i;
            }
        }
        return builder.toString();
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitProgrammingElementAggregatingNode(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitProgrammingElementAggregatingNode(ProgrammingElementAggregatingNode var1);
    }
}

