/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.model.element.ImageDecoratorInfo;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.RefactoringState;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactIncomingDependencyMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactOutgoingDependencyMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactVisibility;
import java.util.EnumSet;

public final class ImageSupport {
    private ImageSupport() {
    }

    private static String getPartialMarker(boolean hasPartialElements, boolean hasPartialDependencies) {
        if (hasPartialElements && hasPartialDependencies) {
            return "PartialElementsAndDependencies";
        }
        if (hasPartialElements) {
            return "PartialElements";
        }
        if (hasPartialDependencies) {
            return "PartialDependencies";
        }
        return null;
    }

    private static Boolean getRefactoringInfoOfUnderlyingElements(ArchitecturalViewElement element) {
        assert (element != null) : "Parameter 'element' of method 'getRefactoringInfoOfUnderlyingElements' must not be null";
        boolean hasBeenRefactored = false;
        boolean hasBeenDirectlyRefactored = false;
        for (NamedElement next : element.getUnderlyingElements()) {
            if (next.getRefactoringState() != RefactoringState.REFACTORED) continue;
            hasBeenRefactored = true;
            if (!element.hasBeenDirectlyRefactored()) continue;
            hasBeenDirectlyRefactored = true;
        }
        if (hasBeenRefactored) {
            return hasBeenDirectlyRefactored ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    private static boolean hasUnderlyingUnresolvedErrorIssues(ArchitecturalViewElement element) {
        assert (element != null) : "Parameter 'element' of method 'isRefactored' must not be null";
        for (NamedElement next : element.getUnderlyingElements()) {
            if (!next.hasUnresolvedErrorIssues()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasUnderlyingUnresolvedWarningIssues(ArchitecturalViewElement element) {
        assert (element != null) : "Parameter 'element' of method 'isRefactored' must not be null";
        for (NamedElement next : element.getUnderlyingElements()) {
            if (!next.hasUnresolvedWarningIssues()) continue;
            return true;
        }
        return false;
    }

    private static boolean allUnderlyingElementsIgnoreIssues(ArchitecturalViewElement element) {
        assert (element != null) : "Parameter 'element' of method 'isRefactored' must not be null";
        for (NamedElement next : element.getUnderlyingElements()) {
            if (next.ignoreIssues()) continue;
            return false;
        }
        return true;
    }

    static ImageDecoratorInfo getImageResourceDecoratorInfo(ArchitecturalViewElement element, boolean isReadOnly) {
        assert (element != null) : "Parameter 'element' of method 'getImageResourceDecoratorInfo' must not be null";
        String one = null;
        String two = null;
        String three = null;
        String four = null;
        String partialMarker = ImageSupport.getPartialMarker(element.hasPartialElements(), element.hasPartialDependencies());
        if (isReadOnly) {
            Boolean hasBeenRefactored = ImageSupport.getRefactoringInfoOfUnderlyingElements(element);
            if (element.hasViolation() || ImageSupport.hasUnderlyingUnresolvedErrorIssues(element)) {
                one = "HasViolation";
            } else if (ImageSupport.hasUnderlyingUnresolvedWarningIssues(element)) {
                one = "WarningMarker";
            }
            if (element.isExternal()) {
                two = "ExternalMarker";
            }
            if (element.isHidden()) {
                three = "HiddenMarker";
            } else if (ImageSupport.allUnderlyingElementsIgnoreIssues(element)) {
                three = "IgnoreIssuesMarker";
            }
            if (hasBeenRefactored != null) {
                four = hasBeenRefactored.booleanValue() ? "RefactoredMarker" : "IndirectlyRefactoredMarker";
            }
        } else {
            if (element.hasViolation()) {
                one = "HasViolation";
            }
            if (element.isCreated()) {
                two = "CreatedMarker";
            } else if (element.isExternal()) {
                two = "ExternalMarker";
            }
            if (element.isHidden()) {
                three = "HiddenMarker";
            }
            if (element.isRefactored()) {
                four = "RefactoredMarker";
            }
        }
        if (one != null || two != null || three != null || four != null || partialMarker != null) {
            return new ImageDecoratorInfo(one, two, three, four, partialMarker);
        }
        return null;
    }

    public static String getImageResourceName(ArtifactOutgoingDependencyMode outgoingDependencyMode) {
        assert (outgoingDependencyMode != null) : "Parameter 'outgoingDependencyMode' of method 'getImageResourceName' must not be null";
        switch (outgoingDependencyMode) {
            case RELAXED: {
                return "ArtifactRelaxed";
            }
            case STRICT: {
                return "ArtifactStrict";
            }
            case UNRESTRICTED: {
                return "ArtifactUnrestricted";
            }
            case RESTRICTED: {
                return "Artifact";
            }
        }
        assert (false) : "Unhandled type: " + String.valueOf(outgoingDependencyMode);
        return "Artifact";
    }

    public static ImageDecoratorInfo getImageResourceDecoratorInfo(ArtifactIncomingDependencyMode incomingDependencyMode, EnumSet<ArtifactVisibility> visibility, Marker marker, boolean isPartialByFocus, boolean isPartialByFocusDependencies) {
        assert (incomingDependencyMode != null) : "Parameter 'incomingDependencyMode' of method 'getImageResourceDecoratorInfo' must not be null";
        assert (visibility != null) : "Parameter 'visibility' of method 'getImageResourceDecoratorInfo' must not be null";
        assert (marker != null) : "Parameter 'marker' of method 'getImageResourceDecoratorInfo' must not be null";
        boolean isHidden = visibility.contains(ArtifactVisibility.HIDDEN);
        boolean isLocal = visibility.contains(ArtifactVisibility.LOCAL);
        if (!Marker.NONE.equals((Object)marker) || incomingDependencyMode.equals(ArtifactIncomingDependencyMode.PUBLIC) || isHidden || isLocal || isPartialByFocus) {
            return new ImageDecoratorInfo(switch (marker) {
                case Marker.HAS_VIOLATION -> "HasViolation";
                case Marker.HAS_WARNING -> "WarningMarker";
                case Marker.NONE -> null;
                default -> {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)("Unhandled marker: " + String.valueOf((Object)marker)));
                    }
                    yield null;
                }
            }, incomingDependencyMode.equals(ArtifactIncomingDependencyMode.PUBLIC) ? "PublicMarker" : null, isHidden ? "HiddenMarker" : null, isLocal ? "LocalMarker" : null, ImageSupport.getPartialMarker(isPartialByFocus, isPartialByFocusDependencies));
        }
        return null;
    }

    public static enum Marker {
        HAS_WARNING,
        HAS_VIOLATION,
        NONE;

    }
}

