/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DeleteArchitecturalViewFileInfo {
    private final List<ArchitecturalViewFile> m_files;
    private final List<ArchitecturalViewFile> m_dependingFiles = new ArrayList<ArchitecturalViewFile>(2);

    public DeleteArchitecturalViewFileInfo(List<ArchitecturalViewFile> files) {
        assert (files != null && !files.isEmpty()) : "Parameter 'files' of method 'DeleteArchitecturalViewFileInfo' must not be empty";
        this.m_files = new ArrayList<ArchitecturalViewFile>(files);
    }

    public void addDependingFiles(List<ArchitecturalViewFile> depending) {
        assert (depending != null) : "Parameter 'depending' of method 'addDependingFiles' must not be null";
        this.m_dependingFiles.addAll(depending);
    }

    public List<ArchitecturalViewFile> getFiles() {
        return Collections.unmodifiableList(this.m_files);
    }

    public List<ArchitecturalViewFile> getDependingFiles() {
        return Collections.unmodifiableList(this.m_dependingFiles);
    }

    public int getNumberOfAllFiles() {
        return this.m_files.size() + this.m_dependingFiles.size();
    }

    public int getNumberOfFiles() {
        return this.m_files.size();
    }

    public int getNumberOfDependingFiles() {
        return this.m_dependingFiles.size();
    }

    public List<ArchitecturalViewFile> getAllFiles() {
        ArrayList<ArchitecturalViewFile> all = new ArrayList<ArchitecturalViewFile>(this.m_files);
        all.addAll(this.m_dependingFiles);
        return Collections.unmodifiableList(all);
    }
}

