/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.architecture;

import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureBaseElement;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureElement;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureElementContainer;
import com.hello2morrow.sonargraph.core.model.architecture.IArtifact;
import com.hello2morrow.sonargraph.core.model.architecture.IAssignableFilter;
import com.hello2morrow.sonargraph.core.model.architecture.IClearableArchitectureElement;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ShortNameFilter;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.propertyreader.IntProperty;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public abstract class ArchitectureElement
extends ArchitectureBaseElement
implements IArchitectureElement {
    private List<IAssignableFilter> m_includeFilters;
    private List<IAssignableFilter> m_inheritedStrongFilters;
    private List<IAssignableFilter> m_excludeFilters;
    private String m_name;
    private FilePath m_definingFile;
    private int m_lineNumber;
    private int m_referencedFromLineNumber = -1;

    protected ArchitectureElement(NamedElement parent, String name, FilePath definingFile, int line) {
        super(parent);
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'ArchitectureElement' must not be empty";
        this.m_name = name;
        this.m_definingFile = definingFile;
        this.m_lineNumber = line;
        this.m_includeFilters = new ArrayList<IAssignableFilter>(5);
        this.m_excludeFilters = new ArrayList<IAssignableFilter>(5);
        this.m_inheritedStrongFilters = new ArrayList<IAssignableFilter>(5);
    }

    protected ArchitectureElement(NamedElement parent, ArchitectureElement other) {
        super(parent);
        this.m_name = other.m_name;
        this.m_definingFile = other.m_definingFile;
        this.m_lineNumber = other.m_lineNumber;
        this.m_includeFilters = other.m_includeFilters;
        this.m_excludeFilters = other.m_excludeFilters;
        this.m_inheritedStrongFilters = other.m_inheritedStrongFilters;
        this.m_referencedFromLineNumber = other.m_referencedFromLineNumber;
    }

    public List<IAssignableFilter> getIncludeFilters() {
        return Collections.unmodifiableList(this.m_includeFilters);
    }

    public boolean hasIncludeFilters() {
        return this.m_includeFilters.size() > 0;
    }

    public boolean hasStrongIncludes() {
        if (this.m_includeFilters.stream().anyMatch(f -> f.isStrong())) {
            return true;
        }
        return this.m_inheritedStrongFilters.size() > 0;
    }

    public List<IAssignableFilter> getExcludeFilters() {
        return Collections.unmodifiableList(this.m_excludeFilters);
    }

    public void setName(String extractedName) {
        this.m_name = extractedName;
    }

    public boolean acceptsPatterns() {
        return true;
    }

    public String getLocalName() {
        ArrayDeque<String> stack = new ArrayDeque<String>();
        FilePath myFile = this.m_definingFile;
        ArchitectureElement element = this;
        do {
            stack.push(element.m_name);
            NamedElement parent = element.getParent();
            if (parent instanceof ArchitectureElement) {
                element = (ArchitectureElement)parent;
                if (element.m_definingFile == myFile) continue;
                element = null;
                continue;
            }
            element = null;
        } while (element != null);
        StringBuilder sb = new StringBuilder();
        while (!stack.isEmpty()) {
            String namePart = (String)stack.pop();
            if (sb.length() > 0) {
                sb.append('.');
            }
            sb.append(namePart);
        }
        return sb.toString();
    }

    public int getContextLineNumber() {
        return this.m_referencedFromLineNumber == -1 ? this.m_lineNumber : this.m_referencedFromLineNumber;
    }

    @IntProperty
    public final int getReferencedFromLineNumber() {
        return this.m_referencedFromLineNumber;
    }

    public void setReferencedFromLineNumber(int referencedFromLineNumber) {
        this.m_referencedFromLineNumber = referencedFromLineNumber;
        this.getChildren(ArchitectureElement.class).forEach(c -> c.setReferencedFromLineNumber(referencedFromLineNumber));
    }

    protected void prepareForExtend(FilePath definingFile, int line) {
        super.clear();
        this.m_definingFile = definingFile;
        this.m_lineNumber = line;
        this.m_includeFilters = new ArrayList<IAssignableFilter>(this.m_includeFilters);
        this.m_excludeFilters = new ArrayList<IAssignableFilter>(this.m_excludeFilters);
        this.m_inheritedStrongFilters = new ArrayList<IAssignableFilter>(this.m_inheritedStrongFilters);
    }

    @Override
    public final String getShortName() {
        return this.m_name;
    }

    @Override
    public final String getName() {
        if (this.getParent() instanceof ArchitectureElement) {
            return String.format("%s.%s", this.getParent().getName(), this.m_name);
        }
        return this.m_name;
    }

    public abstract boolean isOptional();

    public boolean isDeprecated() {
        return false;
    }

    public boolean isAutoDefined() {
        return false;
    }

    public List<IAssignableFilter> getNonMatchingFilters() {
        if (!(this.isDeprecated() || this.isOptional() || this.isEmpty())) {
            ArrayList<IAssignableFilter> result = new ArrayList<IAssignableFilter>();
            this.m_includeFilters.stream().filter(f -> f.getMatchingCount() == 0).forEach(f -> {
                boolean bl = result.add((IAssignableFilter)f);
            });
            this.m_excludeFilters.stream().filter(f -> f.getMatchingCount() == 0).forEach(f -> {
                boolean bl = result.add((IAssignableFilter)f);
            });
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isEmpty() {
        if (!super.isEmpty()) {
            return false;
        }
        for (ArchitectureElement child : this.getChildren(ArchitectureElement.class)) {
            if (child.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public FilePath getDefiningFile() {
        return this.m_definingFile;
    }

    @Override
    public int getLineNumber() {
        return this.m_lineNumber;
    }

    protected final MatchCategory matches(IAssignableToArtifact assignable, boolean skipInheritedPatterns) {
        assert (assignable != null) : "Parameter 'assignable' of method 'matches' must not be null";
        if (!skipInheritedPatterns) {
            for (IAssignableFilter filter : this.m_inheritedStrongFilters) {
                if (!filter.matches((IWorkerContext)DefaultWorkerContext.INSTANCE, assignable)) continue;
                return MatchCategory.STRONG_INHERITED;
            }
        }
        MatchCategory result = MatchCategory.NONE;
        for (IAssignableFilter filter : this.m_includeFilters) {
            if (!filter.matches((IWorkerContext)DefaultWorkerContext.INSTANCE, assignable)) continue;
            result = filter.isStrong() ? MatchCategory.STRONG : MatchCategory.WEAK;
            break;
        }
        if (result != MatchCategory.NONE && this.isExcluded(assignable)) {
            result = MatchCategory.NONE;
        }
        return result;
    }

    protected boolean isExcluded(IAssignableToArtifact assignable) {
        for (IAssignableFilter filter : this.m_excludeFilters) {
            if (!filter.matches((IWorkerContext)DefaultWorkerContext.INSTANCE, assignable)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.m_includeFilters.forEach(f -> f.reset());
        this.m_excludeFilters.forEach(f -> f.reset());
        this.m_inheritedStrongFilters.forEach(f -> f.reset());
        this.getChildren(IClearableArchitectureElement.class).forEach(c -> c.clear());
        super.clear();
    }

    protected final void addInheritedStrongIncludeFilter(IAssignableFilter filter) {
        assert (filter != null) : "Parameter 'filter' of method 'addInheritedStrongIncludeFilter' must not be null";
        assert (filter.isStrong()) : "Only can add strong filters in 'addInheritedStrongIncludeFilter'";
        this.m_inheritedStrongFilters.add(filter);
        ArchitectureElement parent = this.getParent(ArchitectureElement.class, new Class[0]);
        if (parent != null) {
            parent.addInheritedStrongIncludeFilter(filter);
        }
    }

    public final void addIncludeFilter(IAssignableFilter filter) {
        ArchitectureElement parent;
        assert (filter != null) : "Parameter 'filter' of method 'addIncludeFilter' must not be null";
        this.m_includeFilters.add(filter);
        if (filter.isStrong() && (parent = this.getParent(ArchitectureElement.class, new Class[0])) != null) {
            parent.addInheritedStrongIncludeFilter(filter.clone());
        }
    }

    protected final List<IAssignableFilter> getStrongIncludeFilters() {
        return this.m_includeFilters.stream().filter(f -> f.isStrong()).collect(Collectors.toList());
    }

    public final void addExcludeFilter(IAssignableFilter filter) {
        assert (filter != null) : "Parameter 'filter' of method 'addIncludeFilter' must not be null";
        this.m_excludeFilters.add(filter);
    }

    public final <T> T resolveName(String name, Class<T> clazz) {
        IArchitectureElementContainer parent;
        T parentResult;
        T result = this.getFirstChild(new ShortNameFilter(name), clazz);
        if ((result == null || result instanceof IArtifact && ((IArtifact)result).isRequired()) && (parentResult = (parent = (IArchitectureElementContainer)((Object)this.getParent())).resolveName(name, clazz)) != null) {
            result = parentResult;
        }
        return result;
    }

    protected void override(FilePath definingFile, int line) {
        this.prepareForExtend(definingFile, line);
        this.m_includeFilters = new ArrayList<IAssignableFilter>(5);
        this.m_excludeFilters = new ArrayList<IAssignableFilter>(5);
    }

    @Override
    public boolean ignoreInModelRepresentation() {
        return false;
    }

    @Property
    public final String getDefinitionInfo() {
        FilePath file = this.getDefiningFile();
        if (file != null) {
            int line = this.getLineNumber();
            return file.getIdentifyingPath() + (String)(line == -1 ? "" : " in line " + line);
        }
        return "";
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        assert (visitor != null) : "Parameter 'visitor' of method 'accept' must not be null";
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitArchitectureElement(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitArchitectureElement(ArchitectureElement var1);
    }

    public static enum MatchCategory {
        NONE,
        WEAK,
        STRONG,
        STRONG_INHERITED;

    }
}

