/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.duplicatecode;

import com.hello2morrow.sonargraph.core.foundation.common.duplicatecode.LocationWithLogicalLineNumber;

final class CheckResult {
    private final int m_matchingPositions;
    private final int m_tolerance;
    private final LocationWithLogicalLineNumber m_from1;
    private final LocationWithLogicalLineNumber m_to1;
    private final LocationWithLogicalLineNumber m_from2;
    private final LocationWithLogicalLineNumber m_to2;

    public CheckResult(int matchingPositions, int tolerance, LocationWithLogicalLineNumber from1, LocationWithLogicalLineNumber to1, LocationWithLogicalLineNumber from2, LocationWithLogicalLineNumber to2) {
        this.m_matchingPositions = matchingPositions;
        this.m_tolerance = tolerance;
        this.m_from1 = from1;
        this.m_to1 = to1;
        this.m_from2 = from2;
        this.m_to2 = to2;
    }

    boolean encompasses(CheckResult otherResult) {
        if (this.m_from1.getFileContent() != otherResult.m_from1.getFileContent()) {
            return false;
        }
        if (this.m_from1.getFileContent() != otherResult.m_from1.getFileContent()) {
            return false;
        }
        if (this.m_from1.getLogicalLineNumber() > otherResult.m_from1.getLogicalLineNumber()) {
            return false;
        }
        if (otherResult.m_from1.getLogicalLineNumber() <= this.m_to1.getLogicalLineNumber() && otherResult.m_from2.getLogicalLineNumber() <= this.m_to2.getLogicalLineNumber() && otherResult.m_from1.getLogicalLineNumber() - this.m_from1.getLogicalLineNumber() == otherResult.m_from2.getLogicalLineNumber() - this.m_from2.getLogicalLineNumber()) {
            return true;
        }
        if (this.m_from2.getLogicalLineNumber() > otherResult.m_from2.getLogicalLineNumber()) {
            return false;
        }
        if (this.m_to1.getLogicalLineNumber() < otherResult.m_to1.getLogicalLineNumber()) {
            return false;
        }
        return this.m_to2.getLogicalLineNumber() >= otherResult.m_to2.getLogicalLineNumber();
    }

    int getMatchingPositions() {
        return this.m_matchingPositions;
    }

    int getTolerance() {
        return this.m_tolerance;
    }

    LocationWithLogicalLineNumber getFrom1() {
        return this.m_from1;
    }

    LocationWithLogicalLineNumber getTo1() {
        return this.m_to1;
    }

    LocationWithLogicalLineNumber getFrom2() {
        return this.m_from2;
    }

    LocationWithLogicalLineNumber getTo2() {
        return this.m_to2;
    }
}

