/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.base;

import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import de.schlichtherle.truezip.file.TFile;

public class StandardFilePathValidator
implements IPathValidator {
    private final IFileType m_fileType;
    private final boolean m_checkReadPermission;
    private final boolean m_canBeEmpty;

    public StandardFilePathValidator(IFileType fileType) {
        this(fileType, true, false);
    }

    public StandardFilePathValidator(IFileType fileType, boolean checkReadPermission) {
        this(fileType, checkReadPermission, false);
    }

    public StandardFilePathValidator(IFileType fileType, boolean checkReadPermission, boolean canBeEmpty) {
        assert (fileType != null) : "Parameter 'fileType' of method 'StandardFilePathValidator' must not be null";
        this.m_fileType = fileType;
        this.m_checkReadPermission = checkReadPermission;
        this.m_canBeEmpty = canBeEmpty;
    }

    @Override
    public IPathValidator.PathType getType() {
        return IPathValidator.PathType.FILE;
    }

    protected IFileType getFileType() {
        return this.m_fileType;
    }

    protected boolean exists(TFile file) {
        assert (file != null) : "Parameter 'file' of method 'exists' must not be null";
        return file.exists();
    }

    protected boolean canRead(TFile file) {
        assert (file != null) : "Parameter 'file' of method 'canRead' must not be null";
        return file.canRead();
    }

    @Override
    public ValidationResult isValid(TFile currentInput, TFile newInput) {
        ValidationResult result = new ValidationResult(!FileUtility.areEqual((TFile)currentInput, (TFile)newInput));
        if (!this.m_canBeEmpty && (newInput == null || newInput.getPath().isEmpty())) {
            result.addError("Path must not be empty");
        } else if (this.m_checkReadPermission && newInput != null && !this.exists(newInput)) {
            result.addError("File does not exist");
        } else if (this.m_checkReadPermission && newInput != null && !this.canRead(newInput)) {
            result.addError("Invalid path: No read permission");
        } else if (newInput != null && !this.m_fileType.hasExtension(FileUtility.getExtension((TFile)newInput))) {
            result.addError("File is not a " + this.m_fileType.getPresentationName());
        }
        return result;
    }
}

