/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.base;

import com.hello2morrow.sonargraph.core.foundation.common.base.IFile;
import com.hello2morrow.sonargraph.core.foundation.common.base.RelevantSourceFile;
import com.hello2morrow.sonargraph.core.foundation.common.base.RelevantSourceLine;
import com.hello2morrow.sonargraph.foundation.file.SmartReader;
import com.hello2morrow.sonargraph.foundation.file.TrueZipFacade;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StreamTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RelevantSourceLinesScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelevantSourceLinesScanner.class);
    private final ScannerInfo m_scannerInfo;
    private static final char SEMICOLON = ';';
    private static final String SHEBANG_COMMENT = "#!";

    public RelevantSourceLinesScanner(ScannerInfo scannerInfo) {
        assert (scannerInfo != null) : "Parameter 'scannerInfo' of method 'RelevantSourceLinesScanner' must not be null";
        this.m_scannerInfo = scannerInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RelevantSourceFile read(IFile handle, TFile file) {
        assert (handle != null) : "Parameter 'handle' of method 'read' must not be null";
        assert (file != null) : "Parameter 'file' of method 'read' must not be null";
        RelevantSourceFile relevantSourceFile = new RelevantSourceFile(handle);
        try {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try {
                    BufferedInputStream inputStream = new BufferedInputStream((InputStream)new TFileInputStream((File)file));
                    try {
                        try (SmartReader smartReader = new SmartReader((InputStream)inputStream);){
                            StreamTokenizer tokenizer = new StreamTokenizer((Reader)smartReader);
                            tokenizer.resetSyntax();
                            tokenizer.eolIsSignificant(true);
                            tokenizer.slashSlashComments(false);
                            tokenizer.slashStarComments(false);
                            tokenizer.quoteChar(34);
                            tokenizer.quoteChar(39);
                            tokenizer.whitespaceChars(0, 32);
                            tokenizer.wordChars(97, 122);
                            tokenizer.wordChars(65, 90);
                            tokenizer.wordChars(95, 95);
                            tokenizer.wordChars(47, 47);
                            tokenizer.wordChars(42, 42);
                            tokenizer.wordChars(35, 35);
                            tokenizer.wordChars(33, 33);
                            TokenReaderContext tokenReaderContext = new TokenReaderContext();
                            do {
                                RelevantSourceLine nextLine;
                                if ((nextLine = this.readNextLine(tokenReaderContext, tokenizer)) == null) continue;
                                relevantSourceFile.add(nextLine);
                            } while (tokenReaderContext.moreAvailable());
                        }
                        if (inputStream == null) return relevantSourceFile;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (inputStream == null) throw throwable;
                        ((InputStream)inputStream).close();
                        throw throwable;
                    }
                    ((InputStream)inputStream).close();
                    return relevantSourceFile;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    } else {
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to process: " + file.getAbsolutePath(), (Throwable)e);
                TrueZipFacade.clear((TFile)file);
            }
            return relevantSourceFile;
        }
        finally {
            TrueZipFacade.clear((TFile)file);
        }
    }

    private int getStartPosition(int pos1, int pos2) {
        if (pos1 == -1 && pos2 == -1) {
            return -1;
        }
        if (pos1 != -1 && pos2 == -1) {
            return pos1;
        }
        if (pos1 == -1 && pos2 != -1) {
            return pos2;
        }
        return pos1 <= pos2 ? pos1 : pos2;
    }

    private boolean isImportStartToken(String token, String[] importStartTokens) {
        assert (token != null) : "Parameter 'token' of method 'isImportStartToken' must not be null";
        assert (importStartTokens != null) : "Parameter 'importStartTokens' of method 'isImportStartToken' must not be null";
        String[] stringArray = importStartTokens;
        int n = importStartTokens.length;
        int n2 = 0;
        while (n2 < n) {
            String next = stringArray[n2];
            if (token.equals(next)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private RelevantSourceLine readNextLine(TokenReaderContext tokenReaderContext, StreamTokenizer tokenizer) {
        assert (tokenReaderContext != null) : "Parameter 'tokenReaderContext' of method 'readNextTokens' must not be null";
        assert (tokenizer != null) : "Parameter 'tokenizer' of method 'readNextLine' must not be null";
        StringBuilder lineBuffer = new StringBuilder();
        boolean lineCompleted = false;
        boolean ignoreRestInLine = false;
        boolean wentThroughLineBreak = false;
        int tokenSeparatorCount = 0;
        do {
            try {
                int tokenType = tokenizer.nextToken();
                Object nextToken = "";
                switch (tokenType) {
                    case -1: {
                        lineCompleted = true;
                        tokenReaderContext.setMoreAvailable(false);
                        break;
                    }
                    case 10: {
                        lineCompleted = true;
                        wentThroughLineBreak = true;
                        tokenReaderContext.setMoreAvailable(true);
                        break;
                    }
                    case -2: {
                        if (tokenReaderContext.ignoreUntilNextSemicolon() || ignoreRestInLine) break;
                        nextToken = "" + tokenizer.nval;
                        break;
                    }
                    case -3: {
                        if (tokenReaderContext.ignoreUntilNextSemicolon()) break;
                        String nextWord = tokenizer.sval;
                        if (this.isImportStartToken(nextWord, this.m_scannerInfo.m_importStartTokens)) {
                            if (!this.m_scannerInfo.isSemicolonAware()) break;
                            tokenReaderContext.setIgnoreUntilNextSemicolon(true);
                            break;
                        }
                        if (tokenReaderContext.inMultiLineComment()) {
                            int pos = nextWord.indexOf(this.m_scannerInfo.getMultiLineCommentEnd());
                            if (pos != -1) {
                                nextToken = nextWord.substring(pos + this.m_scannerInfo.getMultiLineCommentEnd().length());
                                tokenReaderContext.setInMultiLineComment(false);
                                ignoreRestInLine = false;
                                break;
                            }
                            ignoreRestInLine = true;
                            break;
                        }
                        if (ignoreRestInLine) break;
                        int posSingleLineComment = nextWord.indexOf(this.m_scannerInfo.getSingleLineCommentStart());
                        int posShebangComment = nextWord.indexOf(SHEBANG_COMMENT);
                        int resultingPos = this.getStartPosition(posSingleLineComment, posShebangComment);
                        int posMultiLineCommentStart = nextWord.indexOf(this.m_scannerInfo.getMultiLineCommentStart());
                        if ((resultingPos = this.getStartPosition(resultingPos, posMultiLineCommentStart)) != -1) {
                            ignoreRestInLine = true;
                            if (posMultiLineCommentStart != resultingPos) break;
                            tokenReaderContext.setInMultiLineComment(true);
                            int posMultiLineCommentEnd = nextWord.lastIndexOf(this.m_scannerInfo.getMultiLineCommentEnd());
                            if (posMultiLineCommentEnd != -1) {
                                nextToken = nextWord.substring(resultingPos, posMultiLineCommentEnd + this.m_scannerInfo.getMultiLineCommentEnd().length());
                                tokenReaderContext.setInMultiLineComment(false);
                                ignoreRestInLine = false;
                                break;
                            }
                            nextToken = nextWord.substring(0, resultingPos);
                            break;
                        }
                        nextToken = nextWord;
                        break;
                    }
                    case 34: 
                    case 39: {
                        if (tokenReaderContext.ignoreUntilNextSemicolon() || ignoreRestInLine) break;
                        nextToken = (char)tokenType + tokenizer.sval + (char)tokenType;
                        break;
                    }
                    default: {
                        if (!tokenReaderContext.ignoreUntilNextSemicolon() && !ignoreRestInLine) {
                            nextToken = "" + (char)tokenType;
                        }
                        if (!tokenReaderContext.ignoreUntilNextSemicolon() || ';' != (char)tokenType) break;
                        tokenReaderContext.setIgnoreUntilNextSemicolon(false);
                    }
                }
                if (tokenReaderContext.inMultiLineComment() || ((String)nextToken).length() == 0) continue;
                if (lineBuffer.length() != 0) {
                    lineBuffer.append(" ");
                    ++tokenSeparatorCount;
                }
                lineBuffer.append((String)nextToken);
            }
            catch (IOException ex) {
                LOGGER.warn("Caught exception while reading token" + String.valueOf(ex));
                lineCompleted = true;
                ignoreRestInLine = false;
                tokenReaderContext.setMoreAvailable(false);
            }
        } while (!lineCompleted);
        if (lineBuffer.length() != 0) {
            return new RelevantSourceLine(lineBuffer.toString(), tokenizer.lineno() - (wentThroughLineBreak ? 1 : 0), lineBuffer.length() - tokenSeparatorCount);
        }
        return null;
    }

    public static final class ScannerInfo {
        private final String[] m_importStartTokens;
        private final boolean m_isSemicolonAware;
        private final String m_singleLineCommentStart;
        private final String m_multiLineCommentStart;
        private final String m_multiLineCommentEnd;

        public ScannerInfo(String[] importStartTokens) {
            this(importStartTokens, true, "//", "/*", "*/");
        }

        public ScannerInfo(String[] importStartTokens, boolean isSemicolonAware, String singleLineCommentStart, String multiLineCommentStart, String multiLineCommentEnd) {
            this.m_importStartTokens = importStartTokens;
            this.m_isSemicolonAware = isSemicolonAware;
            this.m_singleLineCommentStart = singleLineCommentStart;
            this.m_multiLineCommentStart = multiLineCommentStart;
            this.m_multiLineCommentEnd = multiLineCommentEnd;
        }

        public String[] getImportStartTokens() {
            return this.m_importStartTokens;
        }

        public boolean isSemicolonAware() {
            return this.m_isSemicolonAware;
        }

        public String getSingleLineCommentStart() {
            return this.m_singleLineCommentStart;
        }

        public String getMultiLineCommentStart() {
            return this.m_multiLineCommentStart;
        }

        public String getMultiLineCommentEnd() {
            return this.m_multiLineCommentEnd;
        }
    }

    static final class TokenReaderContext {
        private boolean m_moreAvailable = false;
        private boolean m_inMultiLineComment = false;
        private boolean m_ignoreUntilNextSemicolon = false;

        TokenReaderContext() {
        }

        boolean moreAvailable() {
            return this.m_moreAvailable;
        }

        void setMoreAvailable(boolean moreAvailable) {
            this.m_moreAvailable = moreAvailable;
        }

        boolean inMultiLineComment() {
            return this.m_inMultiLineComment;
        }

        void setInMultiLineComment(boolean inMutliLineComment) {
            this.m_inMultiLineComment = inMutliLineComment;
        }

        boolean ignoreUntilNextSemicolon() {
            return this.m_ignoreUntilNextSemicolon;
        }

        void setIgnoreUntilNextSemicolon(boolean ignore) {
            this.m_ignoreUntilNextSemicolon = ignore;
        }
    }
}

