/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.treemap;

import com.hello2morrow.sonargraph.core.controller.system.treemap.PositiveIntValueRange;

final class LeafNodeHeightCalculator {
    private static final int MIN_HEIGHT = 4;
    private static final int STEPS = 10;
    private static final int MAX_HEIGHT = 40;

    private LeafNodeHeightCalculator() {
    }

    static int calculate(PositiveIntValueRange range, int value) {
        assert (range != null) : "Parameter 'range' of method 'calculate' must not be null";
        assert (value >= 0) : "Invalid 'value':" + value;
        assert (value <= range.getUpperValue()) : "'value' out of range: " + value;
        int calculated = 0;
        if (value == range.getLowerValue()) {
            calculated = 4;
        } else if (value == range.getUpperValue()) {
            calculated = 40;
        } else {
            int numberOfSteps = range.getNumberOfSteps();
            assert (numberOfSteps > 2) : "Unexpected number of steps: " + numberOfSteps;
            double valuePerStep = 36.0 / (double)(numberOfSteps - 1);
            calculated = (int)Math.round((double)value * valuePerStep) + 4;
        }
        return calculated;
    }
}

