/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.base;

import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.controller.system.base.IModifiableFileProviderUndoRedo;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.path.DirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFileAccess;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFileDeltaKey;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileCandidate;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDelta;
import com.hello2morrow.sonargraph.core.model.path.ModifiableFileDeltaDetector;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFilesDirectory;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.OptionalExtension;
import com.hello2morrow.sonargraph.core.model.system.PrepareRefreshResult;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;

public abstract class ModifiableFileBasedProvider<D extends SoftwareSystemFilesDirectory, F extends ModifiableFile>
extends OptionalExtension
implements IModifiableFileDeltaKey,
IModifiableFileProviderUndoRedo<D, F> {
    private final Installation m_installation;
    private final SoftwareSystem m_softwareSystem;
    private final IFinishModelProcessor m_finishModelProcessor;

    protected ModifiableFileBasedProvider(Installation installation, SoftwareSystem softwareSystem, IFinishModelProcessor finishModelProcessor, boolean enabled) {
        super(enabled);
        assert (installation != null) : "Parameter 'installation' of method 'ArchitectureDiagramProvider' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'ArchitectureDiagramProvider' must not be null";
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'ArchitectureDiagramProvider' must not be null";
        this.m_installation = installation;
        this.m_softwareSystem = softwareSystem;
        this.m_finishModelProcessor = finishModelProcessor;
    }

    protected final Installation getInstallation() {
        return this.m_installation;
    }

    protected final SoftwareSystem getSoftwareSystem() {
        return this.m_softwareSystem;
    }

    protected final IFinishModelProcessor getFinishModelProcessor() {
        return this.m_finishModelProcessor;
    }

    @Override
    public final D getDirectory() {
        return this.m_softwareSystem.getUniqueExistingChild(Files.class).getSoftwareSystemFilesDirectory(this.getDirectoryClass());
    }

    public final List<F> getAvailableFiles() {
        List available = ((NamedElement)this.getDirectory()).getChildrenRecursively(this.getFileClass(), new Class[0]);
        Collections.sort(available, new Comparator<F>(){

            @Override
            public int compare(F f1, F f2) {
                if (!$assertionsDisabled && f1 == null) {
                    throw new AssertionError((Object)"Parameter 'f1' of method 'compare' must not be null");
                }
                if (!$assertionsDisabled && f2 == null) {
                    throw new AssertionError((Object)"Parameter 'f2' of method 'compare' must not be null");
                }
                return ((ModifiableFile)f1).getIdentifyingPath().compareTo(((ModifiableFile)f2).getIdentifyingPath());
            }
        });
        return available;
    }

    public final ITextValidator getNameValidator(F file) {
        return new ITextValidator((ModifiableFile)file){
            private final /* synthetic */ ModifiableFile val$file;
            {
                this.val$file = modifiableFile;
            }

            @Override
            public ValidationResult isValid(String currentInput, String newInput) {
                ValidationResult result = new ValidationResult(!StringUtility.areEqual((String)currentInput, (String)newInput));
                if (newInput != null) {
                    newInput = newInput.trim();
                }
                if (newInput == null || newInput.isEmpty()) {
                    result.addError("Must not be empty");
                } else {
                    String newName = "./" + newInput + ModifiableFileBasedProvider.this.getFileType().getDefaultExtension();
                    for (ModifiableFile next : ModifiableFileBasedProvider.this.getAvailableFiles()) {
                        if (this.val$file != null && this.val$file == next || !next.getName().equalsIgnoreCase(newName)) continue;
                        result.addError("'" + ModifiableFileBasedProvider.this.getFileType().getPresentationName() + "' file with name '" + newInput + "' already exists");
                        break;
                    }
                }
                return result;
            }
        };
    }

    public final void checkOutOfSync(OperationResult result) {
        IModifiableFileAccess fileAccess;
        assert (result != null) : "Parameter 'result' of method 'checkOutOfSync' must not be null";
        D directory = this.getDirectory();
        ((SoftwareSystemDirectoryPath)directory).enforceExistence(result);
        if (result.isSuccess() && ((SoftwareSystemFilesDirectory)directory).isOutOfSync(fileAccess = new IModifiableFileAccess(){

            @Override
            public List<IModifiableFile> getModifiableFiles(SoftwareSystemDirectoryPath directoryPath) {
                if (!$assertionsDisabled && directoryPath == null) {
                    throw new AssertionError((Object)"Parameter 'directoryPath' of method 'checkOutOfSync' must not be null");
                }
                return directoryPath.getChildrenRecursively(IModifiableFile.class, new Class[0]);
            }
        }, (String[][])new String[][]{this.getFileType().getExtensions()})) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_SYSTEM_OUT_OF_SYNC, "Consider to refresh the system", new Object[0]);
        }
    }

    @Override
    public final void prepareRefresh(ModifiableFileDeltaDetector deltaDetector, boolean onSystemOpen, PrepareRefreshResult result) {
        assert (deltaDetector != null) : "Parameter 'deltaDetector' of method 'prepareRefresh' must not be null";
        assert (result != null) : "Parameter 'result' of method 'prepareRefresh' must not be null";
        if (this.isEnabled()) {
            ((SoftwareSystemDirectoryPath)this.getDirectory()).checkExistence();
            deltaDetector.detect(new ModifiableFileDeltaDetector.SingleFileTypeProviderAdapter(this, (DirectoryPath)this.getDirectory(), this.getFileType(), this.getFileClass().getSimpleName(), false));
            if (!onSystemOpen) {
                deltaDetector.getDelta().visit(new ModifiableFileDelta.IVisitor(){

                    @Override
                    public IModifiableFileDeltaKey getKey() {
                        return ModifiableFileBasedProvider.this;
                    }
                }, false);
            }
        }
    }

    protected abstract void added(ModifiableFileCandidate var1, OperationResult var2);

    protected abstract void modified(F var1, OperationResult var2);

    protected abstract void deleted(F var1, OperationResult var2);

    @Override
    public final void refreshFiles(IWorkerContext workerContext, ModifiableFileDelta delta, EnumSet<Modification> modifications, final OperationResult result) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'refreshFiles' must not be null";
        assert (delta != null) : "Parameter 'delta' of method 'refreshFiles' must not be null";
        assert (result != null) : "Parameter 'result' of method 'refreshFiles' must not be null";
        if (this.isEnabled()) {
            boolean successSoFar = result.isSuccess();
            delta.visit(new ModifiableFileDelta.IVisitor(){

                @Override
                public IModifiableFileDeltaKey getKey() {
                    return ModifiableFileBasedProvider.this;
                }

                @Override
                public void visitAdded(ModifiableFileCandidate added) {
                    if (!$assertionsDisabled && added == null) {
                        throw new AssertionError((Object)"Parameter 'added' of method 'visitAdded' must not be null");
                    }
                    ModifiableFileBasedProvider.this.added(added, result);
                }

                @Override
                public void visitModified(IModifiableFile modified) {
                    if (!($assertionsDisabled || modified != null && ModifiableFileBasedProvider.this.getFileClass().isAssignableFrom(modified.getClass()))) {
                        throw new AssertionError((Object)("Unexpected class in method 'visitModified': " + String.valueOf(modified)));
                    }
                    ModifiableFileBasedProvider.this.modified((ModifiableFile)modified, result);
                    ((ModifiableFile)modified).reloaded(modified.getFile().lastModified(), false);
                }

                @Override
                public void visitDeleted(IModifiableFile deleted) {
                    if (!($assertionsDisabled || deleted != null && ModifiableFileBasedProvider.this.getFileClass().isAssignableFrom(deleted.getClass()))) {
                        throw new AssertionError((Object)("Unexpected class in method 'visitDeleted': " + String.valueOf(deleted)));
                    }
                    ModifiableFileBasedProvider.this.deleted((ModifiableFile)deleted, result);
                    ((ModifiableFile)deleted).remove();
                }
            }, true);
            if (successSoFar) {
                result.setIsSuccess(successSoFar);
            }
        }
    }
}

