/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.architecture;

import com.hello2morrow.sonargraph.core.controller.system.architecture.AssignableAttributeRetriever;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitecturalModelProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;

public final class WorkspaceFilterNameRetriever
extends AssignableAttributeRetriever<NamedElement> {
    private static final String NAME = "WorkspaceFilterName";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return NAME;
    }

    @Override
    public String getDescription(IArchitecturalModelProvider.ArchitectureModel architectureModel) {
        assert (architectureModel != null) : "Parameter 'architectureModel' of method 'getDescription' must not be null";
        return "Matches the pattern against the 'Workspace Filter Name' of " + "Component".toLowerCase() + "s" + (String)(switch (architectureModel) {
            case IArchitecturalModelProvider.ArchitectureModel.LOGICAL -> " containing the corresponding " + "Top-Level Programming Element".toLowerCase() + ".";
            case IArchitecturalModelProvider.ArchitectureModel.PHYSICAL -> ".";
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Unhandled model: " + String.valueOf((Object)architectureModel)));
                }
                yield ".";
            }
        }) + "\n\nThis can be useful to separate assignment by root directory (e.g. test code versus generated code), since root directories are not part of any architecture filter name.\n\nWildcards: ?=any character, *=any sequence between slashes, **=any sequence\n\n'Workspace Filter Name' composition: [module]/[root directory]/[directory*]/[component]\n\n'Workspace Filter Name' example: Client/src/main/java/com/application/userinterface/MainApplicationWindow\nNote: The directory is relative to the system base directoy (i.e. the directory containing the [system].sonargraph folder)Note: Only available for 'internal' elements.";
    }

    @Override
    protected String computeAttributeForComponent(IWorkerContext workerContext, IComponent assignable, String[] params) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'computeAttributeForComponent' must not be null";
        assert (assignable != null) : "Parameter 'assignable' of method 'computeAttributeForComponents' must not be null";
        if (assignable.isExternal()) {
            return null;
        }
        NamedElement element = assignable.getNamedElement();
        String datum = this.getDatum(element);
        if (datum == null) {
            datum = assignable.getWorkspaceFilterName();
            assert (datum != null && datum.length() > 0) : "'datum' of method 'computeAttributeForComponent' must not be empty: " + String.valueOf(assignable);
            this.setDatum(element, datum);
        }
        return this.createAttribute(datum);
    }

    @Override
    protected String computeAttributeForLogicalProgrammingElement(IWorkerContext workerContext, LogicalProgrammingElement assignable, String[] params) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'computeAttributeForLogicalProgrammingElement' must not be null";
        assert (assignable != null) : "Parameter 'assignable' of method 'computeAttributeForLogicalProgrammingElement' must not be null";
        if (assignable.isExternal()) {
            return null;
        }
        ProgrammingElement programmingElement = assignable.getPrimaryProgrammingElement();
        String datum = this.getDatum(programmingElement);
        if (datum == null) {
            IComponent component = programmingElement.getParent(IComponent.class, ParentMode.SELF_OR_FIRST_PARENT);
            assert (component != null) : "'component' of method 'computeAttributeForLogicalProgrammingElement' must not be null";
            datum = component.getWorkspaceFilterName();
            assert (datum != null && datum.length() > 0) : "'datum' of method 'computeAttributeForLogicalProgrammingElement' must not be empty";
            this.setDatum(programmingElement, datum);
        }
        return this.createAttribute(datum);
    }
}

