/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.architecture;

import com.hello2morrow.sonargraph.core.controller.system.architecture.AutoCompletion;
import com.hello2morrow.sonargraph.core.controller.system.architecture.AutoCompletionArchitectureFileReference;
import com.hello2morrow.sonargraph.core.controller.system.architecture.AutoCompletionArtifact;
import com.hello2morrow.sonargraph.core.model.architecture.Architecture;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AutoCompletionArtifactCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoCompletionArtifactCollector.class);
    private static final String ROOT_SCOPE = "#ROOT#";
    private final ArrayDeque<AutoCompletionArtifact> m_artifactStack = new ArrayDeque();
    private final Map<String, Set<String>> m_referencedIdentifyingPathToScope = new THashMap();

    private AutoCompletionArtifactCollector() {
    }

    private boolean includeReferencedArchitectureFile(String identifyingPath, AutoCompletionArtifact scope) {
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'includeReferencedArchitectureFile' must not be empty";
        THashSet scopes = this.m_referencedIdentifyingPathToScope.get(identifyingPath);
        if (scopes == null) {
            scopes = new THashSet();
            this.m_referencedIdentifyingPathToScope.put(identifyingPath, (Set<String>)scopes);
        }
        return scopes.add(scope == null ? ROOT_SCOPE : scope.getFullName());
    }

    private String getFullName(String artifactName) {
        assert (artifactName != null && artifactName.length() > 0) : "Parameter 'artifactName' of method 'getFullName' must not be empty";
        StringBuilder builder = new StringBuilder();
        if (!this.m_artifactStack.isEmpty()) {
            Iterator<AutoCompletionArtifact> iter = this.m_artifactStack.descendingIterator();
            while (iter.hasNext()) {
                AutoCompletionArtifact next = iter.next();
                builder.append(next.getName()).append('.');
            }
        }
        builder.append(artifactName);
        LOGGER.trace("Full name: " + builder.toString());
        return builder.toString();
    }

    /*
     * Unable to fully structure code
     */
    private int consumeStringToken(StringTokenizer tokenizer) {
        if (AutoCompletionArtifactCollector.$assertionsDisabled || tokenizer != null) ** GOTO lbl8
        throw new AssertionError((Object)"Parameter 'tokenizer' of method 'getNameToken' must not be null");
lbl-1000:
        // 1 sources

        {
            nextToken = tokenizer.nextToken();
            if (nextToken.equals("\n")) {
                return 1;
            }
            if (!nextToken.equals("\"")) continue;
            return 0;
lbl8:
            // 2 sources

            ** while (tokenizer.hasMoreTokens())
        }
lbl9:
        // 1 sources

        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private String getNameToken(StringTokenizer tokenizer) {
        if (AutoCompletionArtifactCollector.$assertionsDisabled || tokenizer != null) ** GOTO lbl8
        throw new AssertionError((Object)"Parameter 'tokenizer' of method 'getNameToken' must not be null");
lbl-1000:
        // 1 sources

        {
            nextToken = tokenizer.nextToken();
            if (nextToken.length() == 1 && ((c = nextToken.charAt(0)) == '{' || c == '}')) {
                return null;
            }
            if (AutoCompletion.isSeparator(nextToken) || AutoCompletion.getKeywords().contains(nextToken)) continue;
            return nextToken;
lbl8:
            // 2 sources

            ** while (tokenizer.hasMoreTokens())
        }
lbl9:
        // 1 sources

        return "";
    }

    private AutoCompletionArchitectureFileReference getArchitectureFileReference(StringTokenizer tokenizer, Architecture architecture) {
        assert (tokenizer != null) : "Parameter 'tokenizer' of method 'getArchitectureFileReference' must not be null";
        assert (architecture != null) : "Parameter 'architecture' of method 'getArchitectureFileReference' must not be null";
        int lines = 0;
        boolean started = false;
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            if (nextToken.equals("\n")) {
                ++lines;
                if (!started) continue;
                return null;
            }
            if (nextToken.equals("\t")) {
                if (!started) continue;
                return null;
            }
            if (nextToken.equals(" ")) {
                if (!started) continue;
                return null;
            }
            if (nextToken.equals("\"")) {
                if (!started) {
                    started = true;
                    continue;
                }
                return null;
            }
            if (!started) continue;
            if (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (token.equals("\"")) {
                    String content;
                    final String identifyingPath = "./" + (String)(nextToken.toLowerCase().endsWith(".arc") ? nextToken : nextToken + ".arc");
                    ArchitectureFile architectureFile = architecture.getFirstChild(new NamedElement.IFilter(){

                        @Override
                        public boolean accept(NamedElement namedElement) {
                            if (!($assertionsDisabled || namedElement != null && namedElement instanceof ArchitectureFile)) {
                                throw new AssertionError((Object)("Unexpected class in method 'accept': " + String.valueOf(namedElement)));
                            }
                            return ((ArchitectureFile)namedElement).getIdentifyingPath().equals(identifyingPath);
                        }
                    }, ArchitectureFile.class);
                    if (architectureFile != null && (content = architectureFile.getContent()) != null && !content.isEmpty()) {
                        return new AutoCompletionArchitectureFileReference(lines, identifyingPath, content);
                    }
                    return new AutoCompletionArchitectureFileReference(lines);
                }
                if (token.equals("\n")) {
                    ++lines;
                }
                return new AutoCompletionArchitectureFileReference(lines);
            }
            return new AutoCompletionArchitectureFileReference(lines);
        }
        return new AutoCompletionArchitectureFileReference(lines);
    }

    private int skip(StringTokenizer tokenizer) {
        assert (tokenizer != null) : "Parameter 'tokenizer' of method 'skip' must not be null";
        int lines = 0;
        int curlyBraces = -1;
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            if (nextToken.equals("{")) {
                if (curlyBraces == -1) {
                    curlyBraces = 0;
                }
                ++curlyBraces;
                continue;
            }
            if (nextToken.equals("}")) {
                if (curlyBraces == -1) {
                    return -1;
                }
                if (--curlyBraces != 0) continue;
                return lines;
            }
            if (!nextToken.equals("\n")) continue;
            ++lines;
        }
        return -1;
    }

    private int skipComment(StringTokenizer tokenizer) {
        assert (tokenizer != null) : "Parameter 'tokenizer' of method 'skipComment' must not be null";
        int lines = 0;
        Comment comment = null;
        boolean firstToken = true;
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            if (firstToken) {
                if (!nextToken.equals("/") && !nextToken.equals("*")) {
                    return -1;
                }
                firstToken = false;
            }
            if (nextToken.equals("/")) {
                if (comment == null) {
                    comment = Comment.SLASH_SLASH;
                    continue;
                }
                if (!Comment.SLASH_STAR_SECOND.equals((Object)comment)) continue;
                return lines;
            }
            if (nextToken.equals("*")) {
                if (comment == null) {
                    comment = Comment.SLASH_STAR_FIRST;
                    continue;
                }
                if (Comment.SLASH_STAR_FIRST.equals((Object)comment)) {
                    comment = Comment.SLASH_STAR_SECOND;
                    continue;
                }
                if (!Comment.SLASH_STAR_SECOND.equals((Object)comment)) continue;
                return -1;
            }
            if (nextToken.equals("\n")) {
                ++lines;
                if (!Comment.SLASH_SLASH.equals((Object)comment)) continue;
                return lines;
            }
            if (!Comment.SLASH_STAR_SECOND.equals((Object)comment)) continue;
            return -1;
        }
        return -1;
    }

    private void tokenize(String text, String identifyingPath, Architecture architecture, List<AutoCompletionArtifact> toplevelArtifacts, FinishArtifactAction action) {
        assert (text != null && text.length() > 0) : "Parameter 'text' of method 'tokenize' must not be empty";
        assert (identifyingPath != null && identifyingPath.length() > 0) : "Parameter 'identifyingPath' of method 'tokenize' must not be empty";
        assert (architecture != null) : "Parameter 'architecture' of method 'tokenize' must not be null";
        assert (toplevelArtifacts != null) : "Parameter 'toplevelArtifacts' of method 'tokenize' must not be null";
        int currentLine = 1;
        boolean isExposed = false;
        StringTokenizer tokenizer = new StringTokenizer(text, AutoCompletion.getSeparatorsAsString(), true);
        while (tokenizer.hasMoreTokens()) {
            AutoCompletionArtifact nextCurrentArtifactEntry;
            String content;
            String identifyingPathToApply;
            String nextToken = tokenizer.nextToken();
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Token '" + nextToken + "' [line=" + currentLine + "]");
            }
            if (nextToken.equals("\"")) {
                currentLine += this.consumeStringToken(tokenizer);
                continue;
            }
            if (nextToken.equals("template")) {
                int lines = this.skip(tokenizer);
                if (lines == -1) {
                    return;
                }
                currentLine += lines;
                continue;
            }
            if (nextToken.equals("connection-scheme")) {
                int lines = this.skip(tokenizer);
                if (lines == -1) {
                    return;
                }
                currentLine += lines;
                continue;
            }
            if (nextToken.equals("/")) {
                int lines = this.skipComment(tokenizer);
                if (lines == -1) {
                    return;
                }
                currentLine += lines;
                continue;
            }
            if (nextToken.equals("apply")) {
                AutoCompletionArchitectureFileReference info = this.getArchitectureFileReference(tokenizer, architecture);
                currentLine += info.getLines();
                identifyingPathToApply = info.getIdentifyingPath();
                content = info.getContent();
                if (identifyingPathToApply == null || identifyingPathToApply.isEmpty() || content == null || content.isEmpty()) continue;
                LOGGER.debug("[" + identifyingPath + "] 'apply' " + identifyingPathToApply + " [line=" + currentLine + "]");
                if (this.includeReferencedArchitectureFile(identifyingPathToApply, this.m_artifactStack.peek())) {
                    this.tokenize(content, identifyingPathToApply, architecture, toplevelArtifacts, null);
                    continue;
                }
                LOGGER.debug("Was already included");
                continue;
            }
            if (nextToken.equals("require")) {
                AutoCompletionArchitectureFileReference info = this.getArchitectureFileReference(tokenizer, architecture);
                currentLine += info.getLines();
                identifyingPathToApply = info.getIdentifyingPath();
                content = info.getContent();
                if (identifyingPathToApply == null || identifyingPathToApply.isEmpty() || content == null || content.isEmpty()) continue;
                LOGGER.debug("[" + identifyingPath + "] 'require' " + identifyingPathToApply + " [line=" + currentLine + "]");
                if (this.includeReferencedArchitectureFile(identifyingPathToApply, this.m_artifactStack.peek())) {
                    this.tokenize(content, identifyingPathToApply, architecture, toplevelArtifacts, null);
                    continue;
                }
                LOGGER.debug("Was already included");
                continue;
            }
            if (nextToken.equals("exposed")) {
                isExposed = true;
                continue;
            }
            if (nextToken.equals("artifact")) {
                String nextNameToken = this.getNameToken(tokenizer);
                if (nextNameToken == null) {
                    return;
                }
                if (nextNameToken.isEmpty()) continue;
                AutoCompletionArtifact nextArtifactEntry = new AutoCompletionArtifact(identifyingPath, this.getFullName(nextNameToken), nextNameToken, currentLine, isExposed);
                isExposed = false;
                AutoCompletionArtifact nextParentArtifact = this.m_artifactStack.peek();
                if (nextParentArtifact == null) {
                    toplevelArtifacts.add(nextArtifactEntry);
                } else {
                    nextParentArtifact.addArtifact(nextArtifactEntry);
                }
                this.m_artifactStack.push(nextArtifactEntry);
                continue;
            }
            if (nextToken.equals("interface")) {
                String nextNameToken = this.getNameToken(tokenizer);
                if (nextNameToken == null) {
                    return;
                }
                if (nextNameToken.isEmpty() || (nextCurrentArtifactEntry = this.m_artifactStack.peek()) == null) continue;
                nextCurrentArtifactEntry.addInterface(nextNameToken);
                continue;
            }
            if (nextToken.equals("connector")) {
                String nextNameToken = this.getNameToken(tokenizer);
                if (nextNameToken == null) {
                    return;
                }
                if (nextNameToken.isEmpty() || (nextCurrentArtifactEntry = this.m_artifactStack.peek()) == null) continue;
                nextCurrentArtifactEntry.addConnector(nextNameToken);
                continue;
            }
            if (nextToken.equals("{")) {
                AutoCompletionArtifact artifactEntry = this.m_artifactStack.peek();
                if (artifactEntry == null) continue;
                artifactEntry.inc();
                LOGGER.trace("'{': " + artifactEntry.toString());
                continue;
            }
            if (nextToken.equals("}")) {
                AutoCompletionArtifact artifact = this.m_artifactStack.peek();
                if (artifact == null || artifact.dec() > 0) continue;
                artifact.setEndline(currentLine);
                if (action != null) {
                    action.finish(artifact);
                }
                this.m_artifactStack.pop();
                continue;
            }
            if (!nextToken.equals("\n")) continue;
            ++currentLine;
        }
    }

    static AutoCompletionArtifact collectArtifacts(String text, int line, List<AutoCompletionArtifact> toplevelArtifacts, String identifyingPath, Architecture architecture) {
        assert (text != null && text.length() > 0) : "Parameter 'text' of method 'collectArtifactAndInterfaceProposals' must not be empty";
        assert (toplevelArtifacts != null) : "Parameter 'toplevelArtifacts' of method 'collectArtifacts' must not be null";
        assert (architecture != null) : "Parameter 'architecture' of method 'collectArtifacts' must not be null";
        AutoCompletionArtifactCollector collector = new AutoCompletionArtifactCollector();
        FinishArtifactAction finishArtifactAction = new FinishArtifactAction(line);
        collector.tokenize(text, identifyingPath, architecture, toplevelArtifacts, finishArtifactAction);
        if (LOGGER.isTraceEnabled()) {
            for (AutoCompletionArtifact next : toplevelArtifacts) {
                LOGGER.trace("\n" + String.valueOf(next));
            }
        }
        return finishArtifactAction.getArtifactContainingLine();
    }

    private static enum Comment {
        SLASH_SLASH,
        SLASH_STAR_FIRST,
        SLASH_STAR_SECOND;

    }

    private static final class FinishArtifactAction {
        private final int m_line;
        private AutoCompletionArtifact m_artifactContainingLine;

        FinishArtifactAction(int line) {
            this.m_line = line;
        }

        void finish(AutoCompletionArtifact artifact) {
            assert (artifact != null) : "Parameter 'artifact' of method 'finish' must not be null";
            if (this.m_artifactContainingLine == null && this.m_line >= artifact.getStartLine() && this.m_line <= artifact.getEndline()) {
                this.m_artifactContainingLine = artifact;
            }
        }

        AutoCompletionArtifact getArtifactContainingLine() {
            return this.m_artifactContainingLine;
        }
    }
}

