/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.cycles;

import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.CyclesAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.LogicalNamespaceDependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.NamespaceCyclesAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.LogicalNamespaceCycleGroup;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.ValueList;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.core.model.programming.InternalLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.system.LogicalSystemNamespaces;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class SystemNamespaceCyclesAnalyzerAdapter
extends NamespaceCyclesAnalyzerAdapter {
    private final Language m_language;

    public SystemNamespaceCyclesAnalyzerAdapter(IAnalyzerController controller, IConfigurableAnalyzerId analyzerId, Language language) {
        super(controller, analyzerId);
        assert (language != null) : "Parameter 'language' of method 'SystemNamespaceCyclesAnalyzerAdapter' must not be null";
        this.m_language = language;
    }

    protected abstract IMetricDescriptor getNumberOfIncomingDependenciesMetric();

    protected abstract IMetricDescriptor getNumberOfOutgoingDependenciesMetric();

    protected abstract IMetricDescriptor getInstabilityMetric();

    protected abstract IMetricDescriptor getAbstractnessMetric();

    protected abstract IMetricDescriptor getDistanceMetric();

    protected Language getLanguage() {
        return this.m_language;
    }

    @Override
    protected void runJobs(AnalyzerResult result) {
        NamespaceCyclesInSystemJob job = new NamespaceCyclesInSystemJob(this.getGroup(), result, this.getController(), new LogicalNamespaceDependencyEndpointCollector());
        job.start();
    }

    protected class NamespaceCyclesInSystemJob
    extends CyclesAnalyzerAdapter.CyclesAnalyzerJob {
        private final LogicalNamespaceDependencyEndpointCollector m_collector;
        private final ValueList m_distance;
        private final ValueList m_abstractness;

        protected NamespaceCyclesInSystemJob(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller, LogicalNamespaceDependencyEndpointCollector collector) {
            super(SystemNamespaceCyclesAnalyzerAdapter.this, group, result, controller);
            this.m_collector = collector;
            this.setInstabilityMetric(SystemNamespaceCyclesAnalyzerAdapter.this.getInstabilityMetric());
            this.setNumberOfIncomingDependenciesMetric(SystemNamespaceCyclesAnalyzerAdapter.this.getNumberOfIncomingDependenciesMetric());
            this.setNumberOfOutgoingDependenciesMetric(SystemNamespaceCyclesAnalyzerAdapter.this.getNumberOfOutgoingDependenciesMetric());
            this.m_distance = SystemNamespaceCyclesAnalyzerAdapter.this.createValueList(result, SystemNamespaceCyclesAnalyzerAdapter.this.getDistanceMetric(), null);
            this.m_abstractness = SystemNamespaceCyclesAnalyzerAdapter.this.createValueList(result, SystemNamespaceCyclesAnalyzerAdapter.this.getAbstractnessMetric(), null);
        }

        @Override
        protected Collection<? extends NamedElement> getNamedElements() {
            this.m_collector.reset();
            for (InternalLogicalNamespaceRoot nextInternalLogicalNamespaceRoot : this.getSoftwareSystem().getUniqueExistingChild(LogicalSystemNamespaces.class).getChildren(InternalLogicalNamespaceRoot.class)) {
                if (!nextInternalLogicalNamespaceRoot.getLanguage().equals(SystemNamespaceCyclesAnalyzerAdapter.this.m_language)) continue;
                List<LogicalNamespace> logicalNamespaces = nextInternalLogicalNamespaceRoot.getNonPartLogicalNamespaces();
                this.m_collector.addLogicalNamespaces(logicalNamespaces);
                return logicalNamespaces;
            }
            return Collections.emptyList();
        }

        protected LogicalNamespaceDependencyEndpointCollector getCollector() {
            return this.m_collector;
        }

        @Override
        protected List<IType> getTypes(NamedElement namedElement) {
            assert (namedElement != null && namedElement instanceof LogicalNamespace) : "Unexpected class in method 'getTypes': " + String.valueOf(namedElement);
            return NamespaceCyclesAnalyzerAdapter.getTypes((LogicalNamespace)namedElement);
        }

        @Override
        protected NodeAdapterSet<ParserDependencyNodeAdapter> createNodeAdapterSet(Collection<? extends NamedElement> elements) {
            assert (elements != null) : "Parameter 'elements' of method 'createNodeAdapterSet' must not be null";
            return new ParserDependencyNodeAdapterSet(this.getWorkerContext(), elements, this.m_collector, PE, PD);
        }

        @Override
        protected AnalyzerCycleGroup createCycleGroup(boolean isCritical) {
            return new LogicalNamespaceCycleGroup(null, this.getSoftwareSystem(), SystemNamespaceCyclesAnalyzerAdapter.this.m_language, isCritical);
        }

        @Override
        protected boolean discardIfContainedInOneModule() {
            return true;
        }

        @Override
        protected void setDistance(NamedElement e, float value) {
            this.m_distance.addValue(e, Float.valueOf(value));
        }

        @Override
        protected void setAbstractness(NamedElement e, float value) {
            this.m_abstractness.addValue(e, Float.valueOf(value));
        }
    }
}

