/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.model.analysis.OnDemandCycleGroup;
import com.hello2morrow.sonargraph.core.model.architecture.AssignedElement;
import com.hello2morrow.sonargraph.core.model.architecture.RecursiveElementComponentContainer;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.IDependency;
import com.hello2morrow.sonargraph.core.model.element.IDomainRoot;
import com.hello2morrow.sonargraph.core.model.element.IRecursiveElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.StructureMode;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.PhysicalRecursiveElement;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.refactoring.DeleteRefactoringData;
import com.hello2morrow.sonargraph.core.model.system.PhysicalImpactCalculator;
import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

final class RefactoringProcessorUtility {
    private RefactoringProcessorUtility() {
    }

    private static Collection<Pair<NamedElement, NamedElement>> translateToPhysical(NamedElement from, NamedElement to) {
        assert (from != null) : "Parameter 'from' of method 'translateToPhysical' must not be null";
        assert (to != null) : "Parameter 'to' of method 'translateToPhysical' must not be null";
        return PhysicalImpactCalculator.createCombinations(PhysicalImpactCalculator.getPhysicalNamedElements(from), PhysicalImpactCalculator.getPhysicalNamedElements(to));
    }

    private static Boolean atLeastOneDependencyExists(NamedElement from, NamedElement to) {
        assert (from != null) : "Parameter 'from' of method 'atLeastOneDependencyExists' must not be null";
        assert (to != null) : "Parameter 'to' of method 'atLeastOneDependencyExists' must not be null";
        for (Pair<NamedElement, NamedElement> nextTranslated : RefactoringProcessorUtility.translateToPhysical(from, to)) {
            NamedElement toTranslatedEndPoint;
            NamedElement fromTranslatedEndPoint = (NamedElement)nextTranslated.getFirst();
            if (PhysicalImpactCalculator.getParserDependencies(fromTranslatedEndPoint, toTranslatedEndPoint = (NamedElement)nextTranslated.getSecond(), true, true).isEmpty()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    static Boolean acceptRepresentationDependencyEndpointsForDeleteRefactoring(NamedElement from, NamedElement to) {
        assert (from != null) : "Parameter 'from' of method 'acceptRepresentationDependencyEndpointsForDeleteRefactoring' must not be null";
        assert (to != null) : "Parameter 'to' of method 'acceptRepresentationDependencyEndpointsForDeleteRefactoring' must not be null";
        IDomainRoot.Domain fromDomain = from.getDomain();
        IDomainRoot.Domain toDomain = to.getDomain();
        if (fromDomain == null || toDomain == null || fromDomain.isLogical() != toDomain.isLogical()) {
            return null;
        }
        if (from instanceof OnDemandCycleGroup || to instanceof OnDemandCycleGroup) {
            return Boolean.FALSE;
        }
        return RefactoringProcessorUtility.atLeastOneDependencyExists(from, to);
    }

    static void collectElementInfo(NamedElement element, ElementInfo elementInfo) {
        assert (element != null) : "Parameter 'element' of method 'collectElementInfo' must not be null";
        assert (elementInfo != null) : "Parameter 'elementInfo' of method 'collectElementInfo' must not be null";
        if (!RefactoringProcessorUtility.isComponentOrProgrammingElement(element)) {
            elementInfo.setAllAreComponentsOrProgrammingElements(false);
        }
        if (element instanceof IRecursiveElement) {
            if (((IRecursiveElement)((Object)element)).isPart()) {
                elementInfo.setAllAreRecursiveNonPartElements(false);
            }
        } else {
            elementInfo.setAllAreRecursiveNonPartElements(false);
        }
    }

    static DeleteRefactoringData createDeleteRefactoringData(Class<?> clazz, List<Element> elements, ElementInfo elementInfo, Boolean enableEndpointOption, StructureMode structureMode) {
        assert (clazz != null) : "Parameter 'clazz' of method 'createDeleteRefactoringData' must not be null";
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'createDeleteRefactoringData' must not be empty";
        assert (elementInfo != null) : "Parameter 'elementInfo' of method 'createDeleteRefactoringData' must not be null";
        assert (structureMode != null) : "Parameter 'structureMode' of method 'createDeleteRefactoringData' must not be null";
        if (clazz.equals(ParserDependency.class) || clazz.equals(IDependency.class)) {
            String optionsInfo;
            assert (enableEndpointOption != null) : "'enableEndpointOption' of method 'createDeleteRefactoringData' must not be null";
            IDomainRoot.Domain domain = null;
            HashSet<ParserDependency> violating = new HashSet<ParserDependency>();
            int number = 0;
            boolean onlyParserDependencies = true;
            for (Element element : elements) {
                if (element instanceof IDependency) {
                    onlyParserDependencies = false;
                    for (Dependency dependency : ((IDependency)((Object)element)).getDependencies()) {
                        assert (dependency instanceof ParserDependency) : "Unexpected class in method 'createDeleteRefactoringData': " + String.valueOf(dependency);
                        if (!((ParserDependency)dependency).isArchitectureRelevant()) continue;
                        ++number;
                        if (!((ParserDependency)dependency).isViolation()) continue;
                        violating.add((ParserDependency)dependency);
                    }
                    if (domain != null) continue;
                    domain = ((IDependency)((Object)element)).getFromEndPoint().getDomain();
                    continue;
                }
                if (!(element instanceof ParserDependency) || !((ParserDependency)element).isArchitectureRelevant()) continue;
                ++number;
                if (((ParserDependency)element).isViolation()) {
                    violating.add((ParserDependency)element);
                }
                if (domain != null) continue;
                domain = ((ParserDependency)element).getFrom().getDomain();
            }
            LinkedHashSet<DeleteRefactoringData.EdgeOption> options = new LinkedHashSet<DeleteRefactoringData.EdgeOption>();
            int n = violating.size();
            if (n > 0) {
                optionsInfo = NumberUtility.format((Number)number) + (number > 1 ? " parser dependencies (" : " parser dependency (") + NumberUtility.format((Number)n) + " violating)";
                options.add(DeleteRefactoringData.EdgeOption.DELETE_VIOLATING_PARSER_DEPENDENCIES);
                if (n != number) {
                    options.add(DeleteRefactoringData.EdgeOption.DELETE_PARSER_DEPENDENCIES);
                }
            } else {
                optionsInfo = NumberUtility.format((Number)number) + (number > 1 ? " parser dependencies" : " parser dependency");
                options.add(DeleteRefactoringData.EdgeOption.DELETE_PARSER_DEPENDENCIES);
            }
            if (enableEndpointOption.booleanValue()) {
                options.add(DeleteRefactoringData.EdgeOption.DELETE_PARSER_DEPENDENCIES_BASED_ON_ENDPOINTS);
            }
            ArrayList<DeleteRefactoringData.EdgeOption> reorderedOptions = new ArrayList<DeleteRefactoringData.EdgeOption>(options);
            if ((structureMode == StructureMode.NON_RECURSIVE || domain == IDomainRoot.Domain.PHYSICAL && onlyParserDependencies) && reorderedOptions.contains((Object)DeleteRefactoringData.EdgeOption.DELETE_PARSER_DEPENDENCIES) && reorderedOptions.contains((Object)DeleteRefactoringData.EdgeOption.DELETE_VIOLATING_PARSER_DEPENDENCIES)) {
                reorderedOptions.remove((Object)DeleteRefactoringData.EdgeOption.DELETE_VIOLATING_PARSER_DEPENDENCIES);
                reorderedOptions.add(DeleteRefactoringData.EdgeOption.DELETE_VIOLATING_PARSER_DEPENDENCIES);
            }
            if (!elementInfo.allAreComponentsOrProgrammingElements() && enableEndpointOption.booleanValue()) {
                if (elementInfo.allAreRecursiveNonPartElements()) {
                    return new DeleteRefactoringData(DeleteRefactoringData.Kind.DEPENDENCY, elements, structureMode, reorderedOptions, reorderedOptions.get(0), optionsInfo, violating, new DeleteRefactoringData.RecursiveElementChildrenOption(false, structureMode == StructureMode.RECURSIVE));
                }
                return new DeleteRefactoringData(DeleteRefactoringData.Kind.DEPENDENCY, elements, structureMode, reorderedOptions, reorderedOptions.get(0), optionsInfo, violating, new DeleteRefactoringData.RecursiveElementChildrenOption(true, true));
            }
            return new DeleteRefactoringData(DeleteRefactoringData.Kind.DEPENDENCY, elements, structureMode, reorderedOptions, (DeleteRefactoringData.EdgeOption)((Object)reorderedOptions.get(0)), optionsInfo, violating);
        }
        if (!elementInfo.allAreComponentsOrProgrammingElements()) {
            if (elementInfo.allAreRecursiveNonPartElements()) {
                return new DeleteRefactoringData(DeleteRefactoringData.Kind.NODE, elements, structureMode, new DeleteRefactoringData.RecursiveElementChildrenOption(false, structureMode == StructureMode.RECURSIVE));
            }
            return new DeleteRefactoringData(DeleteRefactoringData.Kind.NODE, elements, structureMode, new DeleteRefactoringData.RecursiveElementChildrenOption(true, true));
        }
        return new DeleteRefactoringData(DeleteRefactoringData.Kind.NODE, elements, structureMode);
    }

    static boolean isDeletable(NamedElement element) {
        IDomainRoot.Domain domain;
        assert (element != null) : "Parameter 'element' of method 'isDeletable' must not be null";
        if (element.isDefinedInEnclosingElement() && !element.isCompilerGenerated() && (domain = element.getDomain()) != null) {
            switch (domain) {
                case LOGICAL_SYSTEM_SCOPE: 
                case LOGICAL_MODULE_SCOPE: {
                    if (element instanceof LogicalProgrammingElement) {
                        return true;
                    }
                    return element instanceof LogicalNamespace && ((LogicalNamespace)element).hasSourceNamespaces();
                }
                case ARCHITECTURE_LOGICAL: {
                    return element instanceof AssignedElement;
                }
                case ARCHITECTURE_PHYSICAL: {
                    return element instanceof RecursiveElementComponentContainer || element instanceof AssignedElement;
                }
                case PHYSICAL: {
                    return element instanceof PhysicalRecursiveElement || element instanceof ProgrammingElement || element instanceof IComponent;
                }
            }
            assert (false) : "Unhandled domain: " + String.valueOf((Object)domain);
            return false;
        }
        return false;
    }

    private static boolean isComponentOrProgrammingElement(NamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'isComponentOrProgrammingElement' must not be null";
        return namedElement instanceof IComponent || namedElement instanceof AssignedElement || namedElement instanceof ProgrammingElement || namedElement instanceof LogicalProgrammingElement;
    }

    static void collectRepresentationDependencyForDeleteRefactoring(IDependency representationDependency, Collection<Pair<NamedElement, NamedElement>> endpoints, Collection<ParserDependency> parserDependencies, boolean firstDependencyOnly) {
        assert (representationDependency != null) : "Parameter 'representationDependency' of method 'collectRepresentationDependencyForDeleteRefactoring' must not be null";
        assert (endpoints != null) : "Parameter 'endpoints' of method 'collectRepresentationDependencyForDeleteRefactoring' must not be null";
        assert (parserDependencies != null) : "Parameter 'parserDependencies' of method 'collectRepresentationDependencyForDeleteRefactoring' must not be null";
        for (Pair<NamedElement, NamedElement> nextTranslated : RefactoringProcessorUtility.translateToPhysical(representationDependency.getFromEndPoint(), representationDependency.getToEndPoint())) {
            NamedElement fromTranslatedEndPoint = (NamedElement)nextTranslated.getFirst();
            NamedElement toTranslatedEndPoint = (NamedElement)nextTranslated.getSecond();
            parserDependencies.addAll(PhysicalImpactCalculator.getParserDependencies(fromTranslatedEndPoint, toTranslatedEndPoint, firstDependencyOnly, true));
            endpoints.add((Pair<NamedElement, NamedElement>)new Pair((Object)fromTranslatedEndPoint, (Object)toTranslatedEndPoint));
        }
    }

    static void collectDependencyForDeleteRefactoring(Collection<? extends Dependency> dependencies, Set<Pair<NamedElement, NamedElement>> endpoints, Set<ParserDependency> parserDependencies, boolean firstDependencyOnly) {
        assert (dependencies != null && !dependencies.isEmpty()) : "Parameter 'dependencies' of method 'collectDependencyForDeleteRefactoring' must not be empty";
        assert (endpoints != null) : "Parameter 'endpoints' of method 'collectDependencyForDeleteRefactoring' must not be null";
        assert (parserDependencies != null) : "Parameter 'parserDependencies' of method 'collectDependencyForDeleteRefactoring' must not be null";
        for (Dependency dependency : dependencies) {
            assert (dependency instanceof ParserDependency) : "Unexpected class in method 'collectDependencyForDeleteRefactoring': " + String.valueOf(dependency);
            if (!endpoints.add((Pair<NamedElement, NamedElement>)new Pair((Object)dependency.getUnderlyingFrom(), (Object)dependency.getUnderlyingTo()))) continue;
            Set<ParserDependency> affected = PhysicalImpactCalculator.getParserDependencies(dependency.getUnderlyingFrom(), dependency.getUnderlyingTo(), firstDependencyOnly, true);
            parserDependencies.addAll(affected);
        }
    }

    static final class ElementInfo {
        private boolean m_allAreComponentsOrProgrammingElements = true;
        private boolean m_allAreRecursiveNonPartElements = true;

        ElementInfo() {
        }

        boolean allAreComponentsOrProgrammingElements() {
            return this.m_allAreComponentsOrProgrammingElements;
        }

        void setAllAreComponentsOrProgrammingElements(boolean allAreComponentsOrProgrammingElements) {
            this.m_allAreComponentsOrProgrammingElements = allAreComponentsOrProgrammingElements;
        }

        boolean allAreRecursiveNonPartElements() {
            return this.m_allAreRecursiveNonPartElements;
        }

        void setAllAreRecursiveNonPartElements(boolean allAreRecursiveNonPartElements) {
            this.m_allAreRecursiveNonPartElements = allAreRecursiveNonPartElements;
        }
    }
}

