/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.LanguageProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderAccessor;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.programming.ExternalElementContainer;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespace;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.programming.LogicalNamespaceScope;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.NamespaceFragment;
import com.hello2morrow.sonargraph.core.model.programming.PhysicalElementBasedExternalLogicalRoot;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.LogicalModuleNamespaces;
import com.hello2morrow.sonargraph.core.model.system.LogicalSystemNamespaces;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.External;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.ModuleBasedLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LogicalModelProvider {
    private final Logger LOGGER = LoggerFactory.getLogger(LogicalModelProvider.class);
    private final LanguageProviderAccessor m_languageProviderAccessor;

    LogicalModelProvider(LanguageProviderAccessor languageProviderAccessor) {
        assert (languageProviderAccessor != null) : "Parameter 'languageProviderAccessor' of method 'LogicalModelProvider' must not be null";
        this.m_languageProviderAccessor = languageProviderAccessor;
    }

    void clear(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'clear' must not be null";
        this.LOGGER.debug("Clear logical model");
        LogicalSystemNamespaces systemNamespaces = softwareSystem.getUniqueExistingChild(LogicalSystemNamespaces.class);
        systemNamespaces.getChildrenRecursively(LogicalNamespace.class, new Class[0]).forEach(n -> n.disconnect());
        systemNamespaces.forgetChildren(true);
        LogicalModuleNamespaces moduleNamespaces = softwareSystem.getUniqueExistingChild(LogicalModuleNamespaces.class);
        moduleNamespaces.getChildrenRecursively(LogicalNamespace.class, new Class[0]).forEach(n -> n.disconnect());
        moduleNamespaces.forgetChildren(true);
        this.LOGGER.debug("Clear logical model - done");
    }

    void recreate(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'recreate' must not be null";
        this.clear(softwareSystem);
        this.LOGGER.debug("Create logical model");
        Workspace workspace = softwareSystem.getUniqueExistingChild(Workspace.class);
        Set<Language> usedLanguages = softwareSystem.getUsedLanguages();
        if (usedLanguages.stream().anyMatch(lang -> lang.hasLogicalModel())) {
            LogicalSystemNamespaces systemNamespaces = softwareSystem.getUniqueExistingChild(LogicalSystemNamespaces.class);
            workspace.accept(new Aggregator(this.m_languageProviderAccessor, usedLanguages, LogicalNamespaceScope.SYSTEM, systemNamespaces));
            systemNamespaces.finishModification();
            LogicalModuleNamespaces moduleNamespaces = softwareSystem.getUniqueExistingChild(LogicalModuleNamespaces.class);
            workspace.accept(new Aggregator(this.m_languageProviderAccessor, usedLanguages, LogicalNamespaceScope.MODULE, moduleNamespaces));
            moduleNamespaces.finishModification();
        }
        this.LOGGER.debug("Create logical model - done");
    }

    private static final class Aggregator
    extends NamedElementVisitor
    implements Module.IVisitor,
    External.IVisitor,
    NamespaceFragment.IVisitor,
    ProgrammingElement.IVisitor,
    FilePath.IVisitor,
    Workspace.IVisitor {
        private final NonGhostProgrammingElementCollector m_nonGhostProgrammingElementCollector = new NonGhostProgrammingElementCollector();
        private final Map<String, ExternalElementContainer> m_moduleScopeNameToExternalElementContainer = new THashMap();
        private final Map<Language, LogicalNamespaceRoot> m_systemScopeLanguageToLogicalNamespaceRoot = new THashMap();
        private final Map<LogicalNamespace, List<ProgrammingElement>> m_logicalNamespaceToProgrammingElements = new THashMap();
        private final List<ExternalElementContainer> m_createdExternalElementContainers = new ArrayList<ExternalElementContainer>();
        private final Deque<LogicalNamespace> m_namespaceStack = new ArrayDeque<LogicalNamespace>();
        private final LanguageProviderAccessor m_accessor;
        private final LogicalNamespaceScope m_scope;
        private NamedElement m_currentParent;
        private LanguageProvider m_currentLanguageProvider;
        private LogicalNamespaceRoot m_currentLogicalNamespaceRoot;

        Aggregator(LanguageProviderAccessor accessor, Set<Language> usedLanguages, LogicalNamespaceScope scope, NamedElement parent) {
            assert (accessor != null) : "Parameter 'accessor' of method 'Aggregator' must not be null";
            assert (usedLanguages != null) : "Parameter 'usedLanguages' of method 'Aggregator' must not be null";
            assert (scope != null) : "Parameter 'scope' of method 'Aggregator' must not be null";
            assert (parent != null) : "Parameter 'parent' of method 'Aggregator' must not be null";
            this.m_accessor = accessor;
            this.m_scope = scope;
            this.m_currentParent = parent;
            switch (this.m_scope) {
                case SYSTEM: {
                    for (Language lang : usedLanguages) {
                        LanguageProvider nextLanguageProvider = this.m_accessor.getLanguageProvider(lang);
                        assert (nextLanguageProvider != null) : "'nextLanguageProvider' of method 'Aggregator' must not be null";
                        LogicalNamespaceRoot nextLogicalNamespaceRoot = nextLanguageProvider.createLogicalNamespaceRoot(this.m_currentParent);
                        assert (nextLogicalNamespaceRoot != null) : "'nextLogicalNamespaceRoot' of method 'Aggregator' must not be null";
                        this.m_currentParent.addChild(nextLogicalNamespaceRoot);
                        this.m_systemScopeLanguageToLogicalNamespaceRoot.put(lang, nextLogicalNamespaceRoot);
                    }
                    break;
                }
                case MODULE: {
                    break;
                }
                default: {
                    assert (false) : "Unhandled scope: " + String.valueOf((Object)this.m_scope);
                    break;
                }
            }
        }

        private void finishCreation(Collection<? extends LogicalNamespaceRoot> roots) {
            assert (roots != null) : "Parameter 'roots' of method 'finishCreation' must not be null";
            this.m_logicalNamespaceToProgrammingElements.entrySet().forEach(e -> ((LogicalNamespace)e.getKey()).finishCreation((List)e.getValue()));
            this.m_logicalNamespaceToProgrammingElements.clear();
            roots.forEach(root -> root.finishModification());
        }

        @Override
        public void visitWorkspace(Workspace element) {
            assert (element != null) : "Parameter 'element' of method 'visitWorkspace' must not be null";
            this.visitChildrenOf(element);
            for (ExternalElementContainer next : this.m_createdExternalElementContainers) {
                if (next.hasChildren()) continue;
                next.remove();
            }
            this.m_createdExternalElementContainers.clear();
            this.finishCreation(this.m_systemScopeLanguageToLogicalNamespaceRoot.values());
        }

        @Override
        public void visitModule(Module element) {
            assert (element != null) : "Parameter 'element' of method 'visitModule' must not be null";
            Language language = element.getLanguage();
            assert (language != null) : "'language' of method 'visitModule' must not be null";
            this.m_currentLanguageProvider = this.m_accessor.getLanguageProvider(language);
            assert (this.m_currentLanguageProvider != null) : "'m_currentLanguageProvider' of method 'visitModule' must not be null";
            switch (this.m_scope) {
                case SYSTEM: {
                    this.m_currentLogicalNamespaceRoot = this.m_systemScopeLanguageToLogicalNamespaceRoot.get(language);
                    break;
                }
                case MODULE: {
                    this.m_currentLogicalNamespaceRoot = new ModuleBasedLogicalNamespaceRoot(this.m_currentParent, element);
                    this.m_currentParent.addChild(this.m_currentLogicalNamespaceRoot);
                    break;
                }
                default: {
                    assert (false) : "Unhandled scope: " + String.valueOf((Object)this.m_scope);
                    break;
                }
            }
            assert (this.m_currentLogicalNamespaceRoot != null) : "Parameter 'm_currentLogicalNamespaceRoot' of method 'visitModule' must not be null";
            this.visitChildrenOf(element);
            switch (this.m_scope) {
                case SYSTEM: {
                    break;
                }
                case MODULE: {
                    this.finishCreation(Collections.singletonList(this.m_currentLogicalNamespaceRoot));
                    break;
                }
                default: {
                    assert (false) : "Unhandled scope: " + String.valueOf((Object)this.m_scope);
                    break;
                }
            }
            this.m_currentLanguageProvider = null;
            this.m_currentLogicalNamespaceRoot = null;
        }

        @Override
        public void visitExternal(External element) {
            assert (element != null) : "Parameter 'element' of method 'visitExternal' must not be null";
            Language language = element.getLanguage();
            assert (language != null) : "'language' of method 'visitExternal' must not be null";
            this.m_currentLanguageProvider = this.m_accessor.getLanguageProvider(language);
            assert (this.m_currentLanguageProvider != null) : "'m_currentLanguageProvider' of method 'visitExternal' must not be null";
            switch (this.m_scope) {
                case MODULE: {
                    if (element.containsPhysicalElements()) {
                        PhysicalElementBasedExternalLogicalRoot external = new PhysicalElementBasedExternalLogicalRoot(this.m_currentParent, element);
                        this.m_currentParent.addChild(external);
                        this.m_currentParent = external;
                        break;
                    }
                }
                case SYSTEM: {
                    this.m_currentLogicalNamespaceRoot = this.m_currentLanguageProvider.createExternalLogicalNamespaceRoot(this.m_currentParent, element, this.m_scope);
                    this.m_currentParent.addChild(this.m_currentLogicalNamespaceRoot);
                    this.m_currentParent = this.m_currentLogicalNamespaceRoot;
                    break;
                }
                default: {
                    assert (false) : "Unhandled scope: " + String.valueOf((Object)this.m_scope);
                    break;
                }
            }
            this.visitChildrenOf(element);
            switch (this.m_scope) {
                case MODULE: {
                    if (element.containsPhysicalElements()) {
                        this.finishCreation(this.m_currentParent.getChildren(ExternalElementContainer.class));
                        break;
                    }
                }
                case SYSTEM: {
                    this.finishCreation(Collections.singletonList(this.m_currentLogicalNamespaceRoot));
                    break;
                }
                default: {
                    assert (false) : "Unhandled scope: " + String.valueOf((Object)this.m_scope);
                    break;
                }
            }
            this.m_currentParent = this.m_currentParent.getParent();
            this.m_currentLanguageProvider = null;
            this.m_currentLogicalNamespaceRoot = null;
        }

        private LogicalNamespace createNamespace(String name) {
            assert (name != null && name.length() > 0) : "Parameter 'name' of method 'createNamespace' must not be empty: " + String.valueOf((Object)this.m_scope);
            assert (this.m_currentLanguageProvider != null) : "'m_currentLanguageProvider' of method 'createNamespace' must not be null: " + String.valueOf((Object)this.m_scope);
            assert (this.m_currentLogicalNamespaceRoot != null) : "'m_currentLogicalNamespaceRoot' of method 'createNamespace' must not be null: " + String.valueOf((Object)this.m_scope);
            StringTokenizer tokenizer = new StringTokenizer(name, this.m_currentLanguageProvider.getLanguage().getNamespaceSeparator());
            LogicalNamespaceRoot current = this.m_currentLogicalNamespaceRoot;
            while (tokenizer.hasMoreTokens()) {
                String nextNamespaceName = tokenizer.nextToken();
                assert (nextNamespaceName != null && nextNamespaceName.length() > 0) : "'nextNamespaceName' of method 'createNamespace' must not be empty";
                LogicalNamespace nextLogicalNamespace = null;
                for (LogicalNamespace nextNamespaceFragment : current.getNamedElement().getChildren(LogicalNamespace.class)) {
                    if (!nextNamespaceFragment.getShortName().equals(nextNamespaceName)) continue;
                    nextLogicalNamespace = nextNamespaceFragment;
                }
                if (nextLogicalNamespace == null) {
                    switch (this.m_scope) {
                        case SYSTEM: {
                            nextLogicalNamespace = this.m_currentLanguageProvider.createLogicalSystemNamespace(current.getNamedElement(), nextNamespaceName);
                            break;
                        }
                        case MODULE: {
                            nextLogicalNamespace = this.m_currentLanguageProvider.createLogicalModuleNamespace(current.getNamedElement(), nextNamespaceName);
                            break;
                        }
                        default: {
                            assert (false) : "Unhandled: " + String.valueOf((Object)this.m_scope);
                            break;
                        }
                    }
                    current.getNamedElement().addChild(nextLogicalNamespace);
                    this.m_currentLogicalNamespaceRoot.addLogicalNamespace(nextLogicalNamespace);
                    List previous = this.m_logicalNamespaceToProgrammingElements.put(nextLogicalNamespace, new ArrayList(100));
                    assert (previous == null) : "'previous' of method 'createNamespace' must be null";
                }
                current = nextLogicalNamespace;
            }
            return (LogicalNamespace)((Object)current);
        }

        @Override
        public void visitFilePath(FilePath element) {
            assert (element != null) : "Parameter 'element' of method 'visitFilePath' must not be null";
            NamedElement parent = this.m_currentParent;
            boolean currentParentIsPhysicalElementBasedLogicalRoot = false;
            if (this.m_currentParent instanceof PhysicalElementBasedExternalLogicalRoot) {
                String name = this.m_currentLanguageProvider.getExternalElementContainerName(this.m_currentParent, element);
                ExternalElementContainer match = this.m_moduleScopeNameToExternalElementContainer.get(name);
                if (match == null) {
                    match = new ExternalElementContainer(this.m_currentParent, (NamedElement)element, name);
                    this.m_currentParent.addChild(match);
                    this.m_moduleScopeNameToExternalElementContainer.put(name, match);
                    this.m_createdExternalElementContainers.add(match);
                } else {
                    PhysicalElementBasedExternalLogicalRoot logicalExt = (PhysicalElementBasedExternalLogicalRoot)this.m_currentParent;
                    logicalExt.addMapping(element, match);
                }
                this.m_currentLogicalNamespaceRoot = match;
                this.m_currentParent = null;
                currentParentIsPhysicalElementBasedLogicalRoot = true;
            }
            this.visitChildrenOf(element);
            if (currentParentIsPhysicalElementBasedLogicalRoot) {
                this.m_currentParent = parent;
            }
        }

        @Override
        public void visitNamespaceFragment(NamespaceFragment element) {
            assert (element != null) : "Parameter 'element' of method 'visitNamespaceFragment' must not be null";
            if (!element.getRefactoringState().hasBeenDeleted()) {
                LogicalNamespace logicalNamespace = this.createNamespace(element.getName());
                this.m_namespaceStack.push(logicalNamespace);
                this.visitChildrenOf(element);
                this.m_namespaceStack.pop();
                logicalNamespace.connect(element);
            }
        }

        @Override
        public void visitProgrammingElement(ProgrammingElement element) {
            List<ProgrammingElement> relevant;
            assert (element != null) : "Parameter 'element' of method 'visitProgrammingElement' must not be null";
            if (element.isGhost()) {
                relevant = new ArrayList<ProgrammingElement>();
                this.m_nonGhostProgrammingElementCollector.initialize(relevant);
                element.accept(this.m_nonGhostProgrammingElementCollector);
                this.m_nonGhostProgrammingElementCollector.reset();
            } else {
                relevant = Collections.singletonList(element);
            }
            for (ProgrammingElement nextRelevant : relevant) {
                if (!LogicalProgrammingElement.includeInLogicalModel(nextRelevant)) continue;
                LogicalNamespace logicalNamespace = this.m_namespaceStack.isEmpty() ? this.createNamespace(this.m_currentLanguageProvider.getLanguage().getGlobalNamespaceName()) : this.m_namespaceStack.peek();
                List<ProgrammingElement> programmingElements = this.m_logicalNamespaceToProgrammingElements.get(logicalNamespace);
                assert (programmingElements != null) : "'programmingElements' of method 'visitProgrammingElement' must not be null";
                programmingElements.add(nextRelevant);
            }
        }
    }

    static final class NonGhostProgrammingElementCollector
    extends NamedElementVisitor
    implements ProgrammingElement.IVisitor {
        private List<ProgrammingElement> m_collector;

        NonGhostProgrammingElementCollector() {
        }

        void initialize(List<ProgrammingElement> collector) {
            assert (this.m_collector == null) : "'m_collector' of method 'initialize' must be null";
            assert (collector != null) : "Parameter 'collector' of method 'initialize' must not be null";
            this.m_collector = collector;
        }

        void reset() {
            assert (this.m_collector != null) : "'m_collector' of method 'reset' must not be null";
            this.m_collector = null;
        }

        @Override
        public void visitNamedElement(NamedElement element) {
        }

        @Override
        public void visitProgrammingElement(ProgrammingElement element) {
            assert (this.m_collector != null) : "'m_collector' of method 'visitProgrammingElement' must not be null";
            assert (element != null) : "Parameter 'element' of method 'visitProgrammingElement' must not be null";
            if (element.isGhost()) {
                super.visitChildrenOf(element);
            } else {
                this.m_collector.add(element);
            }
        }
    }
}

