/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.CommandRegistry;
import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.common.SonargraphLicense;
import com.hello2morrow.sonargraph.core.command.common.SonargraphLicenseHandler;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SonargraphCommand;
import com.hello2morrow.sonargraph.core.foundation.common.base.CoreResourceProviderAdapter;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.logback.LogbackConfigurator;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.ProxySettings;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.license.model.ProductDescriptor;
import com.hello2morrow.sonargraph.userfeedback.controller.FeedbackProvider;
import com.hello2morrow.sonargraph.userfeedback.model.ErrorFeedback;
import com.hello2morrow.sonargraph.userfeedback.model.Feedback;
import com.hello2morrow.sonargraph.userfeedback.model.UserFeedback;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SendFeedbackCommand
extends SonargraphCommand {
    private final ProxySettings m_proxySettings;
    private final IInteraction m_interaction;

    protected SendFeedbackCommand(ISoftwareSystemProvider provider, IInteraction interaction, ProxySettings proxySettings) {
        super(provider);
        assert (interaction != null) : "Parameter 'interaction' of method 'SendFeedbackCommand' must not be null";
        this.m_interaction = interaction;
        this.m_proxySettings = proxySettings;
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.SEND_FEEDBACK;
    }

    @Override
    protected boolean isUndoable() {
        return false;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        SendFeedbackCommand.sendUserFeedback(this.m_proxySettings, this.m_interaction);
    }

    public static void sendUserFeedback(ProxySettings proxySettings, IInteraction interaction) {
        assert (interaction != null) : "Parameter 'interaction' of method 'sendUserFeedback' must not be null";
        FeedbackData feedbackData = new FeedbackData();
        if (!interaction.collect(feedbackData)) {
            return;
        }
        UserFeedback feedback = feedbackData.createFeedback();
        SonargraphLicenseHandler licenseHandler = CommandRegistry.getInstance().getLicenseHandler();
        feedback.setActivationCode(SendFeedbackCommand.getActivationCode(licenseHandler.getLicense()));
        OperationResult operationResult = FeedbackProvider.sendFeedback(SonargraphLicenseHandler.getHosts(), (ProxySettings)proxySettings, (Feedback)feedback, (ProductDescriptor)licenseHandler.getProductDescriptor());
        interaction.handleResult(operationResult);
    }

    private static String getActivationCode(SonargraphLicense license) {
        if (license == null) {
            return CoreResourceProviderAdapter.getInstance().getString("core.message.license.noActivationCode", new Object[0]);
        }
        String activationCode = license.getValue(SonargraphLicense.Property.ACTIVATION_CODE);
        if (activationCode == null || activationCode.trim().length() == 0) {
            activationCode = CoreResourceProviderAdapter.getInstance().getString("core.message.license.noActivationCode", new Object[0]);
        }
        return activationCode;
    }

    public static OperationResult sendErrorFeedback(Feedback.Salutation salutation, String contactName, String email, String phone, String contextInfo, Throwable exception, String statusMessage, TFile logFile, List<TFile> additionalFiles, ProxySettings proxySettings) {
        Map<String, String> properties;
        assert (salutation != null) : "Parameter 'salutation' of method 'sendErrorFeedback' must not be null";
        assert (contactName != null) : "Parameter 'contactName' of method 'sendErrorFeedback' must not be null";
        assert (email != null) : "Parameter 'email' of method 'sendErrorFeedback' must not be null";
        assert (phone != null) : "Parameter 'phone' of method 'sendErrorFeedback' must not be null";
        assert (contextInfo != null) : "Parameter 'contextInfo' of method 'sendErrorFeedback' must not be null";
        assert (exception != null) : "Parameter 'exception' of method 'sendErrorFeedback' must not be null";
        assert (additionalFiles != null) : "Parameter 'additionalFiles' of method 'sendErrorFeedback' must not be null";
        ErrorFeedback feedback = new ErrorFeedback(logFile);
        feedback.setSalutation(salutation);
        feedback.setContactName(contactName);
        feedback.setEmail(email);
        feedback.setPhone(phone);
        feedback.setAdditionalFiles(additionalFiles);
        SonargraphLicenseHandler licenseHandler = CommandRegistry.getInstance().getLicenseHandler();
        SonargraphLicense license = licenseHandler.getLicense();
        StringBuilder context = new StringBuilder();
        if (!contextInfo.isEmpty()) {
            context.append(contextInfo).append(StringUtility.LINE_SEPARATOR).append(StringUtility.LINE_SEPARATOR);
        }
        if (!(properties = license.getProperties()).isEmpty()) {
            context.append("License info:").append(StringUtility.LINE_SEPARATOR);
            for (Map.Entry<String, String> nextEntry : properties.entrySet()) {
                String nextKey = nextEntry.getKey();
                if (SonargraphLicense.Property.LOGIN.getStandardName().equals(nextKey) || SonargraphLicense.Property.MAC_ADDRESSES.getStandardName().equals(nextKey) || SonargraphLicense.Property.ACTIVATION_CODE.getStandardName().equals(nextKey)) continue;
                context.append(nextKey).append(": '").append(nextEntry.getValue()).append("'").append(StringUtility.LINE_SEPARATOR);
            }
            context.append(StringUtility.LINE_SEPARATOR);
        }
        context.append(CommandRegistry.getInstance().getExecutionContextInfo());
        feedback.setContextInfo(context.toString());
        feedback.setStatusMessage(statusMessage);
        feedback.setActivationCode(SendFeedbackCommand.getActivationCode(license));
        feedback.setException(exception);
        return FeedbackProvider.sendFeedback(SonargraphLicenseHandler.getHosts(), (ProxySettings)proxySettings, (Feedback)feedback, (ProductDescriptor)licenseHandler.getProductDescriptor());
    }

    public static TFile getLogFile() {
        File file = LogbackConfigurator.getLogFile();
        return file == null ? null : new TFile(file);
    }

    public static final class FeedbackData
    implements ICommandInteractionData {
        private Feedback.Salutation m_salutation;
        private String m_contactName;
        private String m_email;
        private String m_phone;
        private String m_contextInfo;
        private String m_subject;
        private TFile m_logFile;
        private TFile m_rootForZip;
        private boolean m_testOnly;
        private List<TFile> m_additionalFiles;

        public void setSalutation(Feedback.Salutation salutation) {
            this.m_salutation = salutation;
        }

        public void setContactName(String contactName) {
            this.m_contactName = contactName;
        }

        public void setEmail(String email) {
            this.m_email = email;
        }

        public void setPhone(String phone) {
            this.m_phone = phone;
        }

        public void setContextInfo(String contextInfo) {
            this.m_contextInfo = contextInfo;
        }

        public void addToContextInfo(String additionalInfo) {
            this.m_contextInfo = this.m_contextInfo + "\n\n" + additionalInfo;
        }

        public void setSubject(String subject) {
            this.m_subject = subject;
        }

        public void setLogFile(TFile logFile) {
            assert (logFile != null) : "Parameter 'logFile' of method 'setLogFile' must not be null";
            this.m_logFile = logFile;
        }

        public void setAdditionalFiles(List<TFile> additionalFiles) {
            assert (additionalFiles != null) : "Parameter 'additionalFiles' of method 'setAdditionalFiles' must not be null";
            this.m_additionalFiles = additionalFiles;
        }

        public void setRootForFilesCollection(TFile rootForZip) {
            assert (rootForZip != null) : "Parameter 'rootForZip' of method 'setRootForFilesCollection' must not be null";
            assert (rootForZip.isDirectory()) : "Parameter 'rootForZip' of method 'setRootForFilesCollection' must be a directory";
            this.m_rootForZip = rootForZip;
        }

        public void setTestOnly(boolean isTestOnly) {
            this.m_testOnly = isTestOnly;
        }

        private UserFeedback createFeedback() {
            UserFeedback feedback = new UserFeedback(this.m_logFile, this.m_rootForZip, this.m_testOnly);
            feedback.setSubject(this.m_subject);
            feedback.setContextInfo(this.m_contextInfo);
            feedback.setSalutation(this.m_salutation);
            feedback.setContactName(this.m_contactName);
            feedback.setEmail(this.m_email);
            feedback.setPhone(this.m_phone);
            feedback.setAdditionalFiles(this.m_additionalFiles != null ? this.m_additionalFiles : Collections.emptyList());
            return feedback;
        }
    }

    public static interface IInteraction
    extends ICommandInteraction {
        public boolean collect(FeedbackData var1);

        public void handleResult(OperationResult var1);
    }
}

