/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.SaveSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ISnapshotExtension;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.ISystemDiffProvider;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Result;
import de.schlichtherle.truezip.file.TFile;

public final class SaveSnapshotCommand
extends SoftwareSystemBasedCommand<ISaveSnapshotInteraction> {
    public SaveSnapshotCommand(ISoftwareSystemProvider provider, ISaveSnapshotInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public final ICommandId getId() {
        return CoreCommandId.SAVE_SYSTEM_AS_SNAPSHOT;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    public ActivityMode getActivityMode() {
        return ActivityMode.MODAL;
    }

    @Override
    public Result isEnabled() {
        Result enabled = super.isEnabled();
        if (enabled.isSuccess() && !this.getController().getSoftwareSystem().isClearable()) {
            enabled.addErrorMessage("System is empty");
        }
        return enabled;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        SoftwareSystem softwareSystem = this.getController().getSoftwareSystem();
        assert (softwareSystem != null) : "'softwareSystem' of method 'internalRun' must not be null";
        String warning = softwareSystem.getExtension(ISystemDiffProvider.class).aboutToSaveFullSnapshot();
        if (warning != null && !warning.isEmpty() && !((ISaveSnapshotInteraction)this.getInteraction()).confirmActiveBaselineWarning(warning)) {
            return;
        }
        SaveSoftwareSystemCommand saveSoftwareSystemCommand = new SaveSoftwareSystemCommand((ISoftwareSystemProvider)this.getController(), (SaveSoftwareSystemCommand.ISaveInteraction)this.getInteraction());
        if (saveSoftwareSystemCommand.isEnabled().isSuccess()) {
            this.runPrerequisiteCommand(saveSoftwareSystemCommand, workerContext);
            if (saveSoftwareSystemCommand.canceled()) {
                return;
            }
        }
        SaveSnapshotData data = new SaveSnapshotData();
        if (((ISaveSnapshotInteraction)this.getInteraction()).collect(data)) {
            TFile snapshotFile = new TFile(data.getFilePath());
            if (snapshotFile.exists() && !((ISaveSnapshotInteraction)this.getInteraction()).confirmSnapshotOverwrite(data.getFilePath())) {
                return;
            }
            ISnapshotProcessor.Mode mode = data.includeSources() ? ISnapshotProcessor.Mode.FULL_WITH_SOURCECODE : ISnapshotProcessor.Mode.FULL;
            OperationResult result = softwareSystem.getExtension(ISnapshotExtension.class).saveSnapshot(workerContext, mode, snapshotFile);
            ((ISaveSnapshotInteraction)this.getInteraction()).processSaveSnapshotResult(result);
        }
    }

    public static interface ISaveSnapshotInteraction
    extends SaveSoftwareSystemCommand.ISaveInteraction {
        default public boolean confirmActiveBaselineWarning(String message) {
            return true;
        }

        public boolean collect(SaveSnapshotData var1);

        public boolean confirmSnapshotOverwrite(String var1);

        public void processSaveSnapshotResult(OperationResult var1);
    }

    public static final class SaveSnapshotData
    implements ICommandInteractionData {
        private String m_filePath;
        private boolean m_includeSources;

        public void setFilePath(String filePath) {
            assert (filePath != null && filePath.length() > 0) : "Parameter 'filePath' of method 'setFilePath' must not be empty";
            this.m_filePath = filePath;
        }

        public void setIncludeSources(boolean includeSources) {
            this.m_includeSources = includeSources;
        }

        String getFilePath() {
            assert (this.m_filePath != null && this.m_filePath.length() > 0) : "'m_filePath' of method 'getFilePath' must not be empty";
            return this.m_filePath;
        }

        boolean includeSources() {
            return this.m_includeSources;
        }
    }
}

