/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.scm.git.controller;

import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.scm.IScmDataProvider;
import com.hello2morrow.sonargraph.scm.RetrieveException;
import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffAlgorithm;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractGitCommandExecution<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGitCommandExecution.class);
    private final IScmDataProvider m_scmDataProvider;
    private final File m_repositoryDir;
    private final String m_branchName;

    public AbstractGitCommandExecution(IScmDataProvider scmDataProvider, File repositoryDir, String branchName) {
        assert (scmDataProvider != null) : "Parameter 'scmDataProvider' of method 'retrieveCommits' must not be null";
        assert (repositoryDir != null) : "Parameter 'repositoryDir' of method 'AbstractGitCommandExecution' must not be null";
        this.m_scmDataProvider = scmDataProvider;
        this.m_repositoryDir = repositoryDir;
        this.m_branchName = branchName;
    }

    /*
     * Loose catch block
     */
    final T execute(IWorkerContext workerContext) throws RetrieveException, IWorkerContext.WorkerContextCancelledException {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'retrieveCommits' must not be null";
        if (!this.m_repositoryDir.isDirectory()) {
            throw new RetrieveException(this.m_repositoryDir.getAbsolutePath() + " is not a directory");
        }
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        builder.setGitDir(this.m_repositoryDir);
        builder.setMustExist(true);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Repository repository = builder.build();){
                T t;
                Git git;
                Throwable throwable2;
                block25: {
                    if (repository.isBare()) {
                        throw new RetrieveException("Empty repository");
                    }
                    this.fixUnsupportedDiffAlgorithm(repository);
                    ObjectId branch = repository.resolve(this.m_branchName);
                    if (branch == null) {
                        throw new RetrieveException("Unknown branch: " + this.m_branchName);
                    }
                    throwable2 = null;
                    Object var8_12 = null;
                    git = new Git(repository);
                    t = this.internalExecute(workerContext, repository, git, branch);
                    if (git == null) break block25;
                    git.close();
                }
                return t;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (git != null) {
                                git.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (IOException | GitAPIException e) {
            throw new RetrieveException(e);
        }
    }

    abstract T internalExecute(IWorkerContext var1, Repository var2, Git var3, ObjectId var4) throws GitAPIException, IOException, IWorkerContext.WorkerContextCancelledException;

    private void fixUnsupportedDiffAlgorithm(Repository repository) {
        assert (repository != null) : "Parameter 'repository' of method 'fixUnsupportedDiffAlgorithm' must not be null";
        String diffAlgorithm = repository.getConfig().getString("diff", null, "algorithm");
        if (diffAlgorithm != null) {
            try {
                DiffAlgorithm.SupportedAlgorithm supported = DiffAlgorithm.SupportedAlgorithm.valueOf((String)diffAlgorithm);
                LOGGER.debug("Configured diff algorithm {} is supported by JGit {}", (Object)diffAlgorithm, (Object)supported);
            }
            catch (IllegalArgumentException e) {
                DiffAlgorithm.SupportedAlgorithm defaultAlgorithm = DiffAlgorithm.SupportedAlgorithm.MYERS;
                repository.getConfig().setString("diff", null, "algorithm", defaultAlgorithm.toString().toLowerCase());
                LOGGER.warn("Configured diff algorithm '{}' is NOT supported by JGit, replaced it with {}", (Object)diffAlgorithm, (Object)defaultAlgorithm);
            }
        }
    }

    protected final String getBranchName() {
        return this.m_branchName;
    }

    protected final IScmDataProvider getScmDataProvider() {
        return this.m_scmDataProvider;
    }

    protected final File getRepositoryDir() {
        return this.m_repositoryDir;
    }
}

