/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency;

import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.CSharpDependencyType;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.CallDependency;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.CatchTypeDependency;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.ConstructorCallDependency;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.DelegateInitializationDependency;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.ExplicitConversion;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.ExtendsDependency;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.FieldTypeDependency;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.GenericParameterConstraintDependency;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.GenericParameterTypeDependency;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.HasAttributeDependency;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.ImplementsDependency;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.ImplicitConversion;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.LocalVariableTypeDependency;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.NewDependency;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.OverrideDependency;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.ParameterTypeDependency;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.ReadDependency;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.ReturnTypeDependency;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.TypeofDependency;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.VirtualCallDependency;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.programming.dependency.WriteDependency;

public class DependencyFactory {
    public static ParserDependency addDependency(CSharpDependencyType type, ProgrammingElement from, ProgrammingElement to, int line) {
        assert (type != null) : "Parameter 'type' of method 'addDependency' must not be null";
        Object dep = null;
        switch (type) {
            case IMPLEMENTS: {
                dep = new ImplementsDependency(from, to);
                break;
            }
            case EXTENDS: {
                dep = new ExtendsDependency(from, to);
                break;
            }
            case HAS_ATTRIBUTE: {
                dep = new HasAttributeDependency(from, to, line);
                break;
            }
            case FIELD_TYPE: {
                dep = new FieldTypeDependency(from, to);
                break;
            }
            case RETURN_TYPE: {
                dep = new ReturnTypeDependency(from, to);
                break;
            }
            case PARAMETER_TYPE: {
                dep = new ParameterTypeDependency(from, to);
                break;
            }
            case GENERIC_PARAMETER_CONSTRAINT: {
                dep = new GenericParameterConstraintDependency(from, to, line);
                break;
            }
            case GENERIC_PARAMETER_TYPE: {
                dep = new GenericParameterTypeDependency(from, to, line);
                break;
            }
            case LOCAL_VARIABLE_TYPE: {
                dep = new LocalVariableTypeDependency(from, to, line);
                break;
            }
            case CATCH_TYPE: {
                dep = new CatchTypeDependency(from, to, line);
                break;
            }
            case READ: {
                dep = new ReadDependency(from, to, line);
                break;
            }
            case WRITE: {
                dep = new WriteDependency(from, to, line);
                break;
            }
            case CALL: {
                dep = new CallDependency(from, to, line);
                break;
            }
            case VIRTUAL_CALL: {
                dep = new VirtualCallDependency(from, to, line);
                break;
            }
            case CONSTRUCTOR_CALL: {
                dep = new ConstructorCallDependency(from, to, line);
                break;
            }
            case TYPEOF: {
                dep = new TypeofDependency(from, to, line);
                break;
            }
            case NEW: {
                dep = new NewDependency(from, to, line);
                break;
            }
            case IMPLICIT_CONVERSION: {
                dep = new ImplicitConversion(from, to, line);
                break;
            }
            case EXPLICIT_CONVERSION: {
                dep = new ExplicitConversion(from, to, line);
                break;
            }
            case DELEGATE_INITIALIZATION: {
                dep = new DelegateInitializationDependency(from, to, line);
                break;
            }
            case OVERRIDE: {
                dep = new OverrideDependency(from, to);
                break;
            }
        }
        assert (dep != null);
        return dep;
    }
}

