/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.model.internal;

import com.hello2morrow.sonargraph.integration.access.model.INamedElement;
import com.hello2morrow.sonargraph.integration.access.model.internal.ElementWithDescriptionImpl;
import java.util.Optional;

public class NamedElementImpl
extends ElementWithDescriptionImpl
implements INamedElement {
    private static final long serialVersionUID = 7897215356427497745L;
    private String fqName;
    private String m_originalFqName;
    private final String kind;
    private final String presentationKind;
    private final String imageResourceName;

    protected NamedElementImpl(String kind, String presentationKind, String name, String presentationName, String fqName, String description, String imageResourceName) {
        super(name, presentationName, description);
        assert (fqName != null && fqName.length() > 0) : "Parameter 'fqName' of method 'NamedElementImpl' must not be empty";
        this.kind = kind;
        this.presentationKind = presentationKind;
        this.fqName = fqName;
        this.imageResourceName = imageResourceName;
    }

    public NamedElementImpl(String kind, String presentationKind, String name, String presentationName, String fqName, String imageResourceName) {
        this(kind, presentationKind, name, presentationName, fqName, "", imageResourceName);
    }

    @Override
    public final String getKind() {
        return this.kind;
    }

    @Override
    public final String getFqName() {
        return this.fqName;
    }

    @Override
    public final String getPresentationKind() {
        return this.presentationKind;
    }

    @Override
    public String getImageResourceName() {
        return this.imageResourceName != null ? this.imageResourceName : this.kind;
    }

    public final void setOriginalFqName(String originalFqName) {
        assert (originalFqName != null && originalFqName.length() > 0) : "Parameter 'originalFqName' of method 'setOriginalFqName' must not be empty";
        this.m_originalFqName = originalFqName;
    }

    protected final void setFqName(String newFqName) {
        assert (newFqName != null && newFqName.length() > 0) : "Parameter 'newFqName' of method 'updateFqName' must not be empty";
        this.fqName = newFqName;
    }

    @Override
    public Optional<String> getOriginalFqName() {
        return Optional.ofNullable(this.m_originalFqName);
    }

    @Override
    public Optional<? extends INamedElement> getOriginalLocation() {
        return Optional.empty();
    }

    @Override
    public boolean isLocationOnly() {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append("\n");
        builder.append("kind:").append(this.kind);
        builder.append("\n");
        builder.append("fqName:").append(this.fqName);
        builder.append("\n");
        builder.append("isLocationOnly:").append(this.isLocationOnly());
        Optional<? extends INamedElement> optOriginalLocation = this.getOriginalLocation();
        if (optOriginalLocation.isPresent()) {
            builder.append("\n");
            builder.append("originalFqName:").append(optOriginalLocation.get().getFqName());
        }
        return builder.toString();
    }
}

