/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.model.internal;

import com.hello2morrow.sonargraph.integration.access.model.IMetricLevel;
import com.hello2morrow.sonargraph.integration.access.model.IModule;
import com.hello2morrow.sonargraph.integration.access.model.INamedElement;
import com.hello2morrow.sonargraph.integration.access.model.ISourceFile;
import com.hello2morrow.sonargraph.integration.access.model.ISourceFileLookup;
import com.hello2morrow.sonargraph.integration.access.model.internal.LanguageBasedContainerImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.MetaDataAccessImpl;
import com.hello2morrow.sonargraph.integration.access.model.internal.NamedElementRegistry;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public final class ModuleImpl
extends LanguageBasedContainerImpl
implements IModule {
    private static final long serialVersionUID = -4617725409511641491L;
    private final ISourceFileLookup sourceFileLookup;
    private final String moduleId;

    public ModuleImpl(String kind, String presentationKind, String name, String presentationName, String fqName, String description, String moduleId, MetaDataAccessImpl metaDataAccessImpl, NamedElementRegistry elementRegistryImpl, String language, ISourceFileLookup sourceFileLookup) {
        super(kind, presentationKind, name, presentationName, fqName, description, metaDataAccessImpl, elementRegistryImpl, language);
        assert (sourceFileLookup != null) : "Parameter 'sourceFileLookup' of method 'ModuleImpl' must not be null";
        this.sourceFileLookup = sourceFileLookup;
        this.moduleId = moduleId;
    }

    @Override
    public String getModuleId() {
        return this.moduleId;
    }

    @Override
    public Map<String, IMetricLevel> getMetricLevels() {
        LinkedHashMap<String, IMetricLevel> metricLevels = new LinkedHashMap<String, IMetricLevel>();
        metricLevels.putAll(this.getAllMetricLevels());
        metricLevels.remove("System");
        return Collections.unmodifiableMap(metricLevels);
    }

    @Override
    public Optional<ISourceFile> getSourceForElement(INamedElement namedElement) {
        assert (namedElement != null) : "Parameter 'namedElement' of method 'getSourceForElement' must not be null";
        Optional<? extends ISourceFile> sourceFileOpt = this.sourceFileLookup.getSourceFile(namedElement);
        if (sourceFileOpt.isPresent()) {
            ISourceFile sourceFile = sourceFileOpt.get();
            Optional<ISourceFile> originalSourceFileOpt = sourceFile.getOriginalLocation();
            if (originalSourceFileOpt.isPresent()) {
                ISourceFile originalSourceFile = originalSourceFileOpt.get();
                return this.getRootDirectories().stream().flatMap(r -> r.getSourceFiles().stream()).filter(s -> s == originalSourceFile).findFirst();
            }
            return this.getRootDirectories().stream().flatMap(r -> r.getSourceFiles().stream()).filter(s -> s == sourceFile).findFirst();
        }
        return this.getRootDirectories().stream().flatMap(r -> r.getSourceFiles().stream()).filter(e -> namedElement.getFqName().startsWith(e.getFqName())).findFirst();
    }

    @Override
    public String getImageResourceName() {
        return "Module";
    }
}

