/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.access.foundation;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.Locale;

public final class Utility {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String INDENTATION = "   ";
    private static final char PATH_SEPARATOR_CHAR = '/';
    private static final char PATH_SEPARATOR_CHAR_TO_BE_CONVERTED = '\\';
    private static final String ISO_8601_DATA_AN_TIME_UNIVERSAL_TIMEZONE_FORMAT_STRING = "yyyy-MM-dd HH:mm:ss Z";

    private Utility() {
    }

    public static String collectAll(Throwable exc) {
        assert (exc != null) : "'exc' must not be null";
        StringBuilder buffer = new StringBuilder(1024);
        Throwable next = exc;
        while (next != null) {
            buffer.append(next.toString());
            buffer.append(LINE_SEPARATOR);
            StackTraceElement[] ste = next.getStackTrace();
            int i = 0;
            while (i < ste.length) {
                buffer.append(ste[i].toString());
                buffer.append(LINE_SEPARATOR);
                ++i;
            }
            next = next.getCause();
        }
        return buffer.toString();
    }

    public static String convertPathToUniversalForm(String path) {
        assert (path != null) : "Parameter 'path' of method 'calculatePath' must not be null";
        return path.replace('\\', '/');
    }

    public static String getDateTimeStringFromLocale(Date date) {
        return DateFormat.getDateTimeInstance(2, 2, Locale.getDefault()).format(date);
    }

    public static String formatDateAndTimeForUniversalTimezone(Date date) {
        return new SimpleDateFormat(ISO_8601_DATA_AN_TIME_UNIVERSAL_TIMEZONE_FORMAT_STRING).format(date);
    }

    public static String convertConstantNameToMixedCaseString(String input, boolean capitalizeFirstLetter, boolean insertSpace) {
        assert (input != null) : "'input' must not be null";
        assert (input.length() > 0) : "'input' must not be empty";
        StringBuilder builder = new StringBuilder();
        boolean previousWasUnderscore = capitalizeFirstLetter;
        int i = 0;
        while (i < input.length()) {
            boolean currentIsUnderscore;
            char nextChar = input.charAt(i);
            boolean bl = currentIsUnderscore = nextChar == '_';
            if (!currentIsUnderscore) {
                if (previousWasUnderscore) {
                    if (insertSpace && builder.length() > 0) {
                        builder.append(' ');
                    }
                    builder.append(Character.toUpperCase(nextChar));
                } else {
                    builder.append(Character.toLowerCase(nextChar));
                }
            }
            previousWasUnderscore = currentIsUnderscore;
            ++i;
        }
        return builder.toString();
    }

    public static String convertConstantNameToStandardName(String input) {
        return Utility.convertConstantNameToMixedCaseString(input, true, false);
    }

    public static String convertConstantNameToPresentationName(String input) {
        assert (input != null) : "'input' must not be null";
        assert (input.length() > 0) : "'input' must not be empty";
        StringBuilder builder = new StringBuilder();
        boolean previousWasUnderscore = true;
        int i = 0;
        while (i < input.length()) {
            boolean currentIsUnderscore;
            char nextChar = input.charAt(i);
            boolean bl = currentIsUnderscore = nextChar == '_';
            if (!currentIsUnderscore) {
                if (previousWasUnderscore) {
                    if (builder.length() > 0) {
                        builder.append(' ');
                    }
                    builder.append(Character.toUpperCase(nextChar));
                } else {
                    builder.append(Character.toLowerCase(nextChar));
                }
            }
            previousWasUnderscore = currentIsUnderscore;
            ++i;
        }
        return builder.toString();
    }

    public static String convertStandardNameToConstantName(String input) {
        assert (input != null) : "'input' must not be null";
        assert (input.length() > 0) : "'input' must not be empty";
        StringBuilder builder = new StringBuilder();
        char previousChar = input.charAt(0);
        builder.append(Character.toUpperCase(previousChar));
        int i = 1;
        while (i < input.length()) {
            char nextChar = input.charAt(i);
            if (Character.isUpperCase(nextChar) || Character.isDigit(nextChar) && !Character.isDigit(previousChar)) {
                builder.append('_');
            }
            builder.append(Character.toUpperCase(nextChar));
            previousChar = nextChar;
            ++i;
        }
        return builder.toString();
    }

    public static String convertMixedCaseStringToConstantName(String input) {
        assert (input != null) : "'input' must not be null";
        assert (input.length() > 0) : "'input' must not be empty";
        StringBuilder builder = new StringBuilder();
        char previousChar = input.charAt(0);
        builder.append(Character.toUpperCase(previousChar));
        int i = 1;
        while (i < input.length()) {
            char nextChar = input.charAt(i);
            if (Character.isUpperCase(nextChar) || Character.isDigit(nextChar) && !Character.isDigit(previousChar)) {
                builder.append('_');
            }
            builder.append(Character.toUpperCase(nextChar));
            previousChar = nextChar;
            ++i;
        }
        return builder.toString();
    }

    public static double round(double value, int decimals) {
        double decimalRounding = Math.pow(10.0, decimals);
        double rounded = value * decimalRounding;
        double temp = Math.round(rounded);
        rounded = temp / decimalRounding;
        return rounded;
    }

    public static boolean hasChanged(double d1, double d2, int decimals) {
        double d2rounded;
        double d1rounded = Utility.round(d1, decimals);
        return d1rounded != (d2rounded = Utility.round(d2, decimals));
    }

    public static String getRoundedValueAsString(Number number, int decimals) {
        assert (number != null) : "Parameter 'number' of method 'getRoundedValueAsString' must not be null";
        String rep = Double.toString(Utility.round(number.doubleValue(), decimals));
        if (rep.endsWith(".0") || rep.endsWith(",0")) {
            rep = rep.substring(0, rep.length() - 2);
        } else if (rep.endsWith(".00") || rep.endsWith(",00")) {
            rep = rep.substring(0, rep.length() - 3);
        }
        return rep;
    }

    public static String trimDescription(String description, int maxLength) {
        assert (maxLength >= 0) : "'maxLength' must not be negative";
        if (description != null && !description.isEmpty() && maxLength > 0) {
            String trimmedDescription = description.replaceAll("\r", " ").replaceAll("\n", " ").trim();
            int length = trimmedDescription.length();
            if (length <= maxLength) {
                return trimmedDescription;
            }
            if (maxLength > 3) {
                return trimmedDescription.substring(0, maxLength - 3) + "...";
            }
            if (maxLength > 2) {
                return trimmedDescription.substring(0, maxLength - 2) + "..";
            }
            if (maxLength > 1) {
                return trimmedDescription.substring(0, maxLength - 1) + ".";
            }
            return trimmedDescription.substring(0, maxLength);
        }
        return "";
    }

    public static String base64Encode(String content) {
        assert (content != null) : "Parameter 'content' of method 'base64Encode' must not be null";
        return Base64.getEncoder().encodeToString(content.getBytes());
    }

    public static String base64Decode(String encoded) {
        assert (encoded != null) : "Parameter 'encoded' of method 'base64Decode' must not be null";
        byte[] decodedBytes = Base64.getDecoder().decode(encoded);
        return new String(decodedBytes);
    }
}

