/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.python.model.programming;

import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericPackage;
import com.hello2morrow.sonargraph.core.model.generic.programming.GenericScript;
import com.hello2morrow.sonargraph.core.model.path.GenericSourceFile;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.languageprovider.python.model.path.PythonFileType;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class PythonSourceFile
extends GenericSourceFile {
    private static void init(IModelServiceProvider msp, PythonSourceFile sourceFile) {
        assert (msp != null) : "Parameter 'msp' of method 'init' must not be null";
        assert (sourceFile != null) : "Parameter 'sourceFile' of method 'init' must not be null";
        String name = FileUtility.removeExtension((String)sourceFile.getShortName());
        sourceFile.addChild((NamedElement)new GenericScript(msp, (NamedElement)sourceFile, name));
    }

    public PythonSourceFile(NamedElement parent) {
        super(parent);
    }

    public PythonSourceFile(IModelServiceProvider msp, NamedElement parent, TFile file) {
        super(msp, parent, file);
        PythonSourceFile.init(msp, this);
    }

    public IFileType getFileType() {
        return PythonFileType.SOURCE_FILE;
    }

    public void reset(IModelServiceProvider msp) {
        assert (msp != null) : "Parameter 'msp' of method 'reset' must not be null";
        this.removeChildren(new Class[0]);
        PythonSourceFile.init(msp, this);
    }

    public void finishModification() {
        ArrayList children = this.getModifiableChildrenList();
        assert (children != null && !children.isEmpty()) : "'children' of method 'finishModification' must not be empty";
        assert (children.get(0) instanceof GenericScript) : "Unexpected child on first position";
        GenericScript script = (GenericScript)children.get(0);
        int i = 1;
        while (i < children.size()) {
            NamedElement nextChild = (NamedElement)children.get(i);
            assert (nextChild != null && nextChild instanceof ProgrammingElement) : "Unexpected class in method 'finishModification': " + String.valueOf(nextChild);
            nextChild.setParent((NamedElement)script);
            script.addChild(nextChild);
            ++i;
        }
        ArrayList<GenericScript> newChildrenList = new ArrayList<GenericScript>(1);
        newChildrenList.add(script);
        this.setModifiableChildrenList(newChildrenList);
    }

    public GenericScript getScript() {
        return (GenericScript)this.getUniqueExistingChild(GenericScript.class);
    }

    public String getPythonModuleName() {
        StringBuilder sb = new StringBuilder();
        if (this.getParent() instanceof GenericPackage) {
            sb.append(this.getParent().getName()).append('.');
        }
        sb.append(FileUtility.removeExtension((String)this.getShortName()));
        return sb.toString();
    }

    public List<SourceFile> getSources() {
        return Collections.singletonList(this);
    }

    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitPythonSourceFile(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitPythonSourceFile(PythonSourceFile var1);
    }
}

