/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.python.controller.system.parser;

import com.hello2morrow.sonargraph.core.controller.system.parser.AbstractSourceLineProcessor;
import com.hello2morrow.sonargraph.core.controller.system.parser.ISourceLineProcessor;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.function.Predicate;

public final class PythonSourceLineProcessor
extends AbstractSourceLineProcessor {
    private static String OPERATOR_CHARS = "+-*/%~^<>!=";
    private final StringBuilder m_collector = new StringBuilder();
    private int m_offset = -1;
    private int m_startOffset;
    private int m_lastChar;
    private boolean m_repeatLastCharacter = false;
    private int m_linesOfCode = 0;
    private boolean m_inMultilineString = false;
    private String m_delimiter;
    private int m_nesting = 0;
    private boolean m_isDocString = false;

    private int readNext(Reader reader) {
        int c = -1;
        if (this.m_repeatLastCharacter) {
            this.m_repeatLastCharacter = false;
            c = this.m_lastChar;
        } else {
            try {
                c = reader.read();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_lastChar = c;
        }
        if (c != -1) {
            ++this.m_offset;
        }
        return c;
    }

    private void unread() {
        if (this.m_lastChar != -1) {
            this.m_repeatLastCharacter = true;
            --this.m_offset;
        }
    }

    private int readNextNonWhiteCharacter(Reader reader) {
        int c = this.readNext(reader);
        while (c != -1 && Character.isWhitespace(c)) {
            c = this.readNext(reader);
        }
        if (c != -1) {
            this.m_collector.append((char)c);
        }
        return c;
    }

    private void readUntil(Reader reader, Predicate<Integer> stopCondition) {
        int c = this.readNext(reader);
        while (c != -1 && !stopCondition.test(c)) {
            this.m_collector.append((char)c);
            c = this.readNext(reader);
        }
        if (c != -1) {
            this.unread();
        }
    }

    private void handleString(Reader reader, int delimiter, ISourceLineProcessor.SourceLineVisitor visitor) {
        int next = this.readNext(reader);
        this.m_collector.append((char)next);
        if (next == delimiter) {
            next = this.readNext(reader);
            if (next == delimiter) {
                boolean earlyTermination = false;
                this.m_collector.append((char)delimiter);
                this.m_delimiter = this.m_collector.toString();
                while ((next = this.readNext(reader)) != -1) {
                    this.m_collector.append((char)next);
                    if (this.m_collector.toString().lastIndexOf(this.m_delimiter) < 2) continue;
                    this.processStringLiteral(visitor);
                    visitor.visitEndOfCommentLine();
                    visitor.visitEndOfCodeCommentLine();
                    earlyTermination = true;
                    break;
                }
                if (!earlyTermination) {
                    this.m_inMultilineString = true;
                }
            } else {
                this.unread();
                this.processStringLiteral(visitor);
            }
        } else {
            boolean sawBackslash = next == 92;
            while ((next = this.readNext(reader)) != -1) {
                this.m_collector.append((char)next);
                if (!sawBackslash && next == delimiter) break;
                if (sawBackslash) {
                    sawBackslash = false;
                    continue;
                }
                if (next != 92) continue;
                sawBackslash = true;
            }
            this.processStringLiteral(visitor);
        }
    }

    private void processStringLiteral(ISourceLineProcessor.SourceLineVisitor visitor) {
        if (this.m_isDocString) {
            visitor.visitMultiLineComment(this.m_startOffset, this.m_collector.toString());
            this.m_isDocString = false;
        } else {
            visitor.visitStringLiteral(this.m_startOffset, this.m_collector.toString());
        }
        this.m_collector.setLength(0);
    }

    protected void processLine(String line, ISourceLineProcessor.SourceLineVisitor visitor) {
        boolean lineHasCode = false;
        if (this.m_inMultilineString) {
            int delimPos;
            if (!this.m_isDocString) {
                lineHasCode = true;
            }
            if ((delimPos = line.indexOf(this.m_delimiter)) >= 0) {
                this.m_collector.append(line.substring(0, delimPos + 3));
                this.processStringLiteral(visitor);
                line = line.substring(delimPos + 3);
                this.m_offset += delimPos + 3;
                this.m_inMultilineString = false;
            } else {
                this.m_collector.append(line);
                this.m_offset += line.length();
            }
            if (this.m_isDocString) {
                visitor.visitEndOfCommentLine();
                if (this.m_linesOfCode > 0 || lineHasCode) {
                    visitor.visitEndOfCodeCommentLine();
                }
            }
        }
        if (!this.m_inMultilineString) {
            StringReader reader = new StringReader(line);
            int c = this.readNextNonWhiteCharacter(reader);
            while (c != -1) {
                this.m_startOffset = this.m_offset;
                if (Character.isJavaIdentifierStart(c)) {
                    this.readUntil(reader, ch -> !Character.isJavaIdentifierPart(ch));
                    visitor.visitWord(this.m_startOffset, this.m_collector.toString());
                    this.m_collector.setLength(0);
                    lineHasCode = true;
                } else if (c == 35) {
                    this.readUntil(reader, ch -> ch == -1);
                    visitor.visitSingleLineComment(this.m_startOffset, this.m_collector.toString());
                    this.m_collector.setLength(0);
                    if (this.m_linesOfCode > 0 || lineHasCode) {
                        visitor.visitEndOfCodeCommentLine();
                    }
                    visitor.visitEndOfCommentLine();
                } else if (c == 64) {
                    this.readUntil(reader, ch -> !Character.isJavaIdentifierPart(ch) && ch != 46);
                    visitor.visitAt(this.m_startOffset, this.m_collector.toString());
                    this.m_collector.setLength(0);
                    lineHasCode = true;
                } else if (c == 39) {
                    this.m_isDocString = this.m_nesting == 0 && !lineHasCode;
                    this.handleString(reader, c, visitor);
                    if (!this.m_isDocString) {
                        lineHasCode = true;
                    }
                } else if (c == 34) {
                    this.m_isDocString = this.m_nesting == 0 && !lineHasCode;
                    this.handleString(reader, c, visitor);
                    if (!this.m_isDocString) {
                        lineHasCode = true;
                    }
                } else if (c == 48) {
                    int next = this.readNext(reader);
                    if (next == 120 || next == 88) {
                        this.m_collector.append((char)next);
                        this.readUntil(reader, ch -> !(Character.isDigit(ch) || ch >= 97 && ch <= 102 || ch >= 65 && ch <= 70));
                        visitor.visitOther(this.m_startOffset, this.m_collector.toString());
                        this.m_collector.setLength(0);
                    } else if (Character.isDigit(next)) {
                        this.m_collector.append((char)next);
                        this.readUntil(reader, ch -> !Character.isDigit(ch));
                        visitor.visitOther(this.m_startOffset, this.m_collector.toString());
                        this.m_collector.setLength(0);
                    } else {
                        this.unread();
                        visitor.visitOther(this.m_startOffset, this.m_collector.toString());
                        this.m_collector.setLength(0);
                    }
                    lineHasCode = true;
                } else if (Character.isDigit(c)) {
                    this.readUntil(reader, ch -> !Character.isDigit(ch));
                    visitor.visitOther(this.m_startOffset, this.m_collector.toString());
                    this.m_collector.setLength(0);
                    lineHasCode = true;
                } else if (OPERATOR_CHARS.indexOf(c) >= 0) {
                    this.readUntil(reader, ch -> OPERATOR_CHARS.indexOf((int)ch) == -1);
                    visitor.visitOther(this.m_startOffset, this.m_collector.toString());
                    this.m_collector.setLength(0);
                    lineHasCode = true;
                } else {
                    visitor.visitOther(this.m_startOffset, this.m_collector.toString());
                    this.m_collector.setLength(0);
                    if ("([{".indexOf(c) >= 0) {
                        ++this.m_nesting;
                    } else if (")]}".indexOf(c) >= 0) {
                        --this.m_nesting;
                    }
                    lineHasCode = true;
                }
                c = this.readNextNonWhiteCharacter(reader);
            }
        }
        ++this.m_offset;
        if (lineHasCode) {
            visitor.visitEndOfLine();
            ++this.m_linesOfCode;
        }
        if (this.m_inMultilineString) {
            this.m_collector.append(StringUtility.DEFAULT_LINE_SEPARATOR);
        }
    }

    protected void reset() {
        this.m_offset = -1;
        this.m_repeatLastCharacter = false;
        this.m_linesOfCode = 0;
        this.m_inMultilineString = false;
        this.m_nesting = 0;
        this.m_isDocString = false;
        this.m_collector.setLength(0);
    }
}

