/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.plugin.spotbugs;

import com.hello2morrow.sonargraph.api.INamedElementAccess;
import com.hello2morrow.sonargraph.api.ModelVisitor;
import com.hello2morrow.sonargraph.api.java.IJavaClassFileAccess;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClassFileRegistry
extends ModelVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassFileRegistry.class);
    private final Map<String, IJavaClassFileAccess> m_relPathToClassFile = new HashMap<String, IJavaClassFileAccess>();

    ClassFileRegistry() {
    }

    public void visitNamedElementAccess(INamedElementAccess element) {
        assert (element != null) : "Parameter 'element' of method 'visitNamedElementAccess' must not be null";
        if (element.isExternal() || element.isExcluded() || element.ignoreIssues()) {
            return;
        }
        if (element instanceof IJavaClassFileAccess) {
            IJavaClassFileAccess javaClassFileAccess = (IJavaClassFileAccess)element;
            String classFileName = javaClassFileAccess.getName();
            if (classFileName != null && classFileName.startsWith("./")) {
                String relPath = classFileName.substring(2);
                if (!relPath.isEmpty()) {
                    this.m_relPathToClassFile.put(relPath, javaClassFileAccess);
                } else {
                    LOGGER.warn("Ignoring class file with invalid name '" + classFileName + "'");
                }
            } else {
                LOGGER.warn("Ignoring class file with invalid name '" + classFileName + "'");
            }
            return;
        }
        super.visitNamedElementAccess(element);
    }

    IJavaClassFileAccess getClassFile(String relPath) {
        assert (relPath != null && relPath.length() > 0) : "Parameter 'relPath' of method 'getClassFile' must not be empty";
        return this.m_relPathToClassFile.get(relPath);
    }

    boolean isEmpty() {
        return this.m_relPathToClassFile.isEmpty();
    }
}

