/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.persistence.visualstudio;

import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.XmlUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.CppCauses;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CPlusPlusVsProjectImportDto;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import java.io.File;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class CPlusPlusVsProjectReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(CPlusPlusVsProjectReader.class);
    private final TFile m_file;
    private final TFile m_solutionDir;

    public CPlusPlusVsProjectReader(TFile vsProjectFile, TFile solutionDir) {
        assert (vsProjectFile != null) : "Parameter 'vsProjectFile' of method 'CPlusPlusVsProjectReader' must not be null";
        this.m_file = vsProjectFile;
        this.m_solutionDir = solutionDir;
    }

    public OperationResultWithOutcome<CPlusPlusVsProjectImportDto> process() {
        LOGGER.debug("Processing file {}", (Object)this.m_file.getNormalizedAbsolutePath());
        OperationResultWithOutcome result = new OperationResultWithOutcome("Reading information from Visual Studio C++ project file '" + this.m_file.getNormalizedAbsolutePath() + "'");
        if (!this.m_file.exists()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FILE_NOT_FOUND, "C++ project file '" + this.m_file.getNormalizedAbsolutePath() + "' does not exist", new Object[0]);
            return result;
        }
        CPlusPlusVsProjectImportDto dto = new CPlusPlusVsProjectImportDto(this.m_file, this.m_solutionDir);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (TFileInputStream is = new TFileInputStream((File)this.m_file);){
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser saxParser = factory.newSAXParser();
                CPlusPlusVisualStudioFileProcessor processor = new CPlusPlusVisualStudioFileProcessor(dto, (OperationResultWithOutcome<CPlusPlusVsProjectImportDto>)result);
                saxParser.parse((InputStream)is, (DefaultHandler)processor);
                this.validateDto(dto);
                result.setOutcome((Object)dto);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.READ_ERROR, "Failed to process C# project file '" + this.m_file.getNormalizedAbsolutePath() + "', " + ExceptionUtility.collectFirstAndLast((Throwable)ex), new Object[0]);
        }
        return result;
    }

    private void validateDto(CPlusPlusVsProjectImportDto dto) {
        assert (dto != null) : "Parameter 'dto' of method 'validateDto' must not be null";
        assert (dto.getProjectFile() != null) : "Project file must not be null";
        assert (dto.getProjectGuid() != null && dto.getProjectGuid().trim().length() > 0) : "Project GUID must not be null";
        assert (dto.getProjectName() != null && dto.getProjectName().trim().length() > 0) : "Project name must not be null";
    }

    private static class CPlusPlusVisualStudioFileProcessor
    extends DefaultHandler {
        private static final String CLOSING_BRACE = "}";
        private static final String OPENING_BRACE = "{";
        private static final String SUPPORTED_SCHEMA = "http://schemas.microsoft.com/developer/msbuild/2003";
        private static final String START = "start";
        private static final String PROJECT_ELEMENT = "project";
        private static final String PROJECT_GUID_ELEMENT = "projectguid";
        private static final String PROJECT_NAME_ELEMENT = "projectname";
        private static final String PROJECT_CONFIGURATION_ELEMENT = "projectconfiguration";
        private static final String CONFIGURATION_ELEMENT = "configuration";
        private static final String PLATFORM_ELEMENT = "platform";
        private static final String PROJECT_REFERENCE_ELEMENT = "projectreference";
        private static final String CLINCLUDE_ELEMENT = "clinclude";
        private static final String CUSTOM_BUILD_ELEMENT = "custombuild";
        private static final String INCLUDE_ATTRIBUTE = "include";
        private static final String ITEM_DEFINITION_GROUP_ELEMENT = "itemdefinitiongroup";
        private String m_currentElementName = "start";
        private StringBuilder m_currentValue;
        private final CPlusPlusVsProjectImportDto m_moduleImport;
        private final OperationResultWithOutcome<CPlusPlusVsProjectImportDto> m_result;
        private String m_currentConfiguration;
        private String m_currentPlatform;
        private String m_previousElementName;
        private String m_currentReferencedProjectPath;
        private String m_currentReferencedProjectGuid;

        CPlusPlusVisualStudioFileProcessor(CPlusPlusVsProjectImportDto dto, OperationResultWithOutcome<CPlusPlusVsProjectImportDto> result) {
            assert (dto != null) : "Parameter 'dto' of method 'CPlusPlusVisualStudioFileProcessor' must not be null";
            assert (result != null) : "Parameter 'result' of method 'CPlusPlusVisualStudioFileProcessor' must not be null";
            this.m_moduleImport = dto;
            this.m_result = result;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[7] lbl49 : CaseStatement: default:\u000a, @NONE, blocks:[7] lbl49 : CaseStatement: default:\u000a]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
             *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
             *     at java.base/java.util.TimSort.sort(TimSort.java:220)
             *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
             *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
             *     at java.base/java.util.Collections.sort(Collections.java:178)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            String currentValue = null;
            if (this.m_currentValue != null) {
                currentValue = this.m_currentValue.toString().trim();
            }
            switch (qName.toLowerCase()) {
                case "projectname": {
                    this.m_moduleImport.setProjectName(currentValue);
                    break;
                }
                case "configuration": {
                    this.m_currentConfiguration = currentValue;
                    break;
                }
                case "platform": {
                    this.m_currentPlatform = currentValue;
                    break;
                }
                case "projectconfiguration": {
                    this.m_moduleImport.addConfigurationAndPlatform(this.m_currentConfiguration, this.m_currentPlatform);
                    this.m_currentConfiguration = null;
                    this.m_currentPlatform = null;
                    break;
                }
                case "projectreference": {
                    if (this.m_currentReferencedProjectPath == null || this.m_currentReferencedProjectGuid == null) break;
                    this.m_moduleImport.addVisualStudioProjectReference(FileUtility.convertPathToUniversalForm((String)this.m_currentReferencedProjectPath), this.m_currentReferencedProjectGuid);
                    this.m_currentReferencedProjectPath = null;
                    this.m_currentReferencedProjectGuid = null;
                    break;
                }
                case "project": {
                    assert (currentValue != null) : "currentValue must not be null";
                    if (this.m_previousElementName == null || !this.m_previousElementName.equalsIgnoreCase(PROJECT_REFERENCE_ELEMENT)) break;
                    this.m_currentReferencedProjectGuid = this.appendBracesToGuid(currentValue.toLowerCase().trim());
                    break;
                }
                case "projectguid": {
                    assert (currentValue != null) : "currentValue must not be null";
                    this.m_moduleImport.setProjectGUID(this.appendBracesToGuid(currentValue.toLowerCase().trim()));
                }
            }
        }

        private String appendBracesToGuid(String guid) {
            assert (guid != null) : "Parameter 'guid' of method 'appendBracesToGuid' must not be null";
            Object returnGuid = guid;
            if (!guid.startsWith(OPENING_BRACE)) {
                returnGuid = OPENING_BRACE + guid;
            }
            if (!guid.endsWith(CLOSING_BRACE)) {
                returnGuid = (String)returnGuid + CLOSING_BRACE;
            }
            return returnGuid;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.m_currentElementName.equals(START)) {
                return;
            }
            this.m_currentValue.append(ch, start, length);
        }

        private void handleProject(Attributes attributes) {
            String toolsVersion;
            String xmlns = attributes.getValue("xmlns");
            if (xmlns != null) {
                if (!xmlns.equals(SUPPORTED_SCHEMA)) {
                    this.m_result.addWarning((OperationResult.IMessageCause)CppCauses.VS_PROJECT_FILE_SCHEMA_VERSION_NOT_SUPPORTED, "The detected schema '" + xmlns + "' does not match the supported schema 'http://schemas.microsoft.com/developer/msbuild/2003'", new Object[0]);
                }
            } else {
                LOGGER.warn("No schema detected. Supported schema is 'http://schemas.microsoft.com/developer/msbuild/2003'");
            }
            if ((toolsVersion = XmlUtility.getAttributeValueIgnoreCase((Attributes)attributes, (String)"ToolsVersion")) != null && toolsVersion.trim().length() > 0) {
                this.m_moduleImport.setToolsVersion(toolsVersion);
            }
        }
    }
}

