/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.persistence.system;

import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.element.NameFilter;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.programming.WorkspaceDependency;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.settings.ModuleSettings;
import com.hello2morrow.sonargraph.core.model.system.settings.RootDirectorySettings;
import com.hello2morrow.sonargraph.core.model.system.settings.SolutionFileInfo;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.core.persistence.system.XmlAdditionalInfoProvider;
import com.hello2morrow.sonargraph.core.persistence.system.XsdAbstractModule;
import com.hello2morrow.sonargraph.core.persistence.system.XsdAbstractModuleDependency;
import com.hello2morrow.sonargraph.core.persistence.system.XsdAbstractSystemExtension;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.ResourceProviderRegistry;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.foundation.utilities.SystemEnvSupport;
import com.hello2morrow.sonargraph.integration.access.persistence.XmlPersistenceContext;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.CPlusPlusLanguage;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.CPlusPlusResourceProviderAdapter;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.CppCauses;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CPlusPlusWorkspaceDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.BasePathForIncludes;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CCSpyDirectory;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CPlusPlusInstallationSettings;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CPlusPlusSystemSettings;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CapturingDataFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CommandFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CompilerOptions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CppSourceFileExtensions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ExcludedDirectoryNode;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.GroovyTemplateElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ICompilerOption;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinition;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ModuleCompilerOptions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ModuleOrSystemCompilerOptions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SettingsBuilder;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SystemCompilerOptions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.VisualStudioProjectFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusCMakeJsonModule;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusCaptureModule;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusManualModule;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusModule;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusModuleType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusVsProjectFileBasedModule;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.persistence.system.ObjectFactory;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.persistence.system.XsdCPlusPlusManualWorkspaceDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.persistence.system.XsdCPlusPlusVisualStudioProjectDependency;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.persistence.system.XsdCaptureFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.persistence.system.XsdCmakeJsonModule;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.persistence.system.XsdCppCaptureModule;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.persistence.system.XsdCppManualModule;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.persistence.system.XsdCppModule;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.persistence.system.XsdCppSystemSettings;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.persistence.system.XsdCppVsProjectFileModule;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.persistence.system.XsdModuleCompilerOptions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.persistence.system.XsdRootPathWithFiles;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.persistence.system.XsdSystemCompilerOptions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.persistence.system.XsdVisualStudioProjectConfiguration;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.persistence.system.XsdVisualStudioProjectFile;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class CPlusPlusPersistenceProvider
extends XmlAdditionalInfoProvider {
    public static final String COMMAND_FILE_MD5_PROPERTY_KEY = "cpp.commandFileMd5";
    private final XmlPersistenceContext m_persistenceContext = new XmlPersistenceContext("com.hello2morrow.sonargraph.languageprovider.cplusplus.persistence.system", CPlusPlusResourceProviderAdapter.getInstance().getResourceUrl((ResourceProviderRegistry.IResourceType)ResourceProviderRegistry.ResourceType.XSD, "com/hello2morrow/sonargraph/languageprovider/cplusplus/persistence/system/cplusplusSoftwareSystem"));
    private final List<SystemCompilerOptions> m_systemCompilerOptions = new ArrayList<SystemCompilerOptions>();
    private CPlusPlusSystemSettings m_systemSettings;
    private final Map<String, Set<String>> m_systemOptionsMap = new HashMap<String, Set<String>>();
    private SoftwareSystem m_softwareSystem;
    private boolean m_systemwasMigratedAndNeedsSave = false;

    public CPlusPlusPersistenceProvider(Installation installation) {
        super(installation);
    }

    public XmlPersistenceContext getPersistentContext() {
        return this.m_persistenceContext;
    }

    public boolean systemWasMigratedAndNeedsSave() {
        return this.m_systemwasMigratedAndNeedsSave;
    }

    protected XsdAbstractModule createXmlModule(Module.IModuleType moduleType) {
        assert (moduleType != null) : "Parameter 'moduleType' of method 'createXmlModule' must not be null";
        assert (moduleType instanceof CPlusPlusModuleType) : "Parameter 'moduleType' must be of type '" + String.valueOf(CPlusPlusModuleType.class) + "'";
        CPlusPlusModuleType type = (CPlusPlusModuleType)moduleType;
        if (type == CPlusPlusModuleType.MANUAL) {
            return new ObjectFactory().createXsdCppManualModule();
        }
        if (type == CPlusPlusModuleType.VISUAL_STUDIO_PROJECT_FILE_IMPORT) {
            return new ObjectFactory().createXsdCppVsProjectFileModule();
        }
        if (type == CPlusPlusModuleType.CMAKE_JSON) {
            return new ObjectFactory().createXsdCmakeJsonModule();
        }
        if (type == CPlusPlusModuleType.CAPTURE) {
            return new ObjectFactory().createXsdCppCaptureModule();
        }
        assert (false) : "Unsupported module type '" + type.getStandardName() + "'";
        return null;
    }

    protected void getModuleDetailsFromXml(Installation inst, SoftwareSystem softwareSystem, Module module, XsdAbstractModule moduleXml, OperationResult result) {
        super.getModuleDetailsFromXml(inst, softwareSystem, module, moduleXml, result);
        assert (module instanceof CPlusPlusModule) : "Module must be of type '" + CPlusPlusModule.class.getName() + "'";
        assert (moduleXml instanceof XsdCppModule) : "Xml for module must be of type " + XsdCppModule.class.getName();
        CPlusPlusModule cppModule = (CPlusPlusModule)module;
        Module.IModuleType type = this.getModuleType(moduleXml.getClass());
        assert (type != null) : "module type must be defined for class '" + moduleXml.getClass().getCanonicalName() + "'";
        assert (type instanceof CPlusPlusModuleType) : "Unexpected class: " + type.getClass().getName();
        CPlusPlusModuleType moduleType = (CPlusPlusModuleType)type;
        switch (moduleType) {
            case MANUAL: {
                this.initManualModule(softwareSystem, cppModule, moduleXml);
                break;
            }
            case VISUAL_STUDIO_PROJECT_FILE_IMPORT: {
                this.initVsProjectFileBasedModule(softwareSystem, cppModule, moduleXml);
                break;
            }
            case CMAKE_JSON: {
                this.initCMakeJsonBasedModule(inst, cppModule, moduleXml);
                break;
            }
            case CAPTURE: {
                this.initCMakeJsonBasedModule(inst, cppModule, moduleXml);
                this.initCaptureModule(cppModule, moduleXml, result);
                break;
            }
            default: {
                assert (false) : "Unsupported module type '" + moduleType.getStandardName() + "'";
                break;
            }
        }
        TFile dir = softwareSystem.getDirectoryFile();
        for (XsdCppModule.AssociatedHeader ah : ((XsdCppModule)moduleXml).getAssociatedHeader()) {
            TFile file = new TFile((File)dir, ah.getFileName());
            cppModule.assignAssociatedHeader(file.getNormalizedAbsoluteFile());
        }
    }

    private void initCaptureModule(CPlusPlusModule cppModule, XsdAbstractModule moduleXml, OperationResult result) {
        XsdCppCaptureModule xmlModule = (XsdCppCaptureModule)moduleXml;
        CPlusPlusCaptureModule module = (CPlusPlusCaptureModule)cppModule;
        ModuleSettings moduleSettings = (ModuleSettings)module.getUniqueChild(ModuleSettings.class);
        assert (moduleSettings != null);
        this.initModuleCompilerOptions(moduleSettings);
        XsdCaptureFile captureFile = xmlModule.getCaptureFile();
        if (captureFile != null) {
            result.addError((OperationResult.IMessageCause)CppCauses.OLD_CAPTURING_FILE_NOT_SUPPORTED, "System is based on deprecated capturing file format. Please create new system.", new Object[0]);
        }
    }

    private void initCMakeJsonBasedModule(Installation inst, CPlusPlusModule cppModule, XsdAbstractModule moduleXml) {
        XsdCppModule xmlModule = (XsdCppModule)moduleXml;
        List xmlRoots = xmlModule.getRootPath().stream().filter(r -> r instanceof XsdRootPathWithFiles).map(r -> (XsdRootPathWithFiles)((Object)r)).collect(Collectors.toList());
        if (xmlRoots.isEmpty() && xmlModule instanceof XsdCmakeJsonModule) {
            XsdCmakeJsonModule xmlCMakeModule = (XsdCmakeJsonModule)xmlModule;
            xmlRoots.addAll(xmlCMakeModule.getRootPathWithFiles());
        }
        for (XsdRootPathWithFiles xmlRoot : xmlRoots) {
            RootDirectoryPath root = (RootDirectoryPath)cppModule.getFirstChild((NamedElement.IFilter)new NameFilter(xmlRoot.getName()), RootDirectoryPath.class);
            assert (root != null);
            RootDirectorySettings settings = new RootDirectorySettings((NamedElement)root);
            root.addChild((NamedElement)settings);
            for (XsdRootPathWithFiles.ExcludedDirectory xmlDir : xmlRoot.getExcludedDirectory()) {
                ExcludedDirectoryNode node = new ExcludedDirectoryNode((NamedElement)settings, xmlDir.getDir());
                settings.addChild((NamedElement)node);
            }
            if (xmlRoot.getSourceFile().isEmpty()) continue;
            this.m_systemwasMigratedAndNeedsSave = true;
        }
        ModuleSettings settings = (ModuleSettings)cppModule.getUniqueChild(ModuleSettings.class);
        this.initModuleCompilerOptions(settings);
    }

    private void initVsProjectFileBasedModule(SoftwareSystem softwareSystem, CPlusPlusModule cppModule, XsdAbstractModule moduleXml) {
        String solutionDir;
        XsdCppVsProjectFileModule vsProjectXml = (XsdCppVsProjectFileModule)moduleXml;
        CPlusPlusVsProjectFileBasedModule module = (CPlusPlusVsProjectFileBasedModule)cppModule;
        ModuleSettings moduleSettings = (ModuleSettings)module.getUniqueChild(ModuleSettings.class);
        XsdVisualStudioProjectFile xmlProjectFile = vsProjectXml.getProjectFile();
        TFile projectFile = null;
        String filePath = xmlProjectFile.getFile();
        String resolvedFilePath = SystemEnvSupport.resolveEscaped((String)filePath);
        projectFile = FileUtility.isRelativePath((String)resolvedFilePath) ? new TFile((File)softwareSystem.getDirectoryFile(), resolvedFilePath) : new TFile(resolvedFilePath);
        VisualStudioProjectFile visualStudioProjectFile = new VisualStudioProjectFile((NamedElement)moduleSettings, projectFile);
        if (!filePath.equals(resolvedFilePath)) {
            visualStudioProjectFile.setFilePathWithEnvVars(filePath);
        }
        moduleSettings.addChild((NamedElement)visualStudioProjectFile);
        XsdVisualStudioProjectConfiguration activeConfiguration = xmlProjectFile.getActiveConfiguration();
        if (activeConfiguration != null) {
            visualStudioProjectFile.setConfiguration(new SolutionFileInfo.ConfigurationAndPlatform(activeConfiguration.getConfiguration(), activeConfiguration.getPlatform()));
        }
        if ((solutionDir = xmlProjectFile.getSolutionDir()) != null && solutionDir.trim().length() > 0) {
            if (FileUtility.isAbsolutePath((String)solutionDir)) {
                visualStudioProjectFile.setSolutionDir(new TFile(solutionDir));
            } else {
                TFile baseDir = ((Files)softwareSystem.getUniqueChild(Files.class)).getSystemBaseDirectory();
                visualStudioProjectFile.setSolutionDir(new TFile((File)baseDir, solutionDir));
            }
        }
    }

    private ModuleCompilerOptions initModuleCompilerOptions(ModuleSettings settings) {
        InstCompilerDefinition activeCompilerDefinition = ((CPlusPlusInstallationSettings)((Object)this.getInstallation().getUniqueChild(CPlusPlusInstallationSettings.class))).getActiveCompilerDefinition();
        ModuleCompilerOptions compilerOptions = null;
        if (activeCompilerDefinition != null) {
            compilerOptions = (ModuleCompilerOptions)((Object)settings.getFirstChild(o -> o.getShortName().equals(activeCompilerDefinition.getName()), ModuleCompilerOptions.class));
            if (compilerOptions != null) {
                return compilerOptions;
            }
            compilerOptions = new ModuleCompilerOptions((NamedElement)settings, activeCompilerDefinition.getName());
        } else {
            compilerOptions = new ModuleCompilerOptions((NamedElement)settings);
        }
        settings.addChild((NamedElement)compilerOptions);
        return compilerOptions;
    }

    private void initManualModule(SoftwareSystem softwareSystem, CPlusPlusModule module, XsdAbstractModule moduleXml) {
        XsdCppManualModule xmlCppModule = (XsdCppManualModule)moduleXml;
        CPlusPlusManualModule manualModule = (CPlusPlusManualModule)module;
        ModuleSettings defaultModuleSettings = (ModuleSettings)manualModule.getUniqueChild(ModuleSettings.class);
        manualModule.removeChild((NamedElement)defaultModuleSettings);
        SettingsBuilder settingsBuilder = new SettingsBuilder((NamedElement)manualModule);
        this.m_softwareSystem = softwareSystem;
        settingsBuilder.setCppSourceFileExtensions(xmlCppModule.getSourceFileExtensions());
        String basePathForIncludes = xmlCppModule.getBasePathForIncludes();
        if (basePathForIncludes == null) {
            basePathForIncludes = ".";
        }
        settingsBuilder.setBasePathForIncludes(basePathForIncludes);
        List<XsdModuleCompilerOptions> xmlModuleOptions = xmlCppModule.getModuleCompilerOptions();
        for (XsdModuleCompilerOptions xmlModuleOption : xmlModuleOptions) {
            String ref = xmlModuleOption.getInstallationCompilerDefinitionRef();
            settingsBuilder.addCompilerOptionsText(ref, xmlModuleOption.getValue());
        }
        module.addChild(settingsBuilder.create());
    }

    public void addModuleDetailsToXml(SoftwareSystem softwareSystem, Module module, com.hello2morrow.sonargraph.core.persistence.system.SoftwareSystem systemXml, XsdAbstractModule moduleXml) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'addModuleDetailsToXml' must not be null";
        assert (module != null) : "Parameter 'module' of method 'addModuleDetailsToXml' must not be null";
        assert (systemXml != null) : "Parameter 'systemXml' of method 'addModuleDetailsToXml' must not be null";
        assert (moduleXml != null) : "Parameter 'moduleXml' of method 'addModuleDetailsToXml' must not be null";
        XsdCppModule cppModuleXml = (XsdCppModule)moduleXml;
        if (module.getType() == CPlusPlusModuleType.MANUAL) {
            this.addManualDetailsToXml(module, cppModuleXml);
        } else if (module.getType() == CPlusPlusModuleType.VISUAL_STUDIO_PROJECT_FILE_IMPORT) {
            this.addVisualProjectFileDetailsToXml(module, cppModuleXml);
        } else if (module.getType() == CPlusPlusModuleType.CMAKE_JSON) {
            this.addCMakeJsonDetailsToXml(module, cppModuleXml);
        } else if (module.getType() == CPlusPlusModuleType.CAPTURE) {
            this.addCMakeJsonDetailsToXml(module, cppModuleXml);
            this.addCaptureDetailsToXml(module, cppModuleXml);
        } else assert (false) : "Unsupported module type '" + module.getType().getStandardName() + "'";
        CPlusPlusModule cppModule = (CPlusPlusModule)module;
        TFile dir = softwareSystem.getDirectoryFile();
        for (TFile file : cppModule.getAssociatedHeaders()) {
            String path = FileUtility.calculateRelativePath((TFile)file, (TFile)dir);
            XsdCppModule.AssociatedHeader ah = new XsdCppModule.AssociatedHeader();
            ah.setFileName(path);
            cppModuleXml.getAssociatedHeader().add(ah);
        }
    }

    public void addRootDirectoryPathToXml(XsdAbstractModule xsdModule, Module module, RootDirectoryPath rootDirectoryPath) {
        assert (xsdModule != null) : "Parameter 'xsdModule' of method 'addRootDirectoryPathToXml' must not be null";
        assert (module != null) : "Parameter 'module' of method 'addRootDirectoryPathToXml' must not be null";
        assert (rootDirectoryPath != null) : "Parameter 'rootDirectoryPath' of method 'createXsdRootDirectoryPath' must not be null";
        if (!(module instanceof CPlusPlusCMakeJsonModule)) {
            super.addRootDirectoryPathToXml(xsdModule, module, rootDirectoryPath);
        }
    }

    private void addCaptureDetailsToXml(Module cppModule, XsdCppModule cppModuleXml) {
        XsdCppCaptureModule xmlModule = (XsdCppCaptureModule)cppModuleXml;
        CPlusPlusCaptureModule module = (CPlusPlusCaptureModule)cppModule;
        ModuleSettings moduleSettings = (ModuleSettings)module.getUniqueChild(ModuleSettings.class);
        assert (moduleSettings != null);
        CapturingDataFile fileNode = (CapturingDataFile)((Object)moduleSettings.getUniqueChild(CapturingDataFile.class));
        if (fileNode != null) {
            fileNode.getFile().delete();
            fileNode.remove();
        }
        xmlModule.setCaptureFile(null);
    }

    private void addCMakeJsonDetailsToXml(Module cppModule, XsdCppModule cppModuleXml) {
        XsdCppModule xmlModule = cppModuleXml;
        CPlusPlusCMakeJsonModule module = (CPlusPlusCMakeJsonModule)cppModule;
        List xmlRoots = xmlModule.getRootPath();
        ObjectFactory factory = new ObjectFactory();
        for (RootDirectoryPath root : module.getChildren(RootDirectoryPath.class)) {
            RootDirectorySettings settings = (RootDirectorySettings)root.getFirstChild(RootDirectorySettings.class);
            if (settings == null) continue;
            XsdRootPathWithFiles xmlRoot = factory.createXsdRootPathWithFiles();
            xmlRoots.add(xmlRoot);
            xmlRoot.setName(root.getName());
            List<XsdRootPathWithFiles.ExcludedDirectory> dirList = xmlRoot.getExcludedDirectory();
            for (ExcludedDirectoryNode exclDir : settings.getChildren(ExcludedDirectoryNode.class)) {
                XsdRootPathWithFiles.ExcludedDirectory xmlDir = factory.createXsdRootPathWithFilesExcludedDirectory();
                dirList.add(xmlDir);
                xmlDir.setDir(exclDir.getName());
            }
        }
    }

    private void addVisualProjectFileDetailsToXml(Module module, XsdCppModule cppModuleXml) {
        XsdCppVsProjectFileModule xmlVsModule = (XsdCppVsProjectFileModule)cppModuleXml;
        xmlVsModule.getRootPath().clear();
        ModuleSettings settings = (ModuleSettings)module.getUniqueExistingChild(ModuleSettings.class);
        VisualStudioProjectFile projectFile = (VisualStudioProjectFile)((Object)settings.getUniqueExistingChild(VisualStudioProjectFile.class));
        XsdVisualStudioProjectFile xmlProjectFile = new XsdVisualStudioProjectFile();
        if (projectFile.getFilePathWithEnvVars() != null) {
            xmlProjectFile.setFile(projectFile.getFilePathWithEnvVars());
        } else {
            xmlProjectFile.setFile(projectFile.getName());
        }
        XsdVisualStudioProjectConfiguration projectConfiguration = new XsdVisualStudioProjectConfiguration();
        SolutionFileInfo.ConfigurationAndPlatform configuration = projectFile.getConfiguration();
        projectConfiguration.setConfiguration(configuration.getConfiguration());
        projectConfiguration.setPlatform(configuration.getPlatform());
        xmlProjectFile.setActiveConfiguration(projectConfiguration);
        TFile solutionDir = projectFile.getSolutionDir();
        if (solutionDir != null) {
            TFile baseDir = ((Files)((SoftwareSystem)module.getParent(SoftwareSystem.class, new Class[0])).getUniqueChild(Files.class)).getSystemBaseDirectory();
            xmlProjectFile.setSolutionDir(FileUtility.calculateRelativePath((TFile)solutionDir, (TFile)baseDir));
        }
        xmlVsModule.setProjectFile(xmlProjectFile);
    }

    private void addManualDetailsToXml(Module module, XsdCppModule moduleXml) {
        BasePathForIncludes basePathIncludes;
        String basePathString;
        XsdCppManualModule xmlManualModule = (XsdCppManualModule)moduleXml;
        ModuleSettings moduleSettings = (ModuleSettings)module.getUniqueChild(ModuleSettings.class);
        CppSourceFileExtensions cppExtensions = (CppSourceFileExtensions)((Object)moduleSettings.getUniqueChild(CppSourceFileExtensions.class));
        if (cppExtensions != null) {
            String cppExtensionsString = cppExtensions.toString();
            xmlManualModule.setSourceFileExtensions(cppExtensionsString);
        }
        if (!(basePathString = (basePathIncludes = (BasePathForIncludes)((Object)moduleSettings.getUniqueChild(BasePathForIncludes.class))).getName()).equals(".")) {
            xmlManualModule.setBasePathForIncludes(basePathString);
        }
        for (ModuleCompilerOptions options : moduleSettings.getChildren(ModuleCompilerOptions.class)) {
            if (!options.hasChildren(false, new Class[]{ICompilerOption.class})) continue;
            XsdModuleCompilerOptions xmlOptions = new ObjectFactory().createXsdModuleCompilerOptions();
            xmlManualModule.getModuleCompilerOptions().add(xmlOptions);
            xmlOptions.setInstallationCompilerDefinitionRef(options.getName());
            GroovyTemplateElement template = (GroovyTemplateElement)((Object)options.getUniqueChild(GroovyTemplateElement.class));
            if (template == null) continue;
            xmlOptions.setValue(template.getTemplateText());
        }
    }

    public Language getLanguage() {
        return CPlusPlusLanguage.INSTANCE;
    }

    public void addSystemDetailsToXml(SoftwareSystem softwareSystem, com.hello2morrow.sonargraph.core.persistence.system.SoftwareSystem systemXml) {
        super.addSystemDetailsToXml(softwareSystem, systemXml);
        CPlusPlusSystemSettings settings = (CPlusPlusSystemSettings)((Object)((Workspace)softwareSystem.getUniqueExistingChild(Workspace.class)).getFirstChild(CPlusPlusSystemSettings.class));
        if (settings != null) {
            CppSourceFileExtensions exts;
            CommandFile commandFile = (CommandFile)((Object)settings.getFirstChild(CommandFile.class));
            CCSpyDirectory ccspyDir = (CCSpyDirectory)((Object)settings.getFirstChild(CCSpyDirectory.class));
            ObjectFactory factory = new ObjectFactory();
            XsdCppSystemSettings xmlSettings = factory.createXsdCppSystemSettings();
            boolean added = false;
            xmlSettings.setLanguage(CPlusPlusLanguage.INSTANCE.getStandardName());
            if (commandFile != null || !settings.getChildren(CompilerOptions.class).isEmpty()) {
                if (commandFile != null) {
                    xmlSettings.setJsonFile(commandFile.getName());
                }
                systemXml.getSystemExtension().add(xmlSettings);
                added = true;
            }
            if (ccspyDir != null) {
                xmlSettings.setCcspyDir(ccspyDir.getName());
                if (!added) {
                    systemXml.getSystemExtension().add(xmlSettings);
                }
            }
            if ((exts = (CppSourceFileExtensions)((Object)settings.getFirstChild(CppSourceFileExtensions.class))) != null) {
                xmlSettings.setSourceFileExtensions(exts.toString());
            }
            List<XsdSystemCompilerOptions> optionList = xmlSettings.getSystemCompilerOptions();
            for (ModuleOrSystemCompilerOptions options : settings.getChildren(SystemCompilerOptions.class)) {
                if (!options.hasChildren(false, new Class[]{ICompilerOption.class})) continue;
                XsdSystemCompilerOptions opts = factory.createXsdSystemCompilerOptions();
                optionList.add(opts);
                opts.setInstallationCompilerDefinitionRef(options.getShortName());
                GroovyTemplateElement template = (GroovyTemplateElement)((Object)options.getUniqueChild(GroovyTemplateElement.class));
                if (template == null) continue;
                opts.setValue(template.getTemplateText());
            }
        }
    }

    private void initSystemSettings(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'initSystemSettings' must not be null";
        Workspace ws = (Workspace)softwareSystem.getUniqueExistingChild(Workspace.class);
        this.m_systemSettings = (CPlusPlusSystemSettings)((Object)ws.getFirstChild(CPlusPlusSystemSettings.class));
        if (this.m_systemSettings == null) {
            this.m_systemSettings = new CPlusPlusSystemSettings((NamedElement)ws);
            ws.addChild((NamedElement)this.m_systemSettings);
        }
    }

    public void getSystemDetailsFromXml(SoftwareSystem softwareSystem, XsdAbstractSystemExtension systemExtension, OperationResult result) {
        super.getSystemDetailsFromXml(softwareSystem, systemExtension, result);
        this.m_softwareSystem = softwareSystem;
        if (systemExtension instanceof XsdCppSystemSettings) {
            String cppExtensions;
            XsdCppSystemSettings xmlSettings;
            if (this.m_systemSettings == null) {
                this.initSystemSettings(softwareSystem);
            }
            if ((xmlSettings = (XsdCppSystemSettings)systemExtension).getJsonFile() != null) {
                this.m_systemSettings.addChild((NamedElement)new CommandFile((NamedElement)this.m_systemSettings, xmlSettings.getJsonFile()));
            }
            if (xmlSettings.getCcspyDir() != null) {
                this.m_systemSettings.addChild((NamedElement)new CCSpyDirectory((NamedElement)this.m_systemSettings, xmlSettings.getCcspyDir()));
            }
            if ((cppExtensions = xmlSettings.getSourceFileExtensions()) != null && !cppExtensions.isEmpty()) {
                this.m_systemSettings.addChild(new CppSourceFileExtensions((NamedElement)this.m_systemSettings, new HashSet<String>(StringUtility.splitAndTrim((String)cppExtensions, (String)","))));
            }
            List<XsdSystemCompilerOptions> optionList = xmlSettings.getSystemCompilerOptions();
            for (XsdSystemCompilerOptions xmlSystemCompilerOptions : optionList) {
                SystemCompilerOptions opts = new SystemCompilerOptions((NamedElement)this.m_systemSettings, xmlSystemCompilerOptions.getInstallationCompilerDefinitionRef());
                this.m_systemSettings.addChild((NamedElement)opts);
                this.m_systemCompilerOptions.add(opts);
                GroovyTemplateElement template = new GroovyTemplateElement((NamedElement)opts, "Options", xmlSystemCompilerOptions.getValue());
                opts.addChild(template);
                opts.addOptions(StringUtility.multiLineStringToList((String)template.getResolvedText()));
            }
        }
    }

    protected void cleanup() {
        if (!this.m_systemOptionsMap.isEmpty()) {
            if (this.m_systemSettings == null) {
                this.initSystemSettings(this.m_softwareSystem);
            }
            for (String compilerId : this.m_systemOptionsMap.keySet()) {
                SystemCompilerOptions systemOptions = (SystemCompilerOptions)((Object)this.m_systemSettings.getFirstChild(s -> s.getShortName().equals(compilerId), SystemCompilerOptions.class));
                if (systemOptions == null) {
                    systemOptions = new SystemCompilerOptions((NamedElement)this.m_systemSettings, compilerId);
                    this.m_systemSettings.addChild((NamedElement)systemOptions);
                }
                Set<String> options = this.m_systemOptionsMap.get(compilerId);
                String optionText = StringUtility.concat(options, (String)"\n") + "\n";
                if (options.isEmpty()) continue;
                GroovyTemplateElement template = new GroovyTemplateElement((NamedElement)systemOptions, "Options", optionText);
                systemOptions.addChild(template);
                systemOptions.addOptions(options);
            }
        }
        this.m_systemCompilerOptions.clear();
        this.m_systemOptionsMap.clear();
        this.m_systemSettings = null;
        this.m_softwareSystem = null;
        super.cleanup();
    }

    protected XsdAbstractModuleDependency createWorkspaceDependency(Module origin, WorkspaceDependency dependency) {
        assert (origin != null) : "Parameter 'origin' of method 'createWorkspaceDependency' must not be null";
        assert (dependency != null) : "Parameter 'dependency' of method 'createWorkspaceDependency' must not be null";
        assert (dependency.getType() instanceof CPlusPlusWorkspaceDependency.DependencyType) : "Unexpected class: " + dependency.getType().getClass().getName();
        CPlusPlusWorkspaceDependency.DependencyType dependencyType = (CPlusPlusWorkspaceDependency.DependencyType)dependency.getType();
        switch (dependencyType) {
            case MANUAL_DEPENDENCY: {
                return new ObjectFactory().createXsdCPlusPlusManualWorkspaceDependency();
            }
            case VISUAL_STUDIO_PROJECT_DEPENDENCY: {
                return new ObjectFactory().createXsdCPlusPlusVisualStudioProjectDependency();
            }
        }
        assert (false) : "type '" + dependencyType.getStandardName() + "' is not yet supported";
        return null;
    }

    public WorkspaceDependency.IWorkspaceDependencyType getWorkspaceDependencyType(Class<? extends XsdAbstractModuleDependency> clazz) {
        assert (clazz != null) : "Parameter 'clazz' of method 'getWorkspaceDependencyType' must not be null";
        if (clazz.equals(XsdCPlusPlusManualWorkspaceDependency.class)) {
            return CPlusPlusWorkspaceDependency.DependencyType.MANUAL_DEPENDENCY;
        }
        if (clazz.equals(XsdCPlusPlusVisualStudioProjectDependency.class)) {
            return CPlusPlusWorkspaceDependency.DependencyType.VISUAL_STUDIO_PROJECT_DEPENDENCY;
        }
        assert (false) : "No workspace dependency type defined for class '" + clazz.getCanonicalName() + "'";
        return null;
    }

    public Module.IModuleType getModuleType(Class<? extends XsdAbstractModule> clazz) {
        assert (clazz != null) : "Parameter 'clazz' of method 'getModuleType' must not be null";
        if (clazz.equals(XsdCppManualModule.class)) {
            return CPlusPlusModuleType.MANUAL;
        }
        if (clazz.equals(XsdCppVsProjectFileModule.class)) {
            return CPlusPlusModuleType.VISUAL_STUDIO_PROJECT_FILE_IMPORT;
        }
        if (clazz.equals(XsdCmakeJsonModule.class)) {
            return CPlusPlusModuleType.CMAKE_JSON;
        }
        if (clazz.equals(XsdCppCaptureModule.class)) {
            return CPlusPlusModuleType.CAPTURE;
        }
        assert (false) : "No module type defined for class '" + clazz.getCanonicalName() + "'";
        return null;
    }
}

