/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.parser;

import com.hello2morrow.sonargraph.core.controller.system.LanguageProvider;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.ElementWithIssues;
import com.hello2morrow.sonargraph.core.model.element.IModelServiceProvider;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.path.DirectoryFragment;
import com.hello2morrow.sonargraph.core.model.path.IDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.External;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.collections.MultipleValueMap;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components.ComponentAnalyzer;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.components.ComponentRemovalVisitor;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.parser.ErrorMessage;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.system.parser.ParserLog;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.CPlusPlusIssueId;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.CPlusPlusIssueWithDescriptionLineAndColumn;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.InternalCppError;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.MultipleDefinitionsIssue;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.NonHeaderDeclaration;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.element.ParsingResultIssue;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppDirectoryFragment;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppExternalHeaderFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppHeader;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppHeaderFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppIncludeDirectory;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppParserLogSourceFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppSource;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.path.CppSourceFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppClassStructUnion;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppClassStructUnionDeclaration;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppClassStructUnionDefinition;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppRoutine;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppRoutineDefinition;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.CppVariable;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.ICppNamespaceMember;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.programming.ICppProgrammingElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusExternal;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusInternalHeaders;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusParserLogSourceRoot;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParserContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParserContext.class);
    private final MultipleValueMap<String, CppHeader> m_headerMap = new MultipleValueMap();
    private final Map<String, CppSourceFile> m_sourceMap = new THashMap(2048);
    private final LanguageProvider m_languageProvider;
    private final SoftwareSystem m_softwareSystem;
    private final Set<CppRoutine> m_undefinedRoutines = new HashSet<CppRoutine>();
    private final Set<CppVariable> m_undefinedVariables = new HashSet<CppVariable>();
    private final Set<CppClassStructUnionDeclaration> m_undefinedClasses = new HashSet<CppClassStructUnionDeclaration>();
    private final MultipleValueMap<String, ProgrammingElement> m_linkTable = new MultipleValueMap();
    private final Map<String, CppIncludeDirectory> m_systemIncludes = new HashMap<String, CppIncludeDirectory>();
    private final Set<CppHeaderFile> m_projectHeaders = new LinkedHashSet<CppHeaderFile>();
    private final List<CppSourceFile> m_projectSources = new ArrayList<CppSourceFile>();
    private final ParserLog m_parserLog = new ParserLog();
    private CPlusPlusInternalHeaders m_internalHeaderRoot;
    private OperationResult m_result;
    private final boolean m_fileNamesAreCaseSensitive = Platform.isCaseSensitive();
    private final List<TFile> m_scmRoots;
    private final List<CppHeader> m_externals = new ArrayList<CppHeader>();

    public ParserContext(LanguageProvider languageProvider, SoftwareSystem system, List<TFile> scmRoots) {
        assert (languageProvider != null) : "Parameter 'languageProvider' of method 'ParserContext' must not be null";
        assert (system != null) : "Parameter 'system' of method 'ParserContext' must not be null";
        this.m_languageProvider = languageProvider;
        this.m_softwareSystem = system;
        this.m_scmRoots = scmRoots;
        Workspace workspace = (Workspace)system.getUniqueExistingChild(Workspace.class);
        CPlusPlusInternalHeaders internalHeaders = (CPlusPlusInternalHeaders)((Object)workspace.getUniqueChild(CPlusPlusInternalHeaders.class));
        if (internalHeaders != null) {
            this.m_internalHeaderRoot = internalHeaders;
        } else {
            this.m_internalHeaderRoot = new CPlusPlusInternalHeaders((NamedElement)workspace);
            workspace.addChild((NamedElement)this.m_internalHeaderRoot);
        }
        CPlusPlusParserLogSourceRoot parserLogRoot = (CPlusPlusParserLogSourceRoot)((Object)workspace.getUniqueChild(CPlusPlusParserLogSourceRoot.class));
        if (parserLogRoot != null) {
            parserLogRoot.remove();
        }
        this.m_softwareSystem.getParserModel().removeElementIssues(new IIssueId[]{CPlusPlusIssueId.CPP_PARSER_ERROR, CPlusPlusIssueId.INTERNAL_ERROR});
        ComponentRemovalVisitor componentRemover = new ComponentRemovalVisitor(this.m_softwareSystem);
        workspace.accept((NamedElement.INamedElementVisitor)componentRemover);
        this.m_projectSources.addAll(componentRemover.getProjectSources());
        this.m_projectHeaders.addAll(componentRemover.getProjectHeaders());
    }

    public final SoftwareSystem getSoftwareSystem() {
        return this.m_softwareSystem;
    }

    public OperationResult getResult() {
        assert (this.m_result != null);
        return this.m_result;
    }

    public void setResult(OperationResult result) {
        this.m_result = result;
    }

    private final void checkForBadlyPlacedDeclarations(ProgrammingElement decl, ProgrammingElement def) {
        assert (decl != null) : "Parameter 'decl' of method 'checkForBadlyPlacedDeclarations' must not be null";
        CppSourceFile sourceFile = (CppSourceFile)((Object)decl.getParent(CppSourceFile.class, new Class[0]));
        if (sourceFile != null && def.getParent(CppSource.class, new Class[0]) != sourceFile) {
            this.m_softwareSystem.getParserModel().addElementIssue((ElementWithIssues)decl, (Issue)new NonHeaderDeclaration((NamedElement)decl));
        }
    }

    public void addSourceFile(CppSourceFile source) {
        this.m_projectSources.add(source);
        String path = source.getFile().getNormalizedAbsolutePath();
        if (!this.m_fileNamesAreCaseSensitive) {
            path = path.toLowerCase();
        }
        this.m_sourceMap.put(path, source);
    }

    private void link() {
        ICppNamespaceMember def;
        ICppNamespaceMember definition;
        for (CppVariable var : this.m_undefinedVariables) {
            if (var.isExternal()) continue;
            definition = null;
            for (ProgrammingElement candidate : this.m_linkTable.get((Object)var.getName())) {
                if (candidate == var || !(candidate instanceof CppVariable)) continue;
                def = (CppVariable)candidate;
                var.addDefinition((CppVariable)def);
                definition = def;
                break;
            }
            this.m_softwareSystem.getParserModel().removeElementIssues((ElementWithIssues)var, new IIssueId[]{CPlusPlusIssueId.NON_HEADER_DECLARATION});
            if (definition == null) continue;
            this.checkForBadlyPlacedDeclarations(var, (ProgrammingElement)definition);
        }
        for (CppRoutine routine : this.m_undefinedRoutines) {
            if (routine.isExternal()) continue;
            definition = null;
            for (ProgrammingElement candidate : this.m_linkTable.get((Object)routine.getName())) {
                if (!(candidate instanceof CppRoutineDefinition)) continue;
                def = (CppRoutineDefinition)candidate;
                routine.addDefinition((CppRoutine)def);
                definition = candidate;
                break;
            }
            this.m_softwareSystem.getParserModel().removeElementIssues((ElementWithIssues)routine, new IIssueId[]{CPlusPlusIssueId.NON_HEADER_DECLARATION});
            if (definition == null) continue;
            this.checkForBadlyPlacedDeclarations((ProgrammingElement)routine, (ProgrammingElement)definition);
        }
    }

    private final void onParsingSuccess() {
        this.link();
        List<CppHeaderFile> invalidHeaders = this.m_projectHeaders.stream().filter(h -> !h.isValid()).collect(Collectors.toList());
        this.m_projectHeaders.removeAll(invalidHeaders);
        invalidHeaders.forEach(h -> h.remove());
        List<CppSourceFile> invalidSources = this.m_projectSources.stream().filter(s -> s.getParent(IDirectoryPath.class, new Class[0]) == null || !s.isValid()).collect(Collectors.toList());
        this.m_projectSources.removeAll(invalidSources);
        invalidSources.forEach(s -> s.remove());
        ComponentAnalyzer.createComponents(this.m_softwareSystem, this.m_projectHeaders, this.m_projectSources);
        block0: for (CppClassStructUnionDeclaration cppClassStructUnionDeclaration : this.m_undefinedClasses) {
            for (ProgrammingElement candidate : this.m_linkTable.get((Object)cppClassStructUnionDeclaration.getName())) {
                if (!(candidate instanceof CppClassStructUnionDefinition)) continue;
                cppClassStructUnionDeclaration.addDefinition((CppClassStructUnionDefinition)candidate);
                continue block0;
            }
        }
        this.m_softwareSystem.getCurrentModel().removeElementIssues(new IIssueId[]{CPlusPlusIssueId.MULTIPLE_DEFINITIONS});
        for (String string : this.m_linkTable.keySet()) {
            List pes = this.m_linkTable.get((Object)string);
            if (pes.size() <= 1) continue;
            for (ProgrammingElement pe : pes) {
                CppClassStructUnion csu;
                if (!(pe instanceof CppClassStructUnion) || (csu = (CppClassStructUnion)pe).isTemplate()) continue;
                pe.addIssue((Issue)new MultipleDefinitionsIssue((NamedElement)pe));
            }
        }
        for (RootDirectoryPath rootDirectoryPath : this.m_systemIncludes.values()) {
            if (rootDirectoryPath.hasChildren()) continue;
            rootDirectoryPath.remove();
        }
    }

    public void reset() {
        if (this.m_internalHeaderRoot != null) {
            this.m_internalHeaderRoot.remove();
            this.m_internalHeaderRoot = null;
        }
    }

    public void logErrorMessage(ErrorMessage msg) {
        this.m_parserLog.logMessage(msg);
    }

    public final void processParserLog() {
        List<ErrorMessage> messages = this.m_parserLog.getMessages();
        if (messages.isEmpty()) {
            return;
        }
        ElementWithIssues.IIssueManager manager = this.m_softwareSystem.getIssueManager();
        HashMap<String, CppParserLogSourceFile> fileMap = new HashMap<String, CppParserLogSourceFile>();
        Workspace workspace = (Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class);
        CPlusPlusParserLogSourceRoot parserLogRoot = new CPlusPlusParserLogSourceRoot((NamedElement)workspace);
        workspace.addChild((NamedElement)parserLogRoot);
        for (ErrorMessage msg : this.m_parserLog.getMessages()) {
            String fileName = msg.getFileName();
            if (fileName.trim().length() == 0) continue;
            CppParserLogSourceFile parserLogFile = (CppParserLogSourceFile)((Object)fileMap.get(fileName));
            if (parserLogFile == null) {
                parserLogFile = new CppParserLogSourceFile((NamedElement)parserLogRoot, fileName);
                parserLogRoot.addChild((NamedElement)parserLogFile);
                if (parserLogFile.getFile().exists()) {
                    parserLogFile.setTimestamp(parserLogFile.getFile().lastModified());
                }
                fileMap.put(fileName, parserLogFile);
            }
            CPlusPlusIssueWithDescriptionLineAndColumn issue = msg.getCategory().equals("Internal") ? new InternalCppError((NamedElement)parserLogFile, msg.getCategory() + ": " + msg.getMessage(), msg.getLineNumber(), msg.getColumn()) : new ParsingResultIssue((NamedElement)parserLogFile, msg.getCategory() + ": " + msg.getMessage(), msg.getLineNumber(), msg.getColumn());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(parserLogFile.getName() + ": " + issue.toString());
            }
            manager.addElementIssue((ElementWithIssues)parserLogFile, (Issue)issue);
        }
    }

    public final void parsingFinished(boolean success) {
        if (success) {
            this.onParsingSuccess();
            assert (!this.m_internalHeaderRoot.hasChildren());
        } else {
            Workspace ws = (Workspace)this.m_softwareSystem.getUniqueChild(Workspace.class);
            for (CppSourceFile nextSourceFile : ws.getChildrenRecursively(CppSourceFile.class, new Class[0])) {
                nextSourceFile.setTimestamp(1L);
                nextSourceFile.forgetChildren(true);
            }
            ((CPlusPlusExternal)((Object)ws.getUniqueChild(CPlusPlusExternal.class))).forgetChildren(true);
            ws.getChildrenRecursively(CppHeader.class, new Class[0]).forEach(header -> header.remove());
        }
        this.reset();
    }

    public void addDefinition(String fullName, ProgrammingElement def) {
        this.m_linkTable.putIfNotPresent((Object)fullName, (Object)def);
    }

    public void addUndefinedRoutine(CppRoutine r) {
        if (r.isValid() && !r.isExternal()) {
            this.m_undefinedRoutines.add(r);
        }
    }

    public void addUndefinedVariable(CppVariable v) {
        if (v.isValid() && !v.isExternal()) {
            this.m_undefinedVariables.add(v);
        }
    }

    public void addUndefinedClass(CppClassStructUnionDeclaration c) {
        if (c.isValid()) {
            this.m_undefinedClasses.add(c);
        }
    }

    public final void setSystemIncludeDirectories(Collection<TFile> systemIncludes) {
        External externalNode = (External)((Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class)).getUniqueChild(CPlusPlusExternal.class);
        for (TFile dirFile : systemIncludes) {
            String path = dirFile.getNormalizedAbsolutePath();
            CppIncludeDirectory includeDir = this.m_systemIncludes.get(path);
            if (includeDir != null) continue;
            includeDir = new CppIncludeDirectory((IModelServiceProvider)this.m_softwareSystem, (NamedElement)externalNode, dirFile, true);
            externalNode.addChild((NamedElement)includeDir);
            this.m_systemIncludes.put(path, includeDir);
        }
    }

    public final CppHeader getHeader(String fileName, Set<String> keys, String includerName, int line) {
        String fileNameKey = this.m_fileNamesAreCaseSensitive ? fileName : fileName.toLowerCase();
        List headers = this.m_headerMap.get((Object)fileNameKey);
        CppHeader header = null;
        for (CppHeader h : headers) {
            if (keys.isEmpty()) {
                header = h;
                break;
            }
            KeyCollector collector = new KeyCollector();
            h.accept((NamedElement.INamedElementVisitor)collector);
            if (collector.m_keySet.isEmpty() || !keys.stream().anyMatch(k -> keyCollector.m_keySet.contains(k))) continue;
            header = h;
            break;
        }
        if (header == null) {
            TFile file = new TFile(fileName);
            TFile parent = file.getParentFile();
            CppIncludeDirectory parentDir = null;
            for (CppIncludeDirectory dir : this.m_systemIncludes.values()) {
                if (!dir.isOwnerOf(parent) || parentDir != null && dir.getName().length() <= parentDir.getName().length()) continue;
                parentDir = dir;
            }
            if (parentDir != null) {
                header = parentDir.getExternalHeader((IModelServiceProvider)this.m_softwareSystem, file);
            } else if (file.exists()) {
                boolean isExternal = false;
                if (!this.m_scmRoots.isEmpty()) {
                    isExternal = true;
                    for (TFile scmRoot : this.m_scmRoots) {
                        if (!scmRoot.isParentOf((File)file)) continue;
                        isExternal = false;
                        break;
                    }
                }
                if (isExternal) {
                    header = new CppExternalHeaderFile((IModelServiceProvider)this.m_softwareSystem, null, file);
                    this.m_externals.add(header);
                } else {
                    if (this.m_sourceMap.get(fileNameKey) != null) {
                        String msg = String.format("Source file '%s' is incuded from '%s':%d!", fileNameKey, includerName, line);
                        ErrorMessage errorMsg = new ErrorMessage("Potential Error", msg, includerName, line, 0);
                        this.logErrorMessage(errorMsg);
                        LOGGER.warn(errorMsg.toString());
                    }
                    header = new CppHeaderFile((IModelServiceProvider)this.m_softwareSystem, (NamedElement)this.m_internalHeaderRoot, file);
                    this.m_internalHeaderRoot.addChild((NamedElement)header);
                    if (headers.size() == 0) {
                        this.m_languageProvider.processAddedOrChangedSourceFile((SourceFile)header);
                    }
                    this.m_projectHeaders.add((CppHeaderFile)header);
                }
            }
            if (header != null) {
                if (headers.size() > 0) {
                    header.setSerialNumber(headers.size());
                }
                this.m_headerMap.put((Object)fileNameKey, (Object)header);
            }
        } else if (header.getTimestamp() != header.getFile().lastModified()) {
            this.m_languageProvider.processAddedOrChangedSourceFile((SourceFile)header);
            header.setTimestamp(header.getFile().lastModified());
        }
        return header;
    }

    private IDirectoryPath getDirectoryFragmentFor(CppIncludeDirectory root, TFile primaryDir) {
        assert (root != null) : "Parameter 'root' of method 'getDirectoryFragmentFor' must not be null";
        assert (primaryDir != null);
        String relPath = FileUtility.calculateRelativePath((TFile)primaryDir, (TFile)root.getFile());
        return DirectoryFragment.getDirectoryFragmentOrSpecifiedParent((IModelServiceProvider)this.m_softwareSystem, (IDirectoryPath)root, (String)relPath, (DirectoryFragment.IDirectoryFragmentCreator)new DirectoryFragment.IDirectoryFragmentCreator(){

            public DirectoryFragment create(IModelServiceProvider msp, NamedElement parent, String name) {
                return new CppDirectoryFragment(msp, parent, name);
            }
        });
    }

    public void processExternals() {
        if (!this.m_scmRoots.isEmpty()) {
            External externalNode = (External)((Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class)).getUniqueChild(CPlusPlusExternal.class);
            Set dirs = this.m_externals.stream().map(f -> f.getFile().getParentFile()).collect(Collectors.toSet());
            THashSet reducedSet = new THashSet();
            ArrayList<CppIncludeDirectory> incDirs = new ArrayList<CppIncludeDirectory>();
            incDirs.addAll(externalNode.getChildren(CppIncludeDirectory.class));
            for (TFile dir : dirs) {
                if (dirs.stream().anyMatch(d -> d.isParentOf((File)dir)) || incDirs.stream().anyMatch(d -> d.getDirectoryFile().isParentOf((File)dir))) continue;
                reducedSet.add(dir);
            }
            THashMap incDirMap = new THashMap();
            incDirs.addAll(externalNode.getChildren(CppIncludeDirectory.class));
            incDirs.forEach(arg_0 -> ParserContext.lambda$9((Map)incDirMap, arg_0));
            for (TFile incDir : reducedSet) {
                CppIncludeDirectory dir = (CppIncludeDirectory)((Object)incDirMap.get(incDir));
                if (dir != null) continue;
                dir = new CppIncludeDirectory((IModelServiceProvider)this.m_softwareSystem, (NamedElement)externalNode, incDir, true);
                externalNode.addChild((NamedElement)dir);
                incDirs.add(dir);
            }
            for (CppHeader header : this.m_externals) {
                CppIncludeDirectory parentDir = incDirs.stream().filter(d -> d.getDirectoryFile().isParentOf((File)header.getFile())).findFirst().orElse(null);
                assert (parentDir != null);
                NamedElement headerParent = this.getDirectoryFragmentFor(parentDir, header.getFile().getParentFile()).getNamedElement();
                header.setParent(headerParent);
                headerParent.addChild((NamedElement)header);
            }
            this.m_externals.clear();
        }
    }

    private static /* synthetic */ void lambda$9(Map map, CppIncludeDirectory d) {
        CppIncludeDirectory cppIncludeDirectory = map.put(d.getDirectoryFile(), d);
    }

    private class KeyCollector
    extends NamedElementVisitor {
        Set<String> m_keySet = new THashSet();

        private KeyCollector() {
        }

        public void visitNamedElement(NamedElement element) {
            if (element instanceof ICppProgrammingElement) {
                ICppProgrammingElement cppElement = (ICppProgrammingElement)element;
                if (cppElement.isRealElement()) {
                    this.m_keySet.add(cppElement.getKey());
                }
            } else {
                super.visitNamedElement(element);
            }
        }
    }
}

