/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings;

import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.IncludeReference;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class ProjectFile {
    private final TFile m_file;
    private final String m_path;
    private final IFileType m_fileType;
    private final List<IncludeReference> m_references = new ArrayList<IncludeReference>();
    private final Collection<TFile> m_requiredIncludeDirectories = new LinkedHashSet<TFile>();
    private final Collection<ProjectFile> m_included = new LinkedHashSet<ProjectFile>();

    ProjectFile(TFile file, String path, IFileType fileType) {
        this.m_file = file;
        this.m_path = path;
        this.m_fileType = fileType;
    }

    TFile getFile() {
        return this.m_file;
    }

    String getPath() {
        return this.m_path;
    }

    IFileType getFileType() {
        return this.m_fileType;
    }

    void addReference(IncludeReference ref) {
        this.m_references.add(ref);
    }

    List<IncludeReference> getReferences() {
        return this.m_references;
    }

    private void getRequiredIncludeDirectories(Set<TFile> result, Set<ProjectFile> visited) {
        result.addAll(this.m_requiredIncludeDirectories);
        for (ProjectFile pf : this.m_included) {
            if (!visited.add(pf)) continue;
            pf.getRequiredIncludeDirectories(result, visited);
        }
    }

    Collection<TFile> getRequiredIncludeDirectories() {
        HashSet<TFile> result = new HashSet<TFile>();
        HashSet<ProjectFile> visited = new HashSet<ProjectFile>();
        visited.add(this);
        this.getRequiredIncludeDirectories(result, visited);
        return result;
    }

    void addRequiredIncludeDirectories(Collection<TFile> dirs) {
        this.m_requiredIncludeDirectories.addAll(dirs);
    }

    void addIncludedFile(ProjectFile included) {
        this.m_included.add(included);
    }

    public String toString() {
        return "ProjectFile [m_path=" + this.m_path + ", m_fileType=" + String.valueOf(this.m_fileType) + ", m_references=" + String.valueOf(this.m_references) + "]";
    }
}

