/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.languageprovider.cplusplus.controller.settings;

import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.common.IModelValidator;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CompilerOptions;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.GenericCompilerOption;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ICompilerOption;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.IncludeOption;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.SysInclude;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.issue.InstIgnoredOptionLineIssue;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.issue.InvalidSysIncludeIssue;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.issue.SystemNonExistingIncludeIssue;
import de.schlichtherle.truezip.file.TFile;

class CompilerOptionsValidator
implements IModelValidator {
    private final CompilerOptions m_options;

    public CompilerOptionsValidator(CompilerOptions options) {
        assert (options != null) : "Parameter 'options' of method 'CompilerOptionsValidator' must not be null";
        this.m_options = options;
    }

    public final ValidationResult validate() {
        return this.validate(false);
    }

    public ValidationResult validate(boolean addIssues) {
        if (addIssues) {
            this.getElementToAddIssues().removeIssues();
        }
        ValidationResult result = new ValidationResult(true);
        for (ICompilerOption option : this.m_options.getChildren(ICompilerOption.class)) {
            IncludeOption includeOption;
            String message;
            SysInclude sysInclude;
            TFile directory;
            if (option instanceof GenericCompilerOption) continue;
            if (!(!(option instanceof SysInclude) || (directory = (sysInclude = (SysInclude)option).getFile()).exists() && directory.isDirectory() && directory.canRead())) {
                message = "System include directory '" + directory.getAbsolutePath() + "' does not exist or cannot be read";
                if (addIssues) {
                    this.getElementToAddIssues().addIssue((Issue)new InvalidSysIncludeIssue(this.getElementToAddIssues(), message));
                }
                result.addError(message);
            }
            if (!(option instanceof IncludeOption) || (directory = (includeOption = (IncludeOption)option).getFile()).exists() && directory.isDirectory() && directory.canRead()) continue;
            message = "Include directory '" + directory.getAbsolutePath() + "' does not exist or cannot be read";
            if (addIssues) {
                this.getElementToAddIssues().addIssue((Issue)new SystemNonExistingIncludeIssue(this.getElementToAddIssues(), message));
            }
            result.addError(message);
        }
        if (!this.m_options.getSkippedOptionLines().isEmpty()) {
            for (String line : this.m_options.getSkippedOptionLines()) {
                if (addIssues) {
                    this.getElementToAddIssues().addIssue((Issue)new InstIgnoredOptionLineIssue(this.getElementToAddIssues(), line));
                }
                result.addError("# Ignoring line '" + line + "'");
            }
        }
        return result;
    }

    protected NamedElement getElementToAddIssues() {
        return this.m_options;
    }

    public CompilerOptions getOptions() {
        return this.m_options;
    }
}

